/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ueberstyle.h"
#include "pics/volumeslider/volumeslider.h"
#include "pics/acidknob/acidknob.h"
#include "pics/lever_yellow/lever_yellow.h"
#include "pics/lever2/lever2.h"
#include "pics/check/check.h"
#include "pics/radio/radio.h"
#include "pics/button/button.h"
#include "pics/frame/frame.h"

UeberStyle::UeberStyle()
    :QMotifStyle()
{
}


UeberStyle::~UeberStyle()
{
}

void UeberStyle::drawPrimitive( PrimitiveElement pe,
                                  QPainter *p,
                                  const QRect &r,
                                  const QColorGroup &cg,
                                  SFlags flags,
                                  const QStyleOption& opt ) const
{
    switch(pe){

        case PE_GroupBoxFrame:{
            QPen oldpen=p->pen();

            if(r.width()>=100 && r.height()>=100){
                int roundx=QMIN(r.width(),r.height())/20;
                int roundy=roundx;
                p->setPen(QPen(black,1));
                p->drawRoundRect(r,roundx,roundy);
                /*
                p->setPen(QPen(lightGray,2));
                p->drawLine(r.topLeft(),r.bottomRight());
                p->drawLine(r.topRight(),r.bottomLeft());
                */
            }else{
                p->setPen(QPen(black,2));
                p->drawLine(r.topLeft(),r.topRight());
            }
            p->setPen(oldpen);
            break;
        }

        default: QMotifStyle::drawPrimitive(pe,p,r,cg,flags,opt);
    }
}

void UeberStyle::drawControl( ControlElement element,
                                QPainter *p,
                                const QWidget *widget,
                                const QRect &r,
                                const QColorGroup &cg,
                                SFlags flags,
                                const QStyleOption& opt ) const
{
    QPoint absolutepos=widget->mapTo(widget->topLevelWidget(),widget->rect().topLeft());
    int base_width=900;
    int toplevel_width=widget->topLevelWidget()->width();
    int nb_images=(widget->width()*100)/base_width;
    int start_image=(absolutepos.x()*100)/(toplevel_width);
    int center_image=start_image+nb_images/2;

    switch (element) {
        case CE_PushButton:{
            QPushButton* pushbutton=(QPushButton*)widget;
            if(pushbutton->width()<button_embed_image_vec[0].width ||
               pushbutton->height()<button_embed_image_vec[0].height){
                QMotifStyle::drawControl(element,p,widget,r,cg,flags,opt);
                break;
            }else{
                p->fillRect(r,QBrush(cg.background()));
                p->drawImage(0,0,
                            getButtonImage(start_image,r,
                                            flags & (Style_Sunken | Style_Down| Style_On),
                                            pushbutton->isToggleButton(),cg));
                break;
            }
        }
        case CE_PushButtonLabel:{
            QMotifStyle::drawControl(element,p,widget,r,cg,flags,opt);
            break;
        }
        case CE_CheckBox:{
            QCheckBox* checkbox=(QCheckBox*)widget;
            p->drawImage(0,0,getCheckBoxImage(start_image,checkbox->isOn()));
            break;
        }
        case CE_CheckBoxLabel:{
            const QCheckBox *checkbox = (const QCheckBox *) widget;

            int alignment = AlignLeft;
            if (!styleHint(SH_UnderlineAccelerator, widget, QStyleOption::Default, 0))
                alignment |= NoAccel;

            drawItem(p, r, alignment | AlignVCenter | ShowPrefix, cg,
                     flags & Style_Enabled, checkbox->pixmap(), checkbox->text());
            break;
        }
        case CE_RadioButton:{
            QRadioButton* radio=(QRadioButton*)widget;
            p->drawImage(0,0,getRadioImage(start_image,radio->isOn()));
            break;
        }
        case CE_RadioButtonLabel:{
            QRadioButton* radio=(QRadioButton*)widget;
            int alignment = AlignLeft;
            if (!styleHint(SH_UnderlineAccelerator, widget, QStyleOption::Default, 0))
                alignment |= NoAccel;

            drawItem(p, r, alignment | AlignVCenter | ShowPrefix, cg,
                     flags & Style_Enabled, radio->pixmap(), radio->text());
            break;
        }
        default: QMotifStyle::drawControl(element,p,widget,r,cg,flags,opt);
    }

}

void UeberStyle::drawComplexControl( ComplexControl cc,
                                 QPainter * p,
                                 const QWidget* widget,
                                 const QRect & r,
                                 const QColorGroup & cg,
                                 SFlags flags,
                                 SCFlags sub,
                                 SCFlags subActive,
                                 const QStyleOption & opt ) const
{
    QPoint absolutepos=widget->mapTo(widget->topLevelWidget(),widget->rect().topLeft());
    int toplevel_width=900;
    int nb_images=(widget->width()*100)/toplevel_width;
    int start_image=(absolutepos.x()*100)/(toplevel_width-widget->width());
    int center_image=start_image+nb_images/2;
    switch (cc ) {
        case CC_Slider: {
            QSlider* slider=(QSlider*) widget;
            static QPixmap sliderpixmap;
            sliderpixmap.resize(widget->size());
            QPainter p2;
            p2.begin(&sliderpixmap,widget);
            p2.fillRect(widget->rect(),QBrush(cg.background()));
            if(sub & SC_SliderGroove){
                QRect groove = querySubControlMetrics(CC_Slider, widget, SC_SliderGroove, opt);
                p2.setPen( QPen( cg.dark(), 2 ) );
                /*
                p2.drawRect(groove.x()+5,groove.y()+5,
                            groove.width()-10,groove.height()-10);
                */
                QRect hole(groove.x()+15,groove.y()+groove.height()/3,
                                groove.width()-30,groove.height()/3);
                qDrawShadePanel( &p2, hole, cg, TRUE, 3,new QBrush(cg.dark()));
               //p->drawRect (hole);
            }

            // draw slider tickmarks
            if(sub & SC_SliderTickmarks){
                int tickOffset = pixelMetric( PM_SliderTickmarkOffset, slider );
                int ticks = slider->tickmarks();
                int thickness = pixelMetric( PM_SliderControlThickness, slider );
                int len = pixelMetric( PM_SliderLength, slider );
                int available = pixelMetric( PM_SliderSpaceAvailable, slider );
                int interval = slider->tickInterval();

                if ( interval <= 0 ) {
                    interval = slider->lineStep();
                    if (qPositionFromValue( slider, interval, available ) -
                         qPositionFromValue( slider, 0, available ) < 3 )
                        interval = slider->pageStep();
                }

                int fudge = len / 2;
                int pos;

                if ( ticks & QSlider::Above ) {
                    p2.setPen( QPen( cg.text(), 1 ) );
                    int v = slider->minValue();
                    if ( !interval )
                        interval = 1;
                    while ( v <= slider->maxValue() + 1 ) {
                        pos = qPositionFromValue( slider, v, available ) + fudge;
                        if ( slider->orientation() == Horizontal )
                            p2.drawLine( pos, 5, pos, tickOffset -1);
                        else
                            p2.drawLine( 0, pos, tickOffset, pos );
                        v += interval;
                    }
                }

                if ( ticks & QSlider::Below ) {
                    p2.setPen( QPen( cg.text(), 1 ) );
                    int v = slider->minValue();
                    if ( !interval )
                        interval = 1;
                    while ( v <= slider->maxValue() + 1 ) {
                        pos = qPositionFromValue( slider, v, available ) + fudge;
                        if ( slider->orientation() == Horizontal )
                            p2.drawLine( pos, slider->height()-tickOffset, pos,
                                         slider->height()-5);
                        else
                            p2.drawLine( tickOffset+thickness+1, pos,
                                         tickOffset+thickness+1 + available-2,
                                         pos );
                        v += interval;
                    }

                }
            }

            //end draw slider tickmarks

            if(sub & SC_SliderHandle){


                int image_num=
                    ((slider->value()-slider->minValue())*100)/(slider->maxValue()-slider->minValue());
                int middle_value=slider->minValue()+(slider->maxValue()-slider->minValue())/2;
                image_num=(widget->width()*image_num/toplevel_width)-(nb_images/2)+center_image;
                image_num=image_num<0?0:image_num>99?99:image_num;

                QRect handle = querySubControlMetrics(CC_Slider, widget, SC_SliderHandle, opt);
                p2.drawImage(slider->sliderStart(),0,
                            getHorizSliderImage(image_num));
                p2.end();
                bitBlt(p->device(),0,0,&sliderpixmap);
            }
            break;
        }
        case CC_ScrollBar: {
            QScrollBar* scrollbar=(QScrollBar*) widget;
             if (scrollbar->orientation()==Horizontal){
                 static QPixmap scrollbarpixmap;
                 scrollbarpixmap.resize(widget->size());
                 QPainter p2;
                 p2.begin(&scrollbarpixmap,widget);
                 QRect groove = querySubControlMetrics(CC_ScrollBar, widget, SC_ScrollBarGroove, opt);

                    p2.fillRect(widget->rect(),QBrush(cg.background()));
                 //if(sub & SC_ScrollBarGroove){

                     QRect hole(groove.x(),groove.y()+5,
                                groove.width(),16);
                     qDrawShadePanel( &p2, hole, cg, TRUE, 2,new QBrush(cg.dark()));
                 //}

               // if(sub & SC_ScrollBarSlider){
                        QRect handle = querySubControlMetrics(CC_ScrollBar, widget, SC_ScrollBarSlider, opt);
                        int image_num;

                        if(scrollbar->maxValue()!=scrollbar->minValue()){
                            image_num=((scrollbar->value()-scrollbar->minValue())*100)/
                                                   (scrollbar->maxValue()-scrollbar->minValue());
                            if(groove.width()<=handle.width()) image_num=center_image;
                            else image_num=(groove.width()*image_num/toplevel_width)-(nb_images/2)+center_image;
                        }else image_num=center_image;
                        image_num=image_num<0?0:image_num>99?99:image_num;


                        p2.drawImage(handle.x(),handle.y(),
                                     getHorizScrollBarHandleImage(image_num,scrollbar->draggingSlider () ));
                        p2.end();
                        bitBlt(p->device(),0,0,&scrollbarpixmap);
                //}
            }
            break;
        }
        default:{
            QMotifStyle::drawComplexControl( cc, p, widget,r, cg, flags,sub,subActive, opt );
        }
    }
}


QRect UeberStyle::querySubControlMetrics ( ComplexControl control,
                                                                                  const QWidget * widget,
                                                                                    SubControl subcontrol,
                                                                                const QStyleOption & opt) const
{
        switch (control){
            case CC_Slider:{
                switch (subcontrol){
                    case SC_SliderHandle:{
                        const QSlider *slider = (const QSlider *) widget;
                        int len             = pixelMetric( PM_SliderLength, widget );
                        int sliderPos    = slider->sliderStart();
                        int thickness   = pixelMetric( PM_SliderControlThickness, widget );
                        return QRect( sliderPos, 0, len,thickness);
                    }
                    case SC_SliderGroove:{
                        return widget->rect();
                    }
                    default: break;
                }
            }
            case CC_ScrollBar:{
                const QScrollBar *scrollbar = (const QScrollBar *) widget;
                if (scrollbar->orientation()==Horizontal){
                    switch (subcontrol){
                        case SC_ScrollBarSlider:{
                            int thickness   = pixelMetric( PM_ScrollBarExtent, widget );
                            int sliderPos    = scrollbar->sliderStart();
                            int len=pixelMetric(PM_ScrollBarSliderMin , widget );
                            return QRect( sliderPos, 0, len,thickness);
                        }
                        case SC_ScrollBarGroove:{
                            int thickness   = pixelMetric( PM_ScrollBarExtent, widget );
                            int sliderPos    = scrollbar->sliderStart();
                            int maxlen=scrollbar->width();
                            int minlen=pixelMetric(PM_ScrollBarSliderMin , widget );
                            int groovelen;
	                   // calculate groove length
                            if (scrollbar->maxValue() != scrollbar->minValue()) {
                                uint range = scrollbar->maxValue() - scrollbar->minValue();
                                groovelen = maxlen-((scrollbar->pageStep() * maxlen)/(range + scrollbar->pageStep()));
                                if ( groovelen < minlen || range > INT_MAX/2 )
                                    groovelen = minlen;
                                if ( groovelen > maxlen )
                                    groovelen = maxlen;
                            } else{
                                groovelen = minlen;
                            }
                            return QRect((maxlen-groovelen)/2,0, groovelen,thickness);
                        }
                        default: break;
                    }
                }
                break;
            }
            default: return QMotifStyle::querySubControlMetrics(control,widget,subcontrol,opt);
        }
}

QRect UeberStyle::subRect(SubRect r, const QWidget *widget) const
{
    switch(r){
        case SR_PushButtonFocusRect:{
            return QRect();
        }
        case SR_PushButtonContents:{
            if(widget->width()<button_embed_image_vec[0].width ||
               widget->height()<button_embed_image_vec[0].height){
                    return QMotifStyle::subRect(r,widget);
               }else{
                    QRect rect=widget->rect();
                    QRect newrect=rect;
                    newrect.setBottom(rect.y()+rect.height()-16);
                    newrect.setTop(rect.y()+6);
                    newrect.setLeft(rect.x()+10);
                    newrect.setRight(rect.x()+rect.width()-12);
                    return newrect;
               }
        }
        default: return QMotifStyle::subRect(r,widget);
    }
}

QSize UeberStyle::sizeFromContents( ContentsType contents,
                                       const QWidget *widget,
                                       const QSize &contentsSize,
                                       const QStyleOption& opt ) const
{
    QSize sz(contentsSize);
    switch(contents){
        case CT_PushButton:{

            QRect rect=subRect(SR_PushButtonContents,widget);
            sz = QCommonStyle::sizeFromContents(contents, widget, contentsSize, opt);
            //cout<<"[1]name: "<<widget->name()<<" width: "<<sz.width()<<" height: "<<sz.height()<<endl;
            if(contentsSize.width()>rect.width()) sz.setWidth(sz.width()+(contentsSize.width()-rect.width()));
            if(contentsSize.height()>rect.height()) sz.setHeight(sz.height()+(contentsSize.height()-rect.height()));
            if(sz.width()<BUTTON_WIDTH) sz.setWidth(BUTTON_WIDTH);
            if(sz.height()<BUTTON_HEIGHT) sz.setHeight(BUTTON_HEIGHT);
            //cout<<"[2]name: "<<widget->name()<<" width: "<<sz.width()<<" height: "<<sz.height()<<endl;
            return sz;
        }
        default: return QCommonStyle::sizeFromContents(contents,widget,contentsSize,opt);
    }
}
int UeberStyle::pixelMetric(PixelMetric metric, const QWidget *widget) const
{
    switch (metric){
        case PM_ButtonMargin: {
            return 0;
        }
        case PM_ButtonDefaultIndicator: {
            return 0;
        }
        case PM_MenuButtonIndicator: {
            return 0;
        }
        case PM_ButtonShiftHorizontal: {
            return 0;
        }
        case PM_ButtonShiftVertical: {
            return 2;
        }
        case PM_DialogButtonsButtonWidth: {
            return BUTTON_WIDTH;
        }
        case PM_DialogButtonsButtonHeight: {
            return BUTTON_HEIGHT;
        }


        case PM_IndicatorWidth: {
            return CHECK_WIDTH;
        }
        case PM_IndicatorHeight: {
            return CHECK_HEIGHT;
        }
        case PM_ExclusiveIndicatorWidth: {
            return RADIO_WIDTH;
        }
        case PM_ExclusiveIndicatorHeight: {
            return RADIO_HEIGHT;
        }
        case PM_SliderControlThickness: {
            return SLIDER_HEIGHT;
        }
        case PM_SliderThickness: {
            return SLIDER_HEIGHT;
        }
        case PM_SliderLength:{
            return SLIDER_WIDTH;
        }
        case PM_SliderTickmarkOffset :{
            return 15;
        }
        case PM_ScrollBarSliderMin: {
            const QScrollBar *scrollbar = (const QScrollBar *) widget;
            if (scrollbar->orientation()==Horizontal){
                return LEVER2_WIDTH;
            }
            break;
        }
        case PM_ScrollBarExtent: {
            const QScrollBar *scrollbar = (const QScrollBar *) widget;
            if (scrollbar->orientation()==Horizontal){
                return LEVER2_HEIGHT;
            }
            break;
        }
        default: return QMotifStyle::pixelMetric(metric, widget);
    }
}

/*!
    \fn UeberStyle::getHorizSliderImage(int i)
 */
QImage UeberStyle::getHorizSliderImage(int i) const
{
    QByteArray baunzip;
    baunzip = qUncompress( slider_embed_image_vec[i].data,
                           slider_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                slider_embed_image_vec[i].width,
                slider_embed_image_vec[i].height,
                slider_embed_image_vec[i].depth,
                (QRgb*)slider_embed_image_vec[i].colorTable,
                slider_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( slider_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

/*!
    \fn QImage UeberStyle::getHorizScrollBarHandleImage(int n,bool onoff) const
 */
QImage UeberStyle::getHorizScrollBarHandleImage(int n,bool onoff) const
{
    int i=((onoff?1:0)*100)+n;
    QByteArray baunzip;
    baunzip = qUncompress( lever2_embed_image_vec[i].data,
                           lever2_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                lever2_embed_image_vec[i].width,
                lever2_embed_image_vec[i].height,
                lever2_embed_image_vec[i].depth,
                (QRgb*)lever2_embed_image_vec[i].colorTable,
                lever2_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( lever2_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

/*!
    \fn UeberStyle::getCheckBoxImage(int n,bool tf)
 */
QImage UeberStyle::getCheckBoxImage(int n,bool tf) const
{
    int i=tf?n+100:n;
    QByteArray baunzip;
    baunzip = qUncompress( check_embed_image_vec[i].data,
                           check_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                check_embed_image_vec[i].width,
                check_embed_image_vec[i].height,
                check_embed_image_vec[i].depth,
                (QRgb*)check_embed_image_vec[i].colorTable,
                check_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( check_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

/*!
    \fn UeberStyle::getRadioImage(int n,bool tf)
 */
QImage UeberStyle::getRadioImage(int n,bool tf) const
{
    //int i=tf?n+100:n;
    int i=(tf?1:0)*100+n;
    QByteArray baunzip;
    baunzip = qUncompress( radio_embed_image_vec[i].data,
                           radio_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                radio_embed_image_vec[i].width,
                radio_embed_image_vec[i].height,
                radio_embed_image_vec[i].depth,
                (QRgb*)radio_embed_image_vec[i].colorTable,
                radio_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( radio_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

/** taken from qcommonstyle.cpp **/
int UeberStyle::qPositionFromValue( const QRangeControl * rc, int logical_val,
                               int span ) const
{
    if ( span <= 0 || logical_val < rc->minValue() ||
         rc->maxValue() <= rc->minValue() )
        return 0;
    if ( logical_val > rc->maxValue() )
        return span;

    uint range = rc->maxValue() - rc->minValue();
    uint p = logical_val - rc->minValue();

    if ( range > (uint)INT_MAX/4096 ) {
        const int scale = 4096*2;
        return ( (p/scale) * span ) / (range/scale);
	// ### the above line is probably not 100% correct
	// ### but fixing it isn't worth the extreme pain...
    } else if ( range > (uint)span ) {
        return (2*p*span + range) / (2*range);
    } else {
        uint div = span / range;
        uint mod = span % range;
        return p*div + (2*p*mod + range) / (2*range);
    }
    //equiv. to (p*span)/range + 0.5
    // no overflow because of this implicit assumption:
    // span <= 4096
}







/*!
    \fn UeberStyle::getButtonImage(int n,QRect rect,bool down, bool toggle)
 */
QImage UeberStyle::getButtonImage(int n,QRect rect,bool down, bool toggle,const QColorGroup &cg) const
{
    int i=((down?toggle?2:1:0)*100)+n;
    QByteArray baunzip;
    baunzip = qUncompress( button_embed_image_vec[i].data,
                           button_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                button_embed_image_vec[i].width,
                button_embed_image_vec[i].height,
                button_embed_image_vec[i].depth,
                (QRgb*)button_embed_image_vec[i].colorTable,
                button_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( button_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    //draw four corners
    QImage img2(rect.width(),img.height(),32);
    img2.setAlphaBuffer(TRUE);
    img2.fill(cg.background().rgb());
    bitBlt(&img2,0,0,&img,BUTTON_TOP_LEFT.x(),BUTTON_TOP_LEFT.y(),
            BUTTON_TOP_LEFT.width(),BUTTON_TOP_LEFT.height());
    bitBlt(&img2,0,BUTTON_BOTTOM_LEFT.y(),
            &img,BUTTON_BOTTOM_LEFT.x(),BUTTON_BOTTOM_LEFT.y(),
            BUTTON_BOTTOM_LEFT.width(),BUTTON_BOTTOM_LEFT.height());
    bitBlt(&img2,img2.width()-BUTTON_TOP_RIGHT.width(),0,
            &img,BUTTON_TOP_RIGHT.x(),BUTTON_TOP_RIGHT.y(),
            BUTTON_TOP_RIGHT.width(),BUTTON_TOP_RIGHT.height());
    bitBlt(&img2,img2.width()-BUTTON_BOTTOM_RIGHT.width(),
            img2.height()-BUTTON_BOTTOM_RIGHT.height(),
            &img,BUTTON_BOTTOM_RIGHT.x(),BUTTON_BOTTOM_RIGHT.y(),
            BUTTON_BOTTOM_RIGHT.width(),BUTTON_BOTTOM_RIGHT.height());
    //end draw four corners

    if(img.width()>=rect.width() &&img.height()>=rect.height()){
        return img2;
    }else if (img.width()<rect.width() && img.height()>=rect.height()){
        QImage img3=img.copy(down?BUTTON_VERT_CENTER:BUTTON_OFF_VERT_CENTER);
        //img3.scale(rect.width()-img.width(),img.height());
        for (int i=0;i<rect.width()-img.width();i++){
            bitBlt(&img2,BUTTON_TOP_LEFT.width()+i,0,&img3,0,0,img3.width(),img3.height());
        }
        return img2;
    }else if (img.width()>=rect.width() && img.height()<rect.height()){
        return img2; //not yet implemented
    }else{
        return img2;//not yet implemented
    }
}

/*!
    \fn UeberStyle::getFrameImage(int i)
 */
QImage UeberStyle::getFrameImage(int n) const
{
    int i=0;
    QByteArray baunzip;
    baunzip = qUncompress( frame_embed_image_vec[i].data,
                           frame_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                frame_embed_image_vec[i].width,
                frame_embed_image_vec[i].height,
                frame_embed_image_vec[i].depth,
                (QRgb*)frame_embed_image_vec[i].colorTable,
                frame_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( frame_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

void UeberStyle::polish( QWidget* w)
{
    /*
    // the polish function sets some widgets to transparent mode and
    // some to translate background mode in order to get the full
    // benefit from the nice pixmaps in the color group.
    w->setAutoMask( TRUE );
    w->setWindowOpacity(0);
    if ( !w->isTopLevel() ) {
        if ( w->inherits("QPushButton")
             || w->inherits("QToolButton")
             || w->inherits("QComboBox")
             ) {
            w->setAutoMask( TRUE );
            return;
             }
             if ( w->inherits("QLabel")){
                 w->setAutoMask( TRUE );
                 w->setWindowOpacity(0);
             }
        if ( w->backgroundPixmap() )
            w->setBackgroundOrigin( QWidget::WindowOrigin );
    }
    */
}

