/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RANGEINDICATORWIDGET_H
#define RANGEINDICATORWIDGET_H

#include <qlabel.h>
#include <qpainter.h>
#include <qpixmap.h>

/**
@author Predrag Viceic
*/
class RangeIndicatorWidget : public QLabel
{
Q_OBJECT
public:
    RangeIndicatorWidget(QWidget *parent = 0, const char *name = 0);

    ~RangeIndicatorWidget();
    int minValue();
    int maxValue();

    enum movingE {MOVING_START, MOVING_END, MOVING_NONE};

public slots:
    void setRangeMaxValue(int r_max);
    void setMaxValue(int max);
    void setMinValue(int min);
    void setRangeMinValue(int r_min);
    void paintEvent ( QPaintEvent * );
    void setMinimumRange(int);
protected:
    void mousePressEvent ( QMouseEvent * e );
    void mouseReleaseEvent ( QMouseEvent * e ) ;
    void mouseMoveEvent ( QMouseEvent * e ) ;
private:
    int maxVal;
    int minVal;
    int rangeMinVal;
    int rangeMaxVal;
    int minimumRange;
protected:
    movingE moving;

signals:
    void minChanged(int);
    void maxChanged(int);

};

#endif
