/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SPLINELINE_H
#define SPLINELINE_H

#include <polyline.h>
#include <splinepoint.h>
#include <qvaluelist.h>
#include "mymath.h"

/**
@author Predrag Viceic
*/
class SplineLine : public PolyLine
{
public:
    SplineLine(QCanvas* canvas);
    ~SplineLine();
    int rtti() const;
    void addPoint(QPoint p, long sample_pos,float value);
    QPointArray toBezierPointArray(int i);
    SortablePoint* movingPoint(QPoint p);
    void moveSelectedPoint(QPoint to, long sample_pos,float value);
    void deselectAll();
    void removePoint(QPoint p);
    void updateSize(QSize size);
    int getYAtX(int x);
    float getValueAtSample(long sample);
    int count();
    void clear();
    QPointArray toPointArray();
    void setMinValue(float);
    void setMaxValue(float);
protected:
    void drawShape ( QPainter & p );
    QValueList <SplinePoint> splinePoints;
    float maxValue;
    float minValue;
    void toSortablePoints();
};

#endif
