/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DRAWALLSOUNDWIDGET_H
#define DRAWALLSOUNDWIDGET_H

#include <drawsoundwidgetabstract.h>
#include <selectionrectangle.h>
#include <qcursor.h>
/**
@author Predrag Viceic
*/
class DrawAllSoundWidget : public DrawSoundWidgetAbstract{
Q_OBJECT
public:
    DrawAllSoundWidget(QWidget *parent,
                                            const char *name, SoundManager*);

    ~DrawAllSoundWidget();
    void zoomChanged();
    void resized();


    SelectionRectangle* getViewWindow();
    void zoomAll();
    int minimumWidth () const;
    QSize sizeHint () const;
private:
    SelectionRectangle* view;
    void updateViewWindow();
    bool dontChangeViewOnNextSignal;

public slots:
    void visibleAreaChanged(long, long);
    void fileLoaded();
    void contentsMouseMoveEvent( QMouseEvent * mouseEvent);
    void contentsMousePressEvent( QMouseEvent * mouseEvent);
    void contentsMouseReleaseEvent( QMouseEvent * mouseEvent);
    void cropped();

signals:
    void visibleAreaChangedS(long,long);

protected:
    int savedRelativeSamplePos;
};

#endif
