/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BEATLINE_H
#define BEATLINE_H


#include <qcanvas.h>
#include <samplevalueview.h>
#include "pics/icons.h"
/**
@author Predrag Viceic
*/
class BeatLine : public QCanvasLine
{
public:
    BeatLine(QCanvas*,long);

    ~BeatLine();
    long getBeatPos();
    void lock();
    void unlock();
    bool locked();
    void setBpmLine();
    bool isBpmLine();
    int rtti() const;
    void drawShape( QPainter & );
    QPointArray areaPoints() const;
    void setMoving(bool tf);
    bool isMoving();
    QRect* getHandle();
    void setSamplePos(long pos);
    void setSampleValueView(SampleValueView* svv);
    QRect* getRemoveHandle();
    QRect* getLockUnlockHandle();


protected:
    long beatPos;
    bool locked_var;
    bool bpmLine;
    bool moving;
    QRect* handle;
    QRect* removeHandle;
    QRect* lockunlockHandle;
    SampleValueView* sampleValueView;
};

#endif
