/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef UEBERSTYLE_H
#define UEBERSTYLE_H

#include <qmotifstyle.h>
#include <qcommonstyle.h>
#include <qpointarray.h>
#include <qpalette.h>
#include <qpainter.h>
#include <qslider.h>
#include <qscrollbar.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qbitmap.h>
#include "defs.h"

#define SLIDER_HEIGHT slider_embed_image_vec[0].height
#define SLIDER_WIDTH slider_embed_image_vec[0].width
#define LEVER_HEIGHT yellow_lever_embed_image_vec[0].height
#define LEVER_WIDTH yellow_lever_embed_image_vec[0].width
#define LEVER2_HEIGHT lever2_embed_image_vec[0].height
#define LEVER2_WIDTH lever2_embed_image_vec[0].width
#define CHECK_HEIGHT check_embed_image_vec[0].height
#define CHECK_WIDTH check_embed_image_vec[0].width
#define RADIO_HEIGHT radio_embed_image_vec[0].height
#define RADIO_WIDTH radio_embed_image_vec[0].width

#define BUTTON_HEIGHT button_embed_image_vec[0].height
#define BUTTON_WIDTH button_embed_image_vec[0].width
#define BUTTON_SIZE button_embed_image_vec[0].size
#define BUTTON_TOP_LEFT QRect(0,0,24,20)
#define BUTTON_BOTTOM_LEFT QRect(0,20,24,26)
#define BUTTON_TOP_RIGHT QRect(24,0,24,21)
#define BUTTON_BOTTOM_RIGHT QRect(24,20,24,26)
#define BUTTON_VERT_CENTER QRect(23,0,1,BUTTON_HEIGHT)
#define BUTTON_OFF_VERT_CENTER QRect(22,0,1,BUTTON_HEIGHT)

#define FRAME_HEIGHT frame_embed_image_vec[0].height
#define FRAME_WIDTH frame_embed_image_vec[0].width


#include <qdrawutil.h>
/**
@author Predrag Viceic
*/
class UeberStyle : public QMotifStyle
{
Q_OBJECT
public:
    UeberStyle();

    ~UeberStyle();
    void drawPrimitive ( PrimitiveElement pe,
                                QPainter * p,
                                const QRect & r,
                                const QColorGroup & cg,
                                SFlags flags = Style_Default,
                                const QStyleOption & opt = QStyleOption::Default ) const;

    void drawControl ( ControlElement element,
                                        QPainter * p,
                                        const QWidget * widget,
                                        const QRect & r,
                                        const QColorGroup & cg,
                                        SFlags how = Style_Default,
                                        const QStyleOption & opt = QStyleOption::Default ) const;

    void drawComplexControl ( ComplexControl control,
                                                        QPainter * p,
                                                        const QWidget * widget,
                                                        const QRect & r,
                                                        const QColorGroup & cg,
                                                        SFlags how = Style_Default,
                                                        SCFlags sub = SC_All,
                                                        SCFlags subActive = SC_None,
                                                        const QStyleOption & opt = QStyleOption::Default ) const;

    QRect querySubControlMetrics ( ComplexControl control,
                                                                const QWidget * widget,
                                                                SubControl subcontrol,
                                                                const QStyleOption & opt = QStyleOption::Default ) const;

    int pixelMetric ( PixelMetric metric, const QWidget * widget = 0 ) const;

    QRect subRect ( SubRect subrect, const QWidget * widget ) const;

    QSize sizeFromContents (   ContentsType contents,
                                                    const QWidget * widget,
                                                    const QSize & contentsSize,
                                                    const QStyleOption & opt = QStyleOption::Default ) const;

    void polish( QWidget* w);




private:
    QImage getHorizSliderImage(int i) const;
    QImage getHorizScrollBarHandleImage(int i,bool onoff) const;
    QImage getCheckBoxImage(int n,bool tf) const;
    QImage getRadioImage(int n,bool tf) const;
    QImage getButtonImage(int n,QRect rect,bool down, bool toggle,const QColorGroup &cg) const;
    QImage getFrameImage(int n) const;

    int qPositionFromValue( const QRangeControl * rc, int logical_val,int span ) const;


};

#endif
