/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOUNDHOLDER_H
#define SOUNDHOLDER_H

#include <qobject.h>
#include <sndfile.h>
#include <defs.h>

/**
\class SoundHolder

\brief This class hold the sound as arrays of floats and provides the access to the data

@author Predrag Viceic
*/
class SoundHolder : public QObject
{
Q_OBJECT
public:
    SoundHolder(QObject *parent = 0, const char *name = 0);

    ~SoundHolder();
protected:
    SF_INFO sfinfo;
    float* leftChannel;
    float* rightChannel;
    sf_count_t frames;
    int rate;
    int channels;
    bool _hasSound;

    float* exportMultiplexedBuffer(long,long);
    void exportMultiplexedBuffer(float*,long,long);

    float* exportDerivatedLeftBuffer(long,long);
    float* exportDerivatedRightBuffer(long,long);
    float* exportLeftBuffer(long,long);
    float* exportRightBuffer(long,long);
    void importLeftBuffer(float*,long start_sample, long end_sample);
    void importRightBuffer(float*,long start_sample, long end_sample);
    void importMultiplexedBuffer(float* ,long);
    void importMultiplexedShortBuffer(short* ,long);

public:
    int getRate();
    int getChannels();
    sf_count_t getFrames();



    float* getLeftChannel();
    float* getRightChannel();
    void exportMultiplexedShortBuffer(short* data, long,long);

    void setNbFrames(long);
    int getBps();
    int toBpsCode(int);

signals:
    void nbFramesChanged(long);

};

#endif
