/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "beatline.h"
#include <qcanvas.h>
#include <qpainter.h>
BeatLine::BeatLine(QCanvas* canvas,long _pos)
 : QCanvasLine(canvas)
{
        beatPos=_pos;
        locked_var=FALSE;
        bpmLine=false;
        setZ(-5);
        moving=FALSE;
        handle=new QRect(0,0,0,0);
        removeHandle=new QRect(0,0,0,0);
        lockunlockHandle=new QRect(0,0,0,0);
        sampleValueView=0;
}


BeatLine::~BeatLine()
{
    hide();
}




/*!
    \fn BeatLine::getBeatPos()
 */
long BeatLine::getBeatPos()
{
    return beatPos;
}


/*!
    \fn BeatLine::lock()
 */
void BeatLine::lock()
{
    locked_var=TRUE;
}


/*!
    \fn BeatLine::unlock()
 */
void BeatLine::unlock()
{
    locked_var=FALSE;
}


/*!
    \fn BeatLine::locked()
 */
bool BeatLine::locked()
{
    return locked_var;
}


/*!
    \fn BeatLine::setBpmLine()
 */
void BeatLine::setBpmLine()
{
    bpmLine=TRUE;
    setZ(-4);
}


/*!
    \fn BeatLine::isBpmLine
 */
bool BeatLine::isBpmLine()
{
    return bpmLine;
}


/*!
    \fn BeatLine::rtti()
 */
int BeatLine::rtti() const
{
    if(!bpmLine)    return 9;
    else return 10;
}


void BeatLine::drawShape( QPainter &p ){
    QPointArray triangle(3);
    triangle.setPoint(0,QPoint(x()-5,0));
    triangle.setPoint(1,QPoint(x()+5,0));
    triangle.setPoint(2,QPoint(x(),10));

    QPointArray losange(4);
    losange.setPoint(0,QPoint(x(),0));
    losange.setPoint(1,QPoint(x()+5,5));
    losange.setPoint(2,QPoint(x(),10));
    losange.setPoint(3,QPoint(x()-5,5));


    lockunlockHandle->setRect(x()-8,20,16,16);
    if(!locked()){
        removeHandle->setRect(x()-8,canvas()->height()-17,16,16);
        handle->setRect(x()-8,canvas()->height()/2,16,16);
    }else{
        removeHandle->setRect(0,0,0,0);
        handle->setRect(0,0,0,0);
    }



    RasterOp oldROP=p.rasterOp();
    p.setBrush(pen().color());
    p.setRasterOp(CopyROP);
    p.drawLine(x(),1,x(),canvas()->height()-1);
    if(!isBpmLine()){
        if(locked()){
            //p.drawPolygon(losange);
            //p.drawPixmap(x()-8,0,QPixmap(qembed_findImage("encrypted")));
            p.drawPixmap(x()-8,0,QPixmap(qembed_findImage("1downarrow")));

        }else{
            //p.drawPolygon(triangle);
            p.drawPixmap(x()-8,0,QPixmap(qembed_findImage("1downarrow")));
        }

        if(!locked()){
            p.drawPixmap(*handle,QPixmap(qembed_findImage("leftrightarrow")));
            p.drawPixmap(*removeHandle,QPixmap(qembed_findImage("cancel")));
        }
        if(locked()) p.drawPixmap(*lockunlockHandle,QPixmap(qembed_findImage("encrypted")));
        else p.drawPixmap(*lockunlockHandle,QPixmap(qembed_findImage("decrypted")));
    }
    p.setRasterOp(oldROP);
}

QPointArray  BeatLine::areaPoints() const{
    QPointArray result(4);
    result.setPoint(0,QPoint((int)x()-10,-1));
    result.setPoint(1,QPoint((int)x()+10,-1));
    result.setPoint(2,QPoint((int)x()+10,canvas()->height()));
    result.setPoint(3,QPoint((int)x()-10,canvas()->height()));
    return result;
}

/*!
    \fn BeatLine::setMooving(bool tf)
 */
void BeatLine::setMoving(bool tf)
{
    moving=tf;
     if(sampleValueView){
        if(moving) sampleValueView->show();
        else sampleValueView->hide();
        sampleValueView->setX(x()+20);
        sampleValueView->setPosition(beatPos);
        update();
    }
}


/*!
    \fn BeatLine::isMoving()
 */
bool BeatLine::isMoving()
{
    return moving;
}


/*!
    \fn BeatLine::getHandle()
 */
QRect* BeatLine::getHandle()
{
    return handle;
}


/*!
    \fn BeatLine::setSamplePos(long pos)
 */
void BeatLine::setSamplePos(long pos)
{
    beatPos=pos;
    if(sampleValueView){
        sampleValueView->setPosition(beatPos);
        sampleValueView->setX(x()+20);
    }
}


/*!
    \fn BeatLine::setSampleValueView(SampleValueView* svv)
 */
void BeatLine::setSampleValueView(SampleValueView* svv)
{
    sampleValueView=svv;
}


/*!
    \fn BeatLine::getRemoveHandle()
 */
QRect* BeatLine::getRemoveHandle()
{
    return removeHandle;
}


/*!
    \fn BeatLine::getLockUnlockHandle()
 */
QRect* BeatLine::getLockUnlockHandle()
{
    return lockunlockHandle;
}
