/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
    Midi file generation taken from Waon project
    Copyright (C) 1998 Kengo ICHIKI (ichiki@geocities.com)
*/
#ifndef MIDIMANAGER_H
#define MIDIMANAGER_H

#include <qobject.h>
#include <qfile.h>
#include <iostream.h>
#include <algorithm>



/**
@author Predrag Viceic
*/

class MidiManager : public QObject
{
Q_OBJECT
public:
    MidiManager(QObject *parent = 0, const char *name = 0);

    ~MidiManager();
    void writeMidiFile(QString,long*,int,double);
private:
    int smf_header_fmt (QFile * file,
            unsigned short format,
            unsigned short tracks,
            unsigned short divisions);
    int smf_prog_change (QFile * file, char channel, char prog);
    int smf_note_on (QFile * file, long dtime, char note, char vel, char channel);
    int smf_note_off (QFile * file, long dtime, char note, char vel, char channel);
    int smf_track_head (QFile * file, unsigned long size);
    int smf_track_end (QFile * file);
    int write_var_len (QFile * file, long value);
    int wblong (QFile * file, unsigned long ul);
    int wbshort (QFile * file, unsigned short us);
};

#endif
