/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FFTHOLDER_H
#define FFTHOLDER_H

#include <qobject.h>

/**
@author Predrag Viceic
*/
class FFTHolder
{
public:
    FFTHolder();

    ~FFTHolder();

    enum FFTWindowType {WINDOW_RECTANGULAR,WINDOW_HANNING,WINDOW_GAUSS};
    enum FFTPadding {PAD_ZERO,PAD_SIGNAL};

    int getHiresFreqNbBands();
    int getHiresTempNbBands();
    float getHiresFreqFFTMinima();
    float getHiresFreqFFTMaxima();
    int getHiresFreqFFTWidth();
    int getHiresTempFFTWidth();
    int getHiresFreqFFTAdvance();
    int getHiresTempFFTAdvance();

protected:
    float** hirestemp_subband_energies;
    float** hiresfreq_subband_energies;

    int hiresfreq_nbbands;
    int hiresfreq_fft_width;
    int hiresfreq_fft_window_size;
    int hiresfreq_fft_advance;
    float hiresfreq_fftMaxima;
    float hiresfreq_fftMinima;
    int hiresfreq_padding;

    int hirestemp_nbbands;
    int hirestemp_fft_width;
    int hirestemp_fft_window_size;
    int hirestemp_fft_advance;
    float hirestemp_fftMaxima;
    float hirestemp_fftMinima;
    int hirestemp_padding;

};

#endif
