/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drawingline.h"

DrawingLine::DrawingLine(QCanvas* canvas)
 : QCanvasPolygon(canvas)
{

    QPointArray tempPoints(4);
    tempPoints.putPoints(0,4,0,0,0,0,0,0,0,0);
    setPoints(tempPoints);
    QColor colorClear(230,230,230);
    QColor colorDark(150,150,150);
    QBrush brush(colorClear,SolidPattern);
    setPen(colorDark);
    setBrush(brush);

}


DrawingLine::~DrawingLine()
{
}




/*!
    \fn DrawingLine::setStartPoint(int,int)
 */
void DrawingLine::setStartPoint(int x,int y)
{
    QPointArray tempPoints(points());
    tempPoints.setPoint(0,QPoint(x,canvas()->height()));
    tempPoints.setPoint(1,QPoint(x,y));
    setPoints(tempPoints);
}


/*!
    \fn DrawingLine::setEndPoint(int,int)
 */
void DrawingLine::setEndPoint(int x,int y)
{
    QPointArray tempPoints(points());
    tempPoints.setPoint(2,QPoint(x,y));
    tempPoints.setPoint(3,QPoint(x,canvas()->height()));
    setPoints(tempPoints);
}


/*!
    \fn DrawingLine::getStartPoint()
 */
QPoint DrawingLine::getStartPoint()
{
    return points().point(1);
}


/*!
    \fn DrawingLine::getEndPoint()
 */
QPoint DrawingLine::getEndPoint()
{
    return points().point(2);
}

QPointArray DrawingLine::areaPoints () const{
    return QCanvasPolygon::areaPoints();
}

void DrawingLine::drawShape ( QPainter & p ){
    RasterOp oldROP=p.rasterOp();
    p.setRasterOp(AndROP);
    QCanvasPolygon::drawShape(p);
    p.setRasterOp(oldROP);
}

QRect DrawingLine::boundingRect(){
    return points().boundingRect();
}


/*!
    \fn DrawingLine::rtti() const
 */
int DrawingLine::rtti() const
{
    return RTTI;
}


/*!
    \fn DrawingLine::getYAtX(int)
 */
int DrawingLine::getYAtX(int x)
{
    int x1=getStartPoint().x();
    int y1=getStartPoint().y();
    int x2=getEndPoint().x();
    int y2=getEndPoint().y();
    float a=float((y2-y1))/float((x2-x1));
    float b=y1-(a*float(x1));
    return a*x+b;
}
