/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "scopeview.h"

ScopeView::ScopeView(QWidget *parent, const char *name)
 : QFrame(parent, name,WNoAutoErase)
{
    setFrameStyle(LineEditPanel | Sunken);
    frames=1024;
    position=0;
    lastRenderedPosition=0;
    subband_number=64;
    steps=32;
    p = rfftw_create_plan(frames, FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
    //p = fftw_create_plan(frames, FFTW_FORWARD, FFTW_ESTIMATE);
    //p = fftw_create_plan(frames, FFTW_FORWARD,FFTW_MEASURE); // too long
    subband_energies=new float[subband_number];
    setPaletteBackgroundColor(QColor(0,0,0));
    pixmap=0;
    playing=FALSE;
}


ScopeView::~ScopeView()
{
    fftw_destroy_plan(p);
    zaparr(subband_energies);
    if(pixmap) delete pixmap;
}

void ScopeView::showEvent(QShowEvent* ev){
    if(contentsRect().width()>0){
        pixmap=new QPixmap(contentsRect().width(),contentsRect().height());
    }
}

void ScopeView::paintEvent(QPaintEvent* ){

    int x=contentsRect().x();
    int y=contentsRect().y();
    if((!playing || ((position>=lastRenderedPosition+frames)&&
        position+frames<soundManager->getFrames())) && subband_number>0 &&
        contentsRect().width()>0){
        if(playing){
            float* lchannel=&soundManager->getLeftChannel()[position];
            float* rchannel=&soundManager->getRightChannel()[position];

            fftw_real* in=new fftw_real[frames];
            //fftw_real* in2=new fftw_real[frames];
            fftw_real* out=new fftw_real[frames];
            //fftw_real* out2=new fftw_real[frames];

            //fill in and out buffers
            for (int i=0;i<frames;i++){
                float w = (0.5 + 0.5*cos((2*M_PI * i) / frames)); //Hanning
                in[i]=lchannel[i]*w;
                //in2[i]=rchannel[i]*w;
            }
            //end fill in and out buffers
            rfftw_one(p, in, out); //compute fft
            //rfftw_one(p, in2, out2); //compute fft

            int subbandSize=round(float(frames/2)/float(subband_number));
            float* subband_buffer=new float[frames/2];
            for (int j=1;j<((frames+1)/2)-1;j++){
                subband_buffer[j]= 4 * (pow(out[j],2) + pow(out[frames-j],2));
            }

            //compute the energy of n subbands
            for (int i2=1;i2<((frames+1)/2)-1;i2+=subbandSize){
                double subbandE=0;

                for (int i3=i2;i3<i2+subbandSize;i3++){
                    subbandE+=log10(subband_buffer[i3]);
                }
                subband_energies[i2/subbandSize]=subbandE/double(subbandSize);
            }
            //end compute the energy of n subbands
            zaparr(in);
            //zaparr(in2);
            zaparr(out);
            //zaparr(out2);
            zaparr(subband_buffer);
        }else{
            for (int i=0;i<subband_number;i++){
                subband_energies[i]=0;
            }
        }
        lastRenderedPosition=position;

        //QFrame::paintEvent(ev);
        if(!pixmap){
            pixmap=new QPixmap(contentsRect().width(),contentsRect().height());
        }
        QPainter p(pixmap);
        p.fillRect(0,0,contentsRect().width(),contentsRect().height(),QBrush::black);
        float totalBandWidth=float(contentsRect().width())/float(subband_number);
        int rectWidth=round(round(totalBandWidth)*0.5f);
        int spaceH=round(round(totalBandWidth)*0.5f);
        float totalBandHeight=float(contentsRect().height())/float(steps);
        int rectHeight=round(round(totalBandHeight)*0.5f);
        int spaceV=round(round(totalBandHeight)*0.5f);

        QColor color(0,255,0);
        QColor fadedColor(0,255,0);
        QBrush brush(color);
        QBrush fadedBrush(fadedColor);
        for (int i=0;i<subband_number;i++){
            color.setRgb(0,255,0);
            for(int j=0;j<steps;j++){
                int r=color.red();
                int g=color.green();
                int b=color.blue();
                if(r<255){
                    r=(int)(255*(double(j)/double(steps)))*2;
                    r=r>255?255:r;
                }
                else if(g>0){
                    g=(int)(255*(double(steps-j)/double(steps)))*2;
                    g=g>255?255:g;
                }
                color.setRgb(r,g,b);
                fadedColor.setRgb(float(r)*0.2,float(g)*0.2,float(b)*0.2);
                brush.setColor(color);
                fadedBrush.setColor(fadedColor);
                if(subband_energies[i]>=double(j)/double(steps)){
                    p.fillRect(x+i*(rectWidth+spaceH),y+contentsRect().height()-(j*(rectHeight+spaceV)),
                        rectWidth,-rectHeight,brush);
                }else{
                    p.fillRect(x+i*(rectWidth+spaceH),y+contentsRect().height()-(j*(rectHeight+spaceV)),
                        rectWidth,-rectHeight,fadedBrush);
                }
            }
        }
        p.end();
    }
    if (position<lastRenderedPosition) lastRenderedPosition=0;
    bitBlt(this,x,y,pixmap,0,0,-1,-1);

    //QFrame::paintEvent(ev);
}

void ScopeView::customEvent(QCustomEvent* ev)
{
    if(ev->type() == 346798){
        position=(((PlayPositionChanged*)ev)->getPosition());
        playing=(((PlayPositionChanged*)ev)->getPlaying());
        update();
    }
}


/*!
    \fn ScopeView::setSoundManager(SoundManager*)
 */
void ScopeView::setSoundManager(SoundManager* sm)
{
    soundManager=sm;
}


/*!
    \fn ScopeView::resizeEvent(QResizeEvent* ev)
 */
void ScopeView::resizeEvent(QResizeEvent* ev)
{
    subband_number=round(ev->size().width()/10);
    update();
}

QSize ScopeView::sizeHint () const{
    return QSize(100,height());
}
