/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mymath.h"

MyMath::MyMath(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


MyMath::~MyMath()
{
}

/*!
    \fn MyMath::standard_deviation(float* data, int length)

    \return standard deviation of the input data array
 */
float MyMath::standard_deviation(const float* data, int length)
{
    float mean=0;
    for (int i=0;i<length;i++){
        mean+=data[i];
    }
    mean/=float(length);
    float standard_dev=0;
    for (int i=0;i<length;i++){
        standard_dev+=pow(data[i]-mean,2);
    }
    standard_dev=sqrt(standard_dev/float(length));
    return standard_dev;
}

/*!
    \fn MyMath::gaussian_window(int length, float alpha)

    This methods fills the data array with [length] gaussian window values
 */
void MyMath::gaussian_window(float* data, int length, float alpha)
{
    float* result=new float[length];
    data[0]=0;
    for (int i=1;i<length;i++){
        data[i]=pow(M_E,-0.5*pow((alpha*(((i-1)-(float(length)/2.0))/(float(length)/2.0))),2));
    }
}

/*!
    \fn MyMath::linear_regression(double x1, double x1, double y1,double y2, double &b0, double& b1)

    \return  linear regression for value val with bounds [x1,y1] and [x2,y2]
 */
double MyMath::linear_regression(double x1, double x2, double y1,double y2, double val)
{

    double b1=(y2-y1)/(x2-x1);
    double b0=y1-(b1*x1);
    return b0+val*b1;
}



