/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LADSPAEFFECT_H
#define LADSPAEFFECT_H

#include <qobject.h>
#include <dlfcn.h>
#include <ladspa.h>
#include <ladspaport.h>
#include <qptrlist.h>
#include <iostream.h>
#include "monotostereosplitter.h"
#include "ntomonomixer.h"
#include "outputtozero.h"
#include "customeffect.h"
#include "customeffects.h"
#include "inputzero.h"
#include "passthrough.h"
/**
@author Predrag Viceic
*/
class LADSPAEffect : public QObject
{
Q_OBJECT
public:
    LADSPAEffect(const LADSPA_Descriptor*,QObject *parent = 0, const char *name = 0);

    ~LADSPAEffect();
    unsigned long getUniqueID();
    const char * getLabel();
    const char * getName();
    const char * getMaker();
    const char * getCopyright();
    unsigned long getPortCount();
    bool isRealtime();
    bool isInplaceBroken();
    bool isHardRTCapable();
    void init(int,float*,float*,float*,float*);
    bool isEffectSuitable();
    void deactivate();
    void activate();
    void cleanup();
    void process(long size);
    QPtrList<LADSPAPort>* getControlInputPorts();
    QPtrList<LADSPAPort>* getControlOutputPorts();
    QPtrList<LADSPAPort>* getAudioInputPorts();
    QPtrList<LADSPAPort>* getAudioOutputPorts();
    void advancePortValues(int);
    void startPortValues(long=0);
    void startControlPortValues(long);
    void setNbFrames(long);
    void setInUse(bool);
    bool getIsInUse();
    void initControlPortsValues();
    bool hasMonoInput();
    bool hasMonoOutput();
    bool hasAudioInput();
    int getNonAssignedOutput();
    bool usesDoublePlugin();
    void connectAudioPorts(long start);
    long getFrames();
public slots:
    void setDoublePlugin(bool);
private:
    const LADSPA_Descriptor* descriptor;
    LADSPA_Handle plugin_handle_1;
    LADSPA_Handle plugin_handle_2;
    QPtrList <LADSPAPort> audioInputPorts;
    QPtrList <LADSPAPort> audioOutputPorts;
    QPtrList <LADSPAPort> controlInputPorts;
    QPtrList <LADSPAPort> controlOutputPorts;
    CustomEffects* connectors;

protected:
    float* inputAudioBufferLeft;
    float* outputAudioBufferLeft;
    float* inputAudioBufferRight;
    float* outputAudioBufferRight;
    int currentAudioBufferPosition;
    bool isInUse;
    bool usesDoublePluginVal;
    long nbFrames;
};

#endif
