/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LADSPADIALOG_H
#define LADSPADIALOG_H

#include <iostream.h>
#include <qdialog.h>
#include <qtable.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qstring.h>
#include <qtextedit.h>
#include <qscrollview.h>
#include <qcombobox.h>
#include <ladspaeffects.h>
#include <ladspaeffect.h>
#include <ladspaport.h>
#include <ladspadialogbase.h>
#include <qstringlist.h>
#include <qobjectlist.h>
#include <qmessagebox.h>
#include <qcheckbox.h>

/**
@author Predrag Viceic
*/
class LADSPADialog : public LADSPADialogBase
{
Q_OBJECT
public:
    LADSPADialog(QWidget* parent=0,const char *name=0);

    ~LADSPADialog();
    void setEffectsList(LADSPAEffects*);
    bool checkPortAssignments();
    int exec();
    void initAudioBox(QVBox* parent,LADSPAPort* port,int count,bool connectToDouble);
    void clearScrollViews();
    enum Columns {NAME,LABEL,MAKER,UID};


private:
    LADSPAEffects* effects;
    int selectedUniqueId;
public slots:
    void accept();
    void currentChanged_(int,int);
    void headerClicked(int);
    void stateChanged();


signals:
    void addEffect(int id);


protected:
    int currentRow;
};

#endif
