/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "inputzero.h"

InputZero::InputZero(QObject* parent, const char* name): CustomEffect(parent, name)
{
     bufferLength=0;
     output=0;
}


InputZero::~InputZero()
{
    if(output) zaparr(output);
}


void InputZero::advancePosition(long length)
{

}

void InputZero::init(long _bufferLength)
{
     if(!output || _bufferLength>bufferLength){
        bufferLength=_bufferLength;
        if (output) zaparr(output);
        output=new float[bufferLength];
        std::memset(output,0,sizeof(float)*bufferLength);
    }
}

void InputZero::process(long length)
{
     std::memset(output,0,sizeof(float)*length);
}

void InputZero::setPosition(long position)
{

}



/*!
    \fn InputZero::setOutput_P(float*)
 */
float* InputZero::getOutput_P()
{
    return output;
}

QString InputZero::getName(){
    return "InputZero";
}
