/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef AKPMANAGER_H
#define AKPMANAGER_H

#include <qobject.h>
#include <qfile.h>
#include <qstringlist.h>
#include <iostream>
/**
@author Predrag Viceic
*/
class AKPManager : public QObject
{
Q_OBJECT
public:
    AKPManager(QObject *parent = 0, const char *name = 0);

    ~AKPManager();
    QByteArray getPaddedSampleName(QString filename);
    void writeAKPFile(QString,QStringList*);
    void writeZone(QFile* file,QString filename);
    void writeKeygroup(QFile* file,QString filename,int i);
    void write4Bytes(QFile* file,char fst=0x00,char snd=0x00,char trd=0x00,char fth=0x00);
    void writeByte(QFile* file,char fst);

};

#endif
