PHPEXE
<?php

 define("BELTANE", "yes");

 require_once("config.PHPEXT");
 require_once("auth_check.PHPEXT");

 $Config = new BeltaneConfig;

 $statusfile = "serverStatus.PHPEXT";
 $Jetzt = strftime("%x %H:%M"); 

function myErrorHandler ($errno, $errstr, $errfile, $errline, $errcontext) {

  global $statusfile;
  global $Jetzt;

  switch ($errno) {
  case E_ERROR:
    echo "<p><b>FATAL</b> [$errno] $errstr<br>\n";
    echo "  Fatal error in line ".$errline." of file ".$errfile;
    echo ", PHP ".PHP_VERSION." (".PHP_OS.")</p>\n";
    echo "Aborting...<br>\n";
    exit -1;
    break;
  case E_WARNING:
    if (TRUE == preg_match("/Operation not permitted/", $errstr)) {
	echo "  <p>$Jetzt <a href=\"$statusfile\" target=\"Work\">Server running</a></p>\n";
    } 
    else if (TRUE == preg_match("/No such process/", $errstr)) {
	echo "  <p>$Jetzt <a href=\"$statusfile\" target=\"Work\"><b>Server stopped</b></a><br />\n";
	echo "  (but pid file exists)</p>\n";
    } 
    else {
        echo "<p><b>WARNING</b> [$errno] $errstr</p>\n";
    }
    break;
  default:
    print("  <p><b>Server status unknown</b></p>");
    break;
  }
}

print <<<ENDOFPRINT
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<script language="JavaScript" type="text/javascript">
    <!--
     Jetzt = new Date();
     var Start = Jetzt.getTime();
     var absDown = 30;

     function ZeitAnzeigen() 
     { 
      var absSekunden = Math.round(ZeitBerechnen());
      absSekunden = absDown - absSekunden;
      var relSekunden = absSekunden % 60;
      var absMinuten = Math.round((absSekunden-30)/60);
      var anzSekunden ="" + ((relSekunden > 9) ? relSekunden : "0" + relSekunden);
      var anzMinuten ="" + ((absMinuten > 9) ? absMinuten : "0" + absMinuten);

      if (absSekunden <= 0) {
	var Ergebnis = location.href.search(/.+autorefresh.+/);
	var FooBar   = location.href.search(/.+\?.+/);
        if(Ergebnis == -1) {
	   if (FooBar == -1) {
	     location.href = location.href + "?autorefresh=1";
	   } else {
	     location.href = location.href + "&autorefresh=1";
           }
        } else {
	  location.reload();
        } 
	// location.reload();
      } else {
	// window.document.Anzeige.Zeit.value = anzMinuten + ":" + anzSekunden;
        window.setTimeout('ZeitAnzeigen()',1000);
      } 
     }

     function ZeitBerechnen()
     { 
      var Immernoch = new Date(); 
      return((Immernoch.getTime() - Start)/1000); 
     }

    //-->
   </script>
<head>
<title>Control</title>
<link rel="stylesheet" type="text/css" href="beltane_formate.css" />
<script language="JavaScript" src="js/changeimg.js" 
        type="text/javascript"></script>
</head>
<body onload="window.setTimeout('ZeitAnzeigen()',1000)">
  <div align="center">
  <table cellpadding="1" cellspacing="0" border="0" class="m1">
    <tr>
      <td>
        <table cellpadding="0" cellspacing="0" border="0" class="m2" 
               width="230">
           <tr>
              <td class="mc" height="20">
                   &nbsp; &nbsp; Beltane
              </td>
           </tr>
	   <!-- <tr>
	   <td class="mb">&nbsp;</td>
	   </tr> -->
           <tr>
              <td class="mb">
	      <div align="center">
              <table cellpadding="0" cellspacing="0" border="0" width="200">
                 <tr>
                    <td height="30">
                       <a onmouseover="changeImages('ima0','image0on')"
		       onmouseout="changeImages('ima0','image0off')"
		       href="./auth.PHPEXT?action=logout" target="_top"><img 
		       name="ima0" 
		       src="pix/ul.png" border="0" alt="Logout" /></a></td>
                    <td height="30">
                       <a onmouseover="changeImages('ima1','image1on')"
		       onmouseout="changeImages('ima1','image1off')"
		       href="./index.PHPEXT" target="_top"><img name="ima1" 
		       src="pix/ur.png" border="0" alt="Refresh" /></a></td>
		 </tr><tr>
		    <td height="30">
		      <a onmouseover="changeImages('ima2','image2on')"
		       onmouseout="changeImages('ima2','image2off')"
		       href="configure.PHPEXT" target="Work"><img name="ima2" 
		       src="pix/dl.png" border="0" alt="Configure" /></a>
                    </td><td height="30">
                       <a onmouseover="changeImages('ima3','image3on')"
		       onmouseout="changeImages('ima3','image3off')"
		       href="beltane_help/index.html" 
		       target="_blank"><img name="ima3" 
		       src="pix/dr.png" border="0" alt="Help" /></a>
                    </td>
                 <!-- 
                 </tr><tr>
		    <td height="30">
		      <a onmouseover="changeImages('imaST','imageSTon')"
		       onmouseout="changeImages('imaST','imageSToff')"
		       href="$statusfile" target="Work"><img 
		       name="imaST" src="pix/d_sstatus.png" border="0" 
		       alt="Server Status" /></a>
                    </td><td height="30"> &nbsp;
                    </td>
		 -->
                 </tr>
              </table>
	      </div>
              </td>
           </tr>
	   <!-- <tr>
	   <td class="mb">&nbsp;</td>
	   </tr> -->
        </table>
      </td>
    </tr>
ENDOFPRINT;

  print "  </table>";

  $pidfile = $Config->get_pid_file();
  if (!file_exists($pidfile)) {
	print("  <p>$Jetzt <a href=\"$statusfile\" target=\"Work\"><b>Server stopped</b></a></p>");
  } else {
	$tmparr   = @file($pidfile);
	$tmpindex = trim($tmparr[0]);
	if (isset($tmpindex)) {
   	  settype($tmpindex, "integer");
        } else {
	  $tmpindex = 0;
        }
	if ($tmpindex > 0) {

	  if (function_exists('posix_get_last_error')) {
	    $result = posix_kill($tmpindex, 0);
	  } else {
	    $old_error_handler = set_error_handler("myErrorHandler");
	    $result = posix_kill($tmpindex, 0);
	    restore_error_handler();
	  }
	  if ($result == TRUE) {
	    print("  <p>$Jetzt <a href=\"$statusfile\" target=\"Work\">Server running</a></p>");
	  } 
	  else {
	    if (function_exists('posix_get_last_error')) {
	      $errnum = posix_get_last_error();
	      $errstr = posix_strerror($errnum);
              if (TRUE == preg_match("/Operation not permitted/", $errstr)) {
	        echo "  $Jetzt <a href=\"$statusfile\" ";
	        echo " target=\"Work\">Server running</a>\n";
              } 
              else if (TRUE == preg_match("/No such process/", $errstr)) {
	        echo "  $Jetzt <a href=\"$statusfile\" ";
	        echo " target=\"Work\"><b>Server stopped</b></a>";
	        echo " (pid file exists)\n";
              } 
              else {
                echo "<b>WARNING</b> [$errno] $errstr";
              }
	    }
	  }
        } else {
	  print("  <p>$Jetzt <a href=\"$statusfile\" target=\"Work\"><b>Server status unknown</b></a><br />");
	  print("  (pid file invalid or unreadable)</p>");
        }
  }

  print "  </div>";
  print "</body>";
  print "</html>";



?>
