PHPEXE
<?php

##################################################################
#
# authentication interface                            
# Copyright (C) 2000 Rainer Wichmann                                      
#                                                                         
#  This program is free software; you can redistribute it                 
#  and/or modify                                                          
#  it under the terms of the GNU General Public License as                
#  published by                                                           
#  the Free Software Foundation; either version 2 of the License, or      
#  (at your option) any later version.                                    
#                                                                         
#  This program is distributed in the hope that it will be useful,        
#  but WITHOUT ANY WARRANTY; without even the implied warranty of         
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
#  GNU General Public License for more details.                           
#                                                                         
#  You should have received a copy of the GNU General Public License      
#  along with this program; if not, write to the Free Software            
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
#
##################################################################
#
# CONFIGURE in config.inc 
#
##################################################################

 define("BELTANE", "yes");

 function  bail_phperror($title, $errmessage)
 {
   print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
   print "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n";
   print "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
   print "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n";
   print "<head><title>Beltane $title</title>\n";
   print "<link rel=\"stylesheet\" type=\"text/css\" \n";
   print "      href=\"beltane_formate.css\" />\n";
   print "</head>";
   print "<body>";
   print("<h1>Beltane: $title</h1>");
   print("<p style=\"color:#FF0000;\"><b style=\"color:#FF0000;\">ERROR:</b> $errmessage</p>");
   print "</body></html>";
   exit();
 }

 if (TRUE != function_exists('xml_parser_create')) {
	bail_phperror("PHP Configuration Error", 
	"PHP has been compiled without support for XML parser functions.");
 } 
 else if (TRUE != function_exists('pg_close') &&
	  TRUE != function_exists('mysql_close')) {
	bail_phperror("PHP Configuration Error", 
	"PHP has been compiled without support for either PostgreSQL or MySQL.");
 } 
 else {
	$theversion = phpversion();
	if ($theversion{0} != '4') {
		bail_phperror("PHP Configuration Error",
		"Beltane requires PHP 4. Your version is $theversion");
	}
 }

 if (NULL != ini_get('variables_order')) {
    $theorder = ini_get('variables_order');
    if (FALSE == strstr($theorder, "G") || FALSE == strstr($theorder, "P")) {
      bail_phperror("PHP Configuration Error", 
      "PHP configuration variable variables_order does not include G and P.");
    }
 } 
 $theorder = ini_get('session.use_cookies');
 if (1 != $theorder) {
      bail_phperror("PHP Configuration Error", 
      "PHP configuration variable session.use_cookies is not set to 1 (On).");
 } 

 require_once("config.PHPEXT");
 $Config = new BeltaneConfig;

 $theorder = ini_get('safe_mode');
 if (0 != $theorder) {
      $comone = dirname($Config->get_cp_com());
      $comtwo = dirname($Config->get_update_com());
      $edir   = ini_get('safe_mode_exec_dir');
      if (strlen($edir) == strlen($comone) && strlen($edir) == strlen($comtwo)
	&& 0 == strcmp($edir, $comone) && 0 == strcmp($edir, $comtwo)) {
	$theorder = "ok";
      }
      else {
        bail_phperror("PHP Configuration Error", 
        "PHP configuration variable safe_mode is set to 1 (On) and safe_mode_exec_dir ($edir) is not ${comtwo}.");
      }
 } 

 // session_cache_limiter('public');

 if ($HTTP_SERVER_VARS["REQUEST_METHOD"] == "GET") {
   $action = $HTTP_GET_VARS["action"];
   $user   = $HTTP_GET_VARS["user"];
   $md5in  = $HTTP_GET_VARS["md5in"];
   $token  = $HTTP_GET_VARS["token"];
   $times  = $HTTP_GET_VARS["times"];
   $target = $HTTP_GET_VARS["target"];
 } else {
   $action = $HTTP_POST_VARS["action"];
   $user   = $HTTP_POST_VARS["user"];
   $md5in  = $HTTP_POST_VARS["md5in"];
   $token  = $HTTP_POST_VARS["token"];
   $times  = $HTTP_POST_VARS["times"];
   $target = $HTTP_POST_VARS["target"];
 } 


 session_start();
 if (FALSE == session_is_registered("count")) {
	session_register("count");
	$HTTP_SESSION_VARS["count"]++;
	$sessiontest = 0;
 } else {
	$HTTP_SESSION_VARS["count"]++;
	$sessiontest = 1;
 }

 $valid = $HTTP_SESSION_VARS["valid"];

 if ($action == "login" && $sessiontest == 0) {
        bail_phperror("Browser Configuration Error", 
        "You have no session registered yet. Are you sure that you have cookies enabled ?");
 }

 if ($sessiontest == 0) {

     $timestamp = time();
     $HTTP_SESSION_VARS["timestamp"] = $timestamp;

     $valid = 0;
     $HTTP_SESSION_VARS["valid"] = $valid;

     $token0 = md5(uniqid(rand(),1));
     unset($tstr);
     exec("ps axww 2>/dev/null", $tstr);
     $colon_separated = implode(":", $tstr);
     $token1 = md5($colon_separated);
     $token  = md5($token1 . $token0);
     $HTTP_SESSION_VARS["token"] = $token;
     $HTTP_SESSION_VARS["other_side"] = $HTTP_SERVER_VARS["REMOTE_ADDR"];

     $Config->print_head0("Login");

     print <<<ENDOFFORM
     <script language="javascript" type="text/javascript"> 
     <!--
     if(top.frames.length > 0)
      top.location.href=self.location;
     //-->
     </script>     
     <script language="javascript" type="text/javascript" 
	src="js/md5.js"></script>
     <script language="javascript" type="text/javascript" 
	src="js/cr.js"></script>
     <script language="JavaScript" src="js/changeimg.js" 
        type="text/javascript"></script>
     </head>
ENDOFFORM;

     $Config->print_opening("Login");
     print <<<ENDOFFORM
     <p style="text-align:center">
     <img 
      border="0" alt="Beltane" src="pix/logo.png" />
     </p>
     <p>
     <strong>Please&nbsp;authenticate</strong><br /><br />
     </p>
     <noscript>
     <p>
     <b>WARNING</b>
     </p><p>
     Your browser does not support javascript. Do not attempt to login !
     Your login password would be sent in <b>cleartext</b>, and login will
     <b>fail</b> anyway.
     </p>
     </noscript>
     <form name="lgform" enctype="x-application/x-www-form-urlencoded"
          action="auth.PHPEXT"
          method="post">
     <div><pre>
     User:     <input name="user" type="text"
                     size="40" /><br />
     Password: <input name="password"
                     type="password" size="40" /><br />
     <a onmouseover="changeImages('imaOK','imageOKon')"
        onmouseout="changeImages('imaOK','imageOKoff')"
	href="javascript:doChallengeResponse();"><img name="imaOK"
      border="0" alt="login" src="pix/dl_ok.png" /></a>
     <input name="md5in" value="" 
                     type="hidden" size="40" />
     <input name="token" 
                     type="hidden" value="$token" />
     <input name="times" 
               type="hidden" value="$timestamp" />
     <input name="target" 
               type="hidden" value="$target" />
     <input name="action" 
               type="hidden" value="login" />
     </pre><br /></div></form>
     <p>
     Please note that you need to have <strong>cookies</strong> enabled for login.
     </p>
ENDOFFORM;

     $Config->print_closing();
     exit();
 }
   


 if ($action == "logout" && $valid == 1 && 
	$HTTP_SESSION_VARS["other_side"] = $HTTP_SERVER_VARS["REMOTE_ADDR"]) {
   # Unset all of the session variables.
   session_unset();
   # Finally, destroy the session.
   session_destroy();

   $Config->print_head("Logout");
   $Config->print_opening("Logout");
   print "<h1>Logout</h1>\n";
   print "<p>You&nbsp;have&nbsp;been&nbsp;logged&nbsp;out&nbsp;from&nbsp;the&nbsp;system.</p>\n";
   print "<p><a href=\"auth.PHPEXT\">Login form</a></p>\n";
   $Config->print_closing();
   exit();
 }

 if ($action == "login") {

     $timestamp = $HTTP_SESSION_VARS["timestamp"];

     $token = $HTTP_SESSION_VARS["token"];
     $timeout = $Config->get_timeout();
     // $pass_md5  = md5($Config->get_admin_password());
     $user_md5  = $Config->get_admin_name();
     $pass_md5  = $Config->get_admin_password();
     // $check_md5 = md5($user . $pass_md5 . $token);
     $check_md5 = md5($user_md5 . $pass_md5 . $token);

     if ($timeout < (time() - $timestamp)) {
	 # Unset the session count.
   	 session_unregister("count");
   	 # Unset all of the session variables.
   	 session_unset();
   	 # Finally, destroy the session.
   	 session_destroy();

	 $Config->print_head_relocate("Login failure", "3", "auth.PHPEXT");
         $Config->print_opening("Login&nbsp;failure");
	 // print "<h1>Login&nbsp;failure</h1>\n";
	 print "<p>Timeout&nbsp;exceeded.</p>\n";
	 print "<p><a href=\"auth.PHPEXT\">Try again</a></p>\n";
	 $Config->print_closing();
	 exit();
     } else if ($check_md5 == $md5in) {

   	if ( $HTTP_SESSION_VARS["other_side"] != 
	  $HTTP_SERVER_VARS["REMOTE_ADDR"] ) {
   		# Unset all of the session variables.
   		session_unset();
   		# Finally, destroy the session.
   		session_destroy();

   		$Config->print_head_relocate("Bad remote address", 
						"3", "auth.PHPEXT");
         	$Config->print_opening("Bad&nbsp;remote&nbsp;address");
   		// print "<h1>Bad&nbsp;remote&nbsp;address</h1>\n";
   		print "<p>REMOTE_ADDR&nbsp;has&nbsp;changed.</p>\n";
   		print "<p><a href=\"auth.PHPEXT\">Login</a></p>\n";
   		$Config->print_closing();
   		exit();
         }

	 $valid = 1;
	 $HTTP_SESSION_VARS["valid"] = $valid;
	 $tmp = $Config->get_admin_password();
	 if ($tmp == "b23016897bdf980264949f54c16d03d7") {
           $Config->print_head_relocate("Login successful", "5", 
		"index.PHPEXT");
	   $Config->print_opening("Please&nbsp;set&nbsp;a&nbsp;new&nbsp;password");
	   // print "<h1>Login&nbsp;successful</h1>\n";
	   print "<p>You&nbsp;are&nbsp;logged&nbsp;in&nbsp;to&nbsp;the&nbsp;system.</p>\n";
	   print "<p><b>WARNING:</b>&nbsp;Your&nbsp;first&nbsp;action&nbsp;should&nbsp;be&nbsp;to&nbsp;use \n";
	   print "the&nbsp;<i>Configure</i>&nbsp;button&nbsp;in&nbsp;the&nbsp;upper&nbsp;left&nbsp;menue&nbsp;and \n";
	   print "set a <b>new password</b> !!!</p>\n";
	 } else {
           $Config->print_head_relocate("Login successful", "0", 
		"index.PHPEXT");
	   $Config->print_opening("Login&nbsp;successful");
	   // print "<h1>Login&nbsp;successful</h1>\n";
	   print "<p>You&nbsp;are&nbsp;logged&nbsp;in&nbsp;to&nbsp;the&nbsp;system.</p>\n";
         }
	 print "<p><a href=\"index.PHPEXT\">Main window</a></p>\n";
	 $Config->print_closing();
	 exit();
     } else {
	 # Unset all of the session variables.
   	 session_unset();
   	 # Finally, destroy the session.
   	 session_destroy();

	 $Config->print_head_relocate("Login failure", "3", "auth.PHPEXT");
	 $Config->print_opening("Login&nbsp;failure");
	 // print "<h1>Login&nbsp;failure</h1>\n";
	 print "<p>Username&nbsp;or&nbsp;login&nbsp;incorrect.</p>\n";
	 print "<p><a href=\"auth.PHPEXT\">Try again</a></p>\n";
	 $Config->print_closing();
	 exit();
     }
 }

 if ($valid == 1) {

   if ( $HTTP_SESSION_VARS["other_side"] != $HTTP_SERVER_VARS["REMOTE_ADDR"]) {
   	# Unset all of the session variables.
   	session_unset();
   	# Finally, destroy the session.
   	session_destroy();

   	$Config->print_head_relocate("Bad remote address", "3", "auth.PHPEXT");
        $Config->print_opening("Bad&nbsp;remote&nbsp;address");
   	// print "<h1>Bad&nbsp;remote&nbsp;address</h1>\n";
   	print "<p>REMOTE_ADDR&nbsp;has&nbsp;changed.</p>\n";
   	print "<p><a href=\"auth.PHPEXT\">Login</a></p>\n";
   	$Config->print_closing();
   	exit();
   }

   $Config->print_head_relocate("Welcome", "0", "index.PHPEXT");
   $Config->print_opening("Welcome");
   print "<h1>Welcome&nbsp;here&nbsp;!</h1>\n";
   print "<p>You&nbsp;are&nbsp;logged&nbsp;in&nbsp;to&nbsp;the&nbsp;system.</p>\n";
   print "<p><a href=\"index.PHPEXT\">Main window</a></p>\n";
   $Config->print_closing();
   exit();
 }
 
 # Unset all of the session variables.
 session_unset();
 # Finally, destroy the session.
 session_destroy();

 $Config->print_head_relocate("ERROR", "3", "auth.PHPEXT");
 $Config->print_opening("Error");
 print "<h1>ERROR</h1>\n";
 print "<p>Some&nbsp;error&nbsp;has&nbsp;occured.</p>\n";
 print "<p><a href=\"auth.PHPEXT\">Login</a></p>\n";
 $Config->print_closing();
 exit();
?>
