#!/usr/bin/env python
##    Fonty Python Copyright (C) 2006, 2007, 2008 Donn.C.Ingle
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This file is part of Fonty Python.
##    Fonty Python is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Fonty Python is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with Fonty Python.  If not, see <http://www.gnu.org/licenses/>.

import os, sys

## this results in same thing as the __file__ stuff
## because we are running *this* script directly, 
## we can use argv[0]
#fontyroot = os.path.dirname(os.path.realpath(sys.argv[0]))

import fontypythonmodules.i18n
import fontypythonmodules.sanitycheck
import fontypythonmodules.fpversion
   
from distutils.core import setup

#This is a list of files to install, and where:
files = ["things/*", "pofiles/*", "locale/fr/LC_MESSAGES/*", "locale/it/LC_MESSAGES/*"]

setup(name = "fontypython",
    version = fontypythonmodules.fpversion.version,
    description = fontypythonmodules.strings.description,
    author = "Donn.C.Ingle",
    author_email = fontypythonmodules.strings.contact,
    license = "GNU GPLv3",
    url = "https://savannah.nongnu.org/projects/fontypython/",
    packages = ['fontypythonmodules'],
    #'fontypython' package must contain 'files' (see list above)
    package_data = {'fontypythonmodules' : files},
    #'fontypython' is in the root.
    scripts = ["fontypython", "fp"],
    long_description = fontypythonmodules.strings.long_description,
    classifiers=[
      'Development Status :: 4 - Beta',
      'Environment :: X11 Applications :: GTK',
      'Intended Audience :: End Users/Desktop',
      'Intended Audience :: Developers',
      'License :: OSI Approved :: GNU General Public License (GPL)',
      'Operating System :: POSIX :: Linux',
      'Programming Language :: Python',
      'Topic :: Desktop Environment',
      'Topic :: Text Processing :: Fonts'
      ]    
) 

