##    Fonty Python Copyright (C) 2006, 2007, 2008 Donn.C.Ingle
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This file is part of Fonty Python.
##    Fonty Python is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Fonty Python is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with Fonty Python.  If not, see <http://www.gnu.org/licenses/>.

## Import actually loads AND runs those modules.

## This was done in ../fontypython[.py]
## Must do this again or the '_' name is not available.
## I really don't savvy what happens when the imports cross
## from the parent folder into this one.
import i18n # Sets up _() for ALL the modules from now on.

import sys
import strings
import fpsys

## Quick tests - which is there?
## Using imp will find a module very quickly, faster than import x
import imp

## PIL : Is it there?
try: 
    import Image, ImageFont, ImageDraw 
except: 
    print strings.PILError()
    raise SystemExit
    
## Process the command line stuff
import cli

## All alternate gui stuff is pie-in-the-sky code
## I have yet to start that battle!
## Right now, it's only wxPython.

## Determine if the gui chosen can be opened
validguis = ["wxgui", "qtgui"]

chosengui = fpsys.config.usegui # this was set in cli module (default is wxgui)
try:
    import wxversion ## Dec 2007: noticed that it may not be installed along with wxPython....
    wxversion.ensureMinimal("2.6") 
except:
    print strings.wxVersionError()
    print
try:
    imp.find_module("wx")
except: 
    validguis.remove("wxgui")

try: 
    imp.find_module("qt")
except: 
    validguis.remove("qtgui")

if chosengui in validguis:
    fpsys.config.usegui = chosengui #update config
else:    
    print _("An appropriate GUI could not be found.")
    print
    print strings.wxError()
    raise SystemExit

## Dynamic import of a named module
## Wild statement - I don't yet grok the need for the fontypython. bit, 
## because here i am, in the fontypython directory ... but hack on!
gui = __import__("fontypythonmodules." + chosengui) 

## End, clean up
fpsys.config.Save()
