##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

import sys, os, pickle
import strings
import pathcontrol


####
## Save and Load the conf file
class Configure:
    """Makes/Loads the conf file.
    Supplies size, pos, numinpage, text string and point size to other objects."""
    def __init__ ( self ) :
        ## PUBLIC vars :  Set some defaults:
        self.size =  ( 400,600 ) 
        self.pos = ( 10, 10 )
        self.numinpage = 10
        self.text = "Jump the lazy dog fox"
        self.points = 64      
        self.lastview = "" # a pog name or a folder path.
        self.usegui = None
        ## Private vars
        self.__dontSaveNumInPage = False
        self.__setData ( )
        self.ipc = pathcontrol.PathControl ( )
        if os.path.exists ( self.ipc.appConf ( ) ):
            try:
                pf = open ( self.ipc.appConf (  ) ,"r" )  #Using global self.ipc object!
                self.__data = pickle.load ( pf ) 
                pf.close (  ) 
            except:
                sys.exit ( "%s file appears to be damaged.\nPlease delete it and start again" %  self.ipc.appConf (  ) )
        else:
            print "No config file found, creating it with defaults."
            self.__write (  ) 
        ## Now get them into the instance vars:
        try:
            self.size = self.__data['size']
            self.pos= self.__data['pos']
            self.numinpage = self.__data['numinpage']
            self.text = self.__data['text']
            self.points= self.__data['points']
            self.lastview = self.__data['lastview']               
        except KeyError:
            ## The conf file has keys that don't work for this version, chances are it's old.
            ## Let's delete and re-make it.
            try:
                os.unlink ( self.ipc.appConf (  ) )
            except:
                sys.exit ( "The fontypython config file is damaged.\nPlease remove it and start again" )
            self.__write ( )
    def dontSaveNumInPage ( self, flag ):
        self.__dontSaveNumInPage = flag
    def __setData ( self ):
        self.__data = {"size":self.size,
                                "pos":self.pos,
                                "numinpage":self.numinpage,
                                "text":self.text,
                                "points":self.points,
                                "lastview" : self.lastview
                                }
    def __write ( self ) :
        #If we are NOT to save the numinpage, then fetch it from what was there before.
        if self.__dontSaveNumInPage:
            self.numinpage = self.__data["numinpage"]
        self.__setData ( )
        try:
            pf = open ( self.ipc.appConf (  ) ,"w" ) 
            pickle.dump ( self.__data, pf ) 
            pf.close (  ) 
        except IOError:
            print "Could not write to the config file."
    def save ( self ) :
        self.__write (  )  #Go write the file




## Our config instance - it will have one instance across
## all the modules that use it.
instance = Configure ( )
