/* Copyright (C) 2009 Christofer Jonsson
 *
 * This file is part of FNM.
 *
 * FNM is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * FNM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FNM.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fnm_util.h"

fnm_status_t fnm_util_filename(const char *path, size_t length, size_t *pos)
{
   size_t index = 0;

   if (path == NULL || length == 0)
      return FNM_FAILURE;

   index = length - 1;

   if (path[index] == '/')
      return FNM_FAILURE;

   while (index > 0)
   {
      if (path[index] == '/')
      {
	 *pos = index + 1;
	 return FNM_SUCCESS;
      }

      --index;
   }

   *pos = index;
   return FNM_SUCCESS;
}
