/* Copyright (C) 2009 Christofer Jonsson
 *
 * This file is part of FNM.
 *
 * FNM is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * FNM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FNM.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FNM_STR_H
#define FNM_STR_H

#include <string.h>

typedef struct 
{
      char *str;
      size_t len;
} fnm_str_t;

/* Initializes string */
void fnm_str_init(fnm_str_t *str, const char *c_str);

/* Destroys string */
void fnm_str_destroy(fnm_str_t *str);

/* Converts string to lower case */
void fnm_str_lower_case(fnm_str_t *str, size_t offset);

/* Converts string to upper case */
void fnm_str_upper_case(fnm_str_t *str, size_t offset);

/* Replaces old substring with new substring */
void fnm_str_replace(fnm_str_t *str, 
		     fnm_str_t *old_sub, 
		     fnm_str_t *new_sub,
		     size_t offset);

#endif /* FNM_STR_H */
