/* Copyright (C) 2009 Christofer Jonsson
 *
 * This file is part of FNM.
 *
 * FNM is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * FNM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FNM.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FNM_ERROR_H
#define FNM_ERROR_H

#ifdef DEBUG

#define FNM_ERROR(...); fnm_error_debug(__FILE__, __LINE__, __VA_ARGS__);

void fnm_error_debug(const char *file, unsigned line, const char *format, ...);

#else

#define FNM_ERROR(...); fnm_error(__VA_ARGS__);

void fnm_error(const char *format, ...);

#endif /* DEBUG */

#endif /* FNM_ERROR_H */
