/* Copyright (C) 2009 Christofer Jonsson
 *
 * This file is part of FNM.
 *
 * FNM is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * FNM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FNM.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FNM_CMD_H
#define FNM_CMD_H

#include "fnm_global.h"

/* Rename function */
typedef int (*fnm_cmd_func_rename_t)(const char *, const char *);

/* Command function */
typedef fnm_status_t (*fnm_cmd_func_t)(int, 
				       const char **, 
				       fnm_cmd_func_rename_t);

/* Lower case command */
fnm_status_t fnm_cmd_lower_case(int nargs, 
				const char **args, 
				fnm_cmd_func_rename_t rn);

/* Upper case command */
fnm_status_t fnm_cmd_upper_case(int nargs, 
				const char **args, 
				fnm_cmd_func_rename_t rn);

/* Replace command */
fnm_status_t fnm_cmd_replace(int nargs, 
			     const char **args, 
			     fnm_cmd_func_rename_t rn);

/* Version command */
void fnm_cmd_version();

#endif /* FNM_CMD_H */
