/*
 *  localize.h - Localization helper functions.
 *               This file is part of the FreeLCD package.
 *
 *  $Id: localize.h,v 1.3 2003/03/23 20:14:11 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _FLCDD_LOCALIZE_H
#define _FLCDD_LOCALIZE_H 1

/* Create a time string (e.g. "23:12" or "05.20 pm"). */
char* l10n_time( int hours, int minutes );
char* l10n_time_sec( int hours, int minutes, int seconds )

/* Show a timespan */
char* l10n_timespan( long seconds );

/* Date functions */
char* l10n_date_long( int day, int month, int year );
char* l10n_date_short( int day, int month, int year );
char* l10n_weekday_long( int weekday );
char* l10n_weekday_short( int weekday );

/* Convert to 3 digits plus metric (Kilo, Mega, Tera, Exa, Peta) */
char* l10n_metric( float value );

#endif /* Multiple include guard */
