/*
 *  connections.h - Manage connected sockets and the incoming data.
 *                  This file is part of the FreeLCD package.
 *
 *  $Id: connections.h,v 1.4 2003/11/05 21:33:04 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _FLCDD_CONNECTIONS_H
#define _FLCDD_CONNECTIONS_H 1

#include <netinet/in.h>

void conn_open (int sock, struct sockaddr_in *s);
void conn_data (int sock, char *buf, size_t size);
void conn_close (int sock);
int conn_reply (void *originator, const char *data, size_t len);

#endif /* Multiple include guard */
