/*
 *  charlayout.h - Create a layout for a character-based renderer.
 *                 This file is part of the FreeLCD package.
 *
 *  $Id: charlayout.h,v 1.4 2004/01/16 23:17:56 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

/** \file charlayout.h
 * Routines for creating screen layouts for character based devices.
 */


#ifndef _CHARLAYOUT_H
#define _CHARLAYOUT_H

#include <common/xmlt.h>

/** A visible element in the layout of the screen. They are less abstract
 * than widgets: they have a position on a canvas, and a size. The result
 * of fitting a hierarchy of widgets into a canvas, is a set of these
 * structs. 
 */
typedef struct
{
  int x;            /**< X position on the canvas. */
  int y;            /**< Y position on the canvas. */
  int width;        /**< Width of the element in charaters. */
  int height;       /**< Height of the element in characters. */
  char *utf8_data;  /**< Textual contents of this element. */
  char is_label;    /**< A flag, indicating if it is a static label, or a 
                         dynamic data field. */
}
cl_layout_elem;

/** Physical layout of a screen.
 * After fitting a tree of widgets to a canvas with a given size, this
 * struct contains the resulting visible elements. 
 */
typedef struct
{
  size_t          layout_data_size; /**< Number of elements in this layout. */
  cl_layout_elem  *layout_data;     /**< An array of elements. */
}
cl_layout;


/** Create a screen layout from XML data. 
 * \param layout The XML layout, as specified by a client.
 * \param width The width of the canvas to fit the layout into.
 * \param height The height of the canvas to fit the layout into.
 */
cl_layout *
cl_make_layout (xml_node *layout, int width, int height);

/** Free all resources used by a layout that was created earlier by
 * cl_make_layout(). 
 * \param layout The layout struct to clean up.
 */
void
cl_free_layout (cl_layout *layout);

#endif /* Multiple include guard */
