/*
 *  utfconv.h : Character conversion between UTF-8 and UCS4.
 *              This file is part of the FreeLCD package.
 *
 *  $Id: utfconv.h,v 1.1 2004/01/17 00:04:24 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _UTFCONV_H
#define _UTFCONF_H 1

#include <stdlib.h>

typedef unsigned int  ucs4_t;

size_t
utf8_to_wc (const char *utf8, ucs4_t *wchar);

size_t
wc_to_utf8 (ucs4_t wchar, char *utf8);

#endif

