/*
 *  socket.h : TCP/IP socket routines.
 *             This file is part of the FreeLCD package.
 *
 *  $Id: socket.h,v 1.4 2003/11/02 21:38:16 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */


#ifndef _FLCD_SOCKET_H
#define _FLCD_SOCKET_H 1

#include <sys/select.h>
#include <netinet/in.h>

typedef int socket_t;

/* Create a plain socket and return the handle */
socket_t socket_create (const char *addr, unsigned int port);

/* Create a server socket and return the handle */
socket_t socket_create_server (unsigned int port, fd_set *fdset);

/* Poll server socket for connections and/or clients sending data */
int
socket_poll (socket_t sock, fd_set *fdset,
             void (*callback_newconn) (socket_t sock, struct sockaddr_in *in),
             void (*callback_data) (socket_t sock, char *data, size_t len),
             void (*callback_close) (socket_t sock));

/* Send something over the socket */
int socket_send (socket_t sock, const char *data, size_t len);

#endif /* Multiple include guard */
