/*
 *  backend.h - Different backends that can be used by the drivers.
 *              This file is part of the FreeLCD package.
 *
 *  $Id: backend.h,v 1.1 2004/01/16 23:06:44 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

/** \file backend.h
 * Different backends that can be used by device drivers.
 * This header file defines a uniform API for sending data over serial,
 * parallel, USB, and I2C ports, as well as a curses window for those
 * who want to test FreeLCD without an LCD. */

#ifndef _FLCDD_BACKEND_H
#define _FLCDD_BACKEND_H 1

#include <stdlib.h>

#include "common/xmlt.h"


#define BACKEND_NOT_OPENED_ERR -1  /* Returned by backend_send() */

/** Create a backend handle. 
 * The XML configuration data is the part of the central config file
 * enclosed within <backend> tags.
 * \param config Part of the configuration file, root tag is normally <backend>.
 * \param name Name of this backend.
 * \return Pointer to backend handle.
 */
void *backend_create_handle (xml_node *config, const char* name);

/** Send some data over the backend.
 * \param handle Handle returned by \ref backend_create_handle.
 * \param data Pointer to the data to send.
 * \param len Amount of data to send.
 * \return Zero if operation failed, nonzero if it succeeded. */
int backend_send (void *handle, const char *data, size_t len);

/** Close backend handle and free the memory.
 * \param handle Handle returned by \ref backend_create_handle. */
void backend_free_handle (void *handle);

#endif /* Multiple include guard */
