/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _SLICER_H
#define _SLICER_H

#include <string>

typedef bool (*PAUSE_FUNCTION_t)(unsigned int);

class Slicer
{
public:
	Slicer();
	~Slicer();
	
	bool SetSize(const long long int size);
	bool SetFullName(const std::string & full_name);
	void SetPauseFunction(PAUSE_FUNCTION_t pause_function) { m_pause_function = pause_function; };
	
  off_t GetArchivePosition() {return m_archive_pos;};
  
	void PrintSettings();
	
	bool AppendData(const char *buffer, unsigned int length);
	
private:
	off_t m_size, m_slice_offset, m_archive_pos; /*FIXME: m_archive_pos is only meaningful when sequentially writing to the archive. Because it is only updated in the writing function*/
	PAUSE_FUNCTION_t m_pause_function;
	
	std::string m_slice_path;
	std::string m_slice_base_name;
	
	unsigned int m_slice_num;
	FILE *m_slice_file_handle;
	
	bool HandleSlices();
	size_t WriteAmmount();
	bool CreateNewSlice();
	bool SwitchSlice(unsigned int slice_num);
};

#endif /* _SLICER_H */

