/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _FILTEROUTCACHEBASE_H
#define _FILTEROUTCACHEBASE_H

#include <string>
#include <sys/types.h>

class FilterOutCacheBase
{
public:
  FilterOutCacheBase() {};
	virtual ~FilterOutCacheBase() {};

	virtual bool Flush() = 0;
	virtual bool PutData(const char *data, size_t len) = 0;

	virtual off_t TotalBytes() = 0;

  virtual bool DataAvailable() {return false;};
  virtual bool Dump() {return false;};
};

#endif /* _FILTEROUTCACHEBASE_H */

