/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _ARCHIVER_H
#define _ARCHIVER_H

#include <sys/types.h>
#include <sys/stat.h>
#include <string>
#include <map>

#include "Slicer.h"
#include "Index.h"
#include "ArchiverCallbacks.h"
#include "FilterOutCacheBase.h"
#include "NullOutFilter.h"
#include "ZLibOutFilter.h"
#include "sha1sum.h"

struct archive_header {
	u_int32_t endian_arch;
	u_int16_t format_version;
} __attribute__((packed)); /* Pack this because it gets written to the archive */

class Archiver
{
public:
	Archiver(TArchiverWriteCallback write_callback, TArchiverGetOffset get_offset);
	~Archiver();
	
  void SetMaxMemcache(off_t max_memcache) {m_max_mem_cache = max_memcache;};
  
	bool CreateArchive(bool use_index, unsigned int compression_level /*TODO: Maybe Replace with compression_method*/);
	bool CommitArchive();
	bool AddToArchive(const char *filename);

	void PrintSettings();
	
private:
	TArchiverWriteCallback m_write;
  TArchiverGetOffset m_get_offset;
	Index *m_index;

  unsigned int m_compression_level;
  off_t m_max_mem_cache;

	std::map<ino_t, std::string> m_hardlink_nodes; /* Sorry excuse for a hash */
	
	off_t StatPack(const char *filename, const struct stat &file_stat, bool use_compression, std::string *statbuf);

  bool FilterCacheFileFromDisk(const char *filename, bool use_mem_cache, bool use_compression, FilterOutCacheBase **filtered_cache, Sha1Sum *file_sum, off_t *total_bytes);
  bool FilterFileFromDisk(FilterOutCacheBase *filter, const char *filename, Sha1Sum *file_sum, off_t *ammount_read = NULL);
};

#endif /* _ARCHIVER_H */

