<?php

# FitGallery 0.85
# (C) Omar Lpez 'pollo' (pollo.es.pollo@gmail.com), Enrique D. Bosch 'presi' (presidev@confluencia.net)
# http://fitgallery.presi.org
#
# view thumbs
# args:
# galeria - string  - gallery name
# avance  - integer - number of thumbnails per page
# para    - integer - number of the first thumbnail to show
 
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_html.php';
include 'common_sec.php';

include 'config/config-thumb.php';
include 'config/config.php';
include 'config/config-lang.php';

$galeria=check_input($_GET['galeria'],$VALID_CHARS);

if ($npages_user)
 {
   $avance=check_input($_GET['avance'],'number');
   if ($avance>$max_avance) $avance=$max_avance;
 }
if ($avance==0) $avance=$def_avance;

$para=check_input($_GET['para'],'number');

$dirimgs='imgs';
$semiruta=$dirgal.'/'.$galeria;
$file_titulo=$semiruta.'/'.$titulo;
$texto_titulo=strtr(strip_tags(file_get_contents($file_titulo)),"\n",'');
$file_subtitulo=$semiruta.'/'.$subtitulo;
$ruta=$semiruta.'/'.$dirimgs;
$n=0;
$total=0;

$handle=opendir($ruta);            # Scan image directory
while ($file = readdir($handle))
{ 
 if ($file != '.' && $file != '..')
  {
    $arr[$n]['date']=date($date_string,filemtime("$ruta/$file"));
    $arr[$n]['file']=$file;
    $arr[$n]['bytes']=filesize("$ruta/$file");
    $arr[$n]['size']=getimagesize("$ruta/$file");
    $total += $arr[$n]['bytes'];
    $n++;
  }
}
closedir($handle); 

$totalmegas=round($total/10485.76)/100;
sort($arr);
$numero_arch=count($arr);

if ($para>$numero_arch) exit_error('Images not found.');

$desde=$para+1;
$avmenosuno=$avance-1;
$hasta=$desde+$avmenosuno;
if ($hasta>$numero_arch) $hasta=$numero_arch;
$para2=$para+($avmenosuno);
$nummenosuno=$numero_arch-1;
$numer_pag=$nummenosuno/$avance;
$numer_pagmasuno=$numer_pag+1;

# Generate navigator array

for ($i = 1, $cuenta=$avance, $cuentaant=1; $i <= $numer_pagmasuno; $i++)
{
   if ($cuentaant!=$desde)
     {
       $arrnav[$i]['enlace']=true;
       $arrnav[$i]['para']=$cuentaant-1;
     }
   else $arrnav[$i]['enlace']=false;
   $arrnav[$i]['cua']=$cuentaant;
   if ($cuenta>$numero_arch) $arrnav[$i]['cu']=$numero_arch;
   else $arrnav[$i]['cu']=$cuenta;
   $cuentaant=$cuenta+1;
   $cuenta=$cuenta+$avance;
}

$anterior=$para-$avance;
$siguiente=$para+$avance;


html_begin($galeria,$style_thumb,$texto_titulo,$file_titulo,$file_subtitulo,$desde,$hasta,$version);

          # Print top navigator
if ($nav_pos=="top" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print top number-of-thumbnails-per-page form
if ($tpp_pos=="top" || $tpp_pos=="both")
    html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria);

html_sep();

       # Print images body
if ($para2 >= $numero_arch) $para2 = $nummenosuno;
for ( $i=$para ; $i <= $para2 ; $i++) 
    html_image($ruta,$galeria,$h_thumb,$h_medium,$text_medium,$i,$arr[$i]['file'],
               $arr[$i]['size'],$arr[$i]['bytes'],$arr[$i]['date'],
               $show_exif_thumbs,$show_exif_info,$text_exif,&$any_exif);

html_sep();

      # Print bottom navigator
if ($nav_pos=="bottom" || $nav_pos=="both")
    out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
            $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance);


      # Print bottom number-of-thumbnails-per-page form
if ($tpp_pos=="bottom" || $tpp_pos=="both")
    html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria);


html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals);


# ------------- functions

function out_nav($arrnav,$numer_pagmasuno,$text_galerias,$text_pages,$galeria,$anterior,
                 $text_anterior,$siguiente,$text_siguiente,$numero_arch,$avance)
{
  html_nav_begin($text_galerias,$text_pages);

  for ($i = 1; $i <= $numer_pagmasuno; $i++)
     html_nav_elem($arrnav[$i]['enlace'],$galeria,$arrnav[$i]['para'],$avance,
                   $arrnav[$i]['cua'],$arrnav[$i]['cu']);

  html_nav_end($anterior,$text_anterior,$galeria,$siguiente,$text_siguiente,$numero_arch,$avance);

}


function html_begin($galeria,$style_thumb,$texto_titulo,$file_titulo,$file_subtitulo,$desde,$hasta,$version)
{

if (file_exists("styles/$galeria_$style_thumb")) { $style="$galeria_$style_thumb"; }
else { $style=$style_thumb; }

html_header($style,$texto_titulo,$version);

echo'
<h3 class="normal">';
include "$file_titulo";
echo '</h3>
';
echo "<h4 class=\"normal\">";
include "$file_subtitulo";
echo "\n</h4>
<h4 class=\"normal\">$desde-$hasta</h4>\n";
}


function html_nav_begin($text_galerias,$text_pages)
{
echo '
<p class="clear">
';
if (file_exists('ver_gals.php')) echo "<a href=\"ver_gals.php\">$text_galerias</a> | ";
echo "<strong>$text_pages:</strong> ";
}


function html_nav_elem($enlace,$galeria,$para,$avance,$cuentaant,$cuenta)
{
if ($enlace) echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$para&amp;avance=$avance\">";
echo "$cuentaant-$cuenta";
if ($enlace) echo '</a>';
echo ' | ';
}


function html_nav_end($anterior,$text_anterior,$galeria,$siguiente,$text_siguiente,$numero_arch,$avance)
{
if ($anterior<0) echo $text_anterior;
            else echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$anterior&amp;avance=$avance\">$text_anterior</a>";
echo ' | ';
if ($siguiente>=$numero_arch) echo $text_siguiente;
            else echo "<a class=\"texto\" href=\"ver_thumb.php?galeria=$galeria&amp;para=$siguiente&amp;avance=$avance\">$text_siguiente</a>";
echo '</p>';
}


function html_image($ruta,$galeria,$h_thumb,$h_medium,$text_medium,$i,$valor,$size,$bytes,$fecha,
                     $show_exif_thumbs,$show_exif_info,$text_exif,$any_exif)
{
   echo "
   <div class=\"figure\">
   <p class=\"caption\">
   <a href=\"$ruta/$valor\">\n";
   if ($show_exif_thumbs)
    {
      $exif_th=exif_thumbnail($ruta."/".$valor,$exif_w,$exif_h);
      if ($exif_th && $exif_h<=$h_thumb)
         $thumbsrc="exif_thumb.php?img=$valor&amp;galeria=$galeria";
      else
         $thumbsrc="thumb.php?galeria=$galeria&amp;valor=$valor&amp;altura=$h_thumb&amp;tipo=t";
    }
   else $thumbsrc="thumb.php?galeria=$galeria&amp;valor=$valor&amp;altura=$h_thumb&amp;tipo=t";
   echo "   <img class=\"thumbnail\" src=\"$thumbsrc\" alt=\"$valor\">
   </a>\n";
   if ($h_medium>0) 
     echo "   <br>\n   <a class=\"texto\" href=\"thumb.php?galeria=$galeria&amp;valor=$valor&amp;altura=$h_medium&amp;tipo=m\">$text_medium</a>\n";
   $image_type=$size[2];
   if ($show_exif_info && $image_type==2)
     {
       $exif=exif_read_data($ruta."/".$valor,EXIF,true);
       if (is_array($exif) && array_key_exists('FILE', $exif))
         {
           echo "   <br>\n   <a class=\"texto\" href=\"exif.php?valor=$valor&amp;galeria=$galeria\">$text_exif</a>\n";
           $any_exif=true;
         }
       else
         if ($any_exif) echo "   <br><br>\n";
     }
   else if ($any_exif) echo "   <br><br>\n";
   echo "   </p>\n";
   echo "   <p class=\"caption\">\n   ";
   echo $i+1;
   echo ". \n";
   echo "   <a class=\"texto\" href=\"$ruta/$valor\">
   $valor<br>
   </a>
   $size[0]x$size[1]<br>
   $bytes bytes<br>
   $fecha
   </p>
   </div>
";
}


function html_thpp_form($npages_user,$text_thpp,$avance,$text_change,$galeria)
{
if ($npages_user) echo "
<form class=\"tpp\" action=\"ver_thumb.php\" method=\"get\">
<p class=\"normal\">
$text_thpp <input class=\"tppin\" type=\"text\" name=\"avance\" value=\"$avance\" size=\"3\" maxlength=\"3\">
<input class=\"tppbu\" type=\"submit\" value=\"$text_change\">
<input type=\"hidden\" name=\"galeria\" value=\"$galeria\">
</p>
</form>";
}


function html_end($text_totales,$total,$totalmegas,$powered,$text_powered,$version,$print_totals)
{

if ($print_totals)
{
echo "<p class=\"clear\">
$text_totales$total ($totalmegas MB)
";
echo '</p>
';
}

html_bottom($powered,$text_powered,$version);

}

?>
