<?php

# FitGallery 0.85
# (C) Omar Lpez 'pollo' (pollo.es.pollo@gmail.com), Enrique D. Bosch 'presi' (presidev@confluencia.net)
# http://fitgallery.presi.org
#
# thumb generator file
# args:
# galeria - string  - gallery name
# valor   - string  - image file name
# altura  - integer - height of the thumbnail
# tipo    - string  - thumbnail type

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#    http://www.gnu.org/licenses/gpl.html

include 'common_sec.php';

function thumbnail ($galeria,$fichero,$altura,$tipo)
{

include 'config/config-thumb.php';

$dg=$dirgal.'/'.$galeria;
switch ($tipo)
{
  case 'm': $rutathumbs=$dg.'/medium'; break;
  case 't': $rutathumbs=$dg.'/thumbs'; break;
  default: exit_error('Bad thumbnail type.');
}
$ext='.jpeg';
$imagenthumb=$rutathumbs.'/'.$fichero.$ext;

if (file_exists($imagenthumb)) header("Location: $imagenthumb");
else
{
  $rutaimgs=$dg.'/imgs';
  $imagen=$rutaimgs.'/'.$fichero;

  if ($altura>$limite_altura) $altura=$limite_altura;

  $size=getimagesize("$imagen");
  $new_w=$altura*$size[0]/$size[1];
  $new_h=$altura;

  $gdv=gd_v();
  if ($gdv==0) exit_error('No GD found.');
  if ($gdv>1) $dst_img=ImageCreateTrueColor($new_w,$new_h);
         else $dst_img=ImageCreate($new_w,$new_h);
  switch ($size[2])
  {
   case 2: $src_img=ImageCreateFromJpeg($imagen); break;
   case 3: $src_img=ImageCreateFromPng($imagen); break;
   default: exit_error('Source image not in JPEG or PNG.');
  }

  ImageCopyResized($dst_img,$src_img,0,0,0,0,$new_w,$new_h,ImageSX($src_img),ImageSY($src_img));

  header('Content-type: image/jpeg');
  ImageJpeg($dst_img);

  ImageJpeg($dst_img,$imagenthumb);

  Imagedestroy($dst_img);
}

}


function gd_v()
{
   if (!extension_loaded('gd')) return 0;
   ob_start();
   phpinfo();
   $info=ob_get_contents();
   ob_end_clean();
   $info=stristr($info, 'gd version');
   preg_match('/\d/', $info, $gdv);
   return $gdv[0];
}

$galeria=check_input($_GET['galeria'],$VALID_CHARS);
$valor=check_input($_GET['valor'],$VALID_CHARS);
$altura=check_input($_GET['altura'],'number');
$tipo=check_input($_GET['tipo'],$VALID_CHARS);

thumbnail ($galeria,$valor,$altura,$tipo);

?>
