/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2016-2017-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Fisoco.
 * 
 * Fisoco is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Fisoco is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *//////////////////////////////////////
/************
 * main.cc  *
 * ~~~~~~~~ *
 ************/

#include <iostream>
#include <getopt.h>
#include "../include/cli.h"
#include "../include/global.h"

static int debug_flag;

int main (int argc, char **argv)
{
  // Manage command-line options
  int c;
  while (1)
    {
      static struct option long_options[] = {
	  {"debug",    no_argument,   &debug_flag,  1   },
	  {"help",     no_argument,   0,            'h' },
	  {"version",  no_argument,   0,            'v' }
      };
      int option_index = 0;
      c = getopt_long (argc, argv, "hv", long_options, &option_index);
      
      if (c == -1)
	break;
      
      switch (c)
	{
	case 'h': help (); return 0;
	case 'v': version (); return 0;
	default : break;
	}
    }
  
  activate_debug (debug_flag);

  if (optind < argc)
    {
      printf ("non-option ARGV-elements: ");
      while (optind < argc)
	printf ("%s ", argv[optind++]);
      putchar ('\n');
    }
  
  Cli ();
  return 0;
}
