/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    main.h    *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// C headers
#include <iostream>
#include <getopt.h>
// i18n
#include "../include/gettext.h"
#include <locale.h>
#include <cstdlib>
// Gtkmm headers
#include <gtkmm/application.h>
// Multi-thread
#include <thread> 
#include <X11/Xlib.h>
// Fisoco headers
#include "../include/cli.h"
#include "../include/global.h"
#include "../include/gui.h"
#include "../include/main.h"

using namespace std;

struct Fisoco : Gtk::Application {
    
    Fisoco () : Gtk::Application ("fisoco.app", Gio::APPLICATION_HANDLES_COMMAND_LINE) {}
    
    int on_command_line(const Glib::RefPtr<Gio::ApplicationCommandLine> &cmd) {
        // parse arguments:
        Glib::OptionContext context;
        Glib::OptionGroup group (gettext ("options"), gettext ("Main options"), gettext ("Show Fisoco options"));
        // CLI option
        bool show_cli = false;
        Glib::OptionEntry cli_opt;
        cli_opt.set_long_name ("cli");
        cli_opt.set_description (gettext ("Use Command Line Interface (CLI) mode"));
        group.add_entry (cli_opt, show_cli);
        // Debug option
        bool activate_dbg = false;
        Glib::OptionEntry dbg_opt;
        dbg_opt.set_short_name ('d');
        dbg_opt.set_long_name ("debug");
        dbg_opt.set_description (gettext ("Output debug messages"));
        group.add_entry (dbg_opt, activate_dbg);
        // Version option
        bool show_ver = false;
        Glib::OptionEntry ver_opt;
        ver_opt.set_short_name ('v');
        ver_opt.set_long_name ("version");
        ver_opt.set_description (gettext ("Display version and copyrights"));
        group.add_entry (ver_opt, show_ver);
        context.add_group (group);
        // add GTK options, --help-gtk, etc
        Glib::OptionGroup gtkgroup (gtk_get_option_group (true));
        context.add_group (gtkgroup);
        
        int argc;
        char **argv = cmd->get_arguments (argc);
        context.parse (argc, argv);
        
        // manage debug mode
        activate_debug (activate_dbg);
        
        // maybe show the gui (if show_cli stay false)
        if (show_ver)
            version ();
        else if (show_cli)
            Show_cli ();
        else
            Show_gui ();
        return 0;
    }
    void Show_cli ()
    {
        Cli *main;
        main = new Cli ();
    }
    void Show_gui ()
    {
        Gui *main;
        main = new Gui ();
        add_window(*main);
        main->show();
    }
};

int
main (int argc, char* argv[])
{
    /* locale settings */
    setlocale (LC_CTYPE, "");
    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain ( PACKAGE);
    /* graphical interface */
    XInitThreads ();
    if (isatty(fileno(stdin)))
        debug (gettext ("STDIN is a terminal"));
    else
        debug (gettext ("STDIN is a file or a pipe"));
    return Fisoco ().run (argc, argv);
}

void
version ()
{
    std::cout << "Fisoco  Copyright  (C) 2015  Felicien PILLOT <felicien.pillot@member.fsf.org>" << std::endl;
    std::cout << gettext ("This program comes with ABSOLUTELY NO WARRANTY; for details use -w option.") << std::endl;
    std::cout << gettext ("This is free software, and you are welcome to redistribute") << std::endl;
    std::cout << gettext ("it under certain condition (option -c for details).") << std::endl;
}
