/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 * Ctemplate.cc *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// C headers
#include <iostream>
// i18n
#include "../include/gettext.h"
// Fisoco headers
#include "../include/Ctemplate.h"

Ctemplate_ui::Ctemplate_ui ()
  : quit_button_ (gettext ("Quit")),
    template_box (Gtk::ORIENTATION_VERTICAL)
{
  /* menubar */
  init_menubar();
  /* quit button */
  quit_buttonBox_.pack_start (quit_button_, Gtk::PACK_EXPAND_PADDING);
  quit_buttonBox_.set_border_width (5);
  quit_buttonBox_.set_layout (Gtk::BUTTONBOX_END);
  /* signals */
  refActionGroup->add_action
    ("adddevice",sigc::mem_fun (*this,&Ctemplate_ui::temp_add_device));
  refActionGroup->add_action
    ("quit",sigc::mem_fun (*this,&Ctemplate_ui::temp_quit));
  refActionGroup->add_action
    ("manual",sigc::mem_fun (*this,&Ctemplate_ui::temp_manual));
  refActionGroup->add_action
    ("about",sigc::mem_fun (*this,&Ctemplate_ui::temp_about));
  quit_button_.signal_clicked ()
    .connect (sigc::mem_fun (*this,
			     &Ctemplate_ui::temp_quit) );
  /* display */
  add (template_box);
  template_box.pack_start (*menubar, Gtk::PACK_SHRINK);
  template_box.pack_start (quit_buttonBox_, Gtk::PACK_SHRINK);
}

void
Ctemplate_ui::init_menubar ()
{
  refActionGroup = Gio::SimpleActionGroup::create ();
  m_refBuilder = Gtk::Builder::create ();
  try
    {
      m_refBuilder->add_from_file (PACKAGE_UI_DIR "/interface.ui");
    }
  catch (const Glib::Error& ex)
    {
      std::cerr << gettext ("building menus failed: ") <<  ex.what ();
    }
  Glib::RefPtr<Glib::Object> object =
    m_refBuilder->get_object ("menuact");
  gmenu = Glib::RefPtr<Gio::Menu>::cast_dynamic (object);
  if (!gmenu)
    g_warning (gettext ("GMenu not found"));
  menubar = Gtk::manage (new Gtk::MenuBar (gmenu));
}

void
Ctemplate_ui::temp_add_device ()
{
  std::cout << gettext ("The action 'add a device' isn't yet implemented.")
	    << std::endl;
}

void
Ctemplate_ui::temp_manual ()
{
  std::cout << gettext ("The manual isn't yet written.") << std::endl;
}

void
Ctemplate_ui::temp_about ()
{
  std::cout << gettext ("About what ?") << std::endl;
}

void
Ctemplate_ui::temp_quit ()
{
  hide ();
}

Ctemplate_ui::~Ctemplate_ui ()
{
}
