/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *  Ctemplate.h *
 *    ~~~~~~    *
 ****************/

#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/menubar.h>
#include <gtkmm/builder.h>
#include <giomm/simpleaction.h>
#include <giomm/simpleactiongroup.h>

class Ctemplate_ui : public Gtk::Window {
  
public:
  Ctemplate_ui ();
  ~Ctemplate_ui ();
  
protected:
  
  /* Menubar function */
  void init_menubar ();
  
  /* Signal handlers */
  void temp_add_device ();
  void temp_manual ();
  void temp_about ();
  void temp_quit ();
  
  /* Child widgets: */
  Glib::RefPtr<Gtk::Builder> m_refBuilder;
  Glib::RefPtr<Gio::SimpleActionGroup> refActionGroup;
  Glib::RefPtr<Gio::Menu> gmenu;
  Gtk::MenuBar* menubar;
  Gtk::Button quit_button_;
  Gtk::ButtonBox quit_buttonBox_;
  Gtk::Box template_box;    // Main box of the window  
};
