/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    Cmain.h   *
 *    ~~~~~~    *
 ****************/

#include "../include/Ctemplate.h"
#include <gtkmm/frame.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/scrolledwindow.h>

class Cmain_ui : public Ctemplate_ui::Ctemplate_ui
{
  
public:
  Cmain_ui ();
  ~Cmain_ui ();
  
protected:

  void fill_view_recurs (std::string search,
			 std::map<std::string, std::string> results,
			 std::string dir);
  
  // Signal handler
  void on_treeview_row_activated (const Gtk::TreeModel::Path& path,
			    Gtk::TreeViewColumn* column);
  void selected_row_callback (const Gtk::TreeModel::iterator& iter);
  void cancelB_clicked ();
  void searchB_clicked ();
  void selectB_clicked ();
  void convertB_clicked ();
  void moveB_clicked ();
  void new_searchB_clicked ();

  // Tree model column
  class ModelColumns : public Gtk::TreeModelColumnRecord {
  public:
    ModelColumns ()
    {
      add(m_col_id);
      add(m_col_type);
      add(m_col_name);
    }
    
    Gtk::TreeModelColumn<int> m_col_id;
    Gtk::TreeModelColumn<Glib::ustring> m_col_type;
    Gtk::TreeModelColumn<Glib::ustring> m_col_name;
  };
  
  ModelColumns main_columns_;

protected:
  Gtk::Frame search_frame_;
  Gtk::Box main_all_, main_search_, main_interface_;
  Gtk::ButtonBox right_buttons_, search_buttons_;
  Gtk::Button cancel_button_, search_button_, select_button_,
    move_button_, convert_button_, new_search_button_;
  Gtk::Label main_text_top_;
  Gtk::Entry main_entry_;  
  Gtk::ScrolledWindow m_ScrolledWindow_;
  Gtk::TreeView m_TreeView;
  Glib::RefPtr<Gtk::TreeStore> m_refTreeModel;
};

