/* 
   Copyright (C) 2009, 2010, 2011, 2012, 2013 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>

@interface ObjectData : NSObject
{
  id dataViewer;
  id resultsViewer;
  id cleanResultsViewer;
  id chalkboard;
  int conteoReferencia, sistema;
  NSNumber *identificador ;
  NSCharacterSet *numbers, *plus_minusSet, *multiplication_divisionSet;
  NSMutableDictionary *listaObjetos, *conversionDictionary, *menuConversionDictionary ;
}
- (void) sisUnidades: (id)sender;
- (void) calcular: (id)sender;
- (void) agregarObjeto: (id)nuevo;
- (void) borrarObjeto: (int)codigo;
- (void) selecObjeto: (int)codigo;
- (void) borrarObjetos: (BOOL) parametro;
- (NSString *) dataOfObject: (NSNumber *)aNumber;
- (void) setMenuForModule: (NSNotification *)notification;
- (void) insertFactor: (id)sender;
- (int) numberOfRowsInTableView: (NSTableView*)aTableView;
- (id) tableView: (NSTableView*)aTableView objectValueForTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex;
- (void) tableView: (NSTableView*)aTableView setObjectValue: (id)anObject forTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex;
- (BOOL) tableView: (NSTableView*)aTableView shouldEditTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex;
- (void) tableView: (NSTableView*)aTableView willDisplayCell: (id)aCell forTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex;
@end
