/* 
   Copyright (C) 2010, 2011, 2012 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <stdlib.h>
#import <stdio.h>
#import <math.h>
#import <gsl/gsl_vector.h>
#import <gsl/gsl_multiroots.h>
#import <gsl/gsl_rng.h>
#import "FLKinematicsCircularMotion.h"

static int varT ;
static double tiempoDat ;
static NSArray *diccionario ;
static NSMutableArray *variables, *varTemporales ;
static NSString *tiempoVar ;

int valoresCinemaCirc (const gsl_vector *, void *, gsl_vector *);

struct parametros
{
  double a;
  double b;
};

int sis_cinematica_circular (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
  valoresCinemaCirc (variables, params, funciones);  
  return GSL_SUCCESS;
}

int valoresCinemaCirc (const gsl_vector *vars, void *p, gsl_vector *func)
{
  int tIndice ;
  int nEcu = 0;
  double tf ;
  NSMutableDictionary *objeto;
  NSEnumerator *enumerador;
  
  if(varT == 1)
    {
      tIndice = [variables indexOfObject: tiempoVar] ;
      tf = gsl_vector_get (vars, tIndice) ;   
    }
  else
    {
      tf = tiempoDat ;
    }
  
  enumerador = [diccionario objectEnumerator] ;
  
  while((objeto = [enumerador nextObject]))
    {
      NSNumber *tipo = [objeto objectForKey: @"Tipo"] ;
      NSMutableArray *dat = [objeto objectForKey: @"Valores"] ;
      
      switch([tipo intValue])
	{
	case 201:
	  {
	    double r, aci, at, angi, vi, ti, angf, vf, acf;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		r = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		r = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		aci = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		aci = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		at = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		at = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		angi = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		angi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vi = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		angf = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		angf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		vf = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		vf = gsl_vector_get (vars, k) ;
	      }

	    if(![variables containsObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces] ])
	      {
		acf = [[dat objectAtIndex: 10] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces]] ;
		acf = gsl_vector_get (vars, k) ;
	      }
	    
            
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, vf - vi - at*(tf - ti));
	    gsl_vector_set (func, nEcu + 1, (M_PI*angf/180) - (M_PI*angi/180) - (vi/r)*(tf - ti) - 0.5*(at/r)*(tf - ti)*(tf - ti));
	    gsl_vector_set (func, nEcu + 2, aci - (vi*vi)/r);
	    gsl_vector_set (func, nEcu + 3, acf - (vf*vf)/r);
	    
	    nEcu = nEcu + 4 ;
	  }
	  break;
	case 202:
	  {
	    double aa, ar, angi, ri, vai, vri, ti, angf, rf, vaf, vrf ; 
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		aa = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		aa = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		ar = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		ar = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		angi = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		angi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		ri = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		ri = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vai = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vai = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		vri = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		vri = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		angf = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		angf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces] ])
	      {
		rf = [[dat objectAtIndex: 10] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces]] ;
		rf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces] ])
	      {
		vaf = [[dat objectAtIndex: 11] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces]] ;
		vaf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 12] stringByTrimmingSpaces] ])
	      {
		vrf = [[dat objectAtIndex: 12] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 12] stringByTrimmingSpaces]] ;
		vrf = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, vaf - vai - aa*(tf - ti));
	    gsl_vector_set (func, nEcu + 1, (M_PI*angf/180) - (M_PI*angi/180) - vai*(tf - ti) - 0.5*aa*(tf - ti)*(tf - ti));
	    gsl_vector_set (func, nEcu + 2, vrf - vri - ar*(tf - ti));
	    gsl_vector_set (func, nEcu + 3, rf - ri - vri*(tf - ti) - 0.5*ar*(tf - ti)*(tf - ti));
	    
	    nEcu = nEcu + 4 ;
	  }
	  break;
	case 203:
	  {
	    double wi, wf, vi, vf, r;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			break;
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vi = [[objetoBusc objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		vf = [[objetoBusc objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces]] ;
		vf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		r = [[objetoBusc objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		r = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		wi = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		wi = gsl_vector_get (vars, k) ;
	      }

	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		wf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		wf = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, wi - (vi/r));
	    gsl_vector_set (func, nEcu + 1, wf - (vf/r));
	    
	    nEcu = nEcu + 2 ;
	  }
	  break;
	case 204:
	  {
	    double aa, vi, vf, ti, r ;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			break;
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vi = [[objetoBusc objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		vf = [[objetoBusc objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces]] ;
		vf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		r = [[objetoBusc objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		r = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		ti = [[objetoBusc objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		r = [[objetoBusc objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		r = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		aa = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		aa = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, aa - (vf/r - vi/r)/(tf - ti));
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 205:
	  {
	    double atoti, aangi, atotf, aangf ;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBusc = nil;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			tipoBusc = [buscarNombre objectForKey: @"Tipo"] ;
			break;
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		atoti = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		atoti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		aangi = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		aangi = gsl_vector_get (vars, k) ;
	      }

	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		atotf = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		atotf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		aangf = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		aangf = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    if([tipoBusc intValue] == 201)
	      {
		double aci, acf, at ;
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 3] stringByTrimmingSpaces] ])
		  {
		    aci = [[objetoBusc objectAtIndex: 3] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 3] stringByTrimmingSpaces]] ;
		    aci = gsl_vector_get (vars, k) ;
		  }

		if(![variables containsObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces] ])
		  {
		    acf = [[objetoBusc objectAtIndex: 10] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces]] ;
		    acf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 4] stringByTrimmingSpaces] ])
		  {
		    at = [[objetoBusc objectAtIndex: 4] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 4] stringByTrimmingSpaces]] ;
		    at = gsl_vector_get (vars, k) ;
		  }
		
		
		//Se establecen las ecuaciones
		gsl_vector_set (func, nEcu, atoti - gsl_hypot(aci, at));
		gsl_vector_set (func, nEcu + 1, atan2(at, -1*aci) - (M_PI*aangi/180));  
		gsl_vector_set (func, nEcu + 2, atotf - gsl_hypot(acf, at));
		gsl_vector_set (func, nEcu + 3, atan2(at, -1*acf) - (M_PI*aangf/180));  
		
		nEcu = nEcu + 4 ;
	      }
	    else
	      {
		double ri, rf, vri, vrf, vai, vaf, ar, aa ;
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    aa = [[objetoBusc objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    aa = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 3] stringByTrimmingSpaces] ])
		  {
		    ar = [[objetoBusc objectAtIndex: 3] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 3] stringByTrimmingSpaces]] ;
		    ar = gsl_vector_get (vars, k) ;
		  }

		if(![variables containsObject: [[objetoBusc objectAtIndex: 5] stringByTrimmingSpaces] ])
		  {
		    ri = [[objetoBusc objectAtIndex: 5] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 5] stringByTrimmingSpaces]] ;
		    ri = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
		  {
		    vai = [[objetoBusc objectAtIndex: 6] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		    vai = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces] ])
		  {
		    vri = [[objetoBusc objectAtIndex: 7] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces]] ;
		    vri = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces] ])
		  {
		    rf = [[objetoBusc objectAtIndex: 10] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces]] ;
		    rf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces] ])
		  {
		    vaf = [[objetoBusc objectAtIndex: 11] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces]] ;
		    vaf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 12] stringByTrimmingSpaces] ])
		  {
		    vrf = [[objetoBusc objectAtIndex: 12] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 12] stringByTrimmingSpaces]] ;
		    vrf = gsl_vector_get (vars, k) ;
		  }
		
		
		//Se establecen las ecuaciones
		gsl_vector_set (func, nEcu, atoti - gsl_hypot(ar - ri*vai*vai, ri*aa + 2*vri*vai));
		gsl_vector_set (func, nEcu + 1, atan2(ri*aa + 2*vri*vai, ar - ri*vai*vai) - (M_PI*aangi/180));
		gsl_vector_set (func, nEcu + 2, atotf - gsl_hypot(ar - rf*vaf*vaf, rf*aa + 2*vrf*vaf));
		gsl_vector_set (func, nEcu + 3, atan2(rf*aa + 2*vrf*vaf, ar - rf*vaf*vaf) - (M_PI*aangf/180));  
		
		nEcu = nEcu + 4 ;
	      }
	  }
	  break;
	case 206 ... 208:
	  {
	    double ftn ;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBusc = nil;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			tipoBusc = [buscarNombre objectForKey: @"Tipo"] ;
			break;
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		ftn = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		ftn = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    if([tipoBusc intValue] == 201)
	      {
		double ti, r, vi, vf ;
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    r = [[objetoBusc objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    r = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
		  {
		    vi = [[objetoBusc objectAtIndex: 6] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		    vi = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces] ])
		  {
		    vf = [[objetoBusc objectAtIndex: 9] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 9] stringByTrimmingSpaces]] ;
		    vf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces] ])
		  {
		    ti = [[objetoBusc objectAtIndex: 7] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces]] ;
		    ti = gsl_vector_get (vars, k) ;
		  }
		
		
		//Se establece la ecuacion
		switch([tipo intValue])
		  {
		  case 206:
		    {
		      gsl_vector_set (func, nEcu, ftn - ((vf/r) + (vi/r))/(4*M_PI));
		    }
		    break;
		  case 207:
		    {
		      gsl_vector_set (func, nEcu, ftn - (4*M_PI)/((vf/r) + (vi/r)));
		    }
		    break;
		  case 208:
		    {
		      gsl_vector_set (func, nEcu, ftn - ((vf/r) + (vi/r))*(tf - ti)/(4*M_PI));
		    }
		    break;
		  }
		
		nEcu = nEcu + 1 ;
	      }
	    else
	      {
		double vai, vaf, ti ;
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
		  {
		    vai = [[objetoBusc objectAtIndex: 6] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		    vai = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces] ])
		  {
		    vaf = [[objetoBusc objectAtIndex: 11] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces]] ;
		    vaf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 8] stringByTrimmingSpaces] ])
		  {
		    ti = [[objetoBusc objectAtIndex: 8] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 8] stringByTrimmingSpaces]] ;
		    ti = gsl_vector_get (vars, k) ;
		  }
		
		
		//Se establece la ecuacion
		
		switch([tipo intValue])
		  {
		  case 206:
		    {
		      gsl_vector_set (func, nEcu, ftn - (vaf + vai)/(4*M_PI));
		    }
		    break;
		  case 207:
		    {
		      gsl_vector_set (func, nEcu, ftn - (4*M_PI)/(vaf + vai));
		    }
		    break;
		  case 208:
		    {
		      gsl_vector_set (func, nEcu, ftn - (vaf + vai)*(tf - ti)/(4*M_PI));
		    }
		    break;
		  }
		
		nEcu = nEcu + 1 ;
	      }
	  }
	  break;
	case 210:
	  {
	    double d ;
	    
	    NSString *nomObjetoUno = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSString *nomObjetoDos = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBuscUno = nil, *tipoBuscDos = nil;
	    NSMutableArray *objetoBuscUno = nil, *objetoBuscDos = nil;
	    NSMutableDictionary *buscarNombre ;
	    int controlBusc = 0, controlNomUno = 0, controlNomDos = 0 ;
	    NSMutableArray *centroUno = nil, *centroDos = nil;
	    NSString *centroNomUno = nil, *centroNomDos = nil;
	    int angfUnoInd, rfUnoInd ;
	    int angfDosInd, rfDosInd ;
	    double angfUno, rfUno, angfDos, rfDos, xcUno = 0, ycUno = 0, xcDos = 0, ycDos = 0 ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjetoUno isEqualToString: nombre])
		      {
			objetoBuscUno = [buscarNombre objectForKey: @"Valores"] ;
			tipoBuscUno = [buscarNombre objectForKey: @"Tipo"] ;
			controlBusc = controlBusc + 1 ;
		      }
		    
		    if ([nomObjetoDos isEqualToString: nombre])
		      {
			objetoBuscDos = [buscarNombre objectForKey: @"Valores"] ;
			tipoBuscDos = [buscarNombre objectForKey: @"Tipo"] ;
			controlBusc = controlBusc + 1 ;
		      }
		    
		    if (controlBusc == 2)
		      {
			break;
		      }
		  }
	      }
	    
	    buscar = [diccionario objectEnumerator] ;
	    controlBusc = 0 ;
	    
	    if ( ([[[objetoBuscUno objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[objetoBuscUno objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		centroNomUno = [[objetoBuscUno objectAtIndex: 1] stringByTrimmingSpaces] ;
	      }
	    else
	      {
		controlNomUno = 1 ;
		controlBusc = controlBusc + 1 ;
	      }
	    
	    if ( ([[[objetoBuscDos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[objetoBuscDos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		centroNomDos = [[objetoBuscDos objectAtIndex: 1] stringByTrimmingSpaces] ;
	      }
	    else
	      {
		controlNomDos = 1 ;
		controlBusc = controlBusc + 1 ;
	      } 
	    
	    if (controlBusc != 2)
	      {
		while ((buscarNombre = [buscar nextObject]))
		  {
		    NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		    NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		    
		    if ([titulo isEqualToString: @"Nombre"])
		      {
			if (controlNomUno != 1)
			  {
			    if ([centroNomUno isEqualToString: nombre])
			      {
				centroUno = [buscarNombre objectForKey: @"Valores"] ;
				controlBusc = controlBusc + 1 ;
			      }
			  }
			
			if (controlNomDos != 1)
			  {
			    if ([centroNomDos isEqualToString: nombre])
			      {
				centroDos = [buscarNombre objectForKey: @"Valores"] ;
				controlBusc = controlBusc + 1 ;
			      }
			  }
			
			if (controlBusc == 2)
			  {
			    break;
			  }
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		d = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		d = gsl_vector_get (vars, k) ;
	      }
	    
	    if([tipoBuscUno intValue] == 201)
	      {
		rfUnoInd = 2 ;
		angfUnoInd = 8 ;
	      }
	    else
	      {
		rfUnoInd = 10 ;
		angfUnoInd = 9 ;
	      }
	    
	    if([tipoBuscDos intValue] == 201)
	      {
		rfDosInd = 2 ;
		angfDosInd = 8 ;
	      }
	    else
	      {
		rfDosInd = 10 ;
		angfDosInd = 9 ;
	      }
	    
	    
	    //Objeto Uno
	    if(![variables containsObject: [[objetoBuscUno objectAtIndex: rfUnoInd] stringByTrimmingSpaces] ])
	      {
		rfUno = [[objetoBuscUno objectAtIndex: rfUnoInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: rfUnoInd] stringByTrimmingSpaces]] ;
		rfUno = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBuscUno objectAtIndex: angfUnoInd] stringByTrimmingSpaces] ])
	      {
		angfUno = [[objetoBuscUno objectAtIndex: angfUnoInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: angfUnoInd] stringByTrimmingSpaces]] ;
		angfUno = gsl_vector_get (vars, k) ;
	      }
	    
	    //Objeto Dos
	    if(![variables containsObject: [[objetoBuscDos objectAtIndex: rfDosInd] stringByTrimmingSpaces] ])
	      {
		rfDos = [[objetoBuscDos objectAtIndex: rfDosInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: rfDosInd] stringByTrimmingSpaces]] ;
		rfDos = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[objetoBuscDos objectAtIndex: angfDosInd] stringByTrimmingSpaces] ])
	      {
		angfDos = [[objetoBuscDos objectAtIndex: angfDosInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: angfDosInd] stringByTrimmingSpaces]] ;
		angfDos = gsl_vector_get (vars, k) ;
	      }
	    
	    //Coordenadas X y Y del centro 1
	    if(controlNomUno == 0)
	      {
		if(![variables containsObject: [[centroUno objectAtIndex: 1] stringByTrimmingSpaces] ])
		  {
		    xcUno = [[centroUno objectAtIndex: 1] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centroUno objectAtIndex: 1] stringByTrimmingSpaces]] ;
		    xcUno = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[centroUno objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    ycUno = [[centroUno objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centroUno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    ycUno = gsl_vector_get (vars, k) ;
		  }
	      }
	    
	    //Coordenadas X y Y del centro 2
	    if(controlNomDos == 0)
	      {
		if(![variables containsObject: [[centroDos objectAtIndex: 1] stringByTrimmingSpaces] ])
		  {
		    xcDos = [[centroDos objectAtIndex: 1] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centroDos objectAtIndex: 1] stringByTrimmingSpaces]] ;
		    xcDos = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[centroDos objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    ycDos = [[centroDos objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centroDos objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    ycDos = gsl_vector_get (vars, k) ;
		  }
	      }
	    
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, d*d - ((xcDos + rfDos*cos(M_PI*angfDos/180)) - (xcUno + rfUno*cos(M_PI*angfUno/180)))*((xcDos + rfDos*cos(M_PI*angfDos/180)) - (xcUno + rfUno*cos(M_PI*angfUno/180))) - ((ycDos + rfDos*sin(M_PI*angfDos/180)) - (ycUno + rfUno*sin(M_PI*angfUno/180)))*((ycDos + rfDos*sin(M_PI*angfDos/180)) - (ycUno + rfUno*sin(M_PI*angfUno/180))) );
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 211:
	  {
	    double sl ;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBusc = nil;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			tipoBusc = [buscarNombre objectForKey: @"Tipo"] ;
			break;
		      }
		  }
	      }
	    
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		sl = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		sl = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    if([tipoBusc intValue] == 201)
	      {
		double ti, vi, at ; //r
		
		/*if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		  r = [[objetoBusc objectAtIndex: 2] doubleValue] ;
		  }
		  else
		  {
		  int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		  r = gsl_vector_get (vars, k) ;
		  }*/
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
		  {
		    vi = [[objetoBusc objectAtIndex: 6] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		    vi = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 4] stringByTrimmingSpaces] ])
		  {
		    at = [[objetoBusc objectAtIndex: 4] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 4] stringByTrimmingSpaces]] ;
		    at = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces] ])
		  {
		    ti = [[objetoBusc objectAtIndex: 7] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 7] stringByTrimmingSpaces]] ;
		    ti = gsl_vector_get (vars, k) ;
		  }
		
		//Se establece la ecuacion
		gsl_vector_set (func, nEcu, sl - vi*(tf - ti) - 0.5*at*(tf - ti)*(tf - ti));
		
		nEcu = nEcu + 1;
	      }
	    else
	      {
		double ri, rf, aa, vai, ti ; //vaf
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 5] stringByTrimmingSpaces] ])
		  {
		    ri = [[objetoBusc objectAtIndex: 5] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 5] stringByTrimmingSpaces]] ;
		    ri = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces] ])
		  {
		    rf = [[objetoBusc objectAtIndex: 10] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 10] stringByTrimmingSpaces]] ;
		    rf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    aa = [[objetoBusc objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    aa = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces] ])
		  {
		    vai = [[objetoBusc objectAtIndex: 6] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 6] stringByTrimmingSpaces]] ;
		    vai = gsl_vector_get (vars, k) ;
		  }
		
		/*if(![variables containsObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces] ])
		  {
		  vaf = [[objetoBusc objectAtIndex: 11] doubleValue] ;
		  }
		  else
		  {
		  int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 11] stringByTrimmingSpaces]] ;
		  vaf = gsl_vector_get (vars, k) ;
		  }*/
		
		if(![variables containsObject: [[objetoBusc objectAtIndex: 8] stringByTrimmingSpaces] ])
		  {
		    ti = [[objetoBusc objectAtIndex: 8] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoBusc objectAtIndex: 8] stringByTrimmingSpaces]] ;
		    ti = gsl_vector_get (vars, k) ;
		  }
		
		//Se establece la ecuacion
		gsl_vector_set (func, nEcu, sl - (vai*(tf - ti) + 0.5*aa*(tf - ti)*(tf - ti))*(rf + ri)/(4*M_PI));
		
		nEcu = nEcu + 1;
	      }
	    
	  }
	  break;
	case 212:
	  {
	    int angfInd, rfInd ;
	    double xp, yp, angf = 0, rf = 0, xc = 0, yc = 0 ;
	    
	    NSString *nomObjeto = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBusc = nil;
	    NSMutableArray *objetoBusc = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if([nomObjeto isEqualToString: nombre])
		      {
			objetoBusc = [buscarNombre objectForKey: @"Valores"] ;
			tipoBusc = [buscarNombre objectForKey: @"Tipo"] ;
			break ;
		      }
		  }
	      }
	    
	    
	    if ( ([[[objetoBusc objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[objetoBusc objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		NSMutableArray *centro = nil;
		NSString *centroNom;
		buscar = [diccionario objectEnumerator] ;
		
		centroNom = [[objetoBusc objectAtIndex: 1] stringByTrimmingSpaces] ;
		
		while ((buscarNombre = [buscar nextObject]))
		  {
		    NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		    NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		    
		    if ([titulo isEqualToString: @"Nombre"])
		      {
			if ([centroNom isEqualToString: nombre])
			  {
			    centro = [buscarNombre objectForKey: @"Valores"] ;
			    break ;
			  }
		      }
		  }
		
		if (![variables containsObject: [[centro objectAtIndex: 1] stringByTrimmingSpaces] ])
		  {
		    xc = [[centro objectAtIndex: 1] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centro objectAtIndex: 1] stringByTrimmingSpaces]] ;
		    xc = gsl_vector_get (vars, k) ;
		  }
		
		if (![variables containsObject: [[centro objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    yc = [[centro objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[centro objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    yc = gsl_vector_get (vars, k) ;
		  }
	      }
	    
	    
	    if (![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		xp = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		xp = gsl_vector_get (vars, k) ;
	      }
	    
	    if (![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		yp = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		yp = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    if ([tipoBusc intValue] == 201)
	      {
		rfInd = 2 ;
		angfInd = 8 ;
	      }
	    else
	      {
		rfInd = 10 ;
		angfInd = 9 ;
	      }
	    
	    
	    if (![variables containsObject: [[objetoBusc objectAtIndex: rfInd] stringByTrimmingSpaces] ])
	      {
		rf = [[objetoBusc objectAtIndex: rfInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: rfInd] stringByTrimmingSpaces]] ;
		rf = gsl_vector_get (vars, k) ;
	      }
	    
	    if (![variables containsObject: [[objetoBusc objectAtIndex: angfInd] stringByTrimmingSpaces] ])
	      {
		angf = [[objetoBusc objectAtIndex: angfInd] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[objetoBusc objectAtIndex: angfInd] stringByTrimmingSpaces]] ;
		angf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xp - xc - rf*cos(M_PI*angf/180) );
	    gsl_vector_set (func, nEcu + 1, yp - yc - rf*sin(M_PI*angf/180) );
	    
	    nEcu = nEcu + 2 ;
	  }
	  break;
	case 213:
	  {
	    double vr, ang ;
	    
	    NSString *nomObjetoUno = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSString *nomObjetoDos = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSNumber *tipoBuscUno = nil, *tipoBuscDos = nil;
	    NSMutableArray *objetoBuscUno = nil, *objetoBuscDos = nil;
	    NSMutableDictionary *buscarNombre ;
	    int controlBusc = 0 ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if([nomObjetoUno isEqualToString: nombre])
		      {
			objetoBuscUno = [buscarNombre objectForKey: @"Valores"] ;
			tipoBuscUno = [buscarNombre objectForKey: @"Tipo"] ;
			controlBusc = controlBusc + 1 ;
		      }
		    
		    if([nomObjetoDos isEqualToString: nombre])
		      {
			objetoBuscDos = [buscarNombre objectForKey: @"Valores"] ;
			tipoBuscDos = [buscarNombre objectForKey: @"Tipo"] ;
			controlBusc = controlBusc + 1 ;
		      }
		    
		    if(controlBusc == 2)
		      {
			break;
		      }
		  }
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		vr = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		vr = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		ang = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		ang = gsl_vector_get (vars, k) ;
	      }
	    
	    
	    if(([tipoBuscUno intValue] == 209) || ([tipoBuscDos intValue] == 209))
	      {
		NSMutableArray *movil; 
		double angf, rf, vaf, vrf ;
		
		//Se establece cual de los objetos es el movil
		if([tipoBuscUno intValue] == 209)
		  {
		    movil = objetoBuscDos;
		  }
		else
		  {
		    movil = objetoBuscUno;
		  }
		
		//Se obtienen los datos
		if(![variables containsObject: [[movil objectAtIndex: 9] stringByTrimmingSpaces] ])
		  {
		    angf = [[movil objectAtIndex: 9] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[movil objectAtIndex: 9] stringByTrimmingSpaces]] ;
		    angf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[movil objectAtIndex: 10] stringByTrimmingSpaces] ])
		  {
		    rf = [[movil objectAtIndex: 10] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[movil objectAtIndex: 10] stringByTrimmingSpaces]] ;
		    rf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[movil objectAtIndex: 11] stringByTrimmingSpaces] ])
		  {
		    vaf = [[movil objectAtIndex: 11] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[movil objectAtIndex: 11] stringByTrimmingSpaces]] ;
		    vaf = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[movil objectAtIndex: 12] stringByTrimmingSpaces] ])
		  {
		    vrf = [[movil objectAtIndex: 12] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[movil objectAtIndex: 12] stringByTrimmingSpaces]] ;
		    vrf = gsl_vector_get (vars, k) ;
		  }
		
		//Se establecen las ecuaciones
		gsl_vector_set (func, nEcu, vr - gsl_hypot(vaf*rf, vrf));
		gsl_vector_set (func, nEcu + 1, (M_PI*ang/180) - atan2(vaf*rf, vrf) - (M_PI*angf/180));
		
		nEcu = nEcu + 2;
	      }
	    else
	      {
		if(([tipoBuscUno intValue] == 201) && ([tipoBuscDos intValue] == 201))
		  {
		    double angfUno, vfUno, angfDos, vfDos;
		    
		    //Datos del movil uno
		    if(![variables containsObject: [[objetoBuscUno objectAtIndex: 8] stringByTrimmingSpaces] ])
		      {
			angfUno = [[objetoBuscUno objectAtIndex: 8] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 8] stringByTrimmingSpaces]] ;
			angfUno = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoBuscUno objectAtIndex: 9] stringByTrimmingSpaces] ])
		      {
			vfUno = [[objetoBuscUno objectAtIndex: 9] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 9] stringByTrimmingSpaces]] ;
			vfUno = gsl_vector_get (vars, k) ;
		      }
		    
		    //Datos del movil dos
		    if(![variables containsObject: [[objetoBuscDos objectAtIndex: 8] stringByTrimmingSpaces] ])
		      {
			angfDos = [[objetoBuscDos objectAtIndex: 8] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 8] stringByTrimmingSpaces]] ;
			angfDos = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoBuscDos objectAtIndex: 9] stringByTrimmingSpaces] ])
		      {
			vfDos = [[objetoBuscDos objectAtIndex: 9] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 9] stringByTrimmingSpaces]] ;
			vfDos = gsl_vector_get (vars, k) ;
		      }
		    
		    //Se establecen las ecuaciones
		    gsl_vector_set (func, nEcu, vr - gsl_hypot(vfUno*cos(M_PI*(angfUno - angfDos)/180) - vfDos, vfUno*sin(M_PI*(angfUno - angfDos)/180)));
		    gsl_vector_set (func, nEcu + 1, (M_PI*ang/180) - atan2(vfUno*sin(M_PI*(angfUno - angfDos)/180), vfUno*cos(M_PI*(angfUno - angfDos)/180) - vfDos) - (M_PI*angfDos/180)- (M_PI/2));
		    
		    nEcu = nEcu + 2 ;
		  }
		else
		  {
		    if(([tipoBuscUno intValue] == 202) && ([tipoBuscDos intValue] == 202))
		      {
			double rfUno, angfUno, vafUno, vrfUno, rfDos, angfDos, vafDos, vrfDos; 
			
			//Datos del movil uno
			if(![variables containsObject: [[objetoBuscUno objectAtIndex: 10] stringByTrimmingSpaces] ])
			  {
			    rfUno = [[objetoBuscUno objectAtIndex: 10] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 10] stringByTrimmingSpaces]] ;
			    rfUno = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscUno objectAtIndex: 9] stringByTrimmingSpaces] ])
			  {
			    angfUno = [[objetoBuscUno objectAtIndex: 9] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 9] stringByTrimmingSpaces]] ;
			    angfUno = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscUno objectAtIndex: 11] stringByTrimmingSpaces] ])
			  {
			    vafUno = [[objetoBuscUno objectAtIndex: 11] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 11] stringByTrimmingSpaces]] ;
			    vafUno = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscUno objectAtIndex: 12] stringByTrimmingSpaces] ])
			  {
			    vrfUno = [[objetoBuscUno objectAtIndex: 12] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscUno objectAtIndex: 12] stringByTrimmingSpaces]] ;
			    vrfUno = gsl_vector_get (vars, k) ;
			  }
			
			//Datos del movil dos
			if(![variables containsObject: [[objetoBuscDos objectAtIndex: 10] stringByTrimmingSpaces] ])
			  {
			    rfDos = [[objetoBuscDos objectAtIndex: 10] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 10] stringByTrimmingSpaces]] ;
			    rfDos = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscDos objectAtIndex: 9] stringByTrimmingSpaces] ])
			  {
			    angfDos = [[objetoBuscDos objectAtIndex: 9] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 9] stringByTrimmingSpaces]] ;
			    angfDos = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscDos objectAtIndex: 11] stringByTrimmingSpaces] ])
			  {
			    vafDos = [[objetoBuscDos objectAtIndex: 11] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 11] stringByTrimmingSpaces]] ;
			    vafDos = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[objetoBuscDos objectAtIndex: 12] stringByTrimmingSpaces] ])
			  {
			    vrfDos = [[objetoBuscDos objectAtIndex: 12] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[objetoBuscDos objectAtIndex: 12] stringByTrimmingSpaces]] ;
			    vrfDos = gsl_vector_get (vars, k) ;
			  }
			
			//Se establecen las ecuaciones
			gsl_vector_set (func, nEcu, vr - gsl_hypot(vafUno*rfUno*sin(M_PI*(90 + angfUno - angfDos)/180) + vrfUno*sin(M_PI*(angfUno - angfDos)/180) - vafDos*rfDos, vafUno*rfUno*cos(M_PI*(90 + angfUno - angfDos)/180) + vrfUno*cos(M_PI*(angfUno - angfDos)/180) - vrfDos));
			gsl_vector_set (func, nEcu + 1, (M_PI*ang/180) - atan2(vafUno*rfUno*sin(M_PI*(90 + angfUno - angfDos)/180) + vrfUno*sin(M_PI*(angfUno - angfDos)/180) - vafDos*rfDos, vafUno*rfUno*cos(M_PI*(90 + angfUno - angfDos)/180) + vrfUno*cos(M_PI*(angfUno - angfDos)/180) - vrfDos) - (M_PI*angfDos/180));
			
			nEcu = nEcu + 2;
		      }
		    else
		      {
			int tipoRV;
			double vfA, angfA, rfB, angfB, vafB, vrfB;
			NSMutableArray *movilA, *movilB;
			
			if(([tipoBuscUno intValue] == 201) && ([tipoBuscDos intValue] == 202))
			  {
			    tipoRV = 1;
			    movilA = objetoBuscUno;
			    movilB = objetoBuscDos;
			  }
			else
			  {
			    tipoRV = 2;
			    movilA = objetoBuscDos;
			    movilB = objetoBuscUno;
			  }
			
			//Se obtienen los datos del movil A
			if(![variables containsObject: [[movilA objectAtIndex: 8] stringByTrimmingSpaces] ])
			  {
			    angfA = [[movilA objectAtIndex: 8] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilA objectAtIndex: 8] stringByTrimmingSpaces]] ;
			    angfA = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[movilA objectAtIndex: 9] stringByTrimmingSpaces] ])
			  {
			    vfA = [[movilA objectAtIndex: 9] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilA objectAtIndex: 9] stringByTrimmingSpaces]] ;
			    vfA = gsl_vector_get (vars, k) ;
			  }
			
			//Se obtienen los datos del movil B
			if(![variables containsObject: [[movilB objectAtIndex: 10] stringByTrimmingSpaces] ])
			  {
			    rfB = [[movilB objectAtIndex: 10] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilB objectAtIndex: 10] stringByTrimmingSpaces]] ;
			    rfB = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[movilB objectAtIndex: 9] stringByTrimmingSpaces] ])
			  {
			    angfB = [[movilB objectAtIndex: 9] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilB objectAtIndex: 9] stringByTrimmingSpaces]] ;
			    angfB = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[movilB objectAtIndex: 11] stringByTrimmingSpaces] ])
			  {
			    vafB = [[movilB objectAtIndex: 11] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilB objectAtIndex: 11] stringByTrimmingSpaces]] ;
			    vafB = gsl_vector_get (vars, k) ;
			  }
			
			if(![variables containsObject: [[movilB objectAtIndex: 12] stringByTrimmingSpaces] ])
			  {
			    vrfB = [[movilB objectAtIndex: 12] doubleValue] ;
			  }
			else
			  {
			    int k = [variables indexOfObject: [[movilB objectAtIndex: 12] stringByTrimmingSpaces]] ;
			    vrfB = gsl_vector_get (vars, k) ;
			  }
			
			//Se establecen las ecuaciones
			if(tipoRV == 1)
			  {
			    gsl_vector_set (func, nEcu, vr - gsl_hypot(vfA*sin(M_PI*(90 + angfA - angfB)/180) - vafB*rfB, vfA*cos(M_PI*(90 + angfA - angfB)/180) - vrfB));
			    gsl_vector_set (func, nEcu + 1, (M_PI*ang/180) - atan2(vfA*sin(M_PI*(90 + angfA - angfB)/180) - vafB*rfB, vfA*cos(M_PI*(90 + angfA - angfB)/180) - vrfB) - (M_PI*angfB/180));
			  }
			else
			  {
			    gsl_vector_set (func, nEcu, vr - gsl_hypot(vafB*rfB*sin(M_PI*(90 + angfB - angfA)/180) + vrfB*sin(M_PI*(angfB - angfA)/180) - vfA, vafB*rfB*cos(M_PI*(90 + angfB - angfA)/180) + vrfB*cos(M_PI*(angfB - angfA)/180)));
			    gsl_vector_set (func, nEcu + 1, (M_PI*ang/180) - atan2(vafB*rfB*sin(M_PI*(90 + angfB - angfA)/180) + vrfB*sin(M_PI*(angfB - angfA)/180) - vfA, vafB*rfB*cos(M_PI*(90 + angfB - angfA)/180) + vrfB*cos(M_PI*(angfB - angfA)/180)) - (M_PI*angfA/180));
			  }
			
			nEcu = nEcu + 2;
		      }
		  }
		
	      }
	  }
	  break;
	}
    }
  return 0 ;
}

@interface FLKinematicsCircularMotion (Private)
- (void) crearSistema;
@end

@implementation FLKinematicsCircularMotion (Private)
- (void) crearSistema
{
  int aumento = 1 ;
  double nuevoValor ;
  BOOL continuar ;
  
  const gsl_multiroot_fsolver_type *T;
  gsl_multiroot_fsolver *s;
  
  int estado = 0, estadoInt, k, longitud ;
  int nvar  = [variables count] ;
  double par;
  NSString *mensaje ;
  size_t iter ;
  
  const size_t n = nvar;
  struct parametros p = {1.0, 1.0};
  
  gsl_vector *x = gsl_vector_alloc (n);
  
  int countRes = 0 ;
  id unObj ;
  NSMutableArray *resultados = [NSMutableArray array] ;
  NSEnumerator *varCount ;
  
  id datoSigno ;
  NSNumber *tipoOtro ;
  NSMutableArray *verifSigno ;
  NSEnumerator *signoObj ;
  
  //Generador de numeros aleatorios
  const gsl_rng_type * Y;
  gsl_rng * r;
  gsl_rng_env_setup();
  Y = gsl_rng_default;
  r = gsl_rng_alloc (Y);
  
  //Se verifica que los intervalos de tiempo sean positivos o que el sistema no este estancado
  do
    {
      gsl_multiroot_function f;
      iter = 0 ;
      for (k = 0; k < nvar; k++)
	{
	  if( aumento <= 15 )
	    {
	      nuevoValor = 1 ;
	    }
	  else
	    {
	      if( aumento <= 30 )
		{
		  nuevoValor = 10 ;
		}
	      else
		{
		  if( aumento <= 60 )
		    {
		      nuevoValor = 100 ;
		    }
		  else
		    {
		      nuevoValor = 1000 ;
		    }
		}
	    }
	  
	  par = nuevoValor*(gsl_rng_uniform (r)) ;
	  gsl_vector_set (x, k, par) ;
	}
      
      f.f = &sis_cinematica_circular;
      f.n = n;
      f.params = &p;
      T = gsl_multiroot_fsolver_hybrids;
      s = gsl_multiroot_fsolver_alloc (T, nvar);
      gsl_multiroot_fsolver_set (s, &f, x);
      
      do
	{
	  iter++;
	  estadoInt = gsl_multiroot_fsolver_iterate (s);
	  
	  if(estadoInt)
	    break;
	  
	  estado = gsl_multiroot_test_residual (s->f, 1e-7);
	}
      while (estado == GSL_CONTINUE && iter < 1000); 
      
      //Se verifican las variables temporales
      if( ( (varT == 1) || (estadoInt) ) && (aumento < 90) ) 
	{
	  
	  if(estadoInt)
	    {
	      aumento = aumento + 1 ;
	      continuar = YES ;
	    }
	  else
	    {
	      int r, Tindice ;
	      int signo = 0 ;
	      double prueba  ;
	      Tindice = [variables indexOfObject: tiempoVar] ;
	      
	      for(r = 0; r < [varTemporales count]; r++)
		{
		  prueba = (gsl_vector_get (s->x, Tindice)) - [[varTemporales objectAtIndex: r] doubleValue] ;
		  if(prueba >= 0)
		    { signo = signo + 1 ;  }
		}
              
	      if(signo != [varTemporales count])
		{
		  aumento = aumento + 1 ;
		  continuar = YES ;
		}
	      else
		{
		  continuar = NO ;
		}
	    }  
	  
	}
      else
	{
	  continuar = NO ;
	}
      //Se termina la verificacion
    }
  while(continuar) ;
  //se termino la busqueda de la solucion
  
  //Se pasan los datos al array Resultados
  varCount = [variables objectEnumerator];
  
  while((unObj = [varCount nextObject]))
    {
      [resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
      countRes = countRes + 1 ;
    }
  
  //Se corrigen signos en los datos
  signoObj = [diccionario objectEnumerator];
  
  while((datoSigno = [signoObj nextObject]))
    {
      int par1 = 0, w = 0 ;
      tipoOtro = [datoSigno objectForKey: @"Tipo"] ;
      
      switch([tipoOtro intValue])
	{
	case 201:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige el angulo inicial
	    if([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	    
	    //Se corrige el angulo final
	    if([variables containsObject: [[verifSigno objectAtIndex: 8] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 8] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 202:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige el angulo inicial
	    if([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	    
	    //Se corrige el angulo final
	    if([variables containsObject: [[verifSigno objectAtIndex: 9] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 9] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 205:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige el angulo de la aceleracion
	    if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 210:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige el signo de la distancia
	    if ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		
		if ( [[resultados objectAtIndex: w] doubleValue] < 0 )
		  {
		    double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
		    [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
		  }
	      }
	  }
	  break;
	case 213:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige la velocidad
	    if( ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]]) )
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		
		if( [[resultados objectAtIndex: w] doubleValue] < 0 )
		  {
		    double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
		    [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
		    par1 = 1 ;
		  }
	      }
	    
	    //Se corrige el angulo de la velocidad
	    if([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
		if( par1 == 1 )
		  {
		    nv = nv + 180 ;
		  }
                
		if( nv >= 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
		if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		[resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	}
    }
  
  //Se imprimen los resultados
  [self printUnknowns: variables withResults: resultados];
  
  //Se imprime el estado del calculo        
  mensaje = [NSString stringWithFormat: [errores objectAtIndex: 3], gsl_strerror (estado)];
  longitud = [[[self visor] textStorage] length];
  [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
  
  gsl_multiroot_fsolver_free (s);
  gsl_vector_free (x);
  gsl_rng_free (r);
}
@end

@implementation FLKinematicsCircularMotion

- (id) init
{
  NSBundle *mensajes;
  self = [super init];

  variables = [NSMutableArray array] ;
  [variables retain] ;
  varTemporales = [NSMutableArray array] ;
  [varTemporales retain] ;
  
  //Se crea el array de mensajes
  mensajes = [NSBundle mainBundle] ;
  errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"cinematicaCircMensajes" ofType: @"plist"] ] ;
  
  return self;
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  /* insert your code here */
  int longitud, c, objContenidos = 0, numEcuaciones = 0 ;
  NSUInteger sistema = [self system];
  BOOL error = NO ;
  BOOL errorConten = NO ;
  BOOL errorCent = NO ;
  BOOL errorWA = NO ;
  BOOL errorAFTN = NO ;
  BOOL errorDist = NO ;
  BOOL errorArc = NO ;
  BOOL errorCo = NO ;
  BOOL errorVr = NO ;
  NSNumber *identificador ;
  NSMutableDictionary *objeto ;
  NSMutableArray *nomObjetos = [NSMutableArray array] ;
  NSMutableArray *codObjetos = [NSMutableArray array] ;
  NSMutableArray *nomObjetosContenidos = [NSMutableArray array] ;
  NSMutableArray *nomObjContMov = [NSMutableArray array] ;
  NSMutableArray *nomObjContDatUno = [NSMutableArray array] ;
  NSMutableArray *nomObjContDatDos = [NSMutableArray array] ;
  NSMutableArray *nomObjContDist = [NSMutableArray array] ;
  NSMutableArray *nomObjContArc = [NSMutableArray array] ;
  NSMutableArray *nomObjContCo = [NSMutableArray array] ;
  NSMutableArray *nomObjContVr = [NSMutableArray array] ;
  NSEnumerator *cuenta;
  NSTextView *cinemaCircInfo = [self visor];
  varT = 0 ;
  tiempoDat = 0 ;

  diccionario = [[NSArray alloc] initWithArray: [lista allValues]] ;
  cuenta = [diccionario objectEnumerator] ;
  
  while((objeto = [cuenta nextObject]) && !error) 
    {
      int x ;
      NSString *key ;
      NSArray *terminos ;
      NSNumber *numero ;
      NSArray *titulos = [objeto objectForKey: @"Titulos"] ;
      NSMutableArray *datos = [objeto objectForKey: @"Datos"] ;
      NSMutableArray *valores = [objeto objectForKey: @"Valores"] ;
      identificador = [objeto objectForKey: @"Tipo"];
      [valores removeAllObjects] ;
      
      //Cuenta la cantidad de variables en el sistema
      for(x = 0; x < [datos count]; x++)
	{
	  NSString *data = [[datos objectAtIndex: x] stringByTrimmingSpaces];
	  NSString *title = [[titulos objectAtIndex: x] description];
	  
	  if(![self isNumericDataTheString: data] && ![title isEqualToString: _(@"Objeto")] && 
	     ![title isEqualToString: _(@"Objeto 1")] && ![title isEqualToString: _(@"Objeto 2")] && 
	     ![title isEqualToString: _(@"Nombre")] && ![title isEqualToString: @"C"])
	    {
	      if([self hasConversionTheString: data])
		{
		  terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
		  key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
                  
		  if([[[self conversions] allKeys] containsObject: key])
		    {
		      
		      if([self isNumericDataTheString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]])
                        {
			  numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[self conversions] objectForKey: key] doubleValue] ] ;
			  [valores addObject: [numero stringValue]] ;
			  
			  //Se agrega el valor de la variable temporal a varTemporales          
			  if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
			    { [varTemporales addObject: [numero stringValue] ] ; }
			  
                        }
		      else
                        {
			  NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
			  var = [var stringByAppendingString: @"@"] ;
			  var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			  
			  [valores addObject: var] ;
			  if(![variables containsObject: var])
			    {
			      [variables addObject: var] ;
			    }
			  
                        }
		    }
		  else
		    {
                      NSString *anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
                      longitud = [[[self visor] textStorage] length];
                      [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
                      error = YES ;
		    }
		  
		}
	      else
		{
		  //Se agrega una variable simple 
		  NSString *varTit, *varFactor ;   
		  NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  //Se determina el tipo de variable
		  varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  if([varTit hasPrefix: @"r"] || [varTit hasPrefix: @"d"] || 
		     [varTit hasPrefix: @"s"] || [varTit hasPrefix: @"x"] || 
		     [varTit hasPrefix: @"y"])
		    {
		      if(sistema== 0)
			{ varFactor = @"m"; }
		      else
			{ varFactor = @"ft"; }
		    }
		  else if([varTit hasPrefix: @"t"])
		    { 
		      varFactor = @"s";
		    }
		  else if([varTit hasPrefix: @"va"])
		    {
		      varFactor = @"rad/s";
		    }
		  else if([varTit hasPrefix: @"ang"])
		    { 
		      varFactor = [NSString stringWithString: _(@"grados")] ; 
		    }
		  else if([varTit hasPrefix: @"at"] || [varTit hasPrefix: @"ar"] || 
			  [varTit hasPrefix: @"atot"] || [varTit hasPrefix: @"ac"])
		    {
		      if(sistema== 0)
			{ varFactor = @"m/s2"; }
		      else
			{ varFactor = @"ft/s2"; }
		    }
		  else if([varTit hasPrefix: @"aa"])
		    {
		      varFactor = @"rad/s2";
		    }
		  else if([varTit hasPrefix: @"v"])
		    {
		      if(sistema== 0)
			{ varFactor = @"m/s"; }
		      else
			{ varFactor = @"ft/s"; }
		    }
		  else if([varTit hasPrefix: @"f"])
		    {
		      varFactor = @"hz";
		    }
		  else if([varTit hasPrefix: @"T"])
		    {
		      varFactor = @"1/hz";
		    }
		  else
		    {
		      varFactor = @"rev";
		    }
		  //Termina la busqueda del tipo de variable
		  
		  var = [var stringByAppendingString: @"@"] ;
		  var = [var stringByAppendingString: varFactor] ;
		  
		  [valores addObject: var] ;
		  if(![variables containsObject: var])
		    {
		      [variables addObject: var] ;
		    }
		  
		  //Se agrega el valor de la variable temporal a varTemporales          
		  if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
		    { [varTemporales addObject: var ] ; }
		  
		  //Se ha agregado la variable simple   
		}
	    }
          else
	    {
	      [valores addObject: [datos objectAtIndex: x]] ;
              
	      //Se agrega el valor de la variable temporal a varTemporales          
	      if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
		{ [varTemporales addObject: [datos objectAtIndex: x] ] ; }
	    }
	}    
      //Fin del conteo de variables
      
      if(error)
	break ;
      
      //Determina la variable del tiempo y el numero de ecuaciones
      switch ([identificador intValue])
	{
	case 200:
	  {
	    if(![self isNumericDataTheString: [[valores objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		tiempoVar = [[valores objectAtIndex: 0] stringByTrimmingSpaces];
		varT = 1 ;
	      }
	    else
	      {
		tiempoDat = [[valores objectAtIndex: 0] doubleValue];
		varT = 2 ;
	      }
	    
	  }
	  break;
	case 201:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	    [codObjetos addObject: identificador] ;
	    
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContMov addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
	  }    
	  break;
	case 202:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	    [codObjetos addObject: identificador] ;
	    
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContMov addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
	  }
	  break;
	case 203:
	case 204:
	  {
	    if ([identificador intValue] == 203)
	      {
		numEcuaciones = numEcuaciones + 2;
	      }
	    else
	      {
		numEcuaciones = numEcuaciones + 1;
	      }
	    
	    if(([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]))
	      {
		[nomObjContDatUno addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES ;
	      }
	  }
	  break;
	case 205:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    
	    if(([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]))
	      {
		[nomObjContDatDos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES ;
	      }
	  }
	  break;
	case 206 ... 208:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    
	    if(([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]))
	      {
		[nomObjContDatDos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES ;
	      }
	  }
	  break;
	case 209:
	  {
	    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	    [codObjetos addObject: identificador] ;
	  }
	  break;
	case 210:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    
	    if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContDist addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
	    else
	      {
		errorConten = YES ;
	      }
	    
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContDist addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
	    else
	      {
		errorConten = YES ;
	      }
	  }
	  break;
	case 211:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    
	    if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContArc addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
	    else
	      {
		errorConten = YES ;
	      }
	  }
	  break;
	case 212:
	  {
	    numEcuaciones = numEcuaciones + 2 ;
	    
	    if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContCo addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
	    else
	      {errorConten = YES; }
	  }
	  break;
	case 213:
	  {
	    numEcuaciones = numEcuaciones + 2;
	    
	    if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContVr addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
	    else
	      {errorConten = YES; }
	    
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjContVr addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
	    else
	      {errorConten = YES; }
	  }
	  break;
	}
      //Fin del conteo de ecuaciones
    }
  
  //Verificaciones previas al calculo
  
  //Se verifica que existan los objetos a los cuales se hace referencia
  for(c = 0; c < [nomObjetosContenidos count]; c++)
    {
      if([nomObjetos containsObject: [nomObjetosContenidos objectAtIndex: c]])
        {  
	  objContenidos = objContenidos + 1;
        }
    }
  
  if ((objContenidos == [nomObjetosContenidos count]) && ([variables count] == numEcuaciones) && (numEcuaciones > 0) && !error)
    {
      //Se verifica que los moviles solo puedan contener como centro objetos centro
      int indiceObj ;
      id nomObj ;
      NSNumber *verifTip ;
      NSEnumerator *conObj = [nomObjContMov objectEnumerator] ;
      int vrcont, indiceObjUno, indiceObjDos ;
      NSNumber *verifTipUno, *verifTipDos ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] != 209)
	    {
	      errorCent = YES ;
	    }
	}
      
      //Se verifica que los objetos velocidad angular y aceleracion angular solo contengan moviles circulares
      conObj = [nomObjContDatUno objectEnumerator] ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] != 201)
	    {
	      errorWA = YES ;
	    }
	}
      
      //Se verifica que los objetos aceleracion total, frecuencia, periodo y num. de vueltas solo contengan moviles
      conObj = [nomObjContDatDos objectEnumerator] ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] == 209)
	    {
	      errorAFTN = YES ;
	    }
	}
      
      //Se verifica que los objetos distancia solo contengan moviles
      conObj = [nomObjContDist objectEnumerator] ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] == 209)
	    {
	      errorDist = YES ;
	    }
	}
      
      //Se verifica que los objetos arco solo contengan moviles
      conObj = [nomObjContArc objectEnumerator] ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] == 209)
	    {
	      errorArc = YES ;
	    }
	}
      
      //Se verifica que los objetos coordenanda solo contengan moviles
      conObj = [nomObjContCo objectEnumerator] ;
      
      while(( nomObj = [conObj nextObject]))
	{
	  indiceObj = [nomObjetos indexOfObject: [nomObj stringByTrimmingSpaces] ] ;
	  verifTip = [codObjetos objectAtIndex: indiceObj] ;    
	  
	  if([verifTip intValue] == 209)
	    {
	      errorCo = YES ;
	    }
	}
      
      //Se verifica que los objetos velocidad relativa no contengan una cominacion de movil circular y centro
      for(vrcont = 0; vrcont < [nomObjContVr count]; vrcont = vrcont + 2)
	{
	  indiceObjUno = [nomObjetos indexOfObject: [[nomObjContVr objectAtIndex: vrcont] stringByTrimmingSpaces]] ;
	  indiceObjDos = [nomObjetos indexOfObject: [[nomObjContVr objectAtIndex: vrcont + 1] stringByTrimmingSpaces]] ;
	  verifTipUno = [codObjetos objectAtIndex: indiceObjUno] ;  
	  verifTipDos = [codObjetos objectAtIndex: indiceObjDos] ;    
	  
	  if( (([verifTipUno intValue] == 201) && ([verifTipDos intValue] == 209)) || (([verifTipUno intValue] == 209) && ([verifTipDos intValue] == 201)) || (([verifTipUno intValue] == 209) && ([verifTipDos intValue] == 209)) )
	    {
	      errorVr = YES ;
	    }
	}
    }
  
  
  if(([variables count] == numEcuaciones) && (numEcuaciones > 0) && !error && !errorConten && !errorCent && !errorWA && !errorAFTN && !errorDist && !errorArc && !errorCo && !errorVr)
    {
      if(objContenidos == [nomObjetosContenidos count])
	{
	  [self crearSistema] ;
	}
      else
	{
	  longitud = [ [cinemaCircInfo textStorage] length];
	  [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 1]] ;
	}
    }
  else
    {
      if(errorConten)
	{
	  longitud = [ [cinemaCircInfo textStorage] length];
	  [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 4]] ;
	}
      else
	{
	  if(errorCent)
	    {
	      longitud = [ [cinemaCircInfo textStorage] length];
	      [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 5]] ;
	    }
	  else
	    {
	      if(errorWA)
		{
		  longitud = [ [cinemaCircInfo textStorage] length];
		  [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 6]] ;
		}
	      else
		{
		  if(errorAFTN)
		    {
		      longitud = [ [cinemaCircInfo textStorage] length];
		      [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 7]] ;
		    }
		  else
		    {
		      if(errorDist)
			{
			  longitud = [ [cinemaCircInfo textStorage] length];
			  [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 8]] ;
			}
		      else
			{
			  if(errorArc)
			    {
			      longitud = [ [cinemaCircInfo textStorage] length];
			      [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 9]] ;
			    }
			  else
			    {
			      if(errorCo)
				{
				  longitud = [ [cinemaCircInfo textStorage] length];
				  [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 10]] ;
				}
			      else
				{
				  if(errorVr)
				    {
				      longitud = [ [cinemaCircInfo textStorage] length];
				      [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 11]] ;
				    }
				  else
				    {
				      longitud = [ [cinemaCircInfo textStorage] length];
				      [cinemaCircInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 2]] ;
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
}

- (void) dealloc
{
  RELEASE(diccionario) ;
  RELEASE(variables) ;
  RELEASE(varTemporales) ;
  RELEASE(errores) ;
  [super dealloc] ;
}

@end
