/* 
   Copyright (C) 2009, 2010, 2011, 2012 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <stdlib.h>
#import <stdio.h>
#import <math.h>
#import <gsl/gsl_vector.h>
#import <gsl/gsl_multiroots.h>
#import <gsl/gsl_rng.h>
#import "FLKinematics.h"

static int varT ;
static double tiempoDat ;
static NSArray *diccionario ;
static NSMutableArray *variables, *varTemporales ;
static NSString *tiempoVar ;

int valores (const gsl_vector *, void *, gsl_vector *);

struct parametros
{
  double a;
  double b;
};

int sis_cinematica (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
  valores (variables, params, funciones);  
  return GSL_SUCCESS;
}

int valores (const gsl_vector *vars, void *p, gsl_vector *func)
{
  int tIndice ;
  int nEcu = 0;
  double tf ;
  NSMutableDictionary *objeto ;
  NSEnumerator *enumerador;
  NSNumber *tipo;
  NSMutableArray *dat;
  
  if(varT == 1)
    {
      tIndice = [variables indexOfObject: tiempoVar] ;
      tf = gsl_vector_get (vars, tIndice) ;   
    }
  else
    {
      tf = tiempoDat ;
    }
  
  enumerador = [diccionario objectEnumerator] ;
  
  while((objeto = [enumerador nextObject]))
    {
      tipo = [objeto objectForKey: @"Tipo"] ;
      dat = [objeto objectForKey: @"Valores"] ;
      
      switch([tipo intValue])
	{
	case 2:
	  {
	    double xsi, ysi, xof, yof, vxs, vys, vxof, vyof ;
	    double xo, yo, vxo, vyo, angx, angy ;
            
	    NSString *nomObjeto = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoMov = nil, *objetoMovTit = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0] stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoMov = [buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit = [buscarNombre objectForKey: @"Titulos"] ; 
			break;
		      }
		  }
	      }
	    
	    //Dato xsi inicial
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		xsi = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		xsi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato ysi inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		ysi = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		ysi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vxs inicial
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		vxs = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		vxs = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vys inicial
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vys = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vys = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato xof final
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		xof = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		xof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato yof final
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		yof = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		yof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vxof final
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		vxof = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		vxof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vyof final
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		vyof = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		vyof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se obtienen los datos del objeto en el sistema movil
	    
	    //Dato x final
	    if([objetoMovTit containsObject: @"xf"])
	      { 
		int xf_o = [objetoMovTit indexOfObject: @"xf"];
		
		if(![variables containsObject: [[objetoMov objectAtIndex: xf_o] stringByTrimmingSpaces] ])
		  {
		    xo = [[objetoMov objectAtIndex: xf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: xf_o]  stringByTrimmingSpaces]] ;
		    xo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		xo = 0;
	      }                   
	    
	    //Dato y final
	    if([objetoMovTit containsObject: @"yf"])
	      {
		int yf_o = [objetoMovTit indexOfObject: @"yf"];
		
		if(![variables containsObject: [[objetoMov objectAtIndex: yf_o] stringByTrimmingSpaces] ])
		  {
		    yo = [[objetoMov objectAtIndex: yf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: yf_o]  stringByTrimmingSpaces]] ;
		    yo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		yo = 0;
	      }                   
	    
	    //Dato vxo final
	    if([objetoMovTit containsObject: @"vxf"] || [objetoMovTit containsObject: @"vx"])
	      {
		int vxf_o; 
		angx = 0;
		
		if([objetoMovTit containsObject: @"vxf"])
		  {
		    vxf_o = [objetoMovTit indexOfObject: @"vxf"];
		  }
		else
		  {
		    vxf_o = [objetoMovTit indexOfObject: @"vx"];
		  }
		
		if(![variables containsObject: [[objetoMov objectAtIndex: vxf_o] stringByTrimmingSpaces] ])
		  {
		    vxo = [[objetoMov objectAtIndex: vxf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: vxf_o]  stringByTrimmingSpaces]] ;
		    vxo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		if([objetoMovTit containsObject: @"vf"])
		  {
		    int vf_o = [objetoMovTit indexOfObject: @"vf"];
		    int ang_x = [objetoMovTit indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces] ])
		      {
                        vxo = [[objetoMov objectAtIndex: vf_o] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: vf_o]  stringByTrimmingSpaces]] ;
                        vxo = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: ang_x] stringByTrimmingSpaces] ])
		      {
                        angx = [[objetoMov objectAtIndex: ang_x] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: ang_x]  stringByTrimmingSpaces]] ;
                        angx = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vxo = 0 ;
		    angx = 0 ; 
		  }
	      }                   
	    
	    //Dato vyo final
	    if([objetoMovTit containsObject: @"vyf"] || [objetoMovTit containsObject: @"vy"])
	      {
		int vyf_o;
		angy = 90 ;
		
		if([objetoMovTit containsObject: @"vyf"])
		  {
		    vyf_o = [objetoMovTit indexOfObject: @"vyf"];
		  }
		else
		  {
		    vyf_o = [objetoMovTit indexOfObject: @"vy"];
		  }
		
		if(![variables containsObject: [[objetoMov objectAtIndex: vyf_o] stringByTrimmingSpaces] ])
		  {
		    vyo = [[objetoMov objectAtIndex: vyf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: vyf_o]  stringByTrimmingSpaces]] ;
		    vyo = gsl_vector_get (vars, k) ;
		  }
	      }                   
	    else
	      {
		if([objetoMovTit containsObject: @"vf"])
		  {
		    int vf_o = [objetoMovTit indexOfObject: @"vf"];
		    int ang_y = [objetoMovTit indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces] ])
		      {
                        vyo = [[objetoMov objectAtIndex: vf_o] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: vf_o]  stringByTrimmingSpaces]] ;
                        vyo = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: ang_y] stringByTrimmingSpaces] ])
		      {
                        angy = [[objetoMov objectAtIndex: ang_y] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: ang_y]  stringByTrimmingSpaces]] ;
                        angy = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vyo = 0 ;
		    angy = 0 ; 
		  }
	      }                   
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xsi + vxs*tf + xo - xof);
	    gsl_vector_set (func, nEcu + 1, ysi + vys*tf + yo - yof);
	    gsl_vector_set (func, nEcu + 2, vxs + vxo*cos(M_PI*angx/180) - vxof);
	    gsl_vector_set (func, nEcu + 3, vys + vyo*sin(M_PI*angy/180) - vyof);  
            
	    nEcu = nEcu + 4 ; 
	  }
	  break;
	case 3:
	  {
	    double ti, ax, ay, xf, xi, yf, yi, vxf, vxi, vyf, vyi ;
            
	    //Dato t inicial
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }                   
	    
	    //Dato a en x
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		ax = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		ax = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato a en y
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		ay = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		ay = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		xi = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		xi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y inicial
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		yi = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		yi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vx inicial
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vxi = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vxi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vy inicial
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vyi = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vyi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x final
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		xf = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		xf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y final
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		yf = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		yf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vx final
	    if(![variables containsObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces] ])
	      {
		vxf = [[dat objectAtIndex: 10] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces]] ;
		vxf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vy final
	    if(![variables containsObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces] ])
	      {
		vyf = [[dat objectAtIndex: 11] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces]] ;
		vyf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xi + vxi*(tf-ti) + 0.5*ax*(tf-ti)*(tf-ti) - xf);
	    gsl_vector_set (func, nEcu + 1, yi + vyi*(tf-ti) + 0.5*ay*(tf-ti)*(tf-ti) - yf);
	    gsl_vector_set (func, nEcu + 2, vxi + ax*(tf-ti) - vxf);
	    gsl_vector_set (func, nEcu + 3, vyi + ay*(tf-ti) - vyf);  
            
	    nEcu = nEcu + 4 ; 
	  }
	  break;
	case 4:
	  {
	    double ti, ax, ay, xi, yi, vi, angi, xf, yf, vf, angf ;
            
	    //Dato t inicial
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato a en x
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		ax = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		ax = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato a en y
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		ay = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		ay = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		xi = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		xi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y inicial
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		yi = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		yi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x final
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		xf = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		xf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y final
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		yf = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		yf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v inicial
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vi = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v final
	    if(![variables containsObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces] ])
	      {
		vf = [[dat objectAtIndex: 10] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 10] stringByTrimmingSpaces]] ;
		vf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato angulo inicial
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		angi = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		angi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato angulo final
	    if(![variables containsObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces] ])
	      {
		angf = [[dat objectAtIndex: 11] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 11] stringByTrimmingSpaces]] ;
		angf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xi + vi*cos(M_PI*angi/180)*(tf-ti) + 0.5*ax*(tf-ti)*(tf-ti) - xf);
	    gsl_vector_set (func, nEcu + 1, yi + vi*sin(M_PI*angi/180)*(tf-ti) + 0.5*ay*(tf-ti)*(tf-ti) - yf);
	    gsl_vector_set (func, nEcu + 2, gsl_hypot( (vi*cos(M_PI*angi/180) + ax*(tf-ti)) , (vi*sin(M_PI*angi/180) + ay*(tf-ti)) ) - vf);
	    gsl_vector_set (func, nEcu + 3, atan2( (vi*sin(M_PI*angi/180) + ay*(tf-ti)) , (vi*cos(M_PI*angi/180) + ax*(tf-ti)) ) - (M_PI*angf/180) ); 
            
	    nEcu = nEcu + 4 ;     
	  }
	  break;
	case 5:
	case 6:
	  {  
	    double ti, ax, xf, xi, vxf, vxi ;
            
	    //Dato t inicial
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato a
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		ax = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		ax = gsl_vector_get (vars, k) ;
	      }      
	    
	    //Dato x inicial
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		xi = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		xi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		vxi = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		vxi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x final
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		xf = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		xf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v final
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		vxf = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		vxf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xi + vxi*(tf-ti) + 0.5*ax*(tf-ti)*(tf-ti) - xf);
	    gsl_vector_set (func, nEcu + 1, vxi + ax*(tf-ti) - vxf); 
            
	    nEcu = nEcu + 2 ;    
	  }
	  break;
	case 7:
	  {
	    double xsi, xof, vxs, vxof ;
	    double xo, vxo, angx ;
            
	    NSString *nomObjeto = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoMov = nil, *objetoMovTit = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                
		if([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoMov = [buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit = [buscarNombre objectForKey: @"Titulos"] ; 
			break;
		      }
		  }   
	      }
	    
	    //Dato xsi inicial
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		xsi = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		xsi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vxs inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		vxs = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		vxs = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato xof final
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		xof = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		xof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vxof final
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vxof = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vxof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se obtienen los datos del objeto en el sistema movil
	    
	    //Dato x final
	    if([objetoMovTit containsObject: @"xf"])
	      { 
		int xf_o = [objetoMovTit indexOfObject: @"xf"];
		
		if(![variables containsObject: [[objetoMov objectAtIndex: xf_o] stringByTrimmingSpaces] ])
		  {
		    xo = [[objetoMov objectAtIndex: xf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: xf_o]  stringByTrimmingSpaces]] ;
		    xo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		xo = 0;
	      }                   
	    
	    //Dato vxo final
	    if([objetoMovTit containsObject: @"vxf"] || [objetoMovTit containsObject: @"vx"])
	      {
		int vxf_o;
		angx = 0;
		
		if([objetoMovTit containsObject: @"vxf"])
		  {
		    vxf_o = [objetoMovTit indexOfObject: @"vxf"];
		  }
		else
		  {
		    vxf_o = [objetoMovTit indexOfObject: @"vx"];
		  }
		
		if(![variables containsObject: [[objetoMov objectAtIndex: vxf_o] stringByTrimmingSpaces] ])
		  {
		    vxo = [[objetoMov objectAtIndex: vxf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: vxf_o]  stringByTrimmingSpaces]] ;
		    vxo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		if([objetoMovTit containsObject: @"vf"])
		  {
		    int vf_o = [objetoMovTit indexOfObject: @"vf"];
		    int ang_x = [objetoMovTit indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces] ])
		      {
                        vxo = [[objetoMov objectAtIndex: vf_o] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces]] ;
                        vxo = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: ang_x] stringByTrimmingSpaces] ])
		      {
                        angx = [[objetoMov objectAtIndex: ang_x] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: ang_x] stringByTrimmingSpaces]] ;
                        angx = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vxo = 0 ;
		    angx = 0 ; 
		  }
	      }                   
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xsi + vxs*tf + xo - xof);
	    gsl_vector_set (func, nEcu + 1, vxs + vxo*cos(M_PI*angx/180) - vxof);
            
	    nEcu = nEcu + 2 ; 
	  }
	  break;
	case 8:
	  {
	    double ysi, yof, vys, vyof ;
	    double yo, vyo, angy ;
            
	    NSString *nomObjeto = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoMov = nil, *objetoMovTit = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                
		if([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto isEqualToString: nombre])
		      {
			objetoMov = [buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit = [buscarNombre objectForKey: @"Titulos"] ; 
			break;
		      }
		  }
	      }
	    
	    //Dato ysi inicial
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		ysi = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		ysi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vys inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		vys = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		vys = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato yof final
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		yof = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		yof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato vyof final
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vyof = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vyof = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se obtienen los datos del objeto en el sistema movil
	    
	    //Dato y final
	    if([objetoMovTit containsObject: @"yf"])
	      {
		int yf_o = [objetoMovTit indexOfObject: @"yf"];
		
		if(![variables containsObject: [[objetoMov objectAtIndex: yf_o] stringByTrimmingSpaces] ])
		  {
		    yo = [[objetoMov objectAtIndex: yf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: yf_o] stringByTrimmingSpaces]] ;
		    yo = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		yo = 0;
	      }                   
	    
	    //Dato vyo final
	    if([objetoMovTit containsObject: @"vyf"] || [objetoMovTit containsObject: @"vy"])
	      {
		int vyf_o;
		angy = 90 ;
		
		if([objetoMovTit containsObject: @"vyf"])
		  {
		    vyf_o = [objetoMovTit indexOfObject: @"vyf"];
		  }
		else
		  {
		    vyf_o = [objetoMovTit indexOfObject: @"vy"];
		  }
		
		if(![variables containsObject: [[objetoMov objectAtIndex: vyf_o] stringByTrimmingSpaces] ])
		  {
		    vyo = [[objetoMov objectAtIndex: vyf_o] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov objectAtIndex: vyf_o] stringByTrimmingSpaces]] ;
		    vyo = gsl_vector_get (vars, k) ;
		  }
	      }                   
	    else
	      {
		if([objetoMovTit containsObject: @"vf"])
		  {
		    int vf_o = [objetoMovTit indexOfObject: @"vf"];
		    int ang_y = [objetoMovTit indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces] ])
		      {
                        vyo = [[objetoMov objectAtIndex: vf_o] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: vf_o] stringByTrimmingSpaces]] ;
                        vyo = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov objectAtIndex: ang_y] stringByTrimmingSpaces] ])
		      {
                        angy = [[objetoMov objectAtIndex: ang_y] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov objectAtIndex: ang_y] stringByTrimmingSpaces]] ;
                        angy = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vyo = 0 ;
		    angy = 0 ; 
		  }
	      }                   
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, ysi + vys*tf + yo - yof);
	    gsl_vector_set (func, nEcu + 1, vys + vyo*sin(M_PI*angy/180) - vyof);  
            
	    nEcu = nEcu + 2 ; 
	  }
	  break;
	case 9:
	case 10:
	  {
	    double ti, xf, xi, vx ;
	    
	    //Dato t inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x inicial
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		xi = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		xi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x final
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		xf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		xf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v final
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		vx = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		vx = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, xi + vx*(tf-ti) - xf);
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 11:
	  {
	    double xf1, yf1, xf2, yf2, d ;
            
	    NSString *nomObjeto1 = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSString *nomObjeto2 = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoMov1 = nil, *objetoMovTit1 = nil, *objetoMov2 = nil, *objetoMovTit2 = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[ buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		NSString *titulo = [[[ buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  {     
		    if ([nomObjeto1 isEqualToString: nombre])
		      {
			objetoMov1 = [ buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit1 = [ buscarNombre objectForKey: @"Titulos"] ; 
		      }
		    
		    if ([nomObjeto2 isEqualToString: nombre])
		      {
			objetoMov2 = [ buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit2 = [ buscarNombre objectForKey: @"Titulos"] ;
		      }
		  }
	      }
	    
	    //Dato x final del objeto 1
	    if([objetoMovTit1 containsObject: @"xf"])
	      { 
		int xf_uno = [objetoMovTit1 indexOfObject: @"xf"];
		
		if(![variables containsObject: [[objetoMov1 objectAtIndex: xf_uno] stringByTrimmingSpaces] ])
		  {
		    xf1 = [[objetoMov1 objectAtIndex: xf_uno] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: xf_uno] stringByTrimmingSpaces]] ;
		    xf1 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		xf1 = 0;
	      }                                     
	    
	    //Dato y final del objeto 1
	    if([objetoMovTit1 containsObject: @"yf"])
	      { 
		int yf_uno = [objetoMovTit1 indexOfObject: @"yf"];
		
		if(![variables containsObject: [[objetoMov1 objectAtIndex: yf_uno] stringByTrimmingSpaces] ])
		  {
		    yf1 = [[objetoMov1 objectAtIndex: yf_uno] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: yf_uno] stringByTrimmingSpaces]] ;
		    yf1 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		yf1 = 0;
	      }
	    
	    //Dato x final del objeto 2
	    if([objetoMovTit2 containsObject: @"xf"])
	      { 
		int xf_dos = [objetoMovTit2 indexOfObject: @"xf"];
		
		if(![variables containsObject: [[objetoMov2 objectAtIndex: xf_dos] stringByTrimmingSpaces] ])
		  {
		    xf2 = [[objetoMov2 objectAtIndex: xf_dos] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: xf_dos] stringByTrimmingSpaces]] ;
		    xf2 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		xf2 = 0;
	      }
	    
	    //Dato y final del objeto 2
	    if([objetoMovTit2 containsObject: @"yf"])
	      { 
		int yf_dos = [objetoMovTit2 indexOfObject: @"yf"];
		
		if(![variables containsObject: [[objetoMov2 objectAtIndex: yf_dos] stringByTrimmingSpaces] ])
		  {
		    yf2 = [[objetoMov2 objectAtIndex: yf_dos] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: yf_dos] stringByTrimmingSpaces]] ;
		    yf2 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		yf2 = 0;
	      }     
	    
	    //Dato d
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		d = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		d = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, gsl_hypot( xf1 - xf2, yf1 - yf2) - d);
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 12:
	  {
	    double vxf1, vyf1, vxf2, vyf2, angx1, angy1, angx2, angy2, vr, ang ;
	    
	    NSString *nomObjeto1 = [[dat objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSString *nomObjeto2 = [[dat objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableArray *objetoMov1 = nil, *objetoMovTit1 = nil, *objetoMov2 = nil, *objetoMovTit2 = nil;
	    NSMutableDictionary *buscarNombre ;
            
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                
		if ([titulo isEqualToString: @"Nombre"])
		  { 
		    if ([nomObjeto1 isEqualToString: nombre])
		      {
			objetoMov1 = [buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit1 = [buscarNombre objectForKey: @"Titulos"] ; 
		      }
		    
		    if ([nomObjeto2 isEqualToString: nombre])
		      {
			objetoMov2 = [buscarNombre objectForKey: @"Valores"] ;
			objetoMovTit2 = [buscarNombre objectForKey: @"Titulos"] ;
		      }
		  }   
	      }
	    
	    //Dato vx final del objeto 1
	    if([objetoMovTit1 containsObject: @"vxf"] || [objetoMovTit1 containsObject: @"vx"])
	      {
		int vxf_uno;
		angx1 = 0;
		
		if([objetoMovTit1 containsObject: @"vxf"])
		  {
		    vxf_uno = [objetoMovTit1 indexOfObject: @"vxf"];
		  }
		else
		  {
		    vxf_uno = [objetoMovTit1 indexOfObject: @"vx"];
		  }
		
		if(![variables containsObject: [[objetoMov1 objectAtIndex: vxf_uno] stringByTrimmingSpaces] ])
		  {
		    vxf1 = [[objetoMov1 objectAtIndex: vxf_uno] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: vxf_uno] stringByTrimmingSpaces]] ;
		    vxf1 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		if([objetoMovTit1 containsObject: @"vf"])
		  {
		    int vf_uno = [objetoMovTit1 indexOfObject: @"vf"];
		    int ang_x = [objetoMovTit1 indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov1 objectAtIndex: vf_uno] stringByTrimmingSpaces] ])
		      {
                        vxf1 = [[objetoMov1 objectAtIndex: vf_uno] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: vf_uno] stringByTrimmingSpaces]] ;
                        vxf1 = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov1 objectAtIndex: ang_x] stringByTrimmingSpaces] ])
		      {
                        angx1 = [[objetoMov1 objectAtIndex: ang_x] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: ang_x] stringByTrimmingSpaces]] ;
                        angx1 = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vxf1 = 0 ;
		    angx1 = 0 ; 
		  }
	      }
	    
	    //Dato vy final del objeto 1
	    if([objetoMovTit1 containsObject: @"vyf"] || [objetoMovTit1 containsObject: @"vy"])
	      {
		int vyf_uno;
		angy1 = 90 ;
		
		if([objetoMovTit1 containsObject: @"vyf"])
		  {
		    vyf_uno = [objetoMovTit1 indexOfObject: @"vyf"];
		  }
		else
		  {
		    vyf_uno = [objetoMovTit1 indexOfObject: @"vy"];
		  }
		
		if(![variables containsObject: [[objetoMov1 objectAtIndex: vyf_uno] stringByTrimmingSpaces] ])
		  {
		    vyf1 = [[objetoMov1 objectAtIndex: vyf_uno] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: vyf_uno] stringByTrimmingSpaces]] ;
		    vyf1 = gsl_vector_get (vars, k) ;
		  }
	      }                   
	    else
	      {
		if([objetoMovTit1 containsObject: @"vf"])
		  {
		    int vf_uno = [objetoMovTit1 indexOfObject: @"vf"];
		    int ang_y = [objetoMovTit1 indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov1 objectAtIndex: vf_uno] stringByTrimmingSpaces] ])
		      {
                        vyf1 = [[objetoMov1 objectAtIndex: vf_uno] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: vf_uno] stringByTrimmingSpaces]] ;
                        vyf1 = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov1 objectAtIndex: ang_y] stringByTrimmingSpaces] ])
		      {
                        angy1 = [[objetoMov1 objectAtIndex: ang_y] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: ang_y] stringByTrimmingSpaces]] ;
                        angy1 = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vyf1 = 0 ;
		    angy1 = 0 ; 
		  }
	      }                 
	    
	    //Dato vx final del objeto 2
	    if([objetoMovTit2 containsObject: @"vxf"] || [objetoMovTit2 containsObject: @"vx"])
	      {
		int vxf_dos;
		angx2 = 0;
		
		if([objetoMovTit2 containsObject: @"vxf"])
		  {
		    vxf_dos = [objetoMovTit2 indexOfObject: @"vxf"];
		  }
		else
		  {
		    vxf_dos = [objetoMovTit2 indexOfObject: @"vx"];
		  }
		
		if(![variables containsObject: [[objetoMov2 objectAtIndex: vxf_dos] stringByTrimmingSpaces] ])
		  {
		    vxf2 = [[objetoMov2 objectAtIndex: vxf_dos] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: vxf_dos] stringByTrimmingSpaces]] ;
		    vxf2 = gsl_vector_get (vars, k) ;
		  }
	      }
	    else
	      {
		if([objetoMovTit2 containsObject: @"vf"])
		  {
		    int vf_dos = [objetoMovTit2 indexOfObject: @"vf"];
		    int ang_x = [objetoMovTit2 indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov2 objectAtIndex: vf_dos] stringByTrimmingSpaces] ])
		      {
                        vxf2 = [[objetoMov2 objectAtIndex: vf_dos] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: vf_dos] stringByTrimmingSpaces]] ;
                        vxf2 = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov2 objectAtIndex: ang_x] stringByTrimmingSpaces] ])
		      {
                        angx2 = [[objetoMov2 objectAtIndex: ang_x] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: ang_x] stringByTrimmingSpaces]] ;
                        angx2 = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vxf2 = 0 ;
		    angx2 = 0 ; 
		  }
	      }
	    
	    //Dato vy final del objeto 2
	    if([objetoMovTit2 containsObject: @"vyf"] || [objetoMovTit2 containsObject: @"vy"])
	      {
		int vyf_dos;
		angy2 = 90 ;
		
		if([objetoMovTit2 containsObject: @"vyf"])
		  {
		    vyf_dos = [objetoMovTit2 indexOfObject: @"vyf"];
		  }
		else
		  {
		    vyf_dos = [objetoMovTit2 indexOfObject: @"vy"];
		  }
		
		if(![variables containsObject: [[objetoMov2 objectAtIndex: vyf_dos] stringByTrimmingSpaces] ])
		  {
		    vyf2 = [[objetoMov2 objectAtIndex: vyf_dos] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: vyf_dos] stringByTrimmingSpaces]] ;
		    vyf2 = gsl_vector_get (vars, k) ;
		  }
	      }                   
	    else
	      {
		if([objetoMovTit2 containsObject: @"vf"])
		  {
		    int vf_dos = [objetoMovTit2 indexOfObject: @"vf"];
		    int ang_y = [objetoMovTit2 indexOfObject: @"angf"];
		    
		    if(![variables containsObject: [[objetoMov2 objectAtIndex: vf_dos] stringByTrimmingSpaces] ])
		      {
                        vyf2 = [[objetoMov2 objectAtIndex: vf_dos] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: vf_dos] stringByTrimmingSpaces]] ;
                        vyf2 = gsl_vector_get (vars, k) ;
		      }
		    
		    if(![variables containsObject: [[objetoMov2 objectAtIndex: ang_y] stringByTrimmingSpaces] ])
		      {
                        angy2 = [[objetoMov2 objectAtIndex: ang_y] doubleValue] ;
		      }
		    else
		      {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: ang_y] stringByTrimmingSpaces]] ;
                        angy2 = gsl_vector_get (vars, k) ;
		      }
		  }
		else
		  {
		    vyf2 = 0 ;
		    angy2 = 0 ; 
		  }
	      }                 
	    
	    //Dato v relativa
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		vr = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		vr = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato angulo
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		ang = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		ang = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    {
	      const double cvx = (vxf1*cos(M_PI*angx1/180)) - (vxf2*cos(M_PI*angx2/180)) ;
	      const double cvy = (vyf1*sin(M_PI*angy1/180)) - (vyf2*sin(M_PI*angy2/180)) ; 
	      
	      gsl_vector_set (func, nEcu, gsl_hypot( cvx, cvy ) - vr);
	      gsl_vector_set (func, nEcu + 1, atan2( (vyf1*sin(M_PI*angy1/180)) - (vyf2*sin(M_PI*angy2/180)), (vxf1*cos(M_PI*angx1/180)) - (vxf2*cos(M_PI*angx2/180)) ) - (M_PI*ang/180) ); 
	      
	      nEcu = nEcu + 2 ;
	    }
	  }
	  break;
	case 13:
	  {
	    double ar, angf, xi, yi, vi, ti, xf, yf, vf ;
            
	    //Dato a radial
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		ar = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		ar = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato angulo
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		angf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		angf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x inicial
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		xi = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		xi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y inicial
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		yi = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		yi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v inicial
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		vi = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		vi = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato t inicial
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		ti = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		ti = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x final
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		xf = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		xf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato y final
	    if(![variables containsObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces] ])
	      {
		yf = [[dat objectAtIndex: 8] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 8] stringByTrimmingSpaces]] ;
		yf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato v final
	    if(![variables containsObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces] ])
	      {
		vf = [[dat objectAtIndex: 9] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 9] stringByTrimmingSpaces]] ;
		vf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, xi + vi*cos(M_PI*angf/180)*(tf - ti) + 0.5*ar*cos(M_PI*angf/180)*(tf - ti)*(tf - ti) - xf );
	    gsl_vector_set (func, nEcu + 1, yi + vi*sin(M_PI*angf/180)*(tf - ti) + 0.5*ar*sin(M_PI*angf/180)*(tf - ti)*(tf - ti) - yf ); 
	    gsl_vector_set (func, nEcu + 2, vi + ar*(tf - ti) - vf ); 
	    
	    nEcu = nEcu + 3 ; 
	  }
	  break;
	case 14:
	  {
	    double x1, x2, dx ;
            
	    //Dato x del objeto uno
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		x1 = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		x1 = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato x del objeto dos
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		x2 = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		x2 = gsl_vector_get (vars, k) ;
	      }
	    
	    //Dato dx 
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		dx = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		dx = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establecen las ecuaciones
	    gsl_vector_set (func, nEcu, x1 - x2 - dx );
	    
	    nEcu = nEcu + 1 ; 
	  }
	  break;
	}  
    }
  return 0;        
}


@interface FLKinematics (Private)
- (void) crearSistema;
@end

@implementation FLKinematics (Private)

- (void) crearSistema
{
  int aumento = 1 ;
  double nuevoValor ;
  BOOL continuar ;
  
  const gsl_multiroot_fsolver_type *T;
  gsl_multiroot_fsolver *s;
  
  int estado = 0, estadoInt, k, longitud ;
  double par;
  NSString *mensaje ;
  size_t iter ;
  int countRes = 0 ;
  id unObj ;
  NSMutableArray *resultados;
  NSEnumerator *varCount;
  id datoSigno ;
  NSNumber *tipoOtro ;
  NSMutableArray *verifSigno ;
  NSEnumerator *signoObj;
  
  int nvar  = [variables count] ;
  const size_t n = nvar;
  struct parametros p;
  gsl_vector *x;
  const gsl_rng_type * Y;
  gsl_rng * r;
  
  p.a=1.0;
  p.b=1.0;
  x = gsl_vector_alloc (n);
  
  //Generador de numeros aleatorios
  gsl_rng_env_setup();
  Y = gsl_rng_default;
  r = gsl_rng_alloc (Y);
  
  //Se verifica que los intervalos de tiempo sean positivos o que el sistema no este estancado
  do
    {
      gsl_multiroot_function f;
      iter = 0 ;
      for (k = 0; k < nvar; k++)
	{
	  if( aumento <= 15 )
	    {
	      nuevoValor = 1 ;
	    }
	  else
	    {
	      if( aumento <= 30 )
		{
		  nuevoValor = 10 ;
		}
	      else
		{
		  if( aumento <= 60 )
		    {
		      nuevoValor = 100 ;
		    }
		  else
		    {
		      nuevoValor = 1000 ;
		    }
		}
	    }
	  
	  par = nuevoValor*(gsl_rng_uniform (r)) ;
	  gsl_vector_set (x, k, par) ;
	}
      
      f.f = &sis_cinematica;
      f.n = n;
      f.params = &p;    
      T = gsl_multiroot_fsolver_hybrids;
      s = gsl_multiroot_fsolver_alloc (T, nvar);
      gsl_multiroot_fsolver_set (s, &f, x);
      
      do
	{
	  iter++;
	  estadoInt = gsl_multiroot_fsolver_iterate (s);
	  
	  if(estadoInt)
	    break;
	  
	  estado = gsl_multiroot_test_residual (s->f, 1e-7);
	}
      while (estado == GSL_CONTINUE && iter < 1000);  
      
      /*
	for(k = 0; k < nvar; k++)
	{
	terminos = [[variables objectAtIndex: k] componentsSeparatedByString: @"@"] ;
	factor = [[[conversiones objectAtIndex: sistema] objectForKey: [terminos objectAtIndex: 1]] doubleValue] ; 
	respuesta = [NSNumber numberWithDouble: (gsl_vector_get (s->x, k))/factor ] ;
	mensaje = [NSString stringWithFormat: @"\n  %s  =  %.3f  %s ;  ", [[terminos objectAtIndex: 0] cString], [respuesta doubleValue], [[terminos objectAtIndex: 1] cString]] ;
	longitud = [ [cinemaPuntInfo textStorage] length];
	[cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
	}
        
	mensaje = [NSString stringWithFormat: @"\n Estado = %s \n", gsl_strerror (estadoInt)];
	longitud = [ [cinemaPuntInfo textStorage] length];
	[cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
	
	for(k = 0; k < [varTemporales count]; k++)
	{
	mensaje = [NSString stringWithFormat: @"  variable = %s ;  ", [[varTemporales objectAtIndex: k] cString]] ;
	longitud = [ [cinemaPuntInfo textStorage] length];
	[cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
	}
	
	mensaje = [NSString stringWithFormat: @"\n nuevoValor = % .3f  progreso %d \n", nuevoValor, progreso];
	longitud = [ [cinemaPuntInfo textStorage] length];
	[cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ; 
      */
      
      //Se verifican las variables temporales
      if( ( (varT == 1) || (estadoInt) ) && (aumento < 90) ) 
	{
	  
	  if(estadoInt)
	    {
	      aumento = aumento + 1 ;
	      continuar = YES ;
	    }
	  else
	    {
	      int r, Tindice ;
	      int signo = 0 ;
	      double prueba  ;
	      Tindice = [variables indexOfObject: tiempoVar] ;
	      
	      for(r = 0; r < [varTemporales count]; r++)
		{
		  prueba = (gsl_vector_get (s->x, Tindice)) - [[varTemporales objectAtIndex: r] doubleValue] ;
		  if(prueba >= 0)
		    { signo = signo + 1 ;  }
		}
              
	      if(signo != [varTemporales count])
		{
		  aumento = aumento + 1 ;
		  continuar = YES ;
		}
	      else
		{
		  continuar = NO ;
		}
	    }  
	  
	}
      else
	{
	  continuar = NO ;
	}
      //Se termina la verificacion
    }
  while(continuar) ;
  //se termino la busqueda de la solucion
  
  //Se pasan los datos al array Resultados
  resultados = [NSMutableArray array] ;
  varCount = [variables objectEnumerator] ;
  
  while((unObj = [varCount nextObject]))
    {
      [resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
      countRes = countRes + 1 ;
    }
  
  //Se corrigen signos en los datos
  signoObj = [diccionario objectEnumerator] ;
  
  while((datoSigno = [signoObj nextObject]))
    {
      int par1 = 0, w = 0 ;
      tipoOtro = [datoSigno objectForKey: @"Tipo"] ;
      
      switch([tipoOtro intValue])
	{
	case 12:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige la velocidad
	    if( ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]]) )
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		
		if( [[resultados objectAtIndex: w] doubleValue] < 0 )
		  {
		    double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
		    [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
		    par1 = 1 ;
		  }
	      }
	    
	    //Se corrige el angulo de la velacidad
	    if([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if( par1 == 1 )
		  {
		    nv = nv + 180 ;
		  }
                
                if( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
                
                if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 13:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Se corrige el angulo de la direccion
	    if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
	      {
		double nv ;
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
                
                if( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;   
	}
    } 
  
  //Se imprimen los resultados
  [self printUnknowns: variables withResults: resultados];
  
  //Se imprime el estado del calculo        
  mensaje = [NSString stringWithFormat: _(@"Status = %s \n"), gsl_strerror (estado)];
  longitud = [[[self visor] textStorage] length];
  [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
  
  gsl_multiroot_fsolver_free (s);
  gsl_vector_free (x);
  gsl_rng_free (r);
}

@end

@implementation FLKinematics

- (id) init
{
  NSBundle *mensajes;
  self = [super init];
  
  variables = [NSMutableArray array] ;
  [variables retain] ;
  varTemporales = [NSMutableArray array] ;
  [varTemporales retain] ;
  
  //Se crea el array de mensajes
  mensajes = [NSBundle mainBundle] ;
  errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"cinematicaMensajes" ofType: @"plist"] ] ;
  
  return self;
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  /* insert your code here */
  int longitud, c, objContenidos = 0, numEcuaciones = 0 ;
  NSUInteger sistema= 0;
  BOOL error = NO;
  BOOL errorNom = NO;
  BOOL errorConten = NO;
  NSNumber *identificador ;
  NSMutableDictionary *objeto ;
  NSMutableArray *nomObjetos = [NSMutableArray array] ;
  NSMutableArray *nomObjetosContenidos = [NSMutableArray array] ;
  NSEnumerator *cuenta;
  NSTextView *cinemaPuntInfo = [self visor];
  varT = 0 ;
  tiempoDat = 0 ;
  
  diccionario = [[NSArray alloc] initWithArray: [lista allValues]] ;
  cuenta = [diccionario objectEnumerator] ;
  
  while((objeto = [cuenta nextObject]) && !error) 
    {
      int x ;
      NSString *key ;
      NSArray *terminos ;
      NSNumber *numero ;
      NSArray *titulos;
      NSMutableArray *datos;
      NSMutableArray *valores;
      identificador = [objeto objectForKey: @"Tipo"] ;
      titulos = [objeto objectForKey: @"Titulos"] ;
      datos = [objeto objectForKey: @"Datos"] ;
      valores = [objeto objectForKey: @"Valores"] ;
      [valores removeAllObjects] ;
      
      //Cuenta la cantidad de variables en el sistema
      for(x = 0; x < [datos count]; x++)
	{
	  NSString *data = [[datos objectAtIndex: x] stringByTrimmingSpaces];
	  NSString *title = [[titulos objectAtIndex: x] description];
	  
	  if(![self isNumericDataTheString: data] && ![title isEqualToString: _(@"Objeto")] && 
	     ![title isEqualToString: _(@"Objeto 1")] && ![title isEqualToString: _(@"Objeto 2")] && 
	     ![title isEqualToString: _(@"Nombre")])
	    {
	      if([self hasConversionTheString: data])
		{
		  terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
		  key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
                  
		  if([[[self conversions] allKeys] containsObject: key])
		    {
		      
		      if([self isNumericDataTheString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]])
                        {
			  numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[self conversions] objectForKey: key] doubleValue] ] ;
			  [valores addObject: [numero stringValue]] ;
			  
			  //Se agrega el valor de la variable temporal a varTemporales          
			  if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
			    { [varTemporales addObject: [numero stringValue] ] ; }
			  
                        }
		      else
                        {
			  NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
			  var = [var stringByAppendingString: @"@"] ;
			  var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			  
			  [valores addObject: var] ;
			  if(![variables containsObject: var])
			    {
			      [variables addObject: var] ;
			    }
			  
                        }
		    }
		  else
		    {
		      NSString *anuncio;
                      longitud = [[[self visor] textStorage] length];
                      anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
                      [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
                      error = YES ;
		    }
		  
		}
	      else
		{
		  //Se agrega una variable simple 
		  NSString *varTit, *varFactor ;   
		  NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;
		  sistema = [self system];
		  
		  //Se determina el tipo de variable
		  varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  if ([varTit hasPrefix: @"x"] || [varTit hasPrefix: @"y"] || 
		      [varTit hasPrefix: @"d"])
		    {
		      if (sistema== 0)
			{ varFactor = @"m"; }
		      else
			{ varFactor = @"ft"; }
		    }
		  else if ([varTit hasPrefix: @"t"])
		    { 
		      varFactor = @"s";
		    }
		  else if ([varTit hasPrefix: @"v"])
		    {
		      if (sistema== 0)
			{ varFactor = @"m/s"; }
		      else
			{ varFactor = @"ft/s"; }
		    }
		  else if ([varTit hasPrefix: @"ang"])
		    { 
		      varFactor = [NSString stringWithString: _(@"grados")] ; 
		    }
		  else
		    {
		      if (sistema== 0)
			{ varFactor = @"m/s2"; }
		      else
			{ varFactor = @"ft/s2"; }
		    }
		  //Termina la busqueda del tipo de variable
		  
		  var = [var stringByAppendingString: @"@"] ;
		  var = [var stringByAppendingString: varFactor] ;
		  
		  [valores addObject: var] ;
		  if(![variables containsObject: var])
		    {
		      [variables addObject: var] ;
		    }
		  
		  //Se agrega el valor de la variable temporal a varTemporales          
		  if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
		    { [varTemporales addObject: var ] ; }
		  
		  //Se ha agregado la variable simple   
		}
	    }
          else
	    {
	      [valores addObject: [datos objectAtIndex: x]] ;
              
	      //Se agrega el valor de la variable temporal a varTemporales          
	      if([[titulos objectAtIndex: x] hasPrefix: @"t"] && ([identificador intValue] != 1) )
		{ [varTemporales addObject: [datos objectAtIndex: x] ] ; }
	    }
	}    
      //Fin del conteo de variables
      
      if(error)
	break ;
      
      //Determina la variable del tiempo y el numero de ecuaciones
      switch ([identificador intValue])
	{
	case 1:
	  {
	    if(![self isNumericDataTheString: [[valores objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		tiempoVar = [[valores objectAtIndex: 0]  stringByTrimmingSpaces] ;
		varT = 1 ;
	      }
	    else
	      {
		tiempoDat = [[valores objectAtIndex: 0] doubleValue] ;
		varT = 2 ;
	      }
	  }
	  break;
	case 2:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	    
	    if ( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	  }    
	  break;
	case 3:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	  }
	  break;
	case 4:
	  {
	    numEcuaciones = numEcuaciones + 4;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	  }
	  break;
	case 5:
	case 6:
	  {
	    numEcuaciones = numEcuaciones + 2;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	  }
	  break;
	case 7:
	case 8:
	  {
	    numEcuaciones = numEcuaciones + 2;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	    
	    if ( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	  }
	  break;
	case 9:
	case 10:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	  }
	  break;
	case 11:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	    
	    if ( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	  }
	  break;
	case 12:
	  {
	    numEcuaciones = numEcuaciones + 2;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	    
	    if ( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		[nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
	      }
	    else
	      {
		errorConten = YES;
	      }
	  }
	  break;
	case 13:
	  {
	    numEcuaciones = numEcuaciones + 3;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	  }
	  break;
	case 14:
	  {
	    numEcuaciones = numEcuaciones + 1;
	  }
	  break;
	case 15:
	  {
	    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
	  }
	  break;
	}
      //Fin del conteo de ecuaciones
    }
  
  for(c = 0; c < [nomObjetosContenidos count]; c++)
    {
      if([nomObjetos containsObject: [nomObjetosContenidos objectAtIndex: c]])
        {  
	  objContenidos = objContenidos + 1;
        }
    }
  
  if(([variables count] == numEcuaciones) && (numEcuaciones > 0) && !error && !errorNom && !errorConten)
    {
      if(objContenidos == [nomObjetosContenidos count])
	{
	  [self crearSistema] ;
	}
      else
	{
	  longitud = [ [cinemaPuntInfo textStorage] length];
	  [cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 1]] ;
	}
    }
  else
    {
      if (errorNom)
	{
	  longitud = [ [cinemaPuntInfo textStorage] length];
	  [cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 3]] ;
	}
      else
	{
	  if (errorConten)
	    {
	      longitud = [ [cinemaPuntInfo textStorage] length];
	      [cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 4]] ;
	    }
	  else
	    {
	      longitud = [ [cinemaPuntInfo textStorage] length];
	      [cinemaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 2]] ;
	    }
	}
    }
}

- (void) dealloc
{
  RELEASE(diccionario) ;
  RELEASE(variables) ;
  RELEASE(varTemporales) ;
  RELEASE(errores) ;
  [super dealloc] ;
}

@end
