/* 
   Copyright (C) 2010, 2011, 2012 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <stdlib.h>
#import <stdio.h>
#import <math.h>
#import <gsl/gsl_vector.h>
#import <gsl/gsl_multiroots.h>
#import <gsl/gsl_rng.h>
#import "FLCalorimetry.h"

static BOOL mensajeTemp, cambOrCal ;
static int varT ;
static double tiempoDat ;
static NSMutableDictionary *diccionario ;
static NSMutableArray *variables, *codObjetosContenidos, *codOtros, *depositosApli, *depoTipo ;
static NSString *tiempoVar ;

int valoresCalorGas (const gsl_vector *, void *, gsl_vector *);

struct parametros
{
  double a;
  double b;
};

int sis_calor_gas (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
  valoresCalorGas (variables, params, funciones);  
  return GSL_SUCCESS;
}

int valoresCalorGas (const gsl_vector *vars, void *p, gsl_vector *func)
{
  int tIndice, codigoFuen = 0 ;
  int nEcu = 0 ;
  double tf ;
  NSNumber *objeto ;
  NSEnumerator *enumObjetos;
  //Objetos contenidos en codOtros
  NSEnumerator *enumOtros;

  
  if(varT == 1)
    {
      tIndice = [variables indexOfObject: tiempoVar] ;
      tf = gsl_vector_get (vars, tIndice) ;
    }
  else
    {
      if(varT == 2)
	{
	  tf = tiempoDat ;
	}
      else
	{
	  tf = 0 ;
	}
    }
  
  //Objetos contenidos en codObjetosContenidos
  enumObjetos = [codObjetosContenidos objectEnumerator] ;
  
  while((objeto = [enumObjetos nextObject]))
    {
      NSNumber *tipo =[[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
      NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
      
      switch([tipo intValue])
	{
	case 155:
	case 156:
	case 169:
	  {
	    if([[depositosApli objectAtIndex: codigoFuen] count] > 0)
	      {
		double masa, ce, Ti, Tf, Tm ;
		int conteo = 0 ;
		double signo ;
		double fuentes[8] = {0} ;
		NSNumber *codFuenteObj ;
		NSEnumerator *objFuen;
		
		//Comprobacion del tipo de fuente aplicada
		if([[depoTipo objectAtIndex: codigoFuen] doubleValue] == 1)
		  {
		    Tm = 1 ;
		  }
		else
		  {
		    Tm = tf ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
		  {
		    masa = [[dat objectAtIndex: 1] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		    masa = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    ce = [[dat objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    ce = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
		  {
		    Ti = [[dat objectAtIndex: 3] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		    Ti = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
		  {
		    Tf = [[dat objectAtIndex: 4] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		    Tf = gsl_vector_get (vars, k) ;
		  }

		
		objFuen = [[depositosApli objectAtIndex: codigoFuen] objectEnumerator] ;
		
		while((codFuenteObj = [objFuen nextObject]))
		  {
		    int t = [[[diccionario objectForKey: codFuenteObj] objectForKey: @"Tipo"] intValue] ;
		    
		    switch(t)
		      {
		      case 151 ... 154:
			{
			  if((t == 151) || (t == 152))
			    {
			      signo = 1 ; 
			    }
			  else
			    {
			      signo = -1 ;
			    }
			  
			  if(![variables containsObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
			    {
			      fuentes[conteo] = signo*[[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
			      fuentes[conteo] = signo*(gsl_vector_get (vars, k)) ;
			    }
			  
			  conteo = conteo + 1 ;
			}
			break;
		      }
		    
		  }
		
		//Se establece la ecuacion
		gsl_vector_set (func, nEcu, Tm*(fuentes[0] + fuentes[1] + fuentes[2] + fuentes[3] + fuentes[4] + fuentes[5] + fuentes[6] + fuentes[7]) - masa*ce*(Tf - Ti)) ;
		
		
		nEcu = nEcu + 1 ;
	      }
	  }
	  break;
	case 160:
	case 161:
	  {
	    if([[depositosApli objectAtIndex: codigoFuen] count] > 0)
	      {
		double masa, cf, Tm, sentido = 1 ;
		NSString *sent ;
		int conteo = 0 ;
		double signo ;
		double fuentes[8] = {0} ;
		NSNumber *codFuenteObj ;
		NSEnumerator *objFuen;
		
		//Comprobacion del tipo de fuente aplicada
		if([[depoTipo objectAtIndex: codigoFuen] doubleValue] == 1)
		  {
		    Tm = 1 ;
		  }
		else
		  {
		    Tm = tf ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
		  {
		    masa = [[dat objectAtIndex: 1] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		    masa = gsl_vector_get (vars, k) ;
		  }
		
		if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
		  {
		    cf = [[dat objectAtIndex: 2] doubleValue] ;
		  }
		else
		  {
		    int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		    cf = gsl_vector_get (vars, k) ;
		  }
		
		sent = [NSString stringWithString: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		
		if([sent isEqualToString: @"<"])
		  {
		    sentido = -1 ;
		  }

		
		objFuen = [[depositosApli objectAtIndex: codigoFuen] objectEnumerator] ;
		
		while((codFuenteObj = [objFuen nextObject]))
		  {
		    int t = [[[diccionario objectForKey: codFuenteObj] objectForKey: @"Tipo"] intValue] ;
		    
		    switch(t)
		      {
		      case 151 ... 154:
			{
			  if((t == 151) || (t == 152))
			    {
			      signo = 1 ; 
			    }
			  else
			    {
			      signo = -1 ;
			    }
			  
			  if(![variables containsObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
			    {
			      fuentes[conteo] = signo*[[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
			      fuentes[conteo] = signo*(gsl_vector_get (vars, k)) ;
			    }
			  
			  conteo = conteo + 1 ;
			}
			break;
		      }
		    
		  }
		
		//Se establece la ecuacion
		gsl_vector_set (func, nEcu, Tm*(fuentes[0] + fuentes[1] + fuentes[2] + fuentes[3] + fuentes[4] + fuentes[5] + fuentes[6] + fuentes[7]) - sentido*masa*cf) ;
		
		nEcu = nEcu + 1 ;
	      }
	  }
	  break;
	case 162:
	  {
	    if([[depositosApli objectAtIndex: codigoFuen] count] > 0)
	      {
		double Tm ;
		//Para la busqueda de los datos
		int contGen = 0, cont1 = 0, cont2 = 0 ;   
		double mEstado[3] = {0} ;
		double cElem[3] = {0} ;
		double mFase[2] = {0} ;
		double cfElem[2] = {0} ;
		double senElem[2] = {1} ;
		double tIniElem[3] = {0} ;
		double tFinElem[3] = {0} ;   
		NSEnumerator *datos;   
		//Para la busqueda de fuentes
		int conteo = 0 ;
		double signo ;
		double fuentes[8] = {0} ;
		NSNumber *codFuenteObj ;
		NSEnumerator *objFuen;
		//Para la busqueda de los elementos
		NSMutableArray *otrosObj = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
		NSMutableArray *codElementos = [NSMutableArray array] ;
		NSMutableArray *elementos = [NSMutableArray array] ;
		
		NSNumber *obj1, *obj2, *obj3, *obj4, *obj5 ;                 
		NSString *nomObjeto1 = [[otrosObj objectAtIndex: 1] stringByTrimmingSpaces] ;
		NSString *nomObjeto2 = [[otrosObj objectAtIndex: 2] stringByTrimmingSpaces] ;
		NSString *nomObjeto3 = [[otrosObj objectAtIndex: 3] stringByTrimmingSpaces] ;
		NSString *nomObjeto4 = [[otrosObj objectAtIndex: 4] stringByTrimmingSpaces] ;
		NSString *nomObjeto5 = [[otrosObj objectAtIndex: 5] stringByTrimmingSpaces] ;
		NSMutableArray *objeto1, *objeto2, *objeto3, *objeto4, *objeto5, *objCamb ;
		NSEnumerator *buscar = [diccionario objectEnumerator] ;
		NSMutableDictionary *buscarNombre ;

		//Comprobacion del tipo de fuente aplicada
		if([[depoTipo objectAtIndex: codigoFuen] doubleValue] == 1)
		  {
		    Tm = 1 ;
		  }
		else
		  {
		    Tm = tf ;
		  }
                

		while ((buscarNombre = [buscar nextObject]))
		  {
		    NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		    NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                    
		    if([titulo isEqualToString: @"Nombre"]) 
		      { 
			if( ([nomObjeto1 isEqualToString: nombre]) && ([nomObjeto1 length] > 0) && ![nomObjeto1 isEqualToString: @"0"] )
			  {
			    obj1 = [buscarNombre objectForKey: @"Tipo"] ;
			    objeto1 = [buscarNombre objectForKey: @"Valores"] ;
			    [codElementos addObject: obj1] ;
			    [elementos addObject: objeto1] ;
			  }
			
			if( ([nomObjeto2 isEqualToString: nombre]) && ([nomObjeto2 length] > 0) && ![nomObjeto2 isEqualToString: @"0"]  )
			  {
			    obj2 = [buscarNombre objectForKey: @"Tipo"] ;
			    objeto2 = [buscarNombre objectForKey: @"Valores"] ;
			    [codElementos addObject: obj2] ;
			    [elementos addObject: objeto2] ;
			  }
			
			if( ([nomObjeto3 isEqualToString: nombre]) && ([nomObjeto3 length] > 0) && ![nomObjeto3 isEqualToString: @"0"]  )
			  {
			    obj3 = [buscarNombre objectForKey: @"Tipo"] ;
			    objeto3 = [buscarNombre objectForKey: @"Valores"] ;
			    [codElementos addObject: obj3] ;
			    [elementos addObject: objeto3] ;
			  }   
			
			if( ([nomObjeto4 isEqualToString: nombre]) && ([nomObjeto4 length] > 0) && ![nomObjeto4 isEqualToString: @"0"]  )
			  {
			    obj4 = [buscarNombre objectForKey: @"Tipo"] ;
			    objeto4 = [buscarNombre objectForKey: @"Valores"] ;
			    [codElementos addObject: obj4] ;
			    [elementos addObject: objeto4] ;
			  }
			
			if( ([nomObjeto5 isEqualToString: nombre]) && ([nomObjeto5 length] > 0) && ![nomObjeto5 isEqualToString: @"0"]  )
			  {
			    obj5 = [buscarNombre objectForKey: @"Tipo"] ;
			    objeto5 = [buscarNombre objectForKey: @"Valores"] ;
			    [codElementos addObject: obj5] ;
			    [elementos addObject: objeto5] ;
			  }
		      } 
		  }
		
		datos = [elementos objectEnumerator] ; 
		while((objCamb = [datos nextObject]))
		  {
		    switch([[codElementos objectAtIndex: contGen] intValue])
		      {
		      case 155:
		      case 156:
		      case 169:
			{
			  if(![variables containsObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces] ])
			    {
			      mEstado[cont1] = [[objCamb objectAtIndex: 1] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces]] ;
			      mEstado[cont1] = gsl_vector_get (vars, k) ;
			    }
			  
			  if(![variables containsObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces] ])
			    {
			      cElem[cont1] = [[objCamb objectAtIndex: 2] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces]] ;
			      cElem[cont1] = gsl_vector_get (vars, k) ;
			    }
			  
			  if(![variables containsObject: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces] ])
			    {
			      tIniElem[cont1] = [[objCamb objectAtIndex: 3] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces]] ;
			      tIniElem[cont1] = gsl_vector_get (vars, k) ;
			      mensajeTemp = YES;
			    }
			  
			  if(![variables containsObject: [[objCamb objectAtIndex: 4] stringByTrimmingSpaces] ])
			    {
			      tFinElem[cont1] = [[objCamb objectAtIndex: 4] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 4] stringByTrimmingSpaces]] ;
			      tFinElem[cont1] = gsl_vector_get (vars, k) ;
			      mensajeTemp = YES;
			    }
			  
			  cont1 = cont1 + 1 ;
			}
			break;
		      case 160:
		      case 161:
			{
			  NSString *sent ;
			  cambOrCal = YES;
			  
			  if(![variables containsObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces] ])
			    {
			      mFase[cont2] = [[objCamb objectAtIndex: 1] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces]] ;
			      mFase[cont2] = gsl_vector_get (vars, k) ;
			    }
			  
			  if(![variables containsObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces] ])
			    {
			      cfElem[cont2] = [[objCamb objectAtIndex: 2] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces]] ;
			      cfElem[cont2] = gsl_vector_get (vars, k) ;
			    }
			  
			  sent = [NSString stringWithString: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces]] ;
			  
			  if([sent isEqualToString: @"<"])
			    {
			      senElem[cont2] = -1 ;
			    }
			  
			  cont2 = cont2 + 1 ;
			}
			break;
		      }
		    contGen = contGen + 1 ;
		  }

		
		objFuen = [[depositosApli objectAtIndex: codigoFuen] objectEnumerator] ;
		
		while((codFuenteObj = [objFuen nextObject]))
		  {
		    int t = [[[diccionario objectForKey: codFuenteObj] objectForKey: @"Tipo"] intValue] ;
		    
		    switch(t)
		      {
		      case 151 ... 154:
			{
			  if((t == 151) || (t == 152))
			    {
			      signo = 1 ; 
			    }
			  else
			    {
			      signo = -1 ;
			    }
			  
			  if(![variables containsObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
			    {
			      fuentes[conteo] = signo*[[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
			    }
			  else
			    {
			      int k = [variables indexOfObject: [[[[diccionario objectForKey: codFuenteObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
			      fuentes[conteo] = signo*(gsl_vector_get (vars, k)) ;
			    }
			  
			  conteo = conteo + 1 ;
			}
			break;
		      }
		    
		  }
		
		//Se establece la ecuacion
		gsl_vector_set (func, nEcu, Tm*(fuentes[0] + fuentes[1] + fuentes[2] + fuentes[3] + fuentes[4] + fuentes[5] + fuentes[6] + fuentes[7]) - mEstado[0]*cElem[0]*(tFinElem[0] - tIniElem[0]) - mEstado[1]*cElem[1]*(tFinElem[1] - tIniElem[1]) - mEstado[2]*cElem[2]*(tFinElem[2] - tIniElem[2]) - senElem[0]*mFase[0]*cfElem[0] - senElem[1]*mFase[1]*cfElem[1]) ;
		
		nEcu = nEcu + 1 ;
	      }
	  }
	  break;
	}
      codigoFuen = codigoFuen + 1 ;
    }
  
  
  //Objetos contenidos en codOtros
  enumOtros = [codOtros objectEnumerator] ;
  
  while((objeto = [enumOtros nextObject]))
    {
      NSNumber *tipo =[[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
      NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
      
      switch([tipo intValue])
	{
	case 157 ... 159:
	  {
	    double kl, Li, Lf, Ti, Tf ;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		kl = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		kl = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		Li = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		Li = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		Lf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		Lf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		Ti = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		Ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		Tf = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		Tf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, Lf - Li*(1 + kl*(Tf - Ti))) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 163:
	  {
	    //Calorimetro

	    //Para los objetos contenidos
	    int contSub = 0, contSimple = 0, contCamSimple = 0, contCamFase = 0, contCamSent = 0, contElemSD = 0 ;
	    double elemSimple[16] = {0} ;
	    double cambioSimple[48] = {0} ;
	    double cambioFase[16] = {0} ;
	    double cambioSentido[8] = {1} ;
	    NSEnumerator *calSub;
	    //----
            
	    NSMutableArray *otrosObj = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
	    NSMutableArray *codElementos = [NSMutableArray array] ;
	    NSMutableArray *elementos = [NSMutableArray array] ;
	    
	    NSNumber *obj1, *obj2, *obj3, *obj4 ;                 
	    NSString *nomObjeto1 = [[otrosObj objectAtIndex: 0] stringByTrimmingSpaces] ;
	    NSString *nomObjeto2 = [[otrosObj objectAtIndex: 1] stringByTrimmingSpaces] ;
	    NSString *nomObjeto3 = [[otrosObj objectAtIndex: 2] stringByTrimmingSpaces] ;
	    NSString *nomObjeto4 = [[otrosObj objectAtIndex: 3] stringByTrimmingSpaces] ;
	    
	    NSMutableArray *objeto1, *objeto2, *objeto3, *objeto4, *objCal ;
	    NSEnumerator *buscar = [diccionario objectEnumerator] ;
	    NSMutableDictionary *buscarNombre ;
	    
	    while ((buscarNombre = [buscar nextObject]))
	      {
		NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
		NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                
		if([titulo isEqualToString: @"Nombre"]) 
		  { 
		    if( ([nomObjeto1 isEqualToString: nombre]) && ([nomObjeto1 length] > 0) && ![nomObjeto1 isEqualToString: @"0"] )
		      {
			obj1 = [buscarNombre objectForKey: @"Tipo"] ;
			objeto1 = [buscarNombre objectForKey: @"Valores"] ;
			[codElementos addObject: obj1] ;
			[elementos addObject: objeto1] ;
		      }
		    
		    if( ([nomObjeto2 isEqualToString: nombre]) && ([nomObjeto2 length] > 0) && ![nomObjeto2 isEqualToString: @"0"]  )
		      {
			obj2 = [buscarNombre objectForKey: @"Tipo"] ;              
			objeto2 = [buscarNombre objectForKey: @"Valores"] ;
			[codElementos addObject: obj2] ;
			[elementos addObject: objeto2] ;
		      }
		    
		    if( ([nomObjeto3 isEqualToString: nombre]) && ([nomObjeto3 length] > 0) && ![nomObjeto3 isEqualToString: @"0"]  )
		      {
			obj3 = [buscarNombre objectForKey: @"Tipo"] ;              
			objeto3 = [buscarNombre objectForKey: @"Valores"] ;
			[codElementos addObject: obj3] ;
			[elementos addObject: objeto3] ;
		      }   
		    
		    if( ([nomObjeto4 isEqualToString: nombre]) && ([nomObjeto4 length] > 0) && ![nomObjeto4 isEqualToString: @"0"]  )
		      {
			obj4 = [buscarNombre objectForKey: @"Tipo"] ;               
			objeto4 = [buscarNombre objectForKey: @"Valores"] ;
			[codElementos addObject: obj4] ;
			[elementos addObject: objeto4] ;
		      }
		  } 
	      }
	    

	    calSub = [elementos objectEnumerator] ;
	    
	    while((objCal = [calSub nextObject]))
	      {
		switch([[codElementos objectAtIndex: contSub] intValue])
		  {
		  case 155:
		  case 156:
		  case 169:
		    {
		      if(![variables containsObject: [[objCal objectAtIndex: 1] stringByTrimmingSpaces] ])
			{
			  elemSimple[contSimple] = [[objCal objectAtIndex: 1] doubleValue] ;
			}
		      else
			{
			  int k = [variables indexOfObject: [[objCal objectAtIndex: 1] stringByTrimmingSpaces]] ;
			  elemSimple[contSimple] = gsl_vector_get (vars, k) ;
			}
		      
		      if(![variables containsObject: [[objCal objectAtIndex: 2] stringByTrimmingSpaces] ])
			{
			  elemSimple[contSimple + 1] = [[objCal objectAtIndex: 2] doubleValue] ;
			}
		      else
			{
			  int k = [variables indexOfObject: [[objCal objectAtIndex: 2] stringByTrimmingSpaces]] ;
			  elemSimple[contSimple + 1] = gsl_vector_get (vars, k) ;
			}
		      
		      if(![variables containsObject: [[objCal objectAtIndex: 3] stringByTrimmingSpaces] ])
			{
			  elemSimple[contSimple + 2] = [[objCal objectAtIndex: 3] doubleValue] ;
			}
		      else
			{
			  int k = [variables indexOfObject: [[objCal objectAtIndex: 3] stringByTrimmingSpaces]] ;
			  elemSimple[contSimple + 2] = gsl_vector_get (vars, k) ;
			  mensajeTemp = YES;
			}
		      
		      if(![variables containsObject: [[objCal objectAtIndex: 4] stringByTrimmingSpaces] ])
			{
			  elemSimple[contSimple + 3] = [[objCal objectAtIndex: 4] doubleValue] ;
			}
		      else
			{
			  int k = [variables indexOfObject: [[objCal objectAtIndex: 4] stringByTrimmingSpaces]] ;
			  elemSimple[contSimple + 3] = gsl_vector_get (vars, k) ;
			  mensajeTemp = YES;
			}
		      
		      contSimple = contSimple + 4 ;
		    }
		    break;
		  case 162:
		    {
		      //Para los objetos contenidos
		      int subCamCont = 0 ;
		      NSEnumerator *datos;

		      NSMutableArray *codElemSub = [NSMutableArray array] ;
		      NSMutableArray *elemSub = [NSMutableArray array] ;
		      
		      NSNumber *obj1, *obj2, *obj3, *obj4, *obj5 ;                 
		      NSString *nomObjeto1 = [[objCal objectAtIndex: 1] stringByTrimmingSpaces] ;
		      NSString *nomObjeto2 = [[objCal objectAtIndex: 2] stringByTrimmingSpaces] ;
		      NSString *nomObjeto3 = [[objCal objectAtIndex: 3] stringByTrimmingSpaces] ;
		      NSString *nomObjeto4 = [[objCal objectAtIndex: 4] stringByTrimmingSpaces] ;       
		      NSString *nomObjeto5 = [[objCal objectAtIndex: 5] stringByTrimmingSpaces] ;                                  
		      NSMutableArray *objeto1, *objeto2, *objeto3, *objeto4, *objeto5, *objCamb ;
		      NSEnumerator *buscarSub = [diccionario objectEnumerator] ;
		      NSMutableDictionary *buscarNomSub ;
		      
		      while ((buscarNomSub = [buscarSub nextObject]))
			{
			  NSString *nombre = [[[buscarNomSub objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
			  NSString *titulo = [[[buscarNomSub objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
			  if([titulo isEqualToString: @"Nombre"]) 
			    { 
			      if( ([nomObjeto1 isEqualToString: nombre]) && ([nomObjeto1 length] > 0) && ![nomObjeto1 isEqualToString: @"0"] )
				{
				  obj1 = [buscarNomSub objectForKey: @"Tipo"] ;
				  objeto1 = [buscarNomSub objectForKey: @"Valores"] ;
				  [codElemSub addObject: obj1] ;
				  [elemSub addObject: objeto1] ;
				}
			      
			      if( ([nomObjeto2 isEqualToString: nombre]) && ([nomObjeto2 length] > 0) && ![nomObjeto2 isEqualToString: @"0"]  )
				{
				  obj2 = [buscarNomSub objectForKey: @"Tipo"] ;   
				  objeto2 = [buscarNomSub objectForKey: @"Valores"] ;
				  [codElemSub addObject: obj2] ;
				  [elemSub addObject: objeto2] ;
				}
			      
			      if( ([nomObjeto3 isEqualToString: nombre]) && ([nomObjeto3 length] > 0) && ![nomObjeto3 isEqualToString: @"0"]  )
				{
				  obj3 = [buscarNomSub objectForKey: @"Tipo"] ;       
				  objeto3 = [buscarNomSub objectForKey: @"Valores"] ;
				  [codElemSub addObject: obj3] ;
				  [elemSub addObject: objeto3] ;
				}   
			      
			      if( ([nomObjeto4 isEqualToString: nombre]) && ([nomObjeto4 length] > 0) && ![nomObjeto4 isEqualToString: @"0"]  )
				{
				  obj4 = [buscarNomSub objectForKey: @"Tipo"] ;        
				  objeto4 = [buscarNomSub objectForKey: @"Valores"] ;
				  [codElemSub addObject: obj4] ;
				  [elemSub addObject: objeto4] ;
				}
			      
			      if( ([nomObjeto5 isEqualToString: nombre]) && ([nomObjeto5 length] > 0) && ![nomObjeto5 isEqualToString: @"0"]  )
				{
				  obj5 = [buscarNomSub objectForKey: @"Tipo"] ;        
				  objeto5 = [buscarNomSub objectForKey: @"Valores"] ;
				  [codElemSub addObject: obj5] ;
				  [elemSub addObject: objeto5] ;
				}
			    } 
			}
		      
		      datos = [elemSub objectEnumerator] ; 
		      while((objCamb = [datos nextObject]))
			{
			  switch([[codElemSub objectAtIndex: subCamCont] intValue])
			    {
			    case 155:
			    case 156:
			    case 169:
			      {
				if(![variables containsObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces] ])
				  {
				    cambioSimple[contCamSimple] = [[objCamb objectAtIndex: 1] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces]] ;
				    cambioSimple[contCamSimple] = gsl_vector_get (vars, k) ;
				  }
				
				if(![variables containsObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces] ])
				  {
				    cambioSimple[contCamSimple + 1] = [[objCamb objectAtIndex: 2] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces]] ;
				    cambioSimple[contCamSimple + 1] = gsl_vector_get (vars, k) ;
				  }
				
				if(![variables containsObject: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces] ])
				  {
				    cambioSimple[contCamSimple + 2] = [[objCamb objectAtIndex: 3] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces]] ;
				    cambioSimple[contCamSimple + 2] = gsl_vector_get (vars, k) ;
				    mensajeTemp = YES;
				  }
				
				if(![variables containsObject: [[objCamb objectAtIndex: 4] stringByTrimmingSpaces] ])
				  {
				    cambioSimple[contCamSimple + 3] = [[objCamb objectAtIndex: 4] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 4] stringByTrimmingSpaces]] ;
				    cambioSimple[contCamSimple + 3] = gsl_vector_get (vars, k) ;
				    mensajeTemp = YES;
				  }
				
				contCamSimple = contCamSimple + 4 ;
			      }
			      break;
			    case 160:
			    case 161:
			      {
				NSString *sent ;
				cambOrCal = YES;
				
				if(![variables containsObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces] ])
				  {
				    cambioFase[contCamFase] = [[objCamb objectAtIndex: 1] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 1] stringByTrimmingSpaces]] ;
				    cambioFase[contCamFase] = gsl_vector_get (vars, k) ;
				  }
				
				if(![variables containsObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces] ])
				  {
				    cambioFase[contCamFase + 1] = [[objCamb objectAtIndex: 2] doubleValue] ;
				  }
				else
				  {
				    int k = [variables indexOfObject: [[objCamb objectAtIndex: 2] stringByTrimmingSpaces]] ;
				    cambioFase[contCamFase + 1] = gsl_vector_get (vars, k) ;
				  }
				
				sent = [NSString stringWithString: [[objCamb objectAtIndex: 3] stringByTrimmingSpaces]] ;
				
				if([sent isEqualToString: @"<"])
				  {
				    cambioSentido[contCamSent] = -1 ;
				  }
				
				contCamFase = contCamFase + 2 ;
				contCamSent = contCamSent + 1 ;
			      }
			      break;
			    }
			  subCamCont = subCamCont + 1 ;
			}
		      contElemSD = contElemSD + 1 ;
		      contCamSimple = contElemSD*12 ;
		      contCamFase = contElemSD*4 ;
		      contCamSent = contElemSD*2 ;
		    }
		    break;
		  }
		contSub = contSub + 1 ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, 
			    elemSimple[0]*elemSimple[1]*(elemSimple[3] - elemSimple[2])
			    +  elemSimple[4]*elemSimple[5]*(elemSimple[7] - elemSimple[6])
			    +  elemSimple[8]*elemSimple[9]*(elemSimple[11] - elemSimple[10])
			    +  elemSimple[12]*elemSimple[13]*(elemSimple[15] - elemSimple[14])
			    + cambioSimple[0]*cambioSimple[1]*(cambioSimple[3] - cambioSimple[2])
			    + cambioSentido[0]*cambioFase[0]*cambioFase[1]
			    + cambioSimple[4]*cambioSimple[5]*(cambioSimple[7] - cambioSimple[6])
			    + cambioSentido[1]*cambioFase[2]*cambioFase[3]
			    + cambioSimple[8]*cambioSimple[9]*(cambioSimple[11] - cambioSimple[10])
			    + cambioSimple[12]*cambioSimple[13]*(cambioSimple[15] - cambioSimple[14])
			    + cambioSentido[2]*cambioFase[4]*cambioFase[5]
			    + cambioSimple[16]*cambioSimple[17]*(cambioSimple[19] - cambioSimple[18])
			    + cambioSentido[3]*cambioFase[6]*cambioFase[7]
			    + cambioSimple[20]*cambioSimple[21]*(cambioSimple[23] - cambioSimple[22])
			    + cambioSimple[24]*cambioSimple[25]*(cambioSimple[27] - cambioSimple[26])
			    + cambioSentido[4]*cambioFase[8]*cambioFase[9]
			    + cambioSimple[28]*cambioSimple[29]*(cambioSimple[31] - cambioSimple[30])
			    + cambioSentido[5]*cambioFase[10]*cambioFase[11]
			    + cambioSimple[32]*cambioSimple[33]*(cambioSimple[35] - cambioSimple[34])
			    + cambioSimple[36]*cambioSimple[37]*(cambioSimple[39] - cambioSimple[38])
			    + cambioSentido[6]*cambioFase[12]*cambioFase[13]
			    + cambioSimple[40]*cambioSimple[41]*(cambioSimple[43] - cambioSimple[42])
			    + cambioSentido[7]*cambioFase[14]*cambioFase[15]
			    + cambioSimple[44]*cambioSimple[45]*(cambioSimple[47] - cambioSimple[46])
			    ) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 164:
	  {
	    //Gas a presion constante
	    double Vi, Ti, Vf, Tf ;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		Vi = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		Vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		Ti = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		Ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		Vf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		Vf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		Tf = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		Tf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, Vi/Ti - Vf/Tf) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 165:
	  {
	    //Gas a temperatura constante
	    double Pi, Vi, Pf, Vf ;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		Pi = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		Pi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		Vi = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		Vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		Pf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		Pf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		Vf = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		Vf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, Pi*Vi - Pf*Vf) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 166:
	  {
	    //Gas a volumen constante 
	    double Pi, Ti, Pf, Tf ;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		Pi = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		Pi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		Ti = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		Ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		Pf = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		Pf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		Tf = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		Tf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, Pi/Ti - Pf/Tf) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 167:
	  {
	    //Ley de los gases ideales
	    double Pi, Vi, Ti, Pf, Vf, Tf ; 
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		Pi = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		Pi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		Vi = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		Vi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		Ti = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		Ti = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		Pf = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		Pf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		Vf = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		Vf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		Tf = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		Tf = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, Pi*Vi/Ti - Pf*Vf/Tf) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	case 168:
	  {
	    //Intercambiador de calor
	    double TRi, TRf, dR, cR, TFi, TFf, dF, cF ;
	    
	    if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
	      {
		TRi = [[dat objectAtIndex: 0] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
		TRi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
	      {
		TRf = [[dat objectAtIndex: 1] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
		TRf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
	      {
		dR = [[dat objectAtIndex: 2] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
		dR = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
	      {
		cR = [[dat objectAtIndex: 3] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		cR = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
	      {
		TFi = [[dat objectAtIndex: 4] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		TFi = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
	      {
		TFf = [[dat objectAtIndex: 5] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
		TFf = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
	      {
		dF = [[dat objectAtIndex: 6] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
		dF = gsl_vector_get (vars, k) ;
	      }
	    
	    if(![variables containsObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces] ])
	      {
		cF = [[dat objectAtIndex: 7] doubleValue] ;
	      }
	    else
	      {
		int k = [variables indexOfObject: [[dat objectAtIndex: 7] stringByTrimmingSpaces]] ;
		cF = gsl_vector_get (vars, k) ;
	      }
	    
	    //Se establece la ecuacion
	    gsl_vector_set (func, nEcu, dR*cR*(TRf - TRi) + dF*cF*(TFf - TFi)) ;
	    
	    nEcu = nEcu + 1 ;
	  }
	  break;
	}
    }
  
  return 0 ;
}

@interface FLCalorimetry (Private)
- (void) crearSistema;
@end

@implementation FLCalorimetry (Private)
- (void) crearSistema
{
  int aumento = 1 ;
  BOOL continuar ;
  
  const gsl_multiroot_fsolver_type *T;
  gsl_multiroot_fsolver *s;
  
  int estado = 0, estadoInt, k, longitud ;
  int nvar  = [variables count] ;
  const size_t n = nvar;
  double par;
  NSString *mensaje ;
  size_t iter ;
  
  struct parametros p = {1.0, 1.0};
  
  gsl_vector *x = gsl_vector_alloc (n);
  int Tindice ;
  int countRes = 0 ;
  id unObj ;
  NSMutableArray *resultados = [NSMutableArray array] ;
  NSEnumerator *varCount;
  
  //Generador de numeros aleatorios
  const gsl_rng_type * Y;
  gsl_rng * r;
  gsl_rng_env_setup();
  Y = gsl_rng_default;
  r = gsl_rng_alloc (Y);
  
  do
    {
      gsl_multiroot_function f = {&sis_calor_gas, n, &p};
      iter = 0 ;
      for (k = 0; k < nvar; k++)
	{
	  par = gsl_rng_uniform (r) ;
	  gsl_vector_set (x, k, par) ;
	}
      
      T = gsl_multiroot_fsolver_hybrids;
      s = gsl_multiroot_fsolver_alloc (T, nvar);
      gsl_multiroot_fsolver_set (s, &f, x);
      
      do
	{
	  iter++;
	  estadoInt = gsl_multiroot_fsolver_iterate (s);
	  
	  if(estadoInt)
	    break;
	  
	  estado = gsl_multiroot_test_residual (s->f, 1e-7);
	}
      while (estado == GSL_CONTINUE && iter < 1000);  
      
      //Se verifica el estado
      if( (estadoInt) && (aumento < 90) )
	{
	  aumento = aumento + 1 ;
	  continuar = YES ;
	}
      else
	{
	  if(varT == 1)
            {
	      Tindice = [variables indexOfObject: tiempoVar] ;
	      if( ((gsl_vector_get (s->x, Tindice)) < 0) && (aumento < 90) )
		{
		  aumento = aumento + 1 ;
		  continuar = YES ;
		}
	      else
		{
		  continuar = NO ;
		}
            }
	  else
            {
	      continuar = NO ;
            }
	}
      //Se termina la verificacion
    }
  while(continuar) ;
  //se termino la busqueda de la solucion
  
  //Se pasan los datos al array Resultados
  varCount = [variables objectEnumerator] ;
  
  while((unObj = [varCount nextObject]))
    {
      [resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
      countRes = countRes + 1 ;
    }
  
  //Se imprimen los resultados
  [self printUnknowns: variables withResults: resultados];
  
  //Se imprime el estado del calculo        
  mensaje = [NSString stringWithFormat: [errores objectAtIndex: 8], gsl_strerror (estado)];
  longitud = [ [[self visor] textStorage] length];
  [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
  
  //Advertencia sobre la temperatura
  if ( (mensajeTemp) && (cambOrCal) )
    {
      longitud = [[[self visor] textStorage] length];
      [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 13]] ;
    }
  
  gsl_multiroot_fsolver_free (s);
  gsl_vector_free (x);
  gsl_rng_free (r);
}
@end

@implementation FLCalorimetry

- (id) init
{
  NSBundle *mensajes;
  self = [super init];
  
  variables = [NSMutableArray array] ;
  [variables retain] ;
  codObjetosContenidos = [NSMutableArray array] ;
  [codObjetosContenidos retain] ;
  codOtros = [NSMutableArray array] ;
  [codOtros retain] ;
  depositosApli = [NSMutableArray array] ;
  [depositosApli retain] ;
  depoTipo = [NSMutableArray array] ;
  [depoTipo retain] ;
  
  //Se crea el array de mensajes
  mensajes = [NSBundle mainBundle] ;
  errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"calorGasMensajes" ofType: @"plist"] ] ;
  
  return self;
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  /* insert your code here */
  int width, height, totalCells; //For handle the chalkboard size
  int longitud, numEcuaciones = 0, numDepositos = 0, numFlujos = 0 ;
  BOOL error = NO ;
  BOOL errorNom = NO ;
  BOOL errorFlujos = NO ;
  BOOL errorCalorim = NO ;
  BOOL errorCalFase = NO ;
  BOOL errorApli = NO ;
  BOOL errorApliDos = NO ;
  BOOL errorCambios = NO ;
  BOOL errorCambCont = NO ;
  BOOL errorElemCont = NO ;
  BOOL errorFaseCont = NO ;
  NSNumber *identificador, *codigo ;
  NSMutableArray *nomObjetos = [NSMutableArray array] ;
  NSMutableArray *nomObjetosContenidos = [NSMutableArray array] ;
  NSMutableArray *nomObjetosContenidosCambios = [NSMutableArray array] ;
  NSMutableArray *codDepositos = [NSMutableArray array] ;
  NSMutableArray *codFlujos = [NSMutableArray array] ;
  NSMutableArray *controlCamb = [NSMutableArray array] ;
  NSArray *keys;
  NSEnumerator *cuenta;
  NSTextView *calor_gasInfo = [self visor];
  //Para las verificaciones previas al calculo
  int objContenidos = 0, w = 0;
  NSMutableArray *codFuentesObj;

  mensajeTemp = NO ;
  cambOrCal = NO ;
  varT = 0 ;
  tiempoDat = 0 ;

  //For handle the chalkboard size
  width = [self chalkboardWidth];
  height = [self chalkboardHeight];
  totalCells = width*height - 1;

  diccionario = [[NSMutableDictionary alloc] initWithDictionary: lista] ;
  keys = [[NSArray alloc] initWithArray: [lista allKeys]] ;
  cuenta = [keys objectEnumerator] ;
  
  while((codigo = [cuenta nextObject]) && !error)
    {
      int x ;
      NSString *key ;
      NSArray *terminos ;
      NSNumber *numero ;
      NSArray *titulos = [[diccionario objectForKey: codigo] objectForKey: @"Titulos"] ;
      NSMutableArray *datos = [[diccionario objectForKey: codigo] objectForKey: @"Datos"] ;
      NSMutableArray *valores = [[diccionario objectForKey: codigo] objectForKey: @"Valores"] ;

      //Para determinar el calor o flujo de calor aplicado a los objetos
      int k, pos ;
      NSNumber *ident ;
      NSButton *celda ;
      NSEnumerator *busq;

      identificador = [[diccionario objectForKey: codigo] objectForKey: @"Tipo"] ;
      [valores removeAllObjects] ;
      
      //Cuenta la cantidad de variables en el sistema
      for(x = 0; x < [datos count]; x++)
	{
	  NSString *data = [[datos objectAtIndex: x] stringByTrimmingSpaces];
	  NSString *title = [[titulos objectAtIndex: x] description];
	  
	  if(![self isNumericDataTheString: data] && ![title isEqualToString: _(@"Nombre")] && 
	     ![title isEqualToString: _(@"Objeto 1")] && ![title isEqualToString: _(@"Objeto 2")] && 
	     ![title isEqualToString: _(@"Objeto 3")] && ![title isEqualToString: _(@"Objeto 4")] && 
	     ![title isEqualToString: _(@"Objeto 5")] && ![title isEqualToString: _(@"Sentido")])
	    {
	      if([self hasConversionTheString: data])
		{
		  terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
		  key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
		  
		  if([[[self conversions] allKeys] containsObject: key])
		    {
		      if([self isNumericDataTheString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]])
			{
			  if(![key isEqualToString: @"C"] && ![key isEqualToString: @"R"] && ![key isEqualToString: @"F"])
			    {
			      numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[self conversions] objectForKey: key] doubleValue] ] ;
			    }
			  else
			    {
			      if([key isEqualToString: @"C"])
				{
				  numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue] + 273.15] ;
				}
			      else
				{
				  if([key isEqualToString: @"R"])
				    {
				      numero = [NSNumber numberWithDouble: 0.55555555*([[terminos objectAtIndex: 0] doubleValue] - 491.67) + 273.15] ;
				    }
				  else
				    {
				      numero = [NSNumber numberWithDouble: 0.55555555*([[terminos objectAtIndex: 0] doubleValue] - 32) + 273.15] ;
				    }
				}
			    }
			  
			  [valores addObject: [numero stringValue]] ;
			}
		      else
			{
			  NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
			  var = [var stringByAppendingString: @"@"] ;
			  var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			  
			  [valores addObject: var] ;
			  if(![variables containsObject: var])
			    {
			      [variables addObject: var] ;
			    }
			  
			}
		    }
		  else
		    {
		      NSString *anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
		      longitud = [[[self visor] textStorage] length];
		      [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
		      error = YES ;
		    }
		}
	      else
		{
		  //Se agrega una variable simple
		  NSString *varTit, *varFactor ;
		  NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  //Se determina el tipo de variable
		  varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  if ([varTit hasPrefix: @"m"])
		    {
		      varFactor = @"kg";
		    }
		  else if ([varTit hasPrefix: @"T"])
		    {
		      varFactor = @"K";
		    }
		  else if ([varTit hasPrefix: @"L"])
		    {
		      varFactor = @"m";
		    }
		  else if ([varTit hasPrefix: @"t"])
		    {
		      varFactor = @"s";
		    }
		  else if ([varTit hasPrefix: @"S"])
		    {
		      varFactor = @"m2";
		    }
		  else if ([varTit hasPrefix: @"V"])
		    {
		      varFactor = @"m3";
		    }
		  else if ([varTit hasPrefix: @"P"])
		    {
		      varFactor = @"Pa";
		    }
		  else if ([varTit hasPrefix: @"c"] || [varTit hasPrefix: @"cR"] || 
			   [varTit hasPrefix: @"cF"])
		    {
		      varFactor = @"J/kg*K";
		    }
		  else if ([varTit hasPrefix: @"cf"] || [varTit hasPrefix: @"cv"])
		    {
		      varFactor = @"J/kg";
		    }
		  else if ([varTit hasPrefix: @"k"])
		    {
		      varFactor = @"1/K";
		    }
		  else if ([varTit hasPrefix: @"Q"])
		    {
		      varFactor = @"J";
		    }
		  else if ([varTit hasPrefix: @"dQ"])
		    {
		      varFactor = @"W";
		    }
		  else
		    {
		      varFactor = @"m3/s";
		    }
		  //Termina la busqueda del tipo de variable
		  
		  var = [var stringByAppendingString: @"@"] ;
		  var = [var stringByAppendingString: varFactor] ;
		  
		  [valores addObject: var] ;
		  if(![variables containsObject: var])
		    {
		      [variables addObject: var] ;
		    }
		  
		  //Se ha agregado la variable simple
		}
	    }
	  else
	    {
	      [valores addObject: [datos objectAtIndex: x]] ;
	    }
	}
      //Fin del conteo de variables
      
      //Determina la variable de tiempo y el numero de ecuaciones
      if(error)
	break;
      
      switch([identificador intValue])
	{
	case 150:
	  {
	    if(![self isNumericDataTheString: [[valores objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		tiempoVar = [[valores objectAtIndex: 0] stringByTrimmingSpaces];
		varT = 1 ;
	      }
	    else
	      {
		tiempoDat = [[valores objectAtIndex: 0] doubleValue];
		varT = 2 ;
	      }
	  }
	  break;
	case 151:
	case 153:
	  {
	    numDepositos = numDepositos + 1 ;
	    [codDepositos addObject: codigo] ;
	  }
	  break;
	case 152:
	case 154:
	  {
	    numFlujos = numFlujos + 1 ;
	    [codFlujos addObject: codigo] ;
	  }
	  break;
	case 155:
	case 156:
	case 169:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    [codObjetosContenidos addObject: codigo] ;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	    else
	      {
		[nomObjetos addObject: [NSNull null]] ;
	      }
	  }
	  break;
	case 157 ... 159:
	  {
	    numEcuaciones = numEcuaciones + 1 ;
	    [codOtros addObject: codigo] ;
	  }
	  break;
	case 160:
	case 161:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    [codObjetosContenidos addObject: codigo] ;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	    else
	      {
		[nomObjetos addObject: [NSNull null]] ;
	      }
	  }
	  break;
	case 162:
	  {
	    int c = 0 ;
	    numEcuaciones = numEcuaciones + 1;
	    [codObjetosContenidos addObject: codigo] ;
	    
	    if ( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      {
		if (![nomObjetos containsObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces]])
		  {
		    [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
		  }
		else
		  {
		    errorNom = YES;
		  }
	      }
	    else
	      {
		[nomObjetos addObject: [NSNull null]] ;
	      }
	    
	    
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidosCambios addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
		c = c + 1 ; }
	    if( ([[[datos objectAtIndex: 2] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 2] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidosCambios addObject: [[datos objectAtIndex: 2] stringByTrimmingSpaces] ] ; 
		c = c + 1 ; }
	    if( ([[[datos objectAtIndex: 3] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 3] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidosCambios addObject: [[datos objectAtIndex: 3] stringByTrimmingSpaces] ] ; 
		c = c + 1 ; }
	    if( ([[[datos objectAtIndex: 4] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 4] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidosCambios addObject: [[datos objectAtIndex: 4] stringByTrimmingSpaces] ] ; 
		c = c + 1 ; }
	    if( ([[[datos objectAtIndex: 5] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 5] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidosCambios addObject: [[datos objectAtIndex: 5] stringByTrimmingSpaces] ] ;
		c = c + 1 ; }
	    [controlCamb addObject: [NSNumber numberWithInt: c]] ;
	  }
	  break;
	case 163:
	  {
	    numEcuaciones = numEcuaciones + 1;
	    [codOtros addObject: codigo] ;
	    if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
	    if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
	    if( ([[[datos objectAtIndex: 2] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 2] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidos addObject: [[datos objectAtIndex: 2] stringByTrimmingSpaces] ] ; }
	    if( ([[[datos objectAtIndex: 3] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 3] stringByTrimmingSpaces] isEqualToString: @"0"]) )
	      { [nomObjetosContenidos addObject: [[datos objectAtIndex: 3] stringByTrimmingSpaces] ] ; }
	  }
	  break;
	case 164 ... 167:
	  {
	    numEcuaciones = numEcuaciones + 1 ;
	    [codOtros addObject: codigo] ;
	  }
	  break;
	case 168:
	  {
	    numEcuaciones = numEcuaciones + 1 ;
	    [codOtros addObject: codigo] ;
	  }
	  break;
	}
      //Fin del conteo de ecuaciones
      
      if(errorNom)
	{
	  longitud = [[[self visor] textStorage] length];
	  [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 14]] ;
	  break;
	}
      
      //Se determina el calor o flujo de calor aplicado a los objetos
      busq = [[self cells] objectEnumerator] ;
      
      if(([identificador intValue] == 155) || ([identificador intValue] == 156) || ([identificador intValue] == 169) || (([identificador intValue] >= 160) && ([identificador intValue] <= 162)))
	{
	  NSMutableArray *fuentes = [NSMutableArray array] ;
	  NSArray *ordenObjetos = [self cells];
	  k = 0 ;
	  pos = 0 ;
	  
	  while((celda = [busq nextObject]))
	    {
	      if([celda tag] == [codigo intValue])
		{
		  pos = k ;
		  break ;
		}
	      k = k + 1 ;   
	    }
	  
	  
	  if( (pos%width != 0) && (pos%width != (width - 1)) )
	    {
	      if(pos - 1 >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos - (width - 1) >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width - 1)] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos - width >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos - (width + 1) >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width + 1)] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos + 1 <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos + (width - 1) <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width - 1)] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos + width <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	      
	      if(pos + (width + 1) <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width + 1)] tag]] ;
		  if([ident intValue] != 0)
		    { [fuentes addObject: ident] ; }
		}
	    }
	  else
	    {
	      if(pos%width == 0)
		{
		  if(pos - (width - 1) >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width - 1)] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos - width >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos + 1 <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos + width <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos + (width + 1) <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width + 1)] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		}
	      else
		{
		  if(pos - 1 >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos - width >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos - (width + 1) >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width + 1)] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos + (width - 1) <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width - 1)] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		  
		  if(pos + width <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		      if([ident intValue] != 0)
			{ [fuentes addObject: ident] ; }
		    }
		}
	    }
	  //Agregando los depositos al array
	  if([fuentes count] == 0)
	    {
	      numEcuaciones = numEcuaciones - 1 ;
	    }
	  
	  [depositosApli addObject: fuentes] ;
	}
    }
  
  
  //Verificaciones previas al calculo
  codFuentesObj = [NSMutableArray array] ;
  if (!error && !errorNom)
    {
      int c, v;
      int indiceNom = 0;
      id nomConObj;
      NSEnumerator *compAplis;
      NSEnumerator *compro;
      NSNumber *fuen;
      //Para verificr que no hayan fuentes y flujos aplicados simultaneamente a un objeto
      int fuenApli, controlFuente, controlFlujo ;
      id controlObj, subControlObj ;
      NSEnumerator *subControl ;
      NSEnumerator *control;

      //Verificando que exista un dato temporal al utilizar flujos
      if ( (numFlujos > 0) && (varT == 0) )
	{
	  errorFlujos = YES ;
	}
      
      //Se verifica que existan los objetos a los cuales se hace referencia
      for (c = 0; c < [nomObjetosContenidos count]; c++)
	{
	  if ([nomObjetos containsObject: [nomObjetosContenidos objectAtIndex: c]])
	    {  
	      objContenidos = objContenidos + 1;
	    }
	}
      
      for (c = 0; c < [nomObjetosContenidosCambios count]; c++)
	{
	  if ([nomObjetos containsObject: [nomObjetosContenidosCambios objectAtIndex: c]])
	    {  
	      objContenidos = objContenidos + 1;
	    }
	}
      
      //Se realiza el conteo de las fuentes aplicadas 
      for (v = 0; v < [depositosApli count]; v++)
	{
	  [codFuentesObj addObjectsFromArray: [depositosApli objectAtIndex: v]] ;  
	}
      
      //Se verifica cuantas de las fuentes existentes estan aplicadas a objetos
      compro = [codDepositos objectEnumerator] ;
      while ((fuen = [compro nextObject]))
	{
	  if ([codFuentesObj containsObject: fuen])
	    {
	      w = w + 1 ;
	    }
	}
      
      compro = [codFlujos objectEnumerator] ;
      while ((fuen = [compro nextObject]))
	{
	  if ([codFuentesObj containsObject: fuen])
	    {
	      w = w + 1 ;
	    }
	}
      
      //Se verifica que los objetos tengan fuentes o flujos aplicados cuando corresponda
      compAplis = [nomObjetos objectEnumerator];
      while ((nomConObj = [compAplis nextObject]))
	{
	  if (nomConObj != [NSNull null])
	    {
	      if (![nomObjetosContenidos containsObject: [nomConObj stringByTrimmingSpaces]] && ![nomObjetosContenidosCambios containsObject: [nomConObj stringByTrimmingSpaces]] && ([[depositosApli objectAtIndex: indiceNom] count] == 0) )
		{
		  errorApliDos = YES;
		}
	    }
	  else
	    {
	      if ([[depositosApli objectAtIndex: indiceNom] count] == 0)
		{
		  errorApliDos = YES;
		}
	    }
	  
	  indiceNom++;
	}
      
      //Si los nombres a los que se hace referencia existen...
      if (objContenidos == ([nomObjetosContenidos count] + [nomObjetosContenidosCambios count]))
	{
	  //Se verifica que los objetos en calorimetros no tengan fuentes aplicadas
	  //o que no sean objetos cambio de fase
	  int indiceConObj, depApli, tipoObjCal ;
	  int cc = 0, elemCont = 0, faseCont = 0 ;
	  NSNumber *contCamb ;
	  NSEnumerator *conObjCam;
	  NSEnumerator *conObj = [nomObjetosContenidos objectEnumerator] ;
	  
	  while ((nomConObj = [conObj nextObject]))
	    {
	      indiceConObj = [nomObjetos indexOfObject: [nomConObj stringByTrimmingSpaces] ] ;
	      depApli = [[depositosApli objectAtIndex: indiceConObj] count] ;
	      tipoObjCal = [[[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceConObj]] 
			      objectForKey: @"Tipo"] intValue];
	      
	      if (depApli > 0)
		{
		  errorCalorim = YES ;
		}
	      
	      if ((tipoObjCal == 160) || (tipoObjCal == 161))
		{
		  errorCalFase = YES ;
		}
	    }
	  
	  //Se verifica que los objetos en cambios no tengan fuentes aplicadas y que no sean objetos cambio
	  conObjCam = [nomObjetosContenidosCambios objectEnumerator] ;
	  
	  while ((nomConObj = [conObjCam nextObject]))
	    {
	      indiceConObj = [nomObjetos indexOfObject: [nomConObj stringByTrimmingSpaces] ] ;
	      depApli = [[depositosApli objectAtIndex: indiceConObj] count] ;
	      contCamb = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceConObj]]
			   objectForKey: @"Tipo"] ;    
	      
	      if (depApli > 0)
		{
		  errorCambios = YES ;
		}
	      
	      if ([contCamb intValue] == 162)
		{
		  errorCambCont = YES ;
		}
	    }
	  
	  //Se verifican los otros tipos de objetos en cambios
	  conObjCam = [nomObjetosContenidosCambios objectEnumerator] ;
	  while ((nomConObj = [conObjCam nextObject]))
	    {
	      indiceConObj = [nomObjetos indexOfObject: [nomConObj stringByTrimmingSpaces] ] ;
	      contCamb = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceConObj]]
			   objectForKey: @"Tipo"];
	      
	      if ( ([contCamb intValue] == 155) || ([contCamb intValue] == 156) || ([contCamb intValue] == 169) )
		{
		  elemCont = elemCont + 1 ;
		}
	      
	      if ( ([contCamb intValue] == 160) || ([contCamb intValue] == 161) )
		{
		  faseCont = faseCont + 1 ;
		}
	      
	      if (elemCont > 3)
		{
		  errorElemCont = YES ;
		}
	      
	      if (faseCont > 2)
		{
		  errorFaseCont = YES ;
		}
	      
	      if ((elemCont + faseCont) == [[controlCamb objectAtIndex: cc] intValue])
		{
		  elemCont = 0 ;
		  faseCont = 0 ;
		  cc = cc + 1 ;
		}
	    }
	}
      
      //Se verifica que no hayan fuentes y flujos aplicados simultaneamente a un objeto
      control = [depositosApli objectEnumerator] ;
      
      while ((controlObj = [control nextObject]))
	{
	  controlFuente = 0;
	  controlFlujo = 0;
	  subControl = [controlObj objectEnumerator] ;
	  
	  while ((subControlObj = [subControl nextObject]))
	    {
	      
	      fuenApli = [[[diccionario objectForKey: subControlObj] objectForKey: @"Tipo"] intValue] ; 
	      if ((fuenApli == 151) || (fuenApli == 153))
		{
		  controlFuente = controlFuente + 1 ;
		}
	      else
		{
		  controlFlujo = controlFlujo + 1 ;
		}
	    }
	  
	  if ((controlFuente == [controlObj count]) || (controlFlujo == [controlObj count]))
	    {
	      if (controlFuente == [controlObj count])
		{
		  [depoTipo addObject: [NSNumber numberWithInt: 1]] ;
		}
	      else
		{
		  [depoTipo addObject: [NSNumber numberWithInt: 2]] ;
		}
	    }
	  else
	    {
	      errorApli = YES ;
	      break ;
	    }
	}
    }
  
  
  //Ultimas verificaciones 
  if (!error && !errorNom && !errorFlujos && !errorCalorim && !errorCalFase && !errorApli && !errorApliDos && !errorCambios && !errorCambCont && !errorElemCont && !errorFaseCont)
    {
      if([variables count] == numEcuaciones)
	{
	  if(objContenidos == ([nomObjetosContenidos count] + [nomObjetosContenidosCambios count]))
	    {
	      if( (w == (numDepositos + numFlujos)) && (w == [codFuentesObj count]) )
		{
		  [self crearSistema] ;
		}
	      else
		{
		  NSString *advertencia = nil;
		  
		  if(w < (numDepositos + numFlujos) )
		    {
		      advertencia = [NSString stringWithString: [errores objectAtIndex: 3]] ;
		    }
		  
		  if(w < [codFuentesObj count])
		    {
		      advertencia = [NSString stringWithString: [errores objectAtIndex: 4]] ;
		    }
		  
		  longitud = [[calor_gasInfo textStorage] length];
		  [calor_gasInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: advertencia] ;
		}
	    }
	  else
	    {
	      longitud = [[calor_gasInfo textStorage] length];
	      [calor_gasInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 2]] ;
	    }
	}
      else
	{
	  longitud = [[calor_gasInfo textStorage] length];
	  [calor_gasInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 1]] ;
	}
    }
  else
    {
      int numError = 0 ;
      
      if(errorFlujos)
	{
	  numError = 5 ;
	}
      else
	{
	  if(errorCalorim)
	    {
	      numError = 6 ;
	    }
	  else
	    {
	      if (errorCalFase)
		{
		  numError = 16 ;
		}
	      else
		{
		  if(errorApli)
		    {
		      numError = 7 ;
		    }
		  else
		    {
		      if(errorApliDos)
			{
			  numError = 15 ;
			}
		      else
			{
			  if(errorCambios)
			    {
			      numError = 9 ;
			    }
			  else
			    {
			      if(errorCambCont)
				{
				  numError = 10 ;
				}
			      else
				{
				  if(errorElemCont)
				    {
				      numError = 11 ;
				    }
				  else
				    {
				      if (errorFaseCont)
					{
					  numError = 12 ;
					}
				    }
				}
			    }
			}
		    }
		}
	    }	
	}
      
      if (numError != 0)
	{
	  longitud = [[calor_gasInfo textStorage] length];
	  [calor_gasInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: numError]] ;
	}
    }
  
  RELEASE(keys) ;
}

- (void) dealloc
{
  RELEASE(diccionario) ;
  RELEASE(variables) ;
  RELEASE(codObjetosContenidos) ;
  RELEASE(errores) ;
  RELEASE(codOtros) ;
  RELEASE(depositosApli) ;
  RELEASE(depoTipo) ;
  [super dealloc] ;
}

@end
