/* 
   Copyright (C) 2009, 2010, 2011, 2012, 2013 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <math.h>
#import "ObjectData.h"
#import "ChalkboardView.h"

@interface NSObject ( NSToolTipOwner )
- (NSString *)view:(NSView *)view stringForToolTip:(NSToolTipTag)tag point:(NSPoint)point userData:(void *)userData;
@end

@interface ChalkboardView (Private)
- (BOOL) validacion: (int) codigo;
- (void) postModuleNotification;
@end

@implementation ChalkboardView (Private)
- (BOOL) validacion: (int) codigo
{
  BOOL desicion ;
  
  if (objetos == -1)
    {
      objetos = floor(codigo/50) ;
      desicion = YES ;
      [self postModuleNotification];
    }
  else
    {
      if(objetos == floor(codigo/50))
	{
          desicion = YES ;
	} 
      else
	{
          desicion = NO ;
	}
    }
  return desicion ;     
}

- (void) postModuleNotification
{

  [[NSNotificationCenter defaultCenter]
    postNotificationName: @"moduleDidChangeNotification"
    object: self
    userInfo: nil];
}
@end

@implementation ChalkboardView

- (id)init
{
  self = [super init];

  if (self)
    {
      selectedCell = nil;
    }

  return self;
}

- (void) dealloc
{
  TEST_RELEASE(selectedCell);
  [super dealloc];
}

-(void) drawRect: (NSRect) frame
{
  NSBezierPath *marco = [NSBezierPath bezierPathWithRect: [self bounds]];
  [[NSColor blackColor] set];
  [marco fill];

  if (selectedCell != nil)
    {
      [[NSColor yellowColor] set];
      [selectedCell setLineWidth: 2];
      [selectedCell stroke];
    }
}   

- (void) addObject: (id)sender
{
  /* insert your code here */
  BOOL permiso ;
  moveObjeto = NO ;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  
  permiso = [self validacion: [sender tag]] ;
  
  if (permiso)
    {  
      [[NSCursor openHandCursor] set] ; 
      imagenIcono = [sender image] ;
      codigoObjeto = [sender tag] ;
      newObjeto = YES ;
    }
}

- (void) calcular: (id) sender
{
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  [information calcular: self] ;
}

- (int) codigo: (id)sender
{
  return objetos ;
}

- (void) limpiar: (id)sender
{
  /* insert your code here */
  int x, cantidad ;
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  cantidad = [[self subviews] count] ;
  
  for (x = 0; x <= cantidad - 1; x = x + 1)
    {
      [[[self subviews] objectAtIndex: x ] setImage: nil] ;
      [[[self subviews] objectAtIndex: x ] setTag: 0] ;
      [[[self subviews] objectAtIndex: x ] setToolTip: @""] ;
    } 
  
  DESTROY(selectedCell);
  [self setNeedsDisplay: YES] ;
  [information borrarObjetos: YES] ;
  objetos = -1 ;
  conteo = 0 ;
  [self postModuleNotification];
}


- (void)clicCell: (id) sender
{
  int key = [[[self window] currentEvent ] modifierFlags] ;
  
  if ((newObjeto) && ([sender image] == nil))
    {
      [sender setImage: imagenIcono] ;
      [[NSCursor arrowCursor] set] ;
      [sender setTag: codigoObjeto] ;
      [information agregarObjeto: sender] ;
      conteo = conteo + 1 ;
      newObjeto = NO ; 
      imagenIcono = nil;
    }
  else if ((moveObjeto) && ([sender image] == nil))
    {
      [sender setImage: imagenIcono] ;
      [[NSCursor arrowCursor] set] ;
      [sender setTag: codigoObjeto] ;
      moveObjeto = NO ; 
      imagenIcono = nil;
    }
  else if ((key == NSControlKeyMask) && ([sender image] != nil) && (imagenIcono == nil))
    {
      imagenIcono = [sender image] ;
      codigoObjeto = [sender tag] ;
      [sender setImage: nil] ;
      [sender setTag: 0] ;
      [sender setToolTip: @""];
      //  [[NSCursor pointingHandCursor] set] ;
      [[NSCursor closedHandCursor] set] ;
      moveObjeto = YES ;
    }
  else if ((key == NSShiftKeyMask) && ([sender image] != nil) && (imagenIcono == nil))
    {
      [sender setImage: nil] ;
      [information borrarObjeto: [sender tag]] ;
      [sender setTag: 0] ;
      [sender setToolTip: @""];
      conteo = conteo - 1 ;
      if (conteo == 0)
	{
	  objetos = -1 ;
	  [self postModuleNotification];
	}
      
      DESTROY(selectedCell);
      [self setNeedsDisplay: YES];
    }
  
  if (!newObjeto && !moveObjeto && ([sender image] != nil))
    {
      [information selecObjeto: [sender tag]];
      ASSIGN(selectedCell, [NSBezierPath bezierPathWithRect: [sender frame]]);
      [self setNeedsDisplay: YES];
    }
}

- (void) controlCursor: (id) sender
{
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  
  if (conteo == 0)
    {
      objetos = -1 ;
    }
}

- (NSUInteger) chalkboardWidth
{
  return width;
}

- (NSUInteger) chalkboardHeight
{
  return height;
}

- (NSString *)view:(NSView *)view stringForToolTip:(NSToolTipTag)tag point:(NSPoint)point userData:(void *)userData
{
  if ([view tag] > 0)
    {
      NSNumber *num = [NSNumber numberWithInt: [view tag]];
      return [information dataOfObject: num];
    }
  else
    {
      return @"";
    }
}

- (void) awakeFromNib
{
  int x, y;
  NSButton *botonCell ;
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

  width = [defaults integerForKey: @"ChalkboardWidth"];
  height = [defaults integerForKey: @"ChalkboardHeight"];

  if ((width < 26) || (width > 100))
    {
      width = 26;
    }

  if ( (height < 18) || (height > 100))
    {
      height = 18;
    }
  
  for(y = 1; y <= height; y = y + 1)
    {
      for(x = 0; x < width; x = x + 1)
        {
	  botonCell = [[NSButton alloc] initWithFrame: NSMakeRect(x*50, height*50 - y*50, 50, 50)] ;  
	  [botonCell setTarget: self] ;
	  [botonCell setAction: @selector(clicCell:)] ;
	  [botonCell setTitle: @""] ;
	  [botonCell setImagePosition: NSImageOnly] ;
	  [botonCell setBordered: NO] ;
	  [botonCell addToolTipRect: NSMakeRect(0, 0, width*50, height*50) owner: self userData: nil];
	  [self addSubview: botonCell] ; 
	  RELEASE(botonCell) ; 
        }
    } 
  [self setFrameSize: NSMakeSize(50*width, 50*height)];
  moveObjeto = NO ;
  
  objetos = -1 ;
  conteo = 0 ;
}

@end
