/* 
   Project: FísicaLab

   Copyright (C) 2009, 2010, 2011, 2012, 2013 Free Software Foundation

   Author: German A. Arias <german@xelalug.org>

   Created: 2008-09-10 18:56:00 -0600 by german
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import "ChalkboardView.h"
#import "AppController.h"

@implementation AppController

+ (void)initialize
{
  //NSMutableDictionary *defaults = [NSMutableDictionary dictionary];
  
  /*
   * Register your app's defaults here by adding objects to the
   * dictionary, eg
   *
   * [defaults setObject:anObject forKey:keyForThatObject];
   *
   */
  
  //[[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
  //[[NSUserDefaults standardUserDefaults] synchronize];
}

- (id)init
{
  if ((self = [super init]))
    {
      preferencesPanel = nil;
    }
  return self;
}

- (void)dealloc
{
  [super dealloc];
}

- (void)awakeFromNib
{
}

- (void)applicationWillFinishLaunching: (NSNotification *)aNotification
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

  NSScrollView *staticView, *dynamicsCircularView;

  [sistema setHidden: YES];
  [[elementos window] setDelegate: self];
  [[elementos window] setFrameUsingName: @"Paleta"];
  [[pizarra window] setDelegate: self];
  [[pizarra window] setFrameUsingName: @"Pizarra"];
  
  //Set up the static of rigid bodies view
  [NSBundle loadNibNamed: @"staticRigidBodies.gorm" owner: self];

  staticView = [[NSScrollView alloc] initWithFrame: NSMakeRect(0,0,270,320)];
  [staticView setHasVerticalScroller: YES];
  [staticView setDocumentView: [staticRigidBodies contentView]]; 
  [staticRigidBodiesView addSubview: staticView];

  //Set up the dynamics circular of particles view
  [NSBundle loadNibNamed: @"dynamicsCircular.gorm" owner: self];

  dynamicsCircularView = [[NSScrollView alloc] initWithFrame: NSMakeRect(0,0,270,320)];
  [dynamicsCircularView setHasVerticalScroller: YES];
  [dynamicsCircularView setDocumentView: [dynamicsCircularParticles contentView]]; 
  [dynamicsCircularParticlesView addSubview: dynamicsCircularView];

  RELEASE(staticView);
  RELEASE(staticRigidBodies);
  RELEASE(dynamicsCircularView);
  RELEASE(dynamicsCircularParticles);

  // Fix menu if the user set FixMenu to YES, this could be necessary
  // in some desktops.
  if ( (NSInterfaceStyleForKey(@"NSMenuInterfaceStyle", nil) ==
	NSWindows95InterfaceStyle) &&
       ([defaults boolForKey: @"FixMenu"]) )
    {
      [[pizarra window] setMenu:
			  [[[NSMenu alloc] initWithTitle: @"None"] autorelease]];
    }
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotif
{
}

- (BOOL)applicationShouldTerminate:(id)sender
{
  return YES;
}

- (void)applicationWillTerminate:(NSNotification *)aNotif
{  
}

- (void)showPrefPanel:(id)sender
{
  if (preferencesPanel == nil)
    {
      int width = 0, height = 0, size = 0;
      NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
      [NSBundle loadNibNamed: @"preferences" owner: self];

      [preferencesPanel center];
      [preferencesPanel makeKeyAndOrderFront: self];
      
      width = [defaults integerForKey: @"ChalkboardWidth"];
      height = [defaults integerForKey: @"ChalkboardHeight"];
      size = [defaults integerForKey: @"NSToolTipsFontSize"];
      
      if ((width < 26) || (width > 100))
	{
	  width = 26;
	}
      
      if ( (height < 18) || (height > 100))
	{
	  height = 18;
	}

      if ( (size < 10) || (size > 20))
	{
	  size = 10;
	}

      [widthLabel setIntValue: width];
      [heightLabel setIntValue: height];
      [fontsizeLabel setIntValue: size];
      [widthStepper setIntValue: width];
      [heightStepper setIntValue: height];
      [fontsizeStepper setIntValue: size];

      [NSApp runModalForWindow: preferencesPanel];
    }
  else
    {
      [preferencesPanel makeKeyAndOrderFront: self];
      [NSApp runModalForWindow: preferencesPanel];
    }
}

- (void)ayuda: (id)sender
{
  if (panelAyuda == nil)
    {
      [NSBundle loadNibNamed: @"ayuda.gorm" owner: self] ;
      [panelAyuda makeKeyAndOrderFront: self] ;
    }
  else
    {
      [panelAyuda makeKeyAndOrderFront: self] ;
    }
}

- (void)moduloSel: (id)sender
{
  [pizarra controlCursor: self] ;
  
  if ([sender tag] == 3)
    {
      if ([sistema isHidden] == YES)
        {
          [sistema setHidden: NO] ;
          [unitsSelector setHidden: YES] ;
        }
    }
  else
    {
      if ([sistema isHidden] ==  NO)
        {
          [sistema setHidden: YES] ;
          [unitsSelector setHidden: NO] ;
        }
    }
  
  [elementos selectTabViewItemAtIndex: [sender tag]] ;
}

- (void)addToChalkboard: (id)sender
{
  [pizarra addObject: sender];
}

- (void)windowWillClose: (NSNotification *)aNotification
{
  id ventana = [aNotification object];
  
  if (ventana == [pizarra window])
    {
      [ventana saveFrameUsingName: @"Pizarra"];
    }
  
  if (ventana == [elementos window])
    {
      [ventana saveFrameUsingName: @"Paleta"];
    }

  if (ventana == preferencesPanel)
    {
      [NSApp stopModal];
    }
}

// Preferences
- (void) changeChalkboardWidth: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"ChalkboardWidth"];
  [widthLabel setIntValue: [sender intValue]];
}

- (void) changeChalkboardHeight: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"ChalkboardHeight"];
  [heightLabel setIntValue: [sender intValue]];
}

- (void) changeFontsizeTooltips: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"NSToolTipsFontSize"];
  [fontsizeLabel setIntValue: [sender intValue]];
}

- (void) restoreDefaults: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults removeObjectForKey: @"ChalkboardWidth"];
  [defaults removeObjectForKey: @"ChalkboardHeight"];
  [defaults removeObjectForKey: @"NSToolTipsFontSize"];

  [widthLabel setIntValue: 26];
  [heightLabel setIntValue: 18];
  [fontsizeLabel setIntValue: 10];
  [widthStepper setIntValue: 26];
  [heightStepper setIntValue: 18];
  [fontsizeStepper setIntValue: 10];
}

@end
