/* 
   Copyright (C) 2009 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <AppKit/AppKit.h>
#include "estaticaPuntual.h"

int valoresEstatPunt (const gsl_vector *, void *, gsl_vector *);

struct parametros
       {
         double a;
         double b;
       };

int sis_estatica (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
valoresEstatPunt (variables, params, funciones);  
return GSL_SUCCESS;
}

int valoresEstatPunt (const gsl_vector *vars, void *p, gsl_vector *func)
{
       int gIndice, codigoFuer = 0 ;
       int nEcu = 0 ;
       double gf ;
       NSNumber *objeto ;
      
       if(varG == 1)
       {
       gIndice = [variables indexOfObject: gravedadVar] ;
       gf = gsl_vector_get (vars, gIndice) ;   
       }
       else
       {
          if(varG == 2)
          {
          gf = gravedadDat ;
          }
          else
          {
          gf = 0 ;
          }
       }
       
       NSEnumerator *enumerador = [codObjetos objectEnumerator] ;
       
       while((objeto = [enumerador nextObject]))
       {
       NSNumber *tipo = [[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
       NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
       
       switch([tipo intValue])
              {
              case 51:
                   {
                   double peso, masa ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 0] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                   
                   peso = masa*gf ;
                   
                        if([[tipoFuer objectAtIndex: codigoFuer] intValue] == 3)
                        {
                        int conteo = 1 ;
                        double signo ; 
                        double fuerza[9] = {0} ;
                        fuerza[0] = -1*peso ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                
                                        if( t == 62 )
                                        { signo = 1; }
                                        else
                                        { signo = - 1; }   
                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[conteo] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[conteo] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                 
                                conteo = conteo + 1 ;
                                }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, fuerza[0] + fuerza[1] + fuerza[2] + fuerza[3] + fuerza[4] + fuerza[5] + fuerza[6] + fuerza[7] + fuerza[8]);

                        nEcu = nEcu + 1 ;
                        }
                        else
                        {
                        int conteox = 0, conteoy = 1 ; 
                        double signox, signoy ; 
                        double nx = 0, ny = 0 ;
                        double fuerzax[9] = {0} ;
                        double fuerzay[10] = {0} ;
                        fuerzay[0] = -1*peso ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                      {
                                        if(t == 60)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 62:
                                  case 63:
                                     {
                                        if(t == 62)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 56 ... 59:
                                     {
                                     double ang ;
                                     
                                        if( (t == 56) || (t == 59) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 56) || (t == 58) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  case 68:
                                  case 69:
                                     {
                                        if(t == 68)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[8] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[8] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     }
                                     break;
                                  case 70:
                                  case 71:
                                     {
                                        if(t == 70)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[9] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[9] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     }
                                     break;
                                  }
                                }
                        
                        nx = (fabs(fuerzax[0]) + fabs(fuerzax[1]) + fabs(fuerzax[2]) + fabs(fuerzax[3]) + fabs(fuerzax[4]) + fabs(fuerzax[5]) + fabs(fuerzax[6]) + fabs(fuerzax[7]))/2 ;
                        ny = (fabs(fuerzay[0]) + fabs(fuerzay[1]) + fabs(fuerzay[2]) + fabs(fuerzay[3]) + fabs(fuerzay[4]) + fabs(fuerzay[5]) + fabs(fuerzay[6]) + fabs(fuerzay[7]) + fabs(fuerzay[8]))/2 ;
                                
                        //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + fuerzax[8]*ny);
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8] + fuerzay[9]*nx);

                        nEcu = nEcu + 2 ;
                        }
                   }
                   break;
              case 52:
                   {
                   int conteox = 1, conteoy = 1 ; 
                   double signox, signoy ; 
                   double ny = 0 ;
                   double fuerzax[10] = {0} ;
                   double fuerzay[9] = {0} ;
                   double masa, ang ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     ang = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     ang = gsl_vector_get (vars, k) ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 0] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                   
                   fuerzax[0] = -1*masa*sin(M_PI*ang/180)*gf ;
                   fuerzay[0] = -1*masa*cos(M_PI*ang/180)*gf ;
                   NSNumber *codFuerObj ;
                   NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                      while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                      {
                                        if(t == 60)
                                        { signox = 1;
                                           signoy = - 1; }
                                        else
                                        { signox = - 1; 
                                           signoy = 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 62:
                                  case 63:
                                     {
                                        if(t == 62)
                                        { signox = 1;
                                           signoy = 1; }
                                        else
                                        { signox = - 1;
                                           signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        }
                                     
                                     conteox = conteox + 1 ;      
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 56 ... 59:
                                     {
                                     double angf, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 56)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 57)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               {  signoy = - 1;
                                                   angr = angf - ang; }
                                               else
                                               {  signoy = 1;
                                                   angr = ang - angf; }
                                        }
                                        
                                        if(t == 58)
                                        {
                                        signoy = 1;
                                               if(angf + ang > 90)
                                               { signox = 1;
                                                  angr = angf + ang - 90; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang; }
                                        }
                                        
                                        if(t == 59)
                                        {
                                        signoy = - 1;
                                               if(angf + ang <= 90)
                                               { signox = 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang - 90; }
                                        }
                                       
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;
                                  case 64:
                                  case 65:
                                     {
                                        if(t == 64)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[9] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[9] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     }
                                     break;
                                  }
                                }
                        
                    ny = (fabs(fuerzay[0]) + fabs(fuerzay[1]) + fabs(fuerzay[2]) + fabs(fuerzay[3]) + fabs(fuerzay[4]) + fabs(fuerzay[5]) + fabs(fuerzay[6]) + fabs(fuerzay[7]) + fabs(fuerzay[8]))/2 ;
                                
                    //Se establecen las ecuaciones
                    gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + fuerzax[8] + fuerzax[9]*ny);
                    gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8]);

                   nEcu = nEcu + 2 ;
                   }
                   break;
              case 53:
                   {
                   int conteox = 1, conteoy = 1 ; 
                   double signox, signoy ; 
                   double ny = 0 ;
                   double fuerzax[10] = {0} ;
                   double fuerzay[9] = {0} ;
                   double masa, ang ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     ang = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     ang = gsl_vector_get (vars, k) ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 0] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                   
                   fuerzax[0] = -1*masa*sin(M_PI*ang/180)*gf ;
                   fuerzay[0] = -1*masa*cos(M_PI*ang/180)*gf ;
                   NSNumber *codFuerObj ;
                   NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                      while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                      {
                                        if(t == 61)
                                        { signox = 1;
                                           signoy = - 1; }
                                        else
                                        { signox = - 1; 
                                           signoy = 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 62:
                                  case 63:
                                     {
                                        if(t == 62)
                                        { signox = 1;
                                           signoy = 1; }
                                        else
                                        { signox = - 1;
                                           signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        }
                                     
                                     conteox = conteox + 1 ;      
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 56 ... 59:
                                     {
                                     double angf, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 56)
                                        {
                                        signoy = 1;
                                               if(angf + ang <= 90)
                                               { signox = - 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = 1;
                                                  angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 57)
                                        {
                                        signoy = - 1;
                                               if(angf + ang <= 90)
                                               {  signox = 1;
                                                   angr = angf + ang; }
                                               else
                                               {  signox = - 1;
                                                   angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 58)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1;
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 59)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               { signoy = - 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = 1;
                                                  angr = ang - angf; }
                                        }
                                       
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;
                                  case 66:
                                  case 67:
                                     {
                                        if(t == 66)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[9] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[9] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     }
                                     break;
                                  }
                                }
                        
                    ny = (fabs(fuerzay[0]) + fabs(fuerzay[1]) + fabs(fuerzay[2]) + fabs(fuerzay[3]) + fabs(fuerzay[4]) + fabs(fuerzay[5]) + fabs(fuerzay[6]) + fabs(fuerzay[7]) + fabs(fuerzay[8]))/2 ;
                                
                    //Se establecen las ecuaciones
                    gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + fuerzax[8] + fuerzax[9]*ny);
                    gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8]);

                   nEcu = nEcu + 2 ;
                   }
                   break;
              case 54:
                   {
                    
                        if( ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 2) || ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 3) )
                        {
                        int conteo = 0 ; 
                        double signo ;
                        double fuerza[8] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                
                                        if( (t == 60) || (t == 62) )
                                        { signo = 1; }
                                        else
                                        { signo = - 1; }   
                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[conteo] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[conteo] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                 
                                conteo = conteo + 1 ;
                                }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, fuerza[0] + fuerza[1] + fuerza[2] + fuerza[3] + fuerza[4] + fuerza[5] + fuerza[6] + fuerza[7]);

                        nEcu = nEcu + 1 ;
                        }
                        else
                        {
                        int conteox = 0, conteoy = 0 ;
                        double signox, signoy ;  
                        double fuerzax[8] = {0} ;
                        double fuerzay[8] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                      {
                                        if(t == 60)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 62:
                                  case 63:
                                     {
                                        if(t == 62)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 56 ... 59:
                                     {
                                     double ang ;
                                     
                                        if( (t == 56) || (t == 59) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 56) || (t == 58) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  }
                                }
                        
                         //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7]);
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7]);

                        nEcu = nEcu + 2 ;
                        }
                   }
                   break;
              case 55:
                   {
                        if( ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 2) || ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 3) )
                        {
                        int conteo = 0 ; 
                        double signo ;
                        double fuerza[9] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                    case 62:
                                    case 63:
                                       {   
                                        if( (t == 60) || (t == 62) )
                                        { signo = 1; }
                                        else
                                        { signo = - 1; }   
                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[conteo] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[conteo] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                       conteo = conteo + 1 ; 
                                       }
                                       break;
                                    case 73:
                                    case 74:
                                       {
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[8] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[8] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                       }
                                       break;
                                    }
                                }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, fuerza[0] + fuerza[1] + fuerza[2] + fuerza[3] + fuerza[4] + fuerza[5] + fuerza[6] + fuerza[7] - fuerza[8]);

                        nEcu = nEcu + 1 ;
                        }
                        else
                        {
                        int conteox = 0, conteoy = 0 ; 
                        double signox, signoy ; 
                        double fuerzax[9] = {0} ;
                        double fuerzay[9] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 60:
                                    case 61:
                                      {
                                        if(t == 60)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 62:
                                  case 63:
                                     {
                                        if(t == 62)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 56 ... 59:
                                     {
                                     double ang ;
                                     
                                        if( (t == 56) || (t == 59) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 56) || (t == 58) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  case 72:
                                     {
                                      double ang ;
                                         
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[8] = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[8] = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[8] = (gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[8] = (gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                      }
                                     break;
                                  }
                                }
                        
                         //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] - fuerzax[8]);
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] - fuerzay[8]);

                        nEcu = nEcu + 2 ;
                        }
                   }
                   break;
            case 75 ... 78:
                   {
                   int posFuer ;
                   double signo ; 
                   double kr, d, fuerza = 0 ;
                   NSNumber *codFuerObj = [[fuerObj objectAtIndex: codigoFuer] objectAtIndex: 0] ;

                   if([[tipoFuer objectAtIndex: codigoFuer] intValue] == 4)
                     {
                   posFuer = 1 ;
                     }
                   else
                     {
                   posFuer = -1 ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     kr = [[dat objectAtIndex: 0] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     kr = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     d = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     d = gsl_vector_get (vars, k) ;
                     }
                  
                   int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                               
                        switch(t)
                        {
                        case 56:
                        case 58:
                        case 61:
                        case 62:
                             {
                             signo = 1 ;
                             }
                             break;
                        case 57:
                        case 59:
                        case 60:
                        case 63:
                             {
                             signo = -1 ;
                             }
                             break;
                        }
                     
                   if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     fuerza = signo*posFuer*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                     }
                  else
                     {
                     int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     fuerza = signo*posFuer*(gsl_vector_get (vars, k)) ;
                     }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, kr*d - fuerza);

                        nEcu = nEcu + 1 ;
                    }
                   break;                   
              }
       codigoFuer = codigoFuer + 1 ;
       }
return 0 ;       
}

@implementation estaticaPuntual

- (void) awakeFromNib
{
variables = [NSMutableArray array] ;
[variables retain] ;
codObjetos = [NSMutableArray array] ;
[codObjetos retain] ;
fuerObj = [NSMutableArray array] ;
[fuerObj retain] ;
tipoFuer = [NSMutableArray array] ;
[tipoFuer retain] ;

//Se crea el array de mensajes
NSBundle *mensajes = [NSBundle mainBundle] ;
errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"estaticaMensajes" ofType: @"plist"] ] ;

NSString *siFactores = [NSString stringWithString: @"1/1/1/1/1/1/1/0.01/0.001/14.59/1000"] ;
NSString *siKeys = [NSString stringWithString: @"N-kg-grados-ad-m/s2-N/m-m-cm-g-slug-T"] ;
NSDictionary *si = [NSDictionary dictionaryWithObjects: [siFactores componentsSeparatedByString: @"/"] forKeys: [siKeys componentsSeparatedByString: @"-"]] ;

NSString *inglesFactores = [NSString stringWithString: @"1/1/1/1/1/1/1/0.06854/0.00006854/12E-1/12"] ;
NSString *inglesKeys = [NSString stringWithString: @"lb-slug-grados-ad-ft/s2-lb/ft-ft-kg-g-in-lb/in"] ;

NSDictionary *ingles = [NSDictionary dictionaryWithObjects: [inglesFactores componentsSeparatedByString: @"/"] forKeys: [inglesKeys componentsSeparatedByString: @"-"]] ;

conversiones = [NSArray arrayWithObjects: si, ingles, nil ] ;
[conversiones retain] ;
}

- (void) setSistema: (int)eleccion
{
  /* insert your code here */
  sistema = eleccion ;
}

- (void) celdas: (NSArray *)pizarra
{
/*
int x, y, longitud ;
NSString *mensaje ;

     for(y = 0; y < 13; y = y + 1)
     {
     mensaje = [NSString stringWithString: @""] ;
     
          for(x = 0; x < 16; x++)
          {
               if([[pizarra objectAtIndex: 16*y + x] tag] > 0)
               {
               mensaje = [mensaje stringByAppendingString: @"  1"] ;
               }
               else
               {
               mensaje = [mensaje stringByAppendingString: @"  0"] ;
               }
          }
     mensaje = [mensaje stringByAppendingString: @"  \n"] ;     
     longitud = [ [estaticaPuntInfo textStorage] length];
     [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;    
     }
*/
ordenObjetos = [[NSArray alloc] initWithArray: pizarra] ;     
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  /* insert your code here */
int longitud, numEcuaciones = 0, numFuerzas = 0, numFuerObj = 0 ;
BOOL error = NO;
BOOL errorFuer = NO;
varG = 0 ;
gravedadDat = 0 ;
NSNumber *identificador, *codigo ;
[variables removeAllObjects] ;
[codObjetos removeAllObjects] ;
[fuerObj removeAllObjects] ;
[tipoFuer removeAllObjects] ;
NSString *mensaje ;
NSMutableArray *codFuerzas = [NSMutableArray array] ;
NSMutableArray *codFuerzasObj = [NSMutableArray array] ;
  
diccionario = [[NSMutableDictionary alloc] initWithDictionary: lista] ;
NSArray *keys = [[NSArray alloc] initWithArray: [lista allKeys]] ;
NSEnumerator *cuenta = [keys objectEnumerator] ;

//Para determinar las fuerzas que actuan en los objetos
int k ; 
NSButton *celda ;
  
while((codigo = [cuenta nextObject]) && !error) 
    {
    int x ;
    NSString *key ;
    NSArray *terminos ;
    NSNumber *numero ;
    identificador = [[diccionario objectForKey: codigo] objectForKey: @"Tipo"] ;
    NSMutableArray *titulos = [[diccionario objectForKey: codigo] objectForKey: @"Titulos"] ;
    NSMutableArray *datos = [[diccionario objectForKey: codigo] objectForKey: @"Datos"] ;
    NSMutableArray *valores = [[diccionario objectForKey: codigo] objectForKey: @"Valores"] ;
    [valores removeAllObjects] ;
    NSCharacterSet *numeros = [NSCharacterSet characterSetWithCharactersInString: @".-+0123456789E"] ;
       
//Cuenta la cantidad de variables en el sistema
    for(x = 0; x < [datos count]; x++)
         {
         NSCharacterSet *valor = [NSCharacterSet characterSetWithCharactersInString: [[datos objectAtIndex: x] stringByTrimmingSpaces]] ; 
        
         if(![numeros isSupersetOfSet: valor] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Nombre"])
                {
                    if([valor characterIsMember: '@'])
                    {
                    terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
                    NSCharacterSet *term1 = [NSCharacterSet characterSetWithCharactersInString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]] ; 
                    key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
                    
                    if([[[conversiones objectAtIndex: sistema] allKeys] containsObject: key])
                      {
                    
                    if([numeros isSupersetOfSet: term1])
                        {
                        numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[conversiones objectAtIndex: sistema] objectForKey: key] doubleValue] ] ;
                        [valores addObject: [numero stringValue]] ;
                        }
                        else
                        {
                        NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
                        var = [var stringByAppendingString: @"@"] ;
                        var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                        
                               [valores addObject: var] ;
                               if(![variables containsObject: var])
                                    {
                                    [variables addObject: var] ;
                                    }
                                    
                        }
                      }
                      else
                      {
                      longitud = [ [estaticaPuntInfo textStorage] length];
                      NSString *anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
                      [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
                      error = YES ;
                      }
                    
                    }
                    else
                    {
                    //Se agrega una variable simple 
                               NSString *varTit, *varFactor ;   
                               NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;

			       //Se determina el tipo de variable
                               varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;

                               if([varTit hasPrefix: @"m"])
                                  {
                                         if(sistema== 0)
                                         { varFactor = [NSString stringWithString: @"kg"] ; }
                                         else
                                         { varFactor = [NSString stringWithString: @"slug"] ; } 
                                  }
                               else
                                  {
                                      if([varTit hasPrefix: @"f"])
                                         {
                                             if(sistema== 0)
                                             { varFactor = [NSString stringWithString: @"N"] ; }
                                             else
                                             { varFactor = [NSString stringWithString: @"lb"] ; }
                                         }
                                      else
                                         {
                                              if([varTit hasPrefix: @"ang"])
                                                 {
                                                     { varFactor = [NSString stringWithString: @"grados"] ; } 
                                                 }
                                              else
                                                 {
                                                     if([varTit hasPrefix: @"g"])
                                                        {
                                                            if(sistema== 0)
                                                            { varFactor = [NSString stringWithString: @"m/s2"] ; }
                                                            else
                                                            { varFactor = [NSString stringWithString: @"ft/s2"] ; }
                                                        }
                                                     else
                                                        {
                                                            if([varTit hasPrefix: @"d"])
                                                            {
                                                                if(sistema== 0)
                                                                { varFactor = [NSString stringWithString: @"m"] ; }
                                                                else
                                                                { varFactor = [NSString stringWithString: @"ft"] ; }
                                                            }
                                                            else
                                                            {
                                                                if([varTit hasPrefix: @"k"])
                                                                {
                                                                   if(sistema== 0)
                                                                   { varFactor = [NSString stringWithString: @"N/m"] ; }
                                                                   else
                                                                   { varFactor = [NSString stringWithString: @"lb/ft"] ; }
                                                                }
                                                                else
                                                                {
                                                                varFactor = [NSString stringWithString: @"ad"] ; 
                                                                }  
                                                            }
                                                        }
                                                 }
                                         } 
                                  }
                               //Termina la busqueda del tipo de variable
	
                               var = [var stringByAppendingString: @"@"] ;
                               var = [var stringByAppendingString: varFactor] ;

                               [valores addObject: var] ;
                               if(![variables containsObject: var])
                                    {
                                    [variables addObject: var] ;
                                    }
  
                    //Se ha agregado la variable simple   
                    }
                }
          else
                {
                [valores addObject: [datos objectAtIndex: x]] ;
                }
         }    
//Fin del conteo de variables

if(error)
  break ;

//Determina la variable de la gravedad y el numero de ecuaciones
            switch ([identificador intValue])
            {
            case 50:
                {
                NSCharacterSet *grav = [NSCharacterSet characterSetWithCharactersInString: [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ];
                
                          if(![numeros isSupersetOfSet: grav])
                          {
                          gravedadVar = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          varG = 1 ;
                          }
                          else
                          {
                          gravedadDat = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                          varG = 2 ;
                          }
                
                }
                break;
            case 51:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }    
                break;
            case 52:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }
                break;
            case 53:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }
                break;
            case 54:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }
                break;
            case 55:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }
                break;
            case 56 ... 74:
                {
                numFuerzas = numFuerzas + 1 ;
                [codFuerzas addObject: codigo] ;
                }
                break;
            case 75 ... 78:
                {
                numEcuaciones = numEcuaciones + 1;
                [codObjetos addObject: codigo] ;
                }
            }
//Fin del conteo de ecuaciones

//Se determinan las fuerzas que actuan en cada objeto
int pos ;
NSNumber *ident ;
NSEnumerator *busq = [ordenObjetos objectEnumerator] ;

  if( ([identificador intValue] >= 51) && ([identificador intValue] <= 55) )
  {
  k = 0 ;
  pos = 0 ;
      
      while((celda = [busq nextObject]))
      {
          if([celda tag] == [codigo intValue])
          {
          pos = k ;
          break ;
          }
          k = k + 1 ;   
      }
  
  NSMutableArray *fuerzas = [NSMutableArray array] ;
  
              if( (pos%16 != 0) && (pos%16 != 15) )
                {
                       if(pos - 1 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 15 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 15] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 16 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 17 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 17] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 1 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 15 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 15] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 16 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 17 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 17] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                }
              else
                {
                       if(pos%16 == 0)
                       {
                            if(pos - 15 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 15] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       
                            if(pos - 16 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 1 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 16 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 17 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 17] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       }
                       else
                       {
                            if(pos - 1 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos - 16 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos - 17 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 17] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       
                            if(pos + 15 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 15] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 16 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       }
                }
      
//Se determina el tipo de fuerzas aplicadas al objeto y se corrige el numero de ecuaciones
int fuerHoriz = 0, fuerVert = 0 ;   
NSNumber *fuerTipo ;  
NSEnumerator *verif ;
         if( ([identificador intValue] == 52) && ([fuerzas count] > 0) )
         {
         [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
         
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t >= 66) || ((t >= 50) && (t <= 55)))
                 {
                 errorFuer = YES ;
                 } 
                 
              }
         }
         
         if( ([identificador intValue] == 53) && ([fuerzas count] > 0) )
         {
         [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
         
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 64) || (t == 65) || (t >= 68) || ((t >= 50) && (t <= 55)))
                 {
                 errorFuer = YES ;
                 } 
                 
              }
         }
  
         if( ([identificador intValue] == 54) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 60) || (t == 61) )
                 {
                 fuerHoriz = fuerHoriz + 1 ;
                 }
                 
                 if( (t == 62) || (t == 63) )
                 {
                 fuerVert = fuerVert + 1 ;
                 }
                 
                 if( (t >= 64) || (t <= 55) || ((t >= 50) && (t <= 55)))
                 {
                 errorFuer = YES ;
                 } 
                 
              }
              
              if([fuerzas count] == fuerHoriz)
              {
              numEcuaciones = numEcuaciones - 1;
              [tipoFuer addObject: [NSNumber numberWithInt: 2]] ;
              }
              else
              {
                  if([fuerzas count] == fuerVert)
                  {
                  numEcuaciones = numEcuaciones - 1;
                  [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
                  }
                  else
                  {
                  [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
                  }
              }
              
         }
        
         if( ([identificador intValue] == 55) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 60) || (t == 61) || (t == 73) )
                 {
                 fuerHoriz = fuerHoriz + 1 ;
                 }
                 
                 if( (t == 62) || (t == 63) || (t == 74) )
                 {
                 fuerVert = fuerVert + 1 ;
                 }
                 
                 if( ((t >= 64) && (t <= 71)) || ((t >= 50) && (t <= 55)) )
                 {
                 errorFuer = YES ;
                 }
                 
              }
              
              if([fuerzas count] == fuerHoriz)
              {
              numEcuaciones = numEcuaciones - 1;
              [tipoFuer addObject: [NSNumber numberWithInt: 2]] ;
              }
              else
              {
                  if([fuerzas count] == fuerVert)
                  {
                  numEcuaciones = numEcuaciones - 1;
                  [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
                  }
                  else
                  {
                  [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
                  }
              }
              
         }
          
         if( ([identificador intValue] == 51) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 62) || (t == 63) )
                 {
                 fuerVert = fuerVert + 1 ;
                 }
                 
                 if( ((t >= 64) && (t <= 67)) || (t >= 72) || ((t >= 50) && (t <= 55)) )
                 {
                 errorFuer = YES ;
                 }

              }

              if([fuerzas count] == fuerVert)
              {
              numEcuaciones = numEcuaciones - 1;
              [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
              }
              else
              {
              [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
              }
              
         }
         
  if([fuerzas count] > 0)
         {
         [fuerObj addObject: fuerzas] ; 
         }       
  }
  else
  {
  int signo = 0 ;
  NSMutableArray *fuerzas = [NSMutableArray array] ;
           
         if(([identificador intValue] >= 75) && ([identificador intValue] <= 78))
         {
         int rFuer = 0 ;
         k = 0 ;
         pos = 0 ;
      
         while((celda = [busq nextObject]))
              {
                 if([celda tag] == [codigo intValue])
                 {
                 pos = k ;
                 break ;
                 }
                k = k + 1 ;   
              }
  
        if([identificador intValue] == 75)
          {
          rFuer = 15 ;
          }
        else
          { 
              if([identificador intValue] == 76)
              {
              rFuer = 17 ;
              }
              else
              {
                  if([identificador intValue] == 77)
                  {
                  rFuer = 16 ;
                  }
                  else
                  {
                  rFuer = 1 ;
                  }
              }
          }             
        
              if( (pos%16 != 0) && (pos%16 != 15) )
                {
                    if(pos - rFuer >= 0)
                    {
                    ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                    if([ident intValue] != 0)
                    { [fuerzas addObject: ident] ; 
                       signo = 1; }
                    }
                    
                    if(pos + rFuer <= 207)
                    {
                    ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                    if([ident intValue] != 0)
                    { [fuerzas addObject: ident] ; 
                       signo = -1; }
                    }
                }
              else
                {
                    if(pos%16 == 0)
                       { 
                             if((pos - rFuer >= 0) && ((rFuer != 1) || (rFuer != 17))) 
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = 1; }
                             }
                    
                             if((pos + rFuer <= 207) && (rFuer != 15))
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = -1 ;}
                             }
                       }
                    else
                       {
                             if((pos - rFuer >= 0) && (rFuer != 15)) 
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                                signo = 1; }
                             }
                    
                             if((pos + rFuer <= 207) && ((rFuer != 1) || (rFuer != 17)))
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = -1; }
                             }
                       }
                } 
         }
   
  //Verificacion de fuerzas
         if([fuerzas count] > 0)
         {
              if(signo > 0) 
              {
              [tipoFuer addObject: [NSNumber numberWithInt: 4]] ;
              }
              else
              {
                 if([fuerzas count] == 1)
                 {
                 [tipoFuer addObject: [NSNumber numberWithInt: 5]] ;
                 }
                 else
                 {
                 [tipoFuer addObject: [NSNumber numberWithInt: 4]] ;
                 }
              }
              
              if([fuerzas count] >1)
              {
              int f1 = [[[diccionario objectForKey: [fuerzas objectAtIndex: 0]] objectForKey: @"Tipo"] intValue] ;
              int f2 = [[[diccionario objectForKey: [fuerzas objectAtIndex: 1]] objectForKey: @"Tipo"] intValue] ;
              
                if(f1 == f2)
                {
                errorFuer = YES ;
                }
              }
         }
  
    if([fuerzas count] > 0)
         {
         [fuerObj addObject: fuerzas] ; 
         }     
  }
}

//longitud = [ [estaticaPuntInfo textStorage] length];
//[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [[tipoFuer objectAtIndex: 0] description] ] ;    

//Se verifica que todos los objetos tengan fuerzas aplicadas
if( ([codObjetos count] == [fuerObj count]) && (!errorFuer) )
{
//Se realiza el conteo de las fuerzas aplicadas 
int v ;
    for(v = 0; v < [codObjetos count]; v++)
    {
    //mensaje = [NSString stringWithFormat: @"\n Objeto: %d  fuerzas: %d \n", [[codObjetos objectAtIndex: v] intValue], [[fuerObj objectAtIndex: v] count] ];
    //longitud = [ [estaticaPuntInfo textStorage] length];
    //[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
    
    numFuerObj = numFuerObj + [[fuerObj objectAtIndex: v] count] ;
    [codFuerzasObj addObjectsFromArray: [fuerObj objectAtIndex: v]] ;  
    }
    
//Se verifica cuantas de las fuerzas existentes estan aplicadas a objetos
    int w = 0 ;
    NSEnumerator *compro = [codFuerzas objectEnumerator] ;
    NSNumber *fuer ;
    while((fuer = [compro nextObject]))
    {
       if([codFuerzasObj containsObject: fuer])
       {
       w = w + 1 ;
       }
       
    //longitud = [ [estaticaPuntInfo textStorage] length];
    //[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: @"\n"] ;  
    //longitud = [ [estaticaPuntInfo textStorage] length];
    //[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [fuer description]] ; 
    }
    
    /*
    longitud = [ [estaticaPuntInfo textStorage] length];
    [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [codFuerzasObj componentsJoinedByString: @"-"]] ;
    mensaje = [NSString stringWithFormat: @"\n Total fuerzas: %d  fuerzas en objetos: %d \n", w, [codFuerzasObj count] ];
    longitud = [ [estaticaPuntInfo textStorage] length];
    [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
    longitud = [ [estaticaPuntInfo textStorage] length];
    */
    

//Ultimas verificaciones        
   if(([variables count] == numEcuaciones) && (numEcuaciones > 0) && !error)
    {
         if( (w == [codFuerzas count]) && (w == [codFuerzasObj count]) )
         {
         [self crearSistema] ;
         }
         else
         {
         NSString *advertencia ;
         
             if(w < [codFuerzas count])
             {
             advertencia = [NSString stringWithString: [errores objectAtIndex: 1]] ;
             }
             
             if(w < [codFuerzasObj count])
             {
             advertencia = [NSString stringWithString: [errores objectAtIndex: 2]] ;
             }
         
         longitud = [ [estaticaPuntInfo textStorage] length];
         [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: advertencia] ;
         }
    }
    else
    {
    longitud = [ [estaticaPuntInfo textStorage] length];
    [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 3]] ;        
    }
}
else
{
     if([codObjetos count] != [fuerObj count])
     {
     longitud = [ [estaticaPuntInfo textStorage] length];
     [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 4]] ;
     }
     else
     {
     longitud = [ [estaticaPuntInfo textStorage] length];
     [estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 5]] ;
     }
}

RELEASE(keys) ;
}

- (void) crearSistema
{
int aumento = 1 ;
double nuevoValor ;
BOOL continuar ;

const gsl_multiroot_fsolver_type *T;
gsl_multiroot_fsolver *s;
     
int estado, estadoInt, k, nvar, longitud ;
double par, factor ;
NSString *mensaje ;
NSNumber *respuesta ;
NSArray *terminos ;
size_t iter ;

nvar  = [variables count] ;
const size_t n = nvar;
struct parametros p = {1.0, 1.0};

gsl_vector *x = gsl_vector_alloc (n);

//Generador de numeros aleatorios
const gsl_rng_type * Y;
gsl_rng * r;
gsl_rng_env_setup();
Y = gsl_rng_default;
r = gsl_rng_alloc (Y);

do
{
iter = 0 ;
for (k = 0; k < nvar; k++)
    {
        if( aumento <= 30 )
        {
        nuevoValor = 100 ;
        }
        else
        {
        nuevoValor = 1000 ;
        }
        
    par = nuevoValor*(gsl_rng_uniform (r)) ;
    gsl_vector_set (x, k, par) ;
    }
     
gsl_multiroot_function f = {&sis_estatica, n, &p};    
T = gsl_multiroot_fsolver_hybrids;
s = gsl_multiroot_fsolver_alloc (T, nvar);
gsl_multiroot_fsolver_set (s, &f, x);

         do
         {
           iter++;
           estadoInt = gsl_multiroot_fsolver_iterate (s);
 
           if(estadoInt)
             break;
     
           estado = gsl_multiroot_test_residual (s->f, 1e-7);
         }
         while (estado == GSL_CONTINUE && iter < 1000);  

//Se verifica el estado
    if( (estadoInt) && (aumento < 60) )
    {
             aumento = aumento + 1 ;
             continuar = YES ;
    }
    else
    {
    continuar = NO ;
    }
//Se termina la verificacion
}
while(continuar) ;
//se termino la busqueda de la solucion

//Se pasan los datos al array Resultados
int countRes = 0 ;
id unObj ;
NSMutableArray *resultados = [NSMutableArray array] ;
NSEnumerator *varCount = [variables objectEnumerator] ;

while((unObj = [varCount nextObject]))
{
[resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
countRes = countRes + 1 ;
}

//Se corrigen signos en los datos
id datoSigno ;
NSNumber *tipoOtro ;
NSMutableArray *verifSigno ;
NSEnumerator *signoObj = [diccionario objectEnumerator] ;

while((datoSigno = [signoObj nextObject]))
{
int par1 = 0, w = 0 ;
tipoOtro = [datoSigno objectForKey: @"Tipo"] ;

 switch([tipoOtro intValue])
 {
 case 52 ... 53:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige el angulo del plano
          if([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 56 ... 59:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige la fuerza
          if( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo de la fuerza
          if([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 72:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige la resultante
          if( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo de la resultante
          if([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
 }
} 

//Se imprimen los resultados
for(k = 0; k < nvar; k++)
{
terminos = [[variables objectAtIndex: k] componentsSeparatedByString: @"@"] ;
factor = [[[conversiones objectAtIndex: sistema] objectForKey: [terminos objectAtIndex: 1]] doubleValue] ; 
//respuesta = [NSNumber numberWithDouble: (gsl_vector_get (s->x, k))/factor ] ;
respuesta = [resultados objectAtIndex: k] ;
mensaje = [NSString stringWithFormat: @" %s  =  %.3f  %s ;  ", [[terminos objectAtIndex: 0] cString], ([respuesta doubleValue]/factor), [[terminos objectAtIndex: 1] cString]] ;
longitud = [ [estaticaPuntInfo textStorage] length];
[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
}

//Se imprime el estado del calculo        
mensaje = [NSString stringWithFormat: [errores objectAtIndex: 6], gsl_strerror (estado)];
longitud = [ [estaticaPuntInfo textStorage] length];
[estaticaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;

gsl_multiroot_fsolver_free (s);
gsl_vector_free (x);
gsl_rng_free (r);
}

- (void) dealloc
{
RELEASE(diccionario) ;
RELEASE(variables) ;
RELEASE(codObjetos) ;
RELEASE(fuerObj) ;
RELEASE(tipoFuer) ;
RELEASE(ordenObjetos) ;
RELEASE(errores) ;
[super dealloc] ;
}

@end
