/* 
   Copyright (C) 2009 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <AppKit/AppKit.h>
#include "dinamicaPuntual.h"

int valoresDinamiPunt (const gsl_vector *, void *, gsl_vector *);

struct parametros
       {
         double a;
         double b;
       };

int sis_dinamica (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
valoresDinamiPunt (variables, params, funciones);  
return GSL_SUCCESS;
}

int valoresDinamiPunt (const gsl_vector *vars, void *p, gsl_vector *func)
{
       int tIndice, gIndice, codigoFuer = 0 ;
       int nEcu = 0 ;
       double tf, gf ;
       NSNumber *objeto ;
      
       if(varG == 1)
       {
       gIndice = [variables indexOfObject: gravedadVar] ;
       gf = gsl_vector_get (vars, gIndice) ;  
       }
       else
       {
          if(varG == 2)
          {
          gf = gravedadDat ;
          }
          else
          {
          gf = 0 ;
          }
       }
       
       if(varT == 1)
       {
       tIndice = [variables indexOfObject: tiempoVar] ;
       tf = gsl_vector_get (vars, tIndice) ;   
       }
       else
       {
          if(varT == 2)
          {
          tf = tiempoDat ;
          }
          else
          {
          tf = 0 ;
          }
       }
       
       NSEnumerator *enumObjetos = [codObjetos objectEnumerator] ;
       
       while((objeto = [enumObjetos nextObject]))
       {
       NSNumber *tipo = [[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
       NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
       
       switch([tipo intValue])
              {
              case 104:
                   {
                   int a_status = 0 ;
                   double peso, masa, a, vi, vf, d ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     a = [[dat objectAtIndex: 2] doubleValue] ;
                     a_status = 1 ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     a = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
                     {
                     vi = [[dat objectAtIndex: 3] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
                     vi = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
                     {
                     vf = [[dat objectAtIndex: 4] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
                     vf = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
                     {
                     d = [[dat objectAtIndex: 5] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
                     d = gsl_vector_get (vars, k) ;
                     }
                   
                   peso = masa*gf ;
                   
                        if([[tipoFuer objectAtIndex: codigoFuer] intValue] == 3)
                        {
                        int conteo = 1 ; 
                        double signo ;
                        double fuerza[9] = {0} ;
                        fuerza[0] = -1*peso ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                
                                        if( t == 115 )
                                        { signo = 1; }
                                        else
                                        { signo = - 1; }   
                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[conteo] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[conteo] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                 
                                conteo = conteo + 1 ;
                                }
                        
                        //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerza[0] + fuerza[1] + fuerza[2] + fuerza[3] + fuerza[4] + fuerza[5] + fuerza[6] + fuerza[7] + fuerza[8] - masa*a);
                        gsl_vector_set (func, nEcu + 1, 0.5*(vf*vf - vi*vi) - a*d); 
                        
                           if( (a_status = 1) && (a == 0) )
                           {
                           gsl_vector_set (func, nEcu + 2, vi*tf - d);
                           }
                           else
                           {
                           gsl_vector_set (func, nEcu + 2, (vf - vi) - a*tf); 
                           }

                        nEcu = nEcu + 3 ;
                        }
                        else
                        {
                        int conteox = 0, conteoy = 1 ; 
                        double signox, signoy ;
                        double n = 0, u = 0, a_rel = 0 ;
                        double fuerzax[8] = {0} ;
                        double fuerzay[9] = {0} ;
                        fuerzay[0] = -1*peso ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                        
                  if(![[[dat objectAtIndex: 6] stringByTrimmingSpaces] isEqualToString: @"sf"])
                  {     
                   NSEnumerator *buscar = [diccionario objectEnumerator] ;
                   NSNumber *tipoObj ;   
                   NSMutableArray *objetoDatos ;
                   NSMutableDictionary *buscarNombre ;
                   NSString *nomObjeto = [[dat objectAtIndex: 6] stringByTrimmingSpaces] ;  
                   
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoObj = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
                          
                        if([tipoObj intValue] == 105)
                              {
                                 if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                   }       
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 113:
                                    case 114:
                                      {
                                        if(t == 113)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 115:
                                  case 116:
                                     {
                                        if(t == 115)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 109 ... 112:
                                     {
                                     double ang ;
                                     
                                        if( (t == 109) || (t == 112) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 109) || (t == 111) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  case 123:
                                  case 124:
                                     {
                                        if(t == 123)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }

                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        n = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        n = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                                                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                     }
                                     break;
                                  case 131:
                                  case 132:   
                                     {
                                        double u ; 
                                     
                                        if(t == 131)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }

                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*u*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;   
                                     }
                                     break;
                                  case 125:
                                  case 126:
                                  case 127:
                                  case 128:
                                     {
                                        double ang, u ;
                                     
                                        if( (t == 125) || (t == 128) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 125) || (t == 127) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*u*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*u*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  }
                                }
                        
                        //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] - masa*a_rel);
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8] + u*n - masa*a);
                        gsl_vector_set (func, nEcu + 2, 0.5*(vf*vf - vi*vi) - a*d); 
                        //gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf);
                        
                           if( (a_status = 1) && (a == 0) )
                           {
                           gsl_vector_set (func, nEcu + 3, vi*tf - d);
                           }
                           else
                           {
                           gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                           }

                        nEcu = nEcu + 4 ;
                        }
                   }
                   break;
              case 105:
                   {
                   int conteox = 0, conteoy = 1, a_status = 0 ; 
                   double signox, signoy ; 
                   double masa, a, vi, vf, d ;
                   double n = 0, u = 0, a_signo = 1, a_rel = 0, ang_rel = 0 ;
                   double fuerzax[8] = {0} ;
                   double fuerzay[9] = {0} ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     a = [[dat objectAtIndex: 2] doubleValue] ;
                     a_status = 1 ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     a = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
                     {
                     vi = [[dat objectAtIndex: 3] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
                     vi = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
                     {
                     vf = [[dat objectAtIndex: 4] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
                     vf = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
                     {
                     d = [[dat objectAtIndex: 5] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
                     d = gsl_vector_get (vars, k) ;
                     }
                      
                  if(![[[dat objectAtIndex: 6] stringByTrimmingSpaces] isEqualToString: @"sf"])
                  {     
                   NSEnumerator *buscar = [diccionario objectEnumerator] ;
                   NSNumber *tipoObj ;   
                   NSMutableArray *objetoDatos ;
                   NSMutableDictionary *buscarNombre ;
                   NSString *nomObjeto = [[dat objectAtIndex: 6] stringByTrimmingSpaces] ;  
                   
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoObj = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
                          
                       switch([tipoObj intValue])
                       {
                       case 105:
                              {
                                 if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;
                       case 106:
                              {
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   ang_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   ang_rel = gsl_vector_get (vars, k) ;
                                   }
                                   
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;
                       case 107:
                              {
                              a_signo = -1 ;
                              
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   ang_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   ang_rel = gsl_vector_get (vars, k) ;
                                   }
                                   
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;              
                       }   
                   }       

                   fuerzay[0] = -1*masa*gf ;
                   NSNumber *codFuerObj ;
                   NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 113:
                                    case 114:
                                      {
                                        if(t == 113)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 115:
                                  case 116:
                                     {
                                        if(t == 115)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 109 ... 112:
                                     {
                                     double ang ;
                                     
                                        if( (t == 109) || (t == 112) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 109) || (t == 111) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  case 121:
                                  case 122:
                                     {
                                        if(t == 121)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        n = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        n = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                     }
                                     break;
                                  case 129:
                                  case 130:   
                                     {
                                        double u ; 
                                     
                                        if(t == 129)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }

                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*u*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     }
                                     break;
                                  case 125:
                                  case 126:
                                  case 127:
                                  case 128:
                                     {
                                        double ang, u ;
                                     
                                        if( (t == 125) || (t == 128) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 125) || (t == 127) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*u*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*u*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  }
                                }
                        
                        //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + u*n - masa*(a + a_signo*a_rel*cos(M_PI*ang_rel/180)) );
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8] -masa*a_rel*sin(M_PI*ang_rel/180));
                        gsl_vector_set (func, nEcu + 2, 0.5*(vf*vf - vi*vi) - a*d); 
                        //gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                        
                           if( (a_status = 1) && (a == 0) )
                           {
                           gsl_vector_set (func, nEcu + 3, vi*tf - d);
                           }
                           else
                           {
                           gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                           }

                        nEcu = nEcu + 4 ;
                   }
                   break;
              case 106:
                   {
                   int conteox = 1, conteoy = 1, a_status = 0 ;
                   double signox, signoy ; 
                   double n = 0, u = 0, a_signox = 1, a_signoy = 1, a_rel = 0, ang_rel = 0 ;
                   double fuerzax[9] = {0} ;
                   double fuerzay[9] = {0} ;
                   double masa, ang, a, vi, vf, d ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     ang = [[dat objectAtIndex: 2] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     ang = gsl_vector_get (vars, k) ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
                     {
                     a = [[dat objectAtIndex: 3] doubleValue] ;
                     a_status = 1 ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
                     a = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
                     {
                     vi = [[dat objectAtIndex: 4] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
                     vi = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
                     {
                     vf = [[dat objectAtIndex: 5] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
                     vf = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
                     {
                     d = [[dat objectAtIndex: 6] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
                     d = gsl_vector_get (vars, k) ;
                     }
                     
                if(![[[dat objectAtIndex: 7] stringByTrimmingSpaces] isEqualToString: @"sf"])
                  {     
                   NSEnumerator *buscar = [diccionario objectEnumerator] ;
                   NSNumber *tipoObj ;   
                   NSMutableArray *objetoDatos ;
                   NSMutableDictionary *buscarNombre ;
                   NSString *nomObjeto = [[dat objectAtIndex: 7] stringByTrimmingSpaces] ;  
                   
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoObj = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
                          
                       switch([tipoObj intValue])
                       {
                       case 105:
                              {
                              a_signoy = -1 ;
                              
                                 if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                                   
                              ang_rel = ang ;
                              }
                              break;
                       case 106:
                              {
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;
                       case 107:
                              {
                              a_signox = -1 ;
                              
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   ang_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   ang_rel = gsl_vector_get (vars, k) ;
                                   }
                                   
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] + ang ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) + ang ;
                                   }
                              }
                              break;              
                       }   
                   }       
                   
                   fuerzax[0] = -1*masa*sin(M_PI*ang/180)*gf ;
                   fuerzay[0] = -1*masa*cos(M_PI*ang/180)*gf ;
                   NSNumber *codFuerObj ;
                   NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                      while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 113:
                                    case 114:
                                      {
                                        if(t == 113)
                                        { signox = 1;
                                           signoy = - 1; }
                                        else
                                        { signox = - 1; 
                                           signoy = 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 115:
                                  case 116:
                                     {
                                        if(t == 115)
                                        { signox = 1;
                                           signoy = 1; }
                                        else
                                        { signox = - 1;
                                           signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        }
                                     
                                     conteox = conteox + 1 ;      
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 109 ... 112:
                                     {
                                     double angf, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 109)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 110)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               {  signoy = - 1;
                                                   angr = angf - ang; }
                                               else
                                               {  signoy = 1;
                                                   angr = ang - angf; }
                                        }
                                        
                                        if(t == 111)
                                        {
                                        signoy = 1;
                                               if(angf + ang > 90)
                                               { signox = 1;
                                                  angr = angf + ang - 90; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang; }
                                        }
                                        
                                        if(t == 112)
                                        {
                                        signoy = - 1;
                                               if(angf + ang <= 90)
                                               { signox = 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang - 90; }
                                        }
                                       
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;
                                  case 117:
                                  case 118:
                                     {
                                        if(t == 117)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        n = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        n = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                       if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                     }
                                     break;
                                  case 125 ... 128:
                                     {
                                     double angf, u, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 125)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 126)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               {  signoy = - 1;
                                                   angr = angf - ang; }
                                               else
                                               {  signoy = 1;
                                                   angr = ang - angf; }
                                        }
                                        
                                        if(t == 127)
                                        {
                                        signoy = 1;
                                               if(angf + ang > 90)
                                               { signox = 1;
                                                  angr = angf + ang - 90; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang; }
                                        }
                                        
                                        if(t == 128)
                                        {
                                        signoy = - 1;
                                               if(angf + ang <= 90)
                                               { signox = 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = - 1;
                                                  angr = angf + ang - 90; }
                                        }
                                       
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*u*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*u*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;
                                  }
                                }
                                
                    //Se establecen las ecuaciones
                    gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + fuerzax[8] + u*n - masa*(a + a_signox*a_rel*cos(M_PI*ang_rel/180)) );
                    gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8] - masa*a_signoy*a_rel*sin(M_PI*ang_rel/180) );
                    gsl_vector_set (func, nEcu + 2, 0.5*(vf*vf - vi*vi) - a*d); 
                    //gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                    
                           if( (a_status = 1) && (a == 0) )
                           {
                           gsl_vector_set (func, nEcu + 3, vi*tf - d);
                           }
                           else
                           {
                           gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                           }

                   nEcu = nEcu + 4 ;
                   }
                   break;
              case 107:
                   {
                   int conteox = 1, conteoy = 1, a_status = 0 ; 
                   double signox, signoy ;
                   double n = 0, u = 0, a_signo = 1, a_rel = 0, ang_rel = 0 ;
                   double fuerzax[9] = {0} ;
                   double fuerzay[9] = {0} ;
                   double masa, ang, a, vi, vf, d ;
                   
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     ang = [[dat objectAtIndex: 2] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     ang = gsl_vector_get (vars, k) ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     masa = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     masa = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
                     {
                     a = [[dat objectAtIndex: 3] doubleValue] ;
                     a_status = 1 ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
                     a = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces] ])
                     {
                     vi = [[dat objectAtIndex: 4] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
                     vi = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces] ])
                     {
                     vf = [[dat objectAtIndex: 5] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 5] stringByTrimmingSpaces]] ;
                     vf = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces] ])
                     {
                     d = [[dat objectAtIndex: 6] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 6] stringByTrimmingSpaces]] ;
                     d = gsl_vector_get (vars, k) ;
                     }
                     
                if(![[[dat objectAtIndex: 7] stringByTrimmingSpaces] isEqualToString: @"sf"])
                  {     
                   NSEnumerator *buscar = [diccionario objectEnumerator] ;
                   NSNumber *tipoObj ;   
                   NSMutableArray *objetoDatos ;
                   NSMutableDictionary *buscarNombre ;
                   NSString *nomObjeto = [[dat objectAtIndex: 7] stringByTrimmingSpaces] ;  
                   
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoObj = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
                          
                       switch([tipoObj intValue])
                       {
                       case 105:
                              {
                              a_signo = -1 ;                              
                              
                                 if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                                   
                              ang_rel = ang ;     
                              }
                              break;
                       case 106:
                              {
                              a_signo = -1 ;                              
                              
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                                   {
                                   ang_rel = [[objetoDatos objectAtIndex: 2] doubleValue] + ang ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                   ang_rel = gsl_vector_get (vars, k) + ang ;
                                   }
                                   
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;
                       case 107:
                              {
                                if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                                   {
                                   a_rel = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                                   }
                                else
                                   {
                                   int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                                   a_rel = gsl_vector_get (vars, k) ;
                                   }
                              }
                              break;              
                       }   
                   }       
                   
                   fuerzax[0] = -1*masa*sin(M_PI*ang/180)*gf ;
                   fuerzay[0] = -1*masa*cos(M_PI*ang/180)*gf ;
                   NSNumber *codFuerObj ;
                   NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                      while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 113:
                                    case 114:
                                      {
                                        if(t == 114)
                                        { signox = 1;
                                           signoy = - 1; }
                                        else
                                        { signox = - 1; 
                                           signoy = 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 115:
                                  case 116:
                                     {
                                        if(t == 115)
                                        { signox = 1;
                                           signoy = 1; }
                                        else
                                        { signox = - 1;
                                           signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        }
                                     
                                     conteox = conteox + 1 ;      
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 109 ... 112:
                                     {
                                     double angf, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 109)
                                        {
                                        signoy = 1;
                                               if(angf + ang >= 90)
                                               { signox = - 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = 1;
                                                  angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 110)
                                        {
                                        signoy = - 1;
                                               if(angf + ang >= 90)
                                               {  signox = 1;
                                                   angr = angf + ang; }
                                               else
                                               {  signox = - 1;
                                                   angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 111)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1;
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 112)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               { signoy = - 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;
                                  case 119:
                                  case 120:
                                     {
                                        if(t == 119)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        n = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        n = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                        
                                     }
                                     break;
                                  case 125 ... 128:
                                     {
                                     double angf, u, angr ;
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        u = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        u = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces] ])
                                        {
                                        angf = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces]] ;
                                        angf = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(t == 125)
                                        {
                                        signoy = 1;
                                               if(angf + ang >= 90)
                                               { signox = - 1; 
                                                  angr = angf + ang; }
                                               else
                                               { signox = 1;
                                                  angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 126)
                                        {
                                        signoy = - 1;
                                               if(angf + ang >= 90)
                                               {  signox = 1;
                                                   angr = angf + ang; }
                                               else
                                               {  signox = - 1;
                                                   angr = ang + angf - 90; }
                                        }
                                        
                                        if(t == 127)
                                        {
                                        signox = 1;
                                               if(angf >= ang)
                                               { signoy = 1;
                                                  angr = angf - ang; }
                                               else
                                               { signoy = - 1;
                                                  angr = ang - angf; }
                                        }
                                        
                                        if(t == 128)
                                        {
                                        signox = - 1;
                                               if(angf >= ang)
                                               { signoy = - 1; 
                                                  angr = angf - ang; }
                                               else
                                               { signoy = 1;
                                                  angr = ang - angf; }
                                        }
                                       
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                              fuerzax[conteox] = signox*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*angr/180) ;
                                              fuerzay[conteoy] = signoy*u*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*angr/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                            fuerzax[conteox] = signox*u*(gsl_vector_get (vars, k))*cos(M_PI*angr/180) ;
                                            fuerzay[conteoy] = signoy*u*(gsl_vector_get (vars, k))*sin(M_PI*angr/180) ;
                                        }
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ; 
                                     }
                                     break;                                     
                                  }
                                }

                    //Se establecen las ecuaciones
                    gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7] + fuerzax[8] + u*n - masa*a - masa*a_signo*a_rel*cos(M_PI*ang_rel/180) );
                    gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7] + fuerzay[8]  - masa*a_rel*sin(M_PI*ang_rel/180) );
                    gsl_vector_set (func, nEcu + 2, 0.5*(vf*vf - vi*vi) - a*d); 
                    //gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf);
                    
                           if( (a_status = 1) && (a == 0) )
                           {
                           gsl_vector_set (func, nEcu + 3, vi*tf - d);
                           }
                           else
                           {
                           gsl_vector_set (func, nEcu + 3, (vf - vi) - a*tf); 
                           } 

                   nEcu = nEcu + 4 ;
                   }
                   break;
              case 108:
                   {
                    
                        if( ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 2) || ([[tipoFuer objectAtIndex: codigoFuer] intValue] == 3) )
                        {
                        int conteo = 0 ; 
                        double signo ;
                        double fuerza[8] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                
                                        if( (t == 113) || (t == 115) )
                                        { signo = 1; }
                                        else
                                        { signo = - 1; }   
                                
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerza[conteo] = signo*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerza[conteo] = signo*(gsl_vector_get (vars, k)) ;
                                        }
                                 
                                conteo = conteo + 1 ;
                                }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, fuerza[0] + fuerza[1] + fuerza[2] + fuerza[3] + fuerza[4] + fuerza[5] + fuerza[6] + fuerza[7]);

                        nEcu = nEcu + 1 ;
                        }
                        else
                        {
                        int conteox = 0, conteoy = 0 ; 
                        double signox, signoy ;
                        double fuerzax[8] = {0} ;
                        double fuerzay[8] = {0} ;
                        NSNumber *codFuerObj ;
                        NSEnumerator *objFuer = [[fuerObj objectAtIndex: codigoFuer] objectEnumerator] ;
                             
                                while((codFuerObj = [objFuer nextObject]))
                                {
                                int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                                   
                                    switch(t)
                                    {
                                    case 113:
                                    case 114:
                                      {
                                        if(t == 113)
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteox = conteox + 1 ;
                                     }
                                     break;
                                  case 115:
                                  case 116:
                                     {
                                        if(t == 115)
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k)) ;
                                        }
                                        
                                     conteoy = conteoy + 1 ;
                                     }
                                     break;
                                  case 109 ... 112:
                                     {
                                     double ang ;
                                     
                                        if( (t == 109) || (t == 112) )
                                        { signox = 1; }
                                        else
                                        { signox = - 1; }
                                        
                                        if( (t == 109) || (t == 111) )
                                        { signoy = 1; }
                                        else
                                        { signoy = - 1; }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
                                        {
                                        ang = [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
                                        ang = gsl_vector_get (vars, k) ;
                                        }
                                        
                                        if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                                        {
                                        fuerzax[conteox] = signox*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
                                        }
                                        else
                                        {
                                        int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                                        fuerzax[conteox] = signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
                                        fuerzay[conteoy] = signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
                                        }
                                        
                                     conteox = conteox + 1 ;   
                                     conteoy = conteoy + 1 ;      
                                     }
                                     break;
                                  }
                                }
                        
                         //Se establecen las ecuaciones
                        gsl_vector_set (func, nEcu, fuerzax[0] + fuerzax[1] + fuerzax[2] + fuerzax[3] + fuerzax[4] + fuerzax[5] + fuerzax[6] + fuerzax[7]);
                        gsl_vector_set (func, nEcu + 1, fuerzay[0] + fuerzay[1] + fuerzay[2] + fuerzay[3] + fuerzay[4] + fuerzay[5] + fuerzay[6] + fuerzay[7]);

                        nEcu = nEcu + 2 ;
                        }
                   }
                   break;
              case 133 ... 136:
                   {
                   int posFuer ; 
                   double signo, kr, xi, xf, fuerza = 0 ;
                   NSNumber *codFuerObj = [[fuerObj objectAtIndex: codigoFuer] objectAtIndex: 0] ;

                   if([[tipoFuer objectAtIndex: codigoFuer] intValue] == 4)
                     {
                   posFuer = 1 ;
                     }
                   else
                     {
                   posFuer = -1 ;
                     }
                   
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     kr = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     kr = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     xi = [[dat objectAtIndex: 2] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     xi = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces] ])
                     {
                     xf = [[dat objectAtIndex: 3] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
                     xf = gsl_vector_get (vars, k) ;
                     }
                     
                   int t = [[[diccionario objectForKey: codFuerObj] objectForKey: @"Tipo"] intValue] ;
                               
                        switch(t)
                        {
                        case 109:
                        case 111:
                        case 114:
                        case 115:
                             {
                             signo = 1 ;
                             }
                             break;
                        case 110:
                        case 112:
                        case 113:
                        case 116:
                             {
                             signo = -1 ;
                             }
                             break;
                        }
                     
                   if(![variables containsObject: [[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     fuerza = signo*posFuer*[[[[diccionario objectForKey: codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                     }
                  else
                     {
                     int k = [variables indexOfObject: [[[[diccionario objectForKey:  codFuerObj] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     fuerza = signo*posFuer*(gsl_vector_get (vars, k)) ;
                     }
                        
                        //Se establece la ecuacion
                        gsl_vector_set (func, nEcu, (kr*(xf - xi)/2) - fuerza);

                        nEcu = nEcu + 1 ;
                    }
                   break;
               }
       codigoFuer = codigoFuer + 1 ;
       }
 
//Objetos de relacion             
       NSEnumerator *enumRel = [codRel objectEnumerator] ;
       
       while((objeto = [enumRel nextObject]))
       {
       NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
  
                   double a_uno, a_dos, z ;
                 
                   if(![variables containsObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces] ])
                     {
                     a_uno = [[dat objectAtIndex: 0] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]] ;
                     a_uno = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces] ])
                     {
                     a_dos = [[dat objectAtIndex: 1] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
                     a_dos = gsl_vector_get (vars, k) ;
                     }
                     
                   if(![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces] ])
                     {
                     z = [[dat objectAtIndex: 2] doubleValue] ;
                     }
                   else
                     {
                     int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
                     z = gsl_vector_get (vars, k) ;
                     }
                 
                 //Se establece la ecuacion
                 gsl_vector_set (func, nEcu, a_uno - z*a_dos);
                        
                 nEcu = nEcu + 1 ;
       }
       
//Objetos colision
       NSEnumerator *enumCol = [codCol objectEnumerator] ;
       int numCol = 0 ;
       
       while((objeto = [enumCol nextObject]))
       {
       double e, angn, m1, m2 ;
       NSMutableArray *otros = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
       int tipoColision = [[tipoCol objectAtIndex: numCol] intValue] ;
       numCol = numCol + 1 ; 
       
                 NSString *nomObjeto1 = [[otros objectAtIndex: 0] stringByTrimmingSpaces] ;
                 NSString *nomObjeto2 = [[otros objectAtIndex: 1] stringByTrimmingSpaces] ;
                 NSEnumerator *buscar = [diccionario objectEnumerator] ;
                 NSMutableArray *objetoMov1, *objetoMov2 ;
                 NSMutableDictionary *buscarNombre ;
                 
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto1 isEqualToString: nombre])
                                {
                                objetoMov1 = [buscarNombre objectForKey: @"Valores"] ;
                                }
                                
                            if ([nomObjeto2 isEqualToString: nombre])
                                {
                                objetoMov2 = [buscarNombre objectForKey: @"Valores"] ;
                                }
                            }   
                          }
       
       if(![variables containsObject: [[otros objectAtIndex: 2] stringByTrimmingSpaces] ])
          {
          e = [[otros objectAtIndex: 2] doubleValue] ;
          }
       else
          {
          int k = [variables indexOfObject: [[otros objectAtIndex: 2] stringByTrimmingSpaces]] ;
          e = gsl_vector_get (vars, k) ;
          }
          
       if(![variables containsObject: [[otros objectAtIndex: 3] stringByTrimmingSpaces] ])
          {
          angn = [[otros objectAtIndex: 3] doubleValue] ;
          }
       else
          {
          int k = [variables indexOfObject: [[otros objectAtIndex: 3] stringByTrimmingSpaces]] ;
          angn = gsl_vector_get (vars, k) ;
          }
          
       if(![variables containsObject: [[objetoMov1 objectAtIndex: 1] stringByTrimmingSpaces] ])
          {
          m1 = [[objetoMov1 objectAtIndex: 1] doubleValue] ;
          }
       else
          {
          int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 1] stringByTrimmingSpaces]] ;
          m1 = gsl_vector_get (vars, k) ;
          }   
                        
       if(![variables containsObject: [[objetoMov2 objectAtIndex: 1] stringByTrimmingSpaces] ])
          {
          m2 = [[objetoMov2 objectAtIndex: 1] doubleValue] ;
          }
       else
          {
          int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 1] stringByTrimmingSpaces]] ;
          m2 = gsl_vector_get (vars, k) ;
          }          
  
                 if(tipoColision == 2)
                 {
                 double vi_uno, vf_uno, vi_dos, vf_dos ;   
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 2] stringByTrimmingSpaces] ])
                        {
                        vi_uno = [[objetoMov1 objectAtIndex: 2] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                        vi_uno = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 3] stringByTrimmingSpaces] ])
                        {
                        vf_uno = [[objetoMov1 objectAtIndex: 3] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 3] stringByTrimmingSpaces]] ;
                        vf_uno = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 2] stringByTrimmingSpaces] ])
                        {
                        vi_dos = [[objetoMov2 objectAtIndex: 2] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                        vi_dos = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 3] stringByTrimmingSpaces] ])
                        {
                        vf_dos = [[objetoMov2 objectAtIndex: 3] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 3] stringByTrimmingSpaces]] ;
                        vf_dos = gsl_vector_get (vars, k) ;
                        }      
                               
                 //Se establecen las ecuaciones
                 gsl_vector_set (func, nEcu, m1*vi_uno + m2*vi_dos -m1*vf_uno - m2*vf_dos); 
                 gsl_vector_set (func, nEcu + 1, e*(vi_uno - vi_dos) - (vf_dos - vf_uno) );                  
                 
                 nEcu = nEcu + 2 ;      
                 }
                 else
                 {
                 double vi_uno, angi_uno, vf_uno, angf_uno, vi_dos, angi_dos, vf_dos, angf_dos ;   
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 2] stringByTrimmingSpaces] ])
                        {
                        vi_uno = [[objetoMov1 objectAtIndex: 2] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                        vi_uno = gsl_vector_get (vars, k) ;
                        }
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 3] stringByTrimmingSpaces] ])
                        {
                        angi_uno = [[objetoMov1 objectAtIndex: 3] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 3] stringByTrimmingSpaces]] ;
                        angi_uno = gsl_vector_get (vars, k) ;
                        }                                    
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 4] stringByTrimmingSpaces] ])
                        {
                        vf_uno = [[objetoMov1 objectAtIndex: 4] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 4] stringByTrimmingSpaces]] ;
                        vf_uno = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov1 objectAtIndex: 5] stringByTrimmingSpaces] ])
                        {
                        angf_uno = [[objetoMov1 objectAtIndex: 5] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov1 objectAtIndex: 5] stringByTrimmingSpaces]] ;
                        angf_uno = gsl_vector_get (vars, k) ;
                        }                              
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 2] stringByTrimmingSpaces] ])
                        {
                        vi_dos = [[objetoMov2 objectAtIndex: 2] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                        vi_dos = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 3] stringByTrimmingSpaces] ])
                        {
                        angi_dos = [[objetoMov2 objectAtIndex: 3] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 3] stringByTrimmingSpaces]] ;
                        angi_dos = gsl_vector_get (vars, k) ;
                        }                              
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 4] stringByTrimmingSpaces] ])
                        {
                        vf_dos = [[objetoMov2 objectAtIndex: 4] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 4] stringByTrimmingSpaces]] ;
                        vf_dos = gsl_vector_get (vars, k) ;
                        }      
                        
                      if(![variables containsObject: [[objetoMov2 objectAtIndex: 5] stringByTrimmingSpaces] ])
                        {
                        angf_dos = [[objetoMov2 objectAtIndex: 5] doubleValue] ;
                        }
                      else
                        {
                        int k = [variables indexOfObject: [[objetoMov2 objectAtIndex: 5] stringByTrimmingSpaces]] ;
                        angf_dos = gsl_vector_get (vars, k) ;
                        } 
                        
                      if(angn > 90)
                      {
                      angn = angn - 180 ;
                      }
                        
                 //Se establecen las ecuaciones
                 gsl_vector_set (func, nEcu, m1*vi_uno*cos(M_PI*(angi_uno - angn)/180) + m2*vi_dos*cos(M_PI*(angi_dos - angn)/180) -m1*vf_uno*cos(M_PI*(angf_uno - angn)/180) - m2*vf_dos*cos(M_PI*(angf_dos - angn)/180)); 
                 gsl_vector_set (func, nEcu + 1, e*(vi_uno*cos(M_PI*(angi_uno - angn)/180) - vi_dos*cos(M_PI*(angi_dos - angn)/180)) - (vf_dos*cos(M_PI*(angf_dos - angn)/180) - vf_uno*cos(M_PI*(angf_uno - angn)/180)) ); 
                 gsl_vector_set (func, nEcu + 2, vi_uno*sin(M_PI*(angi_uno - angn)/180) - vf_uno*sin(M_PI*(angf_uno - angn)/180) ); 
                 gsl_vector_set (func, nEcu + 3, vi_dos*sin(M_PI*(angi_dos - angn)/180) - vf_dos*sin(M_PI*(angf_dos - angn)/180) );                          
                 nEcu = nEcu + 4 ;                                   
                 }
            
       }
       
//Objetos energia, relacion entre distancias recorridas, explosion y movimiento relativo
       NSEnumerator *enumOtros = [otros objectEnumerator] ;
       
       while((objeto = [enumOtros nextObject]))
       {
       NSNumber *tipo = [[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
       
           switch([tipo intValue])
           {
           case 139:
                 {
                 double trab ;
                 double masa[4] = {0} ;
                 double vInicial[4] = {0} ;
                 double vFinal[4] = {0} ;
                 double dist[4] = {0} ;
                 double angs[4] = {0} ;
                 double kres[4] = {0} ;
                 double xsi[4] = {0} ;
                 double xsf[4] = {0} ;
                                      
                 NSMutableArray *otrosObj = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
                 NSMutableArray *codEnergia = [NSMutableArray array] ;
                 NSMutableArray *energia = [NSMutableArray array] ;
      
                 NSNumber *obj1, *obj2, *obj3, *obj4, *objetos ;                 
                 NSString *nomObjeto1 = [[otrosObj objectAtIndex: 0] stringByTrimmingSpaces] ;
                 NSString *nomObjeto2 = [[otrosObj objectAtIndex: 1] stringByTrimmingSpaces] ;
                 NSString *nomObjeto3 = [[otrosObj objectAtIndex: 2] stringByTrimmingSpaces] ;
                 NSString *nomObjeto4 = [[otrosObj objectAtIndex: 3] stringByTrimmingSpaces] ;                                  
                 NSMutableArray *objeto1, *objeto2, *objeto3, *objeto4 ;
                 NSEnumerator *buscar = [diccionario objectEnumerator] ;
                 NSMutableDictionary *buscarNombre ;
                 
                 while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if([titulo isEqualToString: @"Nombre"]) 
                             { 
                             if( ([nomObjeto1 isEqualToString: nombre]) && ([nomObjeto1 length] > 0) && ![nomObjeto1 isEqualToString: @"0"] )
                                {
                                obj1 = [buscarNombre objectForKey: @"Tipo"] ;
                                objeto1 = [buscarNombre objectForKey: @"Valores"] ;
                                [codEnergia addObject: obj1] ;
                                [energia addObject: objeto1] ;
                                }
                                
                            if( ([nomObjeto2 isEqualToString: nombre]) && ([nomObjeto2 length] > 0) && ![nomObjeto2 isEqualToString: @"0"]  )
                                {
                                obj2 = [buscarNombre objectForKey: @"Tipo"] ;                                
                                objeto2 = [buscarNombre objectForKey: @"Valores"] ;
                                [codEnergia addObject: obj2] ;
                                [energia addObject: objeto2] ;
                                }
                                
                            if( ([nomObjeto3 isEqualToString: nombre]) && ([nomObjeto3 length] > 0) && ![nomObjeto3 isEqualToString: @"0"]  )
                                {
                                obj3 = [buscarNombre objectForKey: @"Tipo"] ;                                
                                objeto3 = [buscarNombre objectForKey: @"Valores"] ;
                                [codEnergia addObject: obj3] ;
                                [energia addObject: objeto3] ;
                                }   
                                
                            if( ([nomObjeto4 isEqualToString: nombre]) && ([nomObjeto4 length] > 0) && ![nomObjeto4 isEqualToString: @"0"]  )
                                {
                                obj4 = [buscarNombre objectForKey: @"Tipo"] ;                                
                                objeto4 = [buscarNombre objectForKey: @"Valores"] ;
                                [codEnergia addObject: obj4] ;
                                [energia addObject: objeto4] ;
                                }
                            } 
                          }
                 
                 int conteoMov = 0, conteoRes = 0, conteo = 0, clase ;   
                 int vi, vf, d, ang ;      
                 NSEnumerator *datos = [codEnergia objectEnumerator] ; 
                          while((objetos = [datos nextObject]))
                          {
                          clase = 0 ;
                            if( ([objetos intValue] >= 101) && ([objetos intValue] <= 107) )
                            {
                               switch([objetos intValue])
                                   {
                                   case 101:
                                        {
                                        vi = 2 ;
                                        vf = 4 ;
                                        }
                                        break;
                                   case 102:
                                   case 103:
                                        {
                                        vi = 2 ;
                                        vf = 3 ;
                                        }
                                        break;
                                   case 104:
                                        {
                                        vi = 3 ;
                                        vf = 4 ;
                                        d = 5 ;
                                        clase = 1 ;
                                        }
                                        break;
                                   case 105:
                                        {
                                        vi = 3 ;
                                        vf = 4 ;                                        
                                        }
                                        break;     
                                   case 106:
                                   case 107:
                                        {
                                        vi = 4 ;
                                        vf = 5 ;
                                        d = 6 ;
                                        ang = 2 ;
                                        clase =2 ;
                                        }
                                        break ;
                                   }
                              
                              //Se agregan los datos
                                 if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: 1] stringByTrimmingSpaces]])
                                     {
                                     masa[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: 1] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: 1] stringByTrimmingSpaces] ] ;
                                     masa[conteoMov] = gsl_vector_get (vars, k) ;
                                     }
                              
                                  if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: vi] stringByTrimmingSpaces]])
                                     {
                                     vInicial[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: vi] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: vi] stringByTrimmingSpaces] ] ;
                                     vInicial[conteoMov] = gsl_vector_get (vars, k) ;
                                     }   
                                     
                                  if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: vf] stringByTrimmingSpaces]])
                                     {
                                     vFinal[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: vf] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: vf] stringByTrimmingSpaces] ] ;
                                     vFinal[conteoMov] = gsl_vector_get (vars, k) ;
                                     }
                                     
                                     if(clase == 1)
                                     {
                                          if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: d] stringByTrimmingSpaces]])
                                          {
                                          dist[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: d] doubleValue] ;
                                          }
                                          else
                                          {
                                          int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: d] stringByTrimmingSpaces] ] ;
                                          dist[conteoMov] = gsl_vector_get (vars, k) ;
                                          }                                     
                                     }
                                     
                                     if(clase == 2)
                                     {
                                          if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: d] stringByTrimmingSpaces]])
                                          {
                                          dist[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: d] doubleValue] ;
                                          }
                                          else
                                          {
                                          int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: d] stringByTrimmingSpaces] ] ;
                                          dist[conteoMov] = gsl_vector_get (vars, k) ;
                                          }  
                                          
                                          if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: ang] stringByTrimmingSpaces]])
                                          {
                                          angs[conteoMov] = [[[energia objectAtIndex: conteo] objectAtIndex: ang] doubleValue] ;
                                          }
                                          else
                                          {
                                          int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: ang] stringByTrimmingSpaces] ] ;
                                          angs[conteoMov] = gsl_vector_get (vars, k) ;
                                          }    
                                     }
                                      
                                     conteo = conteo + 1 ;  
                                     conteoMov = conteoMov + 1 ;
                              }
                              else
                              {
                                  if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: 1] stringByTrimmingSpaces]])
                                     {
                                     kres[conteoRes] = [[[energia objectAtIndex: conteo] objectAtIndex: 1] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: 1] stringByTrimmingSpaces] ] ;
                                     kres[conteoRes] = gsl_vector_get (vars, k) ;
                                     }
                                     
                                  if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: 2] stringByTrimmingSpaces]])
                                     {
                                     xsi[conteoRes] = [[[energia objectAtIndex: conteo] objectAtIndex: 2] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: 2] stringByTrimmingSpaces] ] ;
                                     xsi[conteoRes] = gsl_vector_get (vars, k) ;
                                     }
                                     
                                  if(![variables containsObject: [[[energia objectAtIndex: conteo] objectAtIndex: 3] stringByTrimmingSpaces]])
                                     {
                                     xsf[conteoRes] = [[[energia objectAtIndex: conteo] objectAtIndex: 3] doubleValue] ;
                                     }
                                  else
                                     {
                                     int k = [variables indexOfObject: [[[energia objectAtIndex: conteo] objectAtIndex: 3] stringByTrimmingSpaces] ] ;
                                     xsf[conteoRes] = gsl_vector_get (vars, k) ;
                                     }
                                
                              conteo = conteo + 1 ;
                              conteoRes = conteoRes + 1 ;            
                              }
                          }
                          
                 //Se establecen las ecuaciones
                 if(![variables containsObject: [[otrosObj objectAtIndex: 4] stringByTrimmingSpaces] ])
                   {
                   trab = [[otrosObj objectAtIndex: 4] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 4] stringByTrimmingSpaces]] ;
                   trab = gsl_vector_get (vars, k) ;
                   }
                 
                 //Se establece la ecuacion  
                 gsl_vector_set (func, nEcu, 0.5*(masa[0]*vFinal[0]*vFinal[0] + masa[1]*vFinal[1]*vFinal[1] + masa[2]*vFinal[2]*vFinal[2] + masa[3]*vFinal[3]*vFinal[3]) - 0.5*(masa[0]*vInicial[0]*vInicial[0] + masa[1]*vInicial[1]*vInicial[1] + masa[2]*vInicial[2]*vInicial[2] + masa[3]*vInicial[3]*vInicial[3]) + gf*(masa[0]*dist[0]*sin(M_PI*angs[0]/180) + masa[1]*dist[1]*sin(M_PI*angs[1]/180) + masa[2]*dist[2]*sin(M_PI*angs[2]/180) + masa[3]*dist[3]*sin(M_PI*angs[3]/180)) + (0.5*kres[0]*(xsf[0]*xsf[0] - xsi[0]*xsi[0])) + (0.5*kres[1]*(xsi[1]*xsi[1] - xsf[1]*xsf[1])) + (0.5*kres[2]*(xsi[2]*xsi[2] - xsf[2]*xsf[2])) + (0.5*kres[3]*(xsi[3]*xsi[3] - xsf[3]*xsf[3])) - trab );
                 
                 nEcu = nEcu + 1 ;
                 }
                 break;
           case 143:
                 {
                 int indiceNom ;
                 double a_sf, ang_asf, vf_sf, ang_vfsf, d_sf, ang_dsf ;
                 
                 NSMutableArray *otrosObj = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
      
                 NSNumber *obj1, *obj2 ;                 
                 NSString *nomObjeto1 = [[otrosObj objectAtIndex: 0] stringByTrimmingSpaces] ;
                 NSMutableArray *objeto1, *objeto2 ;
                 NSEnumerator *buscar = [diccionario objectEnumerator] ;
                 NSMutableDictionary *buscarNombre ;
                 
                 while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if([titulo isEqualToString: @"Nombre"]) 
                             { 
                           if( ([nomObjeto1 isEqualToString: nombre]) && ([nomObjeto1 length] > 0) && ![nomObjeto1 isEqualToString: @"0"] )
                                {
                                obj1 = [buscarNombre objectForKey: @"Tipo"] ;
                                objeto1 = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             } 
                          }
                
               if( ([obj1 intValue] == 104) || ([obj1 intValue] == 105) )
               {
               indiceNom = 6 ;
               }
               else
               {
               indiceNom = 7 ;
               }

               NSString *nomObjeto2 = [[objeto1 objectAtIndex: indiceNom] stringByTrimmingSpaces] ;
               buscar = [diccionario objectEnumerator] ;
                                    
                 while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if([titulo isEqualToString: @"Nombre"]) 
                             { 
                          if( ([nomObjeto2 isEqualToString: nombre]) && ([nomObjeto2 length] > 0) && ![nomObjeto2 isEqualToString: @"0"]  )
                                {
                                obj2 = [buscarNombre objectForKey: @"Tipo"] ;                                
                                objeto2 = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             } 
                          }
                          
                 if(![variables containsObject: [[otrosObj objectAtIndex: 1] stringByTrimmingSpaces] ])
                   {
                   a_sf = [[otrosObj objectAtIndex: 1] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 1] stringByTrimmingSpaces]] ;
                   a_sf = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[otrosObj objectAtIndex: 2] stringByTrimmingSpaces] ])
                   {
                   ang_asf = [[otrosObj objectAtIndex: 2] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 2] stringByTrimmingSpaces]] ;
                   ang_asf = gsl_vector_get (vars, k) ;
                   }                   
                        
                 if(![variables containsObject: [[otrosObj objectAtIndex: 3] stringByTrimmingSpaces] ])
                   {
                   vf_sf = [[otrosObj objectAtIndex: 3] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 3] stringByTrimmingSpaces]] ;
                   vf_sf = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[otrosObj objectAtIndex: 4] stringByTrimmingSpaces] ])
                   {
                   ang_vfsf = [[otrosObj objectAtIndex: 4] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 4] stringByTrimmingSpaces]] ;
                   ang_vfsf = gsl_vector_get (vars, k) ;
                   }                   
                     
                   if(![variables containsObject: [[otrosObj objectAtIndex: 5] stringByTrimmingSpaces] ])
                   {
                   d_sf = [[otrosObj objectAtIndex: 5] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 5] stringByTrimmingSpaces]] ;
                   d_sf = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[otrosObj objectAtIndex: 6] stringByTrimmingSpaces] ])
                   {
                   ang_dsf = [[otrosObj objectAtIndex: 6] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[otrosObj objectAtIndex: 6] stringByTrimmingSpaces]] ;
                   ang_dsf = gsl_vector_get (vars, k) ;
                   }         
                 
                 int indice1, indice2, signo1 = 1, signo2 = 1 ;    
                 double a1, vf1, d1, ang1, a2, vf2, d2, ang2 ;      
                 
                 if( ([obj1 intValue] == 104) || ([obj1 intValue] == 105) )
                 {
                 ang1 = 0 ;
                 indice1 = 2 ;
                 }
                 else
                 {
                     if(![variables containsObject: [[objeto1 objectAtIndex: 2] stringByTrimmingSpaces] ])
                       {
                       ang1 = [[objeto1 objectAtIndex: 2] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto1 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                       ang1 = gsl_vector_get (vars, k) ;
                       } 
                       
                 indice1 = 3 ;   
                 
                    if([obj1 intValue] == 107)
                    {
                    signo1 = -1 ;
                    }       
                 }
                 
                     if(![variables containsObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces] ])
                       {
                       a1 = [[objeto1 objectAtIndex: indice1] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces]] ;
                       a1 = gsl_vector_get (vars, k) ;
                       }     
                 
                     indice1 = indice1 + 2 ;  
                     if(![variables containsObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces] ])
                       {
                       vf1 = [[objeto1 objectAtIndex: indice1] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces]] ;
                       vf1 = gsl_vector_get (vars, k) ;
                       } 
                      
                     indice1 = indice1 + 1 ;   
                     if(![variables containsObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces] ])
                       {
                       d1 = [[objeto1 objectAtIndex: indice1] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto1 objectAtIndex: indice1] stringByTrimmingSpaces]] ;
                       d1 = gsl_vector_get (vars, k) ;
                       }       

                 if( ([obj2 intValue] == 104) || ([obj2 intValue] == 105) )
                 {
                 ang2 = 0 ;
                 indice2 = 2 ;
                 }
                 else
                 {
                     if(![variables containsObject: [[objeto2 objectAtIndex: 2] stringByTrimmingSpaces] ])
                       {
                       ang2 = [[objeto2 objectAtIndex: 2] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto2 objectAtIndex: 2] stringByTrimmingSpaces]] ;
                       ang2 = gsl_vector_get (vars, k) ;
                       } 
                       
                 indice2 = 3 ;
                 
                    if([obj2 intValue] == 107)
                    {
                    signo2 = -1 ;
                    }            
                 }
                 
                     if(![variables containsObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces] ])
                       {
                       a2 = [[objeto2 objectAtIndex: indice2] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces]] ;
                       a2 = gsl_vector_get (vars, k) ;
                       }     
                 
                     indice2 = indice2 + 2 ;  
                     if(![variables containsObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces] ])
                       {
                       vf2 = [[objeto2 objectAtIndex: indice2] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces]] ;
                       vf2 = gsl_vector_get (vars, k) ;
                       } 
                     
                     indice2 = indice2 + 1 ;    
                     if(![variables containsObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces] ])
                       {
                       d2 = [[objeto2 objectAtIndex: indice2] doubleValue] ;
                       }
                     else
                       {
                       int k = [variables indexOfObject: [[objeto2 objectAtIndex: indice2] stringByTrimmingSpaces]] ;
                       d2 = gsl_vector_get (vars, k) ;
                       }
                 
                 //Se establecen las ecuaciones
                 gsl_vector_set (func, nEcu, signo1*a1*cos(M_PI*ang1/180) + signo2*a2*cos(M_PI*ang2/180) - a_sf*cos(M_PI*ang_asf/180)) ;
                 gsl_vector_set (func, nEcu + 1, a1*sin(M_PI*ang1/180) + a2*sin(M_PI*ang2/180) - a_sf*sin(M_PI*ang_asf/180)) ;
                 gsl_vector_set (func, nEcu + 2, signo1*vf1*cos(M_PI*ang1/180) + signo2*vf2*cos(M_PI*ang2/180) - vf_sf*cos(M_PI*ang_vfsf/180)) ;
                 gsl_vector_set (func, nEcu + 3, vf1*sin(M_PI*ang1/180) + vf2*sin(M_PI*ang2/180) - vf_sf*sin(M_PI*ang_vfsf/180)) ;
                 gsl_vector_set (func, nEcu + 4, signo1*d1*cos(M_PI*ang1/180) + signo2*d2*cos(M_PI*ang2/180) - d_sf*cos(M_PI*ang_dsf/180)) ;
                 gsl_vector_set (func, nEcu + 5, d1*sin(M_PI*ang1/180) + d2*sin(M_PI*ang2/180) - d_sf*sin(M_PI*ang_dsf/180)) ;
                 
                 nEcu = nEcu + 6 ;    
                 }
                 break; 
           case 144:
                 {
                 double m, vi, ang, m1, v1, ang1, m2, v2, ang2, m3, v3, ang3, m4, v4, ang4, ener ;
                 NSMutableArray *datosRel = [[diccionario objectForKey: objeto] objectForKey: @"Valores"] ;
                 
                  if(![variables containsObject: [[datosRel objectAtIndex: 0] stringByTrimmingSpaces] ])
                   {
                   m = [[datosRel objectAtIndex: 0] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 0] stringByTrimmingSpaces]] ;
                   m = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 1] stringByTrimmingSpaces] ])
                   {
                   vi = [[datosRel objectAtIndex: 1] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 1] stringByTrimmingSpaces]] ;
                   vi = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 2] stringByTrimmingSpaces] ])
                   {
                   ang = [[datosRel objectAtIndex: 2] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 2] stringByTrimmingSpaces]] ;
                   ang = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 3] stringByTrimmingSpaces] ])
                   {
                   m1 = [[datosRel objectAtIndex: 3] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 3] stringByTrimmingSpaces]] ;
                   m1 = gsl_vector_get (vars, k) ;
                   }
                   
                if(![variables containsObject: [[datosRel objectAtIndex: 4] stringByTrimmingSpaces] ])
                   {
                   v1 = [[datosRel objectAtIndex: 4] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 4] stringByTrimmingSpaces]] ;
                   v1 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 5] stringByTrimmingSpaces] ])
                   {
                   ang1 = [[datosRel objectAtIndex: 5] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 5] stringByTrimmingSpaces]] ;
                   ang1 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 6] stringByTrimmingSpaces] ])
                   {
                   m2 = [[datosRel objectAtIndex: 6] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 6] stringByTrimmingSpaces]] ;
                   m2 = gsl_vector_get (vars, k) ;
                   }
                   
                if(![variables containsObject: [[datosRel objectAtIndex: 7] stringByTrimmingSpaces] ])
                   {
                   v2 = [[datosRel objectAtIndex: 7] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 7] stringByTrimmingSpaces]] ;
                   v2 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 8] stringByTrimmingSpaces] ])
                   {
                   ang2 = [[datosRel objectAtIndex: 8] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 8] stringByTrimmingSpaces]] ;
                   ang2 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 9] stringByTrimmingSpaces] ])
                   {
                   m3 = [[datosRel objectAtIndex: 9] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 9] stringByTrimmingSpaces]] ;
                   m3 = gsl_vector_get (vars, k) ;
                   }
                   
                if(![variables containsObject: [[datosRel objectAtIndex: 10] stringByTrimmingSpaces] ])
                   {
                   v3 = [[datosRel objectAtIndex: 10] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 10] stringByTrimmingSpaces]] ;
                   v3 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 11] stringByTrimmingSpaces] ])
                   {
                   ang3 = [[datosRel objectAtIndex: 11] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 11] stringByTrimmingSpaces]] ;
                   ang3 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 12] stringByTrimmingSpaces] ])
                   {
                   m4 = [[datosRel objectAtIndex: 12] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 12] stringByTrimmingSpaces]] ;
                   m4 = gsl_vector_get (vars, k) ;
                   }
                   
                if(![variables containsObject: [[datosRel objectAtIndex: 13] stringByTrimmingSpaces] ])
                   {
                   v4 = [[datosRel objectAtIndex: 13] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 13] stringByTrimmingSpaces]] ;
                   v4 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 14] stringByTrimmingSpaces] ])
                   {
                   ang4 = [[datosRel objectAtIndex: 14] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 14] stringByTrimmingSpaces]] ;
                   ang4 = gsl_vector_get (vars, k) ;
                   }
                   
                 if(![variables containsObject: [[datosRel objectAtIndex: 15] stringByTrimmingSpaces] ])
                   {
                   ener = [[datosRel objectAtIndex: 15] doubleValue] ;
                   }
                 else
                   {
                   int k = [variables indexOfObject: [[datosRel objectAtIndex: 15] stringByTrimmingSpaces]] ;
                   ener = gsl_vector_get (vars, k) ;
                   }
                   
                 //Se establecen las ecuaciones
                 gsl_vector_set (func, nEcu, m1*v1*cos(M_PI*ang1/180) + m2*v2*cos(M_PI*ang2/180) + m3*v3*cos(M_PI*ang3/180) + m4*v4*cos(M_PI*ang4/180) - m*vi*cos(M_PI*ang/180)) ;
                 gsl_vector_set (func, nEcu + 1, m1*v1*sin(M_PI*ang1/180) + m2*v2*sin(M_PI*ang2/180) + m3*v3*sin(M_PI*ang3/180) + m4*v4*sin(M_PI*ang4/180) - m*vi*sin(M_PI*ang/180)) ;
                 gsl_vector_set (func, nEcu + 2, 0.5*(m1*v1*v1 + m2*v2*v2 + m3*v3*v3 + m4*v4*v4) - 0.5*m*vi*vi - ener) ;
                    
                 nEcu = nEcu + 3 ;  
                 }
                 break;                
           }
       }              

//Objetos momento
       int contImp = 0 ;
       NSNumber *tipoObj ;
       NSEnumerator *enumImp = [impulsos objectEnumerator] ;
       
       while((objeto = [enumImp nextObject]))
       {
       double m, vi, vf, imp, ang, vi_mov, angi, vf_mov, angf, f_imp ;

       NSEnumerator *buscar = [diccionario objectEnumerator] ;
       NSMutableArray *objetoDatos ;
       NSMutableDictionary *buscarNombre ;
       NSString *nomObjeto = [[impulsosObj objectAtIndex: contImp] stringByTrimmingSpaces] ;
       
       if(![variables containsObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
         {
         imp = [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
         }
       else
         {
         int k = [variables indexOfObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
         imp = gsl_vector_get (vars, k) ;
         }
         
      if(![variables containsObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces] ])
         {
         ang = [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 2] doubleValue] ;
         }
       else
         {
         int k = [variables indexOfObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 2] stringByTrimmingSpaces]] ;
         ang = gsl_vector_get (vars, k) ;
         }
         
      if(![variables containsObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 3] stringByTrimmingSpaces] ])
         {
         f_imp = [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 3] doubleValue] ;
         }
       else
         {
         int k = [variables indexOfObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 3] stringByTrimmingSpaces]] ;
         f_imp = gsl_vector_get (vars, k) ;
         }
                 
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoObj = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
            
                  switch([tipoObj intValue])
                  {
                  case 101:
                      {
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                           {
                           vi_mov = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                           vi_mov = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                           {
                           angi = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                           angi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces] ])
                           {
                           vf_mov = [[objetoDatos objectAtIndex: 4] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces]] ;
                           vf_mov = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces] ])
                           {
                           angf = [[objetoDatos objectAtIndex: 5] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces]] ;
                           angf = gsl_vector_get (vars, k) ;
                           }
                      }
                      break;
                  case 102:
                  case 103:
                      {
                        if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                           {
                           vi = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                           vi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                           {
                           vf = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                           vf = gsl_vector_get (vars, k) ;
                           }
                      }
                      break;
                  case 104:
                  case 105:
                      {
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                           {
                           vi = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                           vi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces] ])
                           {
                           vf = [[objetoDatos objectAtIndex: 4] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces]] ;
                           vf = gsl_vector_get (vars, k) ;
                           }
                      }
                      break;
                  case 106:
                  case 107:
                      {
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces] ])
                           {
                           vi = [[objetoDatos objectAtIndex: 4] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces]] ;
                           vi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces] ])
                           {
                           vf = [[objetoDatos objectAtIndex: 5] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces]] ;
                           vf = gsl_vector_get (vars, k) ;
                           }
                      }
                      break;
                  }            
        
       //Se establecen las ecuaciones
       if([tipoObj intValue] == 101)
       {
       gsl_vector_set (func, nEcu, m*vf_mov*cos(M_PI*angf/180) + m*vi_mov*cos(M_PI*angi/180) - imp*cos(M_PI*ang/180) ) ;
       gsl_vector_set (func, nEcu + 1, m*vf_mov*sin(M_PI*angf/180) + m*vi_mov*sin(M_PI*angi/180) - imp*sin(M_PI*ang/180) ) ;
       gsl_vector_set (func, nEcu + 2, (sqrt(imp*imp)/tf) - f_imp) ;
       
       nEcu = nEcu + 3 ;
       }
       else
       {
       gsl_vector_set (func, nEcu, m*vf - m*vi - imp) ;
       gsl_vector_set (func, nEcu + 1, (sqrt(imp*imp)/tf) - f_imp) ;
       
       nEcu = nEcu + 2 ;
       }
       
       contImp = contImp + 1 ;
       }
       
//Objetos potencia
       int contPot = 0 ;
       NSNumber *tipoPot ;
       NSEnumerator *enumPot = [potencias objectEnumerator] ;
       
       while((objeto = [enumPot nextObject]))
       {
       double m, vi, vf, d, ang = 0, potencia ;

       NSEnumerator *buscar = [diccionario objectEnumerator] ;
       NSMutableArray *objetoDatos ;
       NSMutableDictionary *buscarNombre ;
       NSString *nomObjeto = [[potenciasObj objectAtIndex: contPot] stringByTrimmingSpaces] ;
       
       if(![variables containsObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ])
         {
         potencia = [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
         }
       else
         {
         int k = [variables indexOfObject: [[[[diccionario objectForKey: objeto] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces]] ;
         potencia = gsl_vector_get (vars, k) ;
         }
         
                   while ((buscarNombre = [buscar nextObject]))
                          {
                          NSString *nombre = [[[buscarNombre objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          NSString *titulo = [[[buscarNombre objectForKey: @"Titulos"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          
                           if ([titulo isEqualToString: @"Nombre"])
                             { 
                             if ([nomObjeto isEqualToString: nombre])
                                {
                                tipoPot = [buscarNombre objectForKey: @"Tipo"] ;
                                objetoDatos = [buscarNombre objectForKey: @"Valores"] ;
                                }
                             }   
                          }
                          
                  switch([tipoPot intValue])
                  {
                  case 104:
                  case 105:
                       {
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces] ])
                           {
                           vi = [[objetoDatos objectAtIndex: 3] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 3] stringByTrimmingSpaces]] ;
                           vi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces] ])
                           {
                           vf = [[objetoDatos objectAtIndex: 4] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces]] ;
                           vf = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces] ])
                           {
                           d = [[objetoDatos objectAtIndex: 5] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces]] ;
                           d = gsl_vector_get (vars, k) ;
                           }
                      }
                      break;
                  case 106:
                  case 107:
                      {
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces] ])
                           {
                           m = [[objetoDatos objectAtIndex: 1] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                           m = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces] ])
                           {
                           vi = [[objetoDatos objectAtIndex: 4] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 4] stringByTrimmingSpaces]] ;
                           vi = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces] ])
                           {
                           vf = [[objetoDatos objectAtIndex: 5] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 5] stringByTrimmingSpaces]] ;
                           vf = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces] ])
                           {
                           ang = [[objetoDatos objectAtIndex: 2] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
                           ang = gsl_vector_get (vars, k) ;
                           }
                           
                         if(![variables containsObject: [[objetoDatos objectAtIndex: 6] stringByTrimmingSpaces] ])
                           {
                           d = [[objetoDatos objectAtIndex: 6] doubleValue] ;
                           }
                         else
                           {
                           int k = [variables indexOfObject: [[objetoDatos objectAtIndex: 6] stringByTrimmingSpaces]] ;
                           d = gsl_vector_get (vars, k) ;
                           }
                      }
                      break; 
                }
               
       //Se establece la ecuacion
       
       gsl_vector_set (func, nEcu, (0.5*m*(vf*vf - vi*vi) + m*gf*d*cos(M_PI*ang/180))/tf - potencia) ;
       
       nEcu = nEcu + 1 ;
       contPot = contPot + 1 ;
       }                                       
              
return 0 ;       
}

@implementation dinamicaPuntual

- (void) awakeFromNib
{
variables = [NSMutableArray array] ;
[variables retain] ;
codObjetos = [NSMutableArray array] ;
[codObjetos retain] ;
fuerObj = [NSMutableArray array] ;
[fuerObj retain] ;
tipoFuer = [NSMutableArray array] ;
[tipoFuer retain] ;
codCol = [NSMutableArray array] ;
[codCol retain] ;
codObjCol = [NSMutableArray array] ;
[codObjCol retain] ;
tipoCol = [NSMutableArray array] ;
[tipoCol retain] ;
codObjetosContenidos = [NSMutableArray array] ;
[codObjetosContenidos retain] ;
codRel = [NSMutableArray array] ;
[codRel retain] ;
otros = [NSMutableArray array] ;
[otros retain] ;
impulsos = [NSMutableArray array] ;
[impulsos retain] ;
impulsosObj = [NSMutableArray array] ;
[impulsosObj retain] ;
potencias = [NSMutableArray array] ;
[potencias retain] ;
potenciasObj = [NSMutableArray array] ;
[potenciasObj retain] ;

//Se crea el array de mensajes
NSBundle *mensajes = [NSBundle mainBundle] ;
errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"dinamicaMensajes" ofType: @"plist"] ] ;

NSString *siFactores = [NSString stringWithString: @"1/1/1/1/1/1/1/1/1/1/1/1/3600/60/745.69987/735.49875/1000/0.001/14.59/1000/0.01/0.001/1609.3/0.3048/39.37E-1/0.277777778/0.01/0.001/2.28E-1/0.3048/39.37E-1/5144/0.01/0.001/0.3048/39.37E-1"] ;
NSString *siKeys = [NSString stringWithString: @"s-N/m-N-J-W-N*s-kg-grados-ad-m-m/s-m/s2-h-min-hp-cv-T-g-slug-km-cm-mm-mi-ft-in-km/h-cm/s-mm/s-mph-ft/s-in/s-nudo-cm/s2-mm/s2-ft/s2-in/s2"] ;
NSDictionary *si = [NSDictionary dictionaryWithObjects: [siFactores componentsSeparatedByString: @"/"] forKeys: [siKeys componentsSeparatedByString: @"-"]] ;

NSString *inglesFactores = [NSString stringWithString: @"1/1/1/1/1/1/1/1/1/1/1/1/3600/60/550/557.639663388/0.06852/0.00006852/3280.992/3.281/0.03281/0.003281/5280/12E-1/0.911388889/3.281/0.03281/0.003281/1.466666667/12E-1/1.688133333/3.281/0.03281/0.003281/12E-1/12"] ;
NSString *inglesKeys = [NSString stringWithString: @"s-lb/ft-lb-slug-lb*ft-lb*ft/s-lb*s-grados-ad-ft-ft/s-ft/s2-h-min-hp-cv-kg-g-km-m-cm-mm-mi-in-km/h-m/s-cm/s-mm/s-mph-in/s-nudo-m/s2-cm/s2-mm/s2-in/s2-lb/in"] ;

NSDictionary *ingles = [NSDictionary dictionaryWithObjects: [inglesFactores componentsSeparatedByString: @"/"] forKeys: [inglesKeys componentsSeparatedByString: @"-"]] ;

conversiones = [NSArray arrayWithObjects: si, ingles, nil ] ;
[conversiones retain] ;
}

- (void) setSistema: (int)eleccion
{
  /* insert your code here */
  sistema = eleccion ;
}

- (void) celdas: (NSArray *)pizarra
{
  /* insert your code here */
  ordenObjetos = [[NSArray alloc] initWithArray: pizarra] ;     
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  /* insert your code here */
int longitud, numEcuaciones = 0, numFuerzas = 0, numFuerObj = 0 ;
mensajeFr = NO ;
BOOL error = NO ;
BOOL errorFuer = NO ;
BOOL errorCol = NO ;
BOOL errorImp = NO ;
BOOL errorPot = NO ;
BOOL errorMovRel = NO ;
BOOL errorBlocRel = NO ;

varT = 0 ;
varG = 0 ;
tiempoDat = 0 ;
gravedadDat = 0 ;
NSNumber *identificador, *codigo ;
[variables removeAllObjects] ;
[codObjetos removeAllObjects] ;
[fuerObj removeAllObjects] ;
[tipoFuer removeAllObjects] ;
[codRel removeAllObjects] ;
[codCol removeAllObjects] ;
[codObjCol removeAllObjects] ;
[tipoCol removeAllObjects] ;
[codObjetosContenidos removeAllObjects] ;
[otros removeAllObjects] ;
[impulsos removeAllObjects] ;
[impulsosObj removeAllObjects] ;
[potencias removeAllObjects] ;
[potenciasObj removeAllObjects] ;

NSString *mensaje ;
NSMutableArray *codFuerzas = [NSMutableArray array] ;
NSMutableArray *codFuerzasObj = [NSMutableArray array] ;
NSMutableArray *nomObjetos = [NSMutableArray array] ;
NSMutableArray *nomObjetosContenidos = [NSMutableArray array] ;
NSMutableArray *movRelObj = [NSMutableArray array] ;
NSMutableArray *objetoRel = [NSMutableArray array] ;
NSMutableArray *objetoRel_104 = [NSMutableArray array] ;
  
diccionario = [[NSMutableDictionary alloc] initWithDictionary: lista] ;
NSArray *keys = [[NSArray alloc] initWithArray: [lista allKeys]] ;
NSEnumerator *cuenta = [keys objectEnumerator] ;

//Para determinar las fuerzas que actuan en los objetos
int k ; 
NSButton *celda ;
  
while((codigo = [cuenta nextObject]) && !error) 
    {
    int x ;
    NSString *key ;
    NSArray *terminos ;
    NSNumber *numero ;
    identificador = [[diccionario objectForKey: codigo] objectForKey: @"Tipo"] ;
    NSMutableArray *titulos = [[diccionario objectForKey: codigo] objectForKey: @"Titulos"] ;
    NSMutableArray *datos = [[diccionario objectForKey: codigo] objectForKey: @"Datos"] ;
    NSMutableArray *valores = [[diccionario objectForKey: codigo] objectForKey: @"Valores"] ;
    [valores removeAllObjects] ;
    NSCharacterSet *numeros = [NSCharacterSet characterSetWithCharactersInString: @".-+0123456789E"] ;
       
//Cuenta la cantidad de variables en el sistema
    for(x = 0; x < [datos count]; x++)
         {
         NSCharacterSet *valor = [NSCharacterSet characterSetWithCharactersInString: [[datos objectAtIndex: x] stringByTrimmingSpaces]] ; 
        
         if(![numeros isSupersetOfSet: valor] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Nombre"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Objeto 1"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Objeto 2"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Objeto 3"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Objeto 4"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Objeto"] && ![[[titulos objectAtIndex: x] description] isEqualToString: @"Relativo a"])
                {
                    if([valor characterIsMember: '@'])
                    {
                    terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
                    NSCharacterSet *term1 = [NSCharacterSet characterSetWithCharactersInString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]] ; 
                    key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
                    
                    if([[[conversiones objectAtIndex: sistema] allKeys] containsObject: key])
                      {
                    
                    if([numeros isSupersetOfSet: term1])
                        {
                        numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[conversiones objectAtIndex: sistema] objectForKey: key] doubleValue] ] ;
                        [valores addObject: [numero stringValue]] ;
                        }
                        else
                        {
                        NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
                        var = [var stringByAppendingString: @"@"] ;
                        var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
                        
                               [valores addObject: var] ;
                               if(![variables containsObject: var])
                                    {
                                    [variables addObject: var] ;
                                    }
                                    
                        }
                      }
                      else
                      {
                      longitud = [ [dinamicaPuntInfo textStorage] length];
                      NSString *anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
                      [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
                      error = YES ;
                      }
                    
                    }
                    else
                    {
                    //Se agrega una variable simple 
                               NSString *varTit, *varFactor ;   
                               NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;

			       //Se determina el tipo de variable
                               varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;

                               if([varTit hasPrefix: @"m"])
                                  {
                                         if(sistema== 0)
                                         { varFactor = [NSString stringWithString: @"kg"] ; }
                                         else
                                         { varFactor = [NSString stringWithString: @"slug"] ; } 
                                  }
                               else
                                  {
                                      if([varTit hasPrefix: @"f"] || [varTit hasPrefix: @"N"])
                                         {
                                             if(sistema== 0)
                                             { varFactor = [NSString stringWithString: @"N"] ; }
                                             else
                                             { varFactor = [NSString stringWithString: @"lb"] ; }
                                         }
                                      else
                                         {
                                              if([varTit hasPrefix: @"ang"])
                                                 {
                                                     { varFactor = [NSString stringWithString: @"grados"] ; } 
                                                 }
                                              else
                                                 {
                                                     if([varTit hasPrefix: @"g"] || [varTit hasPrefix: @"a"])
                                                        {
                                                            if(sistema== 0)
                                                            { varFactor = [NSString stringWithString: @"m/s2"] ; }
                                                            else
                                                            { varFactor = [NSString stringWithString: @"ft/s2"] ; }
                                                        }
                                                     else
                                                        {
                                                            if([varTit hasPrefix: @"x"] || [varTit hasPrefix: @"y"] || [varTit hasPrefix: @"d"])
                                                            {
                                                                  if(sistema== 0)
                                                                  { varFactor = [NSString stringWithString: @"m"] ; }
                                                                  else
                                                                  { varFactor = [NSString stringWithString: @"ft"] ; }
                                                             }
                                                            else
                                                            {
                                                                  if([varTit hasPrefix: @"v"]) 
                                                                  {
                                                                     if(sistema== 0)
                                                                     { varFactor = [NSString stringWithString: @"m/s"] ; }
                                                                     else
                                                                     { varFactor = [NSString stringWithString: @"ft/s"] ; } 
                                                                  }
                                                                  else
                                                                  {
                                                                     if([varTit hasPrefix: @"t"])
                                                                     {
                                                                     varFactor = [NSString stringWithString: @"s"] ;
                                                                     }
                                                                     else
                                                                     {
                                                                         if([varTit hasPrefix: @"k"])
                                                                         {
                                                                               if(sistema== 0)
                                                                               { varFactor = [NSString stringWithString: @"N/m"] ; }
                                                                               else
                                                                               { varFactor = [NSString stringWithString: @"lb/ft"] ; }   
                                                                         }
                                                                         else
                                                                         {
                                                                             if([varTit hasPrefix: @"T"] || [varTit hasPrefix: @"E"])
                                                                             {
                                                                                if(sistema== 0)
                                                                                { varFactor = [NSString stringWithString: @"J"] ; }
                                                                                else
                                                                                { varFactor = [NSString stringWithString: @"lb*ft"] ; } 
                                                                             }
                                                                             else
                                                                             {
                                                                                if([varTit hasPrefix: @"I"])
                                                                                {
                                                                                    if(sistema== 0)
                                                                                    { varFactor = [NSString stringWithString: @"N*s"] ; }
                                                                                    else
                                                                                    { varFactor = [NSString stringWithString: @"lb*s"] ; }
                                                                                }
                                                                                else
                                                                                {
                                                                                    if([varTit hasPrefix: @"P"])
                                                                                    {
                                                                                        if(sistema== 0)
                                                                                        { varFactor = [NSString stringWithString: @"W"] ; }
                                                                                        else
                                                                                        { varFactor = [NSString stringWithString: @"lb*m/s"] ; }
                                                                                    }
                                                                                    else
                                                                                    {
                                                                                    varFactor = [NSString stringWithString: @"ad"] ; 
                                                                                    }
                                                                                }
                                                                             }
                                                                         }
                                                                     }
                                                                  }  
                                                            }
                                                        }
                                                 }
                                         } 
                                  }
                               //Termina la busqueda del tipo de variable
	
                               var = [var stringByAppendingString: @"@"] ;
                               var = [var stringByAppendingString: varFactor] ;

                               [valores addObject: var] ;
                               if(![variables containsObject: var])
                                    {
                                    [variables addObject: var] ;
                                    }
  
                    //Se ha agregado la variable simple   
                    }
                }
          else
                {
                [valores addObject: [datos objectAtIndex: x]] ;
                }
         }    
//Fin del conteo de variables

if(error)
  break ;

//Establece el mensaje de advertencia en caso de que hayan fuerzas de friccion
if( ([identificador intValue] >= 117) && ([identificador intValue] <= 132) )
{
mensajeFr = YES ;
} 
  
//Determina la variable de la gravedad y el numero de ecuaciones
            switch ([identificador intValue])
            {
            case 100:
                {
                NSCharacterSet *grav = [NSCharacterSet characterSetWithCharactersInString: [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0] stringByTrimmingSpaces] ];
                NSCharacterSet *tiemp = [NSCharacterSet characterSetWithCharactersInString: [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 1] stringByTrimmingSpaces] ];
                
                          if(![numeros isSupersetOfSet: grav])
                          {
                          gravedadVar = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0]  stringByTrimmingSpaces] ;
                          varG = 1 ;
                          }
                          else
                          {
                          gravedadDat = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 0] doubleValue] ;
                          varG = 2 ;
                          }
                          
                          if(![numeros isSupersetOfSet: tiemp])
                          {
                          tiempoVar = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 1]  stringByTrimmingSpaces] ;
                          varT = 1 ;
                          }
                          else
                          {
                          tiempoDat = [[[[diccionario objectForKey: codigo] objectForKey: @"Valores"] objectAtIndex: 1] doubleValue] ;
                          varT = 2 ;
                          }
                
                }
                break;
            case 101:
                {
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
                [codObjetosContenidos addObject: codigo] ;
                }    
                break;
            case 102:
                {
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
                [codObjetosContenidos addObject: codigo] ;
                }
                break;
            case 103:
                {
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; 
                [codObjetosContenidos addObject: codigo] ;                               
                }
                break;
            case 104:
                {
                numEcuaciones = numEcuaciones + 4;
                [codObjetos addObject: codigo] ;
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
                [codObjetosContenidos addObject: codigo] ;
                if( ![[[datos objectAtIndex: 6] stringByTrimmingSpaces] isEqualToString: @"sf"] )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 6] stringByTrimmingSpaces] ] ;
                      [objetoRel_104 addObject: [[datos objectAtIndex: 6] stringByTrimmingSpaces] ] ; }
                }
                break;
            case 105:
                {
                numEcuaciones = numEcuaciones + 4;
                [codObjetos addObject: codigo] ;
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;                
                [codObjetosContenidos addObject: codigo] ;   
                if( ![[[datos objectAtIndex: 6] stringByTrimmingSpaces] isEqualToString: @"sf"] )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 6] stringByTrimmingSpaces] ] ;
                      [objetoRel addObject: [[datos objectAtIndex: 6] stringByTrimmingSpaces] ] ; }                
                }
                break;
            case 106:
                {
                numEcuaciones = numEcuaciones + 4;
                [codObjetos addObject: codigo] ;
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;                
                [codObjetosContenidos addObject: codigo] ;    
                if( ![[[datos objectAtIndex: 7] stringByTrimmingSpaces] isEqualToString: @"sf"] )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 7] stringByTrimmingSpaces] ] ; 
                      [objetoRel addObject: [[datos objectAtIndex: 7] stringByTrimmingSpaces] ] ; }                    
                }
                break;
            case 107:
                {
                numEcuaciones = numEcuaciones + 4;
                [codObjetos addObject: codigo] ;
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;                
                [codObjetosContenidos addObject: codigo] ;        
                if( ![[[datos objectAtIndex: 7] stringByTrimmingSpaces] isEqualToString: @"sf"] )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 7] stringByTrimmingSpaces] ] ; 
                      [objetoRel addObject: [[datos objectAtIndex: 7] stringByTrimmingSpaces] ] ; }           
                }
                break;                
            case 108:
                {
                numEcuaciones = numEcuaciones + 2;
                [codObjetos addObject: codigo] ;
                }
                break;
            case 109 ... 124:
                {
                numFuerzas = numFuerzas + 1 ;
                [codFuerzas addObject: codigo] ;
                }
                break;
            case 125 ... 132:
                {
                numFuerzas = numFuerzas + 1 ;
                [codFuerzas addObject: codigo] ;                
                }
                break;
            case 133 ... 136:
                {
                numEcuaciones = numEcuaciones + 1;
                [codObjetos addObject: codigo] ;
                [nomObjetos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
                [codObjetosContenidos addObject: codigo] ;  
                }
                break;                
            case 137:
                {
                numEcuaciones = numEcuaciones + 1;
                [codRel addObject: codigo] ;
                }
                break;
            case 138:
                {
                numEcuaciones = numEcuaciones + 4;
                [codCol addObject: codigo] ;
                [codObjCol addObject: [NSArray arrayWithObjects: [[datos objectAtIndex: 0] stringByTrimmingSpaces], [[datos objectAtIndex: 1] stringByTrimmingSpaces], nil] ] ;
                [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ;
                [nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ;
                }
                break;
            case 139:
                {
                numEcuaciones = numEcuaciones + 1;
                [otros addObject: codigo] ;
                   if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; }
                   if( ([[[datos objectAtIndex: 1] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 1] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 1] stringByTrimmingSpaces] ] ; }
                   if( ([[[datos objectAtIndex: 2] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 2] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 2] stringByTrimmingSpaces] ] ; }
                   if( ([[[datos objectAtIndex: 3] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 3] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 3] stringByTrimmingSpaces] ] ; }
                }
                break;
            case 140:
                {
                numEcuaciones = numEcuaciones + 3;
                [impulsos addObject: codigo] ;
                   if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; 
                      [impulsosObj addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ]; }
                }
                break;
            case 141:
                {
                numEcuaciones = numEcuaciones + 1;
                [potencias addObject: codigo] ;
                   if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; 
                      [potenciasObj addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ]; }
                }
                break;
           case 143:
                {
                numEcuaciones = numEcuaciones + 6;
                [otros addObject: codigo] ;
                   if( ([[[datos objectAtIndex: 0] stringByTrimmingSpaces] length] > 0) && (![[[datos objectAtIndex: 0] stringByTrimmingSpaces] isEqualToString: @"0"]) )
                   { [nomObjetosContenidos addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ] ; 
                      [movRelObj addObject: [[datos objectAtIndex: 0] stringByTrimmingSpaces] ]; }
                }
                break;
            case 144:
                {
                numEcuaciones = numEcuaciones + 3;
                [otros addObject: codigo] ;
                }
                break;
            }
//Fin del conteo de ecuaciones

//Se determinan las fuerzas que actuan en cada objeto
int pos ;
NSNumber *ident ;
NSEnumerator *busq = [ordenObjetos objectEnumerator] ;

  if(([identificador intValue] >= 104) && ([identificador intValue] <= 108))
  {
  k = 0 ;
  pos = 0 ;
      
      while((celda = [busq nextObject]))
      {
          if([celda tag] == [codigo intValue])
          {
          pos = k ;
          break ;
          }
          k = k + 1 ;   
      }
  
  NSMutableArray *fuerzas = [NSMutableArray array] ;
  
              if( (pos%16 != 0) && (pos%16 != 15) )
                {
                       if(pos - 1 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 15 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 15] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 16 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos - 17 >= 0)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 17] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 1 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 15 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 15] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 16 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                       
                       if(pos + 17 <= 207)
                       {
                           ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 17] tag]] ;
                           if([ident intValue] != 0)
                           { [fuerzas addObject: ident] ; }
                       }
                }
              else
                {
                       if(pos%16 == 0)
                       {
                            if(pos - 15 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 15] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       
                            if(pos - 16 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 1 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 16 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 17 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 17] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       }
                       else
                       {
                            if(pos - 1 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos - 16 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos - 17 >= 0)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 17] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       
                            if(pos + 15 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 15] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                            
                            if(pos + 16 <= 207)
                            {
                               ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 16] tag]] ;
                               if([ident intValue] != 0)
                               { [fuerzas addObject: ident] ; }
                            }
                       }
                }
                
//Se determina el tipo de fuerzas aplicadas al objeto y se corrige el numero de ecuaciones
int fuerHoriz = 0, fuerVert = 0 ;   
NSNumber *fuerTipo ;  
NSEnumerator *verif ;
         if( ([identificador intValue] == 106) && ([fuerzas count] > 0) )
         {
         [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
         
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t >= 131) || ((t >= 100) && (t <= 108)) || ((t >= 119) && (t <= 124)) )
                 {
                 errorFuer = YES ;
                 } 
                 
              }
         }
         
         if( ([identificador intValue] == 107) && ([fuerzas count] > 0) )
         {
         [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
         
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t >= 131) || (t == 117) || (t == 118) || ((t >= 100) && (t <= 108)) || ((t >= 121) && (t <= 124)) )
                 {
                 errorFuer = YES ;
                 } 
                 
              }
         }
  
         if( ([identificador intValue] == 104) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 115) || (t == 116) || (t == 123) || (t == 124) || (t == 127) )
                 {
                 fuerVert = fuerVert + 1 ;
                 }
                 
                 if( (t >= 133) || (t == 129) || (t == 130) || ((t >= 100) && (t <= 108)) || ((t >= 117) && (t <= 120)) )
                 {
                 errorFuer = YES ;
                 } 
                 
              }
              
              if([fuerzas count] == fuerVert)
              {
              numEcuaciones = numEcuaciones - 1;
              [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
              }
              else
              {
              [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
              }
              
         }
         
         if( ([identificador intValue] == 105) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t >= 131) || ((t >= 100) && (t <= 108)) || ((t >= 117) && (t <= 120)) )
                 {
                 errorFuer = YES ;
                 } 
              }
              
              [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
         }         
         
         if( ([identificador intValue] == 108) && ([fuerzas count] > 0) )
         {
         verif = [fuerzas objectEnumerator] ;
              while((fuerTipo = [verif nextObject]))
              {
              int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
                 if( (t == 113) || (t == 114) )
                 {
                 fuerHoriz = fuerHoriz + 1 ;
                 }
                 
                 if( (t == 115) || (t == 116) )
                 {
                 fuerVert = fuerVert + 1 ;
                 }
                 
                 if( (t >= 117) || ((t >= 100) && (t <= 108)) )
                 {
                 errorFuer = YES ;
                 }
                 
              }
              
              if([fuerzas count] == fuerHoriz)
              {
              numEcuaciones = numEcuaciones - 1;
              [tipoFuer addObject: [NSNumber numberWithInt: 2]] ;
              }
              else
              {
                  if([fuerzas count] == fuerVert)
                  {
                  numEcuaciones = numEcuaciones - 1;
                  [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
                  }
                  else
                  {
                  [tipoFuer addObject: [NSNumber numberWithInt: 1]] ;
                  }
              }
              
         }
         
  if([fuerzas count] > 0)
         {
         [fuerObj addObject: fuerzas] ; 
         }       
   else
         {
            if([identificador intValue] == 104)
            {
            [fuerObj addObject: fuerzas] ; 
            [tipoFuer addObject: [NSNumber numberWithInt: 3]] ;
            numEcuaciones = numEcuaciones - 1;
            }
         }
  }
  else
  {
  int signo = 0 ;
  NSMutableArray *fuerzas = [NSMutableArray array] ;
           
         if(([identificador intValue] >= 133) && ([identificador intValue] <= 136))
         {
         int rFuer = 0 ;
         k = 0 ;
         pos = 0 ;
      
         while((celda = [busq nextObject]))
              {
                 if([celda tag] == [codigo intValue])
                 {
                 pos = k ;
                 break ;
                 }
                k = k + 1 ;   
              }
  
        if([identificador intValue] == 133)
          {
          rFuer = 15 ;
          }
        else
          { 
              if([identificador intValue] == 134)
              {
              rFuer = 17 ;
              }
              else
              {
                  if([identificador intValue] == 135)
                  {
                  rFuer = 16 ;
                  }
                  else
                  {
                  rFuer = 1 ;
                  }
              }
          }             
        
              if( (pos%16 != 0) && (pos%16 != 15) )
                {
                    if(pos - rFuer >= 0)
                    {
                    ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                    if([ident intValue] != 0)
                    { [fuerzas addObject: ident] ; 
                       signo = 1; }
                    }
                    
                    if(pos + rFuer <= 207)
                    {
                    ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                    if([ident intValue] != 0)
                    { [fuerzas addObject: ident] ; 
                       signo = -1; }
                    }
                }
              else
                {
                    if(pos%16 == 0)
                       { 
                             if((pos - rFuer >= 0) && ((rFuer != 1) || (rFuer != 17))) 
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = 1; }
                             }
                    
                             if((pos + rFuer <= 207) && (rFuer != 15))
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = -1 ;}
                             }
                       }
                    else
                       {
                             if((pos - rFuer >= 0) && (rFuer != 15)) 
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                                signo = 1; }
                             }
                    
                             if((pos + rFuer <= 207) && ((rFuer != 1) || (rFuer != 17)))
                             {
                             ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + rFuer] tag]] ;
                             if([ident intValue] != 0)
                             { [fuerzas addObject: ident] ; 
                               signo = -1; }
                             }
                       }
                } 
         }
   
  //Verificacion de fuerzas
         if([fuerzas count] > 0)
         {
              if(signo > 0) 
              {
              [tipoFuer addObject: [NSNumber numberWithInt: 4]] ;
              }
              else
              {
                 if([fuerzas count] == 1)
                 {
                 [tipoFuer addObject: [NSNumber numberWithInt: 5]] ;
                 }
                 else
                 {
                 [tipoFuer addObject: [NSNumber numberWithInt: 4]] ;
                 }
              }
              
              if([fuerzas count] >1)
              {
              int f1 = [[[diccionario objectForKey: [fuerzas objectAtIndex: 0]] objectForKey: @"Tipo"] intValue] ;
              int f2 = [[[diccionario objectForKey: [fuerzas objectAtIndex: 1]] objectForKey: @"Tipo"] intValue] ;
              
                if(f1 == f2)
                {
                errorFuer = YES ;
                }
              }
              
                if([fuerzas count] > 0)
                {
                [fuerObj addObject: fuerzas] ; 
                }     
              
         }
  }
}

//Se verifica que existan los objetos a los cuales se hace referencia
int c, objContenidos = 0 ;
for(c = 0; c < [nomObjetosContenidos count]; c++)
    {
        if([nomObjetos containsObject: [nomObjetosContenidos objectAtIndex: c]])
        {  
        objContenidos = objContenidos + 1;
        }
    }
    
//Se corrige el numero de ecuaciones en base al tipo de objetos que colisionan  
int indice1, indice2 ;  
NSNumber *tipoMov1, *tipoMov2 ;
for(c = 0; c < [codCol count]; c++)
    {
    indice1 = [nomObjetos indexOfObject: [[[codObjCol objectAtIndex: c] objectAtIndex: 0] stringByTrimmingSpaces] ] ;
    indice2 = [nomObjetos indexOfObject: [[[codObjCol objectAtIndex: c] objectAtIndex: 1] stringByTrimmingSpaces] ] ;    

    tipoMov1 = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indice1]] objectForKey: @"Tipo"] ;
    tipoMov2 = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indice2]] objectForKey: @"Tipo"] ;
    
        if( (([tipoMov1 intValue] == 103) && ([tipoMov2 intValue] == 103)) || (([tipoMov1 intValue] == 102) && ([tipoMov2 intValue] == 102)) )
        {  
        [tipoCol addObject: [NSNumber numberWithInt: 2] ] ;
        numEcuaciones = numEcuaciones - 2;        
        }
        else
        {
             if(([tipoMov1 intValue] == 101) && ([tipoMov2 intValue] == 101))
             {
             [tipoCol addObject: [NSNumber numberWithInt: 1] ] ;
             }
             else
             {
             errorCol = YES ;
             }
        }
    }

//Se verifican los objetos contenidos en impulso
int indiceImp ;
NSNumber *tipoImp ;
id codImp ;
NSEnumerator *impObj = [impulsosObj objectEnumerator] ;

while((codImp = [impObj nextObject]))
{
    indiceImp = [nomObjetos indexOfObject: [codImp stringByTrimmingSpaces] ] ;
    tipoImp = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceImp]] objectForKey: @"Tipo"] ;
    
       if([tipoImp intValue] != 101)
       {
       numEcuaciones = numEcuaciones - 1 ;
       }
    
       if( !(([tipoImp intValue] >= 101) && ([tipoImp intValue] <= 107)) )
       {
       errorImp = YES ;
       }
} 

//Se verifican los objetos contenidos en potencia
int indicePot ;
NSNumber *tipoPot ;
id codPot ;
NSEnumerator *potObj = [potenciasObj objectEnumerator] ;

while((codPot = [potObj nextObject]))
{
    indicePot = [nomObjetos indexOfObject: [codPot stringByTrimmingSpaces] ] ;
    tipoPot = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indicePot]] objectForKey: @"Tipo"] ;
    
       if( !(([tipoPot intValue] >= 104) && ([tipoPot intValue] <= 107)) )
       {
       errorPot = YES ;
       }
}       

//Se verifican los objetos contenidos en movimiento relativo
int indiceMR ;
NSNumber *tipoMR ;
id codMR ;
NSEnumerator *mrObj = [movRelObj objectEnumerator] ;

while((codMR = [mrObj nextObject]))
{
    indiceMR = [nomObjetos indexOfObject: [codMR stringByTrimmingSpaces] ] ;
    tipoMR = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceMR]] objectForKey: @"Tipo"] ;
    
       if( !(([tipoMR intValue] >= 104) && ([tipoMR intValue] <= 107)) )
       {
       errorMovRel = YES ;
       }
}       

//Se verifica el objeto al que se hace referencia en 104
int indiceBRV ;
NSNumber *tipoBRV ;
id codBRV ;
NSEnumerator *blocVObj = [objetoRel_104 objectEnumerator] ;

while((codBRV = [blocVObj nextObject]))
{
    indiceBRV = [nomObjetos indexOfObject: [codBRV stringByTrimmingSpaces] ] ;
    tipoBRV = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceBRV]] objectForKey: @"Tipo"] ;
    
       if([tipoBRV intValue] != 105)
       {
       errorBlocRel = YES ;
       } 
}   

//Se verifica el objeto al que se hace referencia en los bloques
int indiceBR ;
NSNumber *tipoBR ;
id codBR ;
NSEnumerator *blocObj = [objetoRel objectEnumerator] ;

while((codBR = [blocObj nextObject]))
{
    indiceBR = [nomObjetos indexOfObject: [codBR stringByTrimmingSpaces] ] ;
    tipoBR = [[diccionario objectForKey: [codObjetosContenidos objectAtIndex: indiceBR]] objectForKey: @"Tipo"] ;
    
       if( !(([tipoBR intValue] >= 105) && ([tipoBR intValue] <= 107)) )
       {
       errorBlocRel = YES ;
       }
}   
    
//Se verifica que todos los objetos tengan fuerzas aplicadas
if( (([codObjetos count] == [fuerObj count]) && (!errorFuer)) && (!errorCol) && (!errorImp) && (!errorPot) && (!errorMovRel) && (!errorBlocRel))
{
//Se realiza el conteo de las fuerzas aplicadas 
int v ;
    for(v = 0; v < [codObjetos count]; v++)
    {
    numFuerObj = numFuerObj + [[fuerObj objectAtIndex: v] count] ;
    [codFuerzasObj addObjectsFromArray: [fuerObj objectAtIndex: v]] ;  
    }
    
//Se verifica cuantas de las fuerzas existentes estan aplicadas a objetos
    int w = 0 ;
    NSEnumerator *compro = [codFuerzas objectEnumerator] ;
    NSNumber *fuer ;
    while((fuer = [compro nextObject]))
    {
       if([codFuerzasObj containsObject: fuer])
       {
       w = w + 1 ;
       }
    }
    
//Ultimas verificaciones        
   if(([variables count] == numEcuaciones) && (numEcuaciones > 0) && !error)
    {
       if(objContenidos == [nomObjetosContenidos count])
       {
         if( (w == [codFuerzas count]) && (w == [codFuerzasObj count]) )
         {
         [self crearSistema] ;
         }
         else
         {
         NSString *advertencia ;
         
             if(w < [codFuerzas count])
             {
             advertencia = [NSString stringWithString: [errores objectAtIndex: 1]] ;
             }
             
             if(w < [codFuerzasObj count])
             {
             advertencia = [NSString stringWithString: [errores objectAtIndex: 2]] ;
             }
         
         longitud = [ [dinamicaPuntInfo textStorage] length];
         [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: advertencia] ;
         }
       }
       else
       {
       longitud = [ [dinamicaPuntInfo textStorage] length];
       [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 3]] ;
       }
    }
    else
    {
    longitud = [ [dinamicaPuntInfo textStorage] length];
    [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 4]] ;
    }
}
else
{
   if(errorCol)
   {
   longitud = [ [dinamicaPuntInfo textStorage] length];
   [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 5]] ;
   }
   else
   {
      if(errorImp)
      {
      longitud = [ [dinamicaPuntInfo textStorage] length];
      [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 6]] ;
      }
      else
      { 
         if(errorPot)
         {
         longitud = [ [dinamicaPuntInfo textStorage] length];
         [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 7]] ;
         }
         else
         {
           if(errorMovRel)
           {
           longitud = [ [dinamicaPuntInfo textStorage] length];
           [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 12]] ;
           }
           else
           {
             if(errorBlocRel)
             {
             longitud = [ [dinamicaPuntInfo textStorage] length];
             [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 13]] ;
             }
             else
             { 
                if([codObjetos count] != [fuerObj count])
                {
                longitud = [ [dinamicaPuntInfo textStorage] length];
                [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 8]] ;
                }
                else
                {
                longitud = [ [dinamicaPuntInfo textStorage] length];
                [dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 9]] ;
                }
             }   
           }  
        }     
      }
   }  
}

RELEASE(keys) ;
}

- (void) crearSistema
{
int aumento = 1 ;
double nuevoValor ;
BOOL continuar ;

const gsl_multiroot_fsolver_type *T;
gsl_multiroot_fsolver *s;
     
int estado, estadoInt, k, nvar, longitud ;
double par, factor ;
NSString *mensaje ;
NSNumber *respuesta ;
NSArray *terminos ;
size_t iter ;

nvar  = [variables count] ;
const size_t n = nvar;
struct parametros p = {1.0, 1.0};

gsl_vector *x = gsl_vector_alloc (n);
int Tindice ;

//Generador de numeros aleatorios
const gsl_rng_type * Y;
gsl_rng * r;
gsl_rng_env_setup();
Y = gsl_rng_default;
r = gsl_rng_alloc (Y);

do
{
iter = 0 ;
for (k = 0; k < nvar; k++)
    {
        if( aumento <= 50 )
        {
        nuevoValor = 100 ;
        }
        else
        {
        nuevoValor = 1000 ;
        }
        
        par = nuevoValor*(gsl_rng_uniform (r)) ;
        gsl_vector_set (x, k, par) ;
    }
         
gsl_multiroot_function f = {&sis_dinamica, n, &p};    
T = gsl_multiroot_fsolver_hybrids;
s = gsl_multiroot_fsolver_alloc (T, nvar);
gsl_multiroot_fsolver_set (s, &f, x);

         do
         {
           iter++;
           estadoInt = gsl_multiroot_fsolver_iterate (s);
 
           if(estadoInt)
             break;
     
           estado = gsl_multiroot_test_residual (s->f, 1e-7);
         }
         while (estado == GSL_CONTINUE && iter < 1000);  

//Se verifica el estado
    if( (estadoInt) && (aumento < 90) )
    {
             aumento = aumento + 1 ;
             continuar = YES ;
    }
    else
    {
            if(varT == 1)
            {
            Tindice = [variables indexOfObject: tiempoVar] ;
                    if( ((gsl_vector_get (s->x, Tindice)) < 0) && (aumento < 90) )
                    {
                    aumento = aumento + 1 ;
                    continuar = YES ;
                    }
                    else
                    {
                    continuar = NO ;
                    }
            }
            else
            {
            continuar = NO ;
            }
    }
//Se termina la verificacion
}
while(continuar) ;
//se termino la busqueda de la solucion

//Se pasan los datos al array Resultados
int countRes = 0 ;
id unObj ;
NSMutableArray *resultados = [NSMutableArray array] ;
NSEnumerator *varCount = [variables objectEnumerator] ;

while((unObj = [varCount nextObject]))
{
[resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
countRes = countRes + 1 ;
}

//Se corrigen signos en los datos
id datoSigno ;
NSNumber *tipoOtro ;
NSMutableArray *verifSigno ;
NSEnumerator *signoObj = [diccionario objectEnumerator] ;

while((datoSigno = [signoObj nextObject]))
{
int par1 = 0, par2 = 0, par3 = 0, w = 0 ;
tipoOtro = [datoSigno objectForKey: @"Tipo"] ;

 switch([tipoOtro intValue])
 {
   case 101:
    {
    verifSigno = [datoSigno objectForKey: @"Valores"] ;
    
          //Se corrige la vi del objeto
          if( ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo inicial del objeto
          if([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del objeto
          if( ([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]] ;
           
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par2 = 1 ;
                }
          }
          
          //Se corrige el angulo final del objeto
          if([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par2 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
    }
   break;
   case 106 ... 107:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige el angulo del plano
          if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 109 ... 112:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige la fuerza
          if( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo de la fuerza
          if([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 125 ... 128:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige el angulo de contacto
          if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 138:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige el angulo de la colision
          if([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 140:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige el imp
          if( ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo del imp
          if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;   
   case 143:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige la a del objeto
          if( ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo de a del objeto
          if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del objeto
          if( ([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par2 = 1 ;
                }
          }
          
          //Se corrige el angulo de vf del objeto
          if([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par2 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la d del objeto
          if( ([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 6] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par3 = 1 ;
                }
          }
          
          //Se corrige el angulo de d del objeto
          if([variables containsObject: [[verifSigno objectAtIndex: 6] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 6] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par3 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
   case 144:
   {
   verifSigno = [datoSigno objectForKey: @"Valores"] ;
   
          //Se corrige la vi de la bomba
          if( ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par1 = 1 ;
                }
          }
          
          //Se corrige el angulo inicial de la bomba
          if([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par1 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del fragmento 1
          if( ([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par2 = 1 ;
                }
          }
          
          //Se corrige el angulo del fragmento 1
          if([variables containsObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 5] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par2 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del fragmento 2
          if( ([variables containsObject: [[verifSigno objectAtIndex: 7] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 8] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 7] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par3 = 1 ;
                }
          }
          
          //Se corrige el angulo del fragmento 2
          if([variables containsObject: [[verifSigno objectAtIndex: 8] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 8] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par3 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del fragmento 3
          if( ([variables containsObject: [[verifSigno objectAtIndex: 10] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 11] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 10] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par3 = 1 ;
                }
          }
          
          //Se corrige el angulo del fragmento 3
          if([variables containsObject: [[verifSigno objectAtIndex: 11] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 11] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par3 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
          
          //Se corrige la vf del fragmento 4
          if( ([variables containsObject: [[verifSigno objectAtIndex: 13] stringByTrimmingSpaces]]) && ([variables containsObject: [[verifSigno objectAtIndex: 14] stringByTrimmingSpaces]]) )
          {
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 13] stringByTrimmingSpaces]] ;
          
              if( [[resultados objectAtIndex: w] doubleValue] < 0 )
                {
                double nv = -1*[[resultados objectAtIndex: w] doubleValue] ;
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
                par3 = 1 ;
                }
          }
          
          //Se corrige el angulo del fragmento 4
          if([variables containsObject: [[verifSigno objectAtIndex: 14] stringByTrimmingSpaces]])
          {
          double nv ;
          w = [variables indexOfObject: [[verifSigno objectAtIndex: 14] stringByTrimmingSpaces]] ;
          nv = [[resultados objectAtIndex: w] doubleValue] ;
          
                if( par3 == 1 )
                {
                nv = nv + 180 ;
                }
                
                if( nv > 360 )
                {
                nv = nv - floor(nv/360)*360 ;
                }
                
                if( nv < 0 )
                {
                nv = nv + (floor(-1*nv/360) + 1)*360 ;                
                }
                
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
          }
   }
   break;
 }
}

//Se imprimen los resultados
for(k = 0; k < nvar; k++)
{
terminos = [[variables objectAtIndex: k] componentsSeparatedByString: @"@"] ;
factor = [[[conversiones objectAtIndex: sistema] objectForKey: [terminos objectAtIndex: 1]] doubleValue] ; 
//respuesta = [NSNumber numberWithDouble: (gsl_vector_get (s->x, k))/factor ] ;
respuesta = [resultados objectAtIndex: k] ;
mensaje = [NSString stringWithFormat: @" %s  =  %.3f  %s ;  ", [[terminos objectAtIndex: 0] cString], ([respuesta doubleValue]/factor), [[terminos objectAtIndex: 1] cString]] ;
longitud = [ [dinamicaPuntInfo textStorage] length];
[dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
}

//Se imprime el estado del calculo        
mensaje = [NSString stringWithFormat: [errores objectAtIndex: 10], gsl_strerror (estado)];
longitud = [ [dinamicaPuntInfo textStorage] length];
[dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;

/*
int q ;
NSNumber *clase ;
for(q = 0; q < [codObjetos count]; q++)
{
clase = [[diccionario objectForKey: [[fuerObj objectAtIndex: q] objectAtIndex: 0]] objectForKey: @"Tipo"] ;
mensaje = [NSString stringWithFormat: @" Codigo %d   Tipo %d  Num fuerzas %d  Clase %d \n ", [[codObjetos objectAtIndex: q] intValue], [[tipoFuer objectAtIndex: q] intValue], [[fuerObj objectAtIndex: q] count], [clase intValue] ] ;
longitud = [ [dinamicaPuntInfo textStorage] length];
[dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
}

mensaje = [NSString stringWithFormat: @" Otros = %d ; \n ", [otros count] ] ;
longitud = [ [dinamicaPuntInfo textStorage] length];
[dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
*/

if(mensajeFr)
{
longitud = [ [dinamicaPuntInfo textStorage] length];
[dinamicaPuntInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 11]] ;
}

gsl_multiroot_fsolver_free (s);
gsl_vector_free (x);
gsl_rng_free (r);
}

- (void) dealloc
{
RELEASE(diccionario) ;
RELEASE(variables) ;
RELEASE(codObjetos) ;
RELEASE(fuerObj) ;
RELEASE(tipoFuer) ;
RELEASE(codCol) ;
RELEASE(codObjCol) ;
RELEASE(tipoCol) ;
RELEASE(codObjetosContenidos) ;
RELEASE(codRel) ;
RELEASE(ordenObjetos) ;
RELEASE(otros) ;
RELEASE(impulsos) ;
RELEASE(impulsosObj) ;
RELEASE(potencias) ;
RELEASE(potenciasObj) ;
RELEASE(errores) ;
[super dealloc] ;
}

@end
